/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.AddRequest;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.BindRequest;
import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.CompareRequest;
import com.unboundid.ldap.sdk.CompareResult;
import com.unboundid.ldap.sdk.DeleteRequest;
import com.unboundid.ldap.sdk.DereferencePolicy;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.ExtendedRequest;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.FullLDAPInterface;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.LDAPSearchException;
import com.unboundid.ldap.sdk.Modification;
import com.unboundid.ldap.sdk.ModifyDNRequest;
import com.unboundid.ldap.sdk.ModifyRequest;
import com.unboundid.ldap.sdk.ReadOnlyAddRequest;
import com.unboundid.ldap.sdk.ReadOnlyCompareRequest;
import com.unboundid.ldap.sdk.ReadOnlyDeleteRequest;
import com.unboundid.ldap.sdk.ReadOnlyModifyDNRequest;
import com.unboundid.ldap.sdk.ReadOnlyModifyRequest;
import com.unboundid.ldap.sdk.ReadOnlySearchRequest;
import com.unboundid.ldap.sdk.RootDSE;
import com.unboundid.ldap.sdk.SearchRequest;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchResultListener;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.ldif.LDIFException;
import com.unboundid.util.Extensible;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.Collection;
import java.util.List;

@Extensible
@ThreadSafety(level=ThreadSafetyLevel.MOSTLY_THREADSAFE)
public class MockableLDAPConnection
implements FullLDAPInterface {
    private final LDAPConnection connection;

    public MockableLDAPConnection(LDAPConnection connection) {
        Validator.ensureNotNullWithMessage(connection, "MockableLDAPConnection.connection must not be null.");
        this.connection = connection;
    }

    public final LDAPConnection getWrappedConnection() {
        return this.connection;
    }

    @Override
    public void close() {
        this.connection.close();
    }

    @Override
    public RootDSE getRootDSE() throws LDAPException {
        return this.connection.getRootDSE();
    }

    @Override
    public Schema getSchema() throws LDAPException {
        return this.connection.getSchema();
    }

    @Override
    public Schema getSchema(String entryDN) throws LDAPException {
        return this.connection.getSchema(entryDN);
    }

    @Override
    public SearchResultEntry getEntry(String dn) throws LDAPException {
        return this.connection.getEntry(dn);
    }

    @Override
    public SearchResultEntry getEntry(String dn, String ... attributes) throws LDAPException {
        return this.connection.getEntry(dn, attributes);
    }

    @Override
    public LDAPResult add(String dn, Attribute ... attributes) throws LDAPException {
        return this.connection.add(dn, attributes);
    }

    @Override
    public LDAPResult add(String dn, Collection<Attribute> attributes) throws LDAPException {
        return this.connection.add(dn, attributes);
    }

    @Override
    public LDAPResult add(Entry entry) throws LDAPException {
        return this.connection.add(entry);
    }

    @Override
    public LDAPResult add(String ... ldifLines) throws LDIFException, LDAPException {
        return this.connection.add(ldifLines);
    }

    @Override
    public LDAPResult add(AddRequest addRequest) throws LDAPException {
        return this.connection.add(addRequest);
    }

    @Override
    public LDAPResult add(ReadOnlyAddRequest addRequest) throws LDAPException {
        return this.connection.add(addRequest);
    }

    @Override
    public BindResult bind(String bindDN, String password) throws LDAPException {
        return this.connection.bind(bindDN, password);
    }

    @Override
    public BindResult bind(BindRequest bindRequest) throws LDAPException {
        return this.connection.bind(bindRequest);
    }

    @Override
    public CompareResult compare(String dn, String attributeName, String assertionValue) throws LDAPException {
        return this.connection.compare(dn, attributeName, assertionValue);
    }

    @Override
    public CompareResult compare(CompareRequest compareRequest) throws LDAPException {
        return this.connection.compare(compareRequest);
    }

    @Override
    public CompareResult compare(ReadOnlyCompareRequest compareRequest) throws LDAPException {
        return this.connection.compare(compareRequest);
    }

    @Override
    public LDAPResult delete(String dn) throws LDAPException {
        return this.connection.delete(dn);
    }

    @Override
    public LDAPResult delete(DeleteRequest deleteRequest) throws LDAPException {
        return this.connection.delete(deleteRequest);
    }

    @Override
    public LDAPResult delete(ReadOnlyDeleteRequest deleteRequest) throws LDAPException {
        return this.connection.delete(deleteRequest);
    }

    @Override
    public ExtendedResult processExtendedOperation(String requestOID) throws LDAPException {
        return this.connection.processExtendedOperation(requestOID);
    }

    @Override
    public ExtendedResult processExtendedOperation(String requestOID, ASN1OctetString requestValue) throws LDAPException {
        return this.connection.processExtendedOperation(requestOID, requestValue);
    }

    @Override
    public ExtendedResult processExtendedOperation(ExtendedRequest extendedRequest) throws LDAPException {
        return this.connection.processExtendedOperation(extendedRequest);
    }

    @Override
    public LDAPResult modify(String dn, Modification mod) throws LDAPException {
        return this.connection.modify(dn, mod);
    }

    @Override
    public LDAPResult modify(String dn, Modification ... mods) throws LDAPException {
        return this.connection.modify(dn, mods);
    }

    @Override
    public LDAPResult modify(String dn, List<Modification> mods) throws LDAPException {
        return this.connection.modify(dn, mods);
    }

    @Override
    public LDAPResult modify(String ... ldifModificationLines) throws LDIFException, LDAPException {
        return this.connection.modify(ldifModificationLines);
    }

    @Override
    public LDAPResult modify(ModifyRequest modifyRequest) throws LDAPException {
        return this.connection.modify(modifyRequest);
    }

    @Override
    public LDAPResult modify(ReadOnlyModifyRequest modifyRequest) throws LDAPException {
        return this.connection.modify(modifyRequest);
    }

    @Override
    public LDAPResult modifyDN(String dn, String newRDN, boolean deleteOldRDN) throws LDAPException {
        return this.connection.modifyDN(dn, newRDN, deleteOldRDN);
    }

    @Override
    public LDAPResult modifyDN(String dn, String newRDN, boolean deleteOldRDN, String newSuperiorDN) throws LDAPException {
        return this.connection.modifyDN(dn, newRDN, deleteOldRDN, newSuperiorDN);
    }

    @Override
    public LDAPResult modifyDN(ModifyDNRequest modifyDNRequest) throws LDAPException {
        return this.connection.modifyDN(modifyDNRequest);
    }

    @Override
    public LDAPResult modifyDN(ReadOnlyModifyDNRequest modifyDNRequest) throws LDAPException {
        return this.connection.modifyDN(modifyDNRequest);
    }

    @Override
    public SearchResult search(String baseDN, SearchScope scope, String filter, String ... attributes) throws LDAPSearchException {
        return this.connection.search(baseDN, scope, filter, attributes);
    }

    @Override
    public SearchResult search(String baseDN, SearchScope scope, Filter filter, String ... attributes) throws LDAPSearchException {
        return this.connection.search(baseDN, scope, filter, attributes);
    }

    @Override
    public SearchResult search(SearchResultListener searchResultListener, String baseDN, SearchScope scope, String filter, String ... attributes) throws LDAPSearchException {
        return this.connection.search(searchResultListener, baseDN, scope, filter, attributes);
    }

    @Override
    public SearchResult search(SearchResultListener searchResultListener, String baseDN, SearchScope scope, Filter filter, String ... attributes) throws LDAPSearchException {
        return this.connection.search(searchResultListener, baseDN, scope, filter, attributes);
    }

    @Override
    public SearchResult search(String baseDN, SearchScope scope, DereferencePolicy derefPolicy, int sizeLimit, int timeLimit, boolean typesOnly, String filter, String ... attributes) throws LDAPSearchException {
        return this.connection.search(baseDN, scope, derefPolicy, sizeLimit, timeLimit, typesOnly, filter, attributes);
    }

    @Override
    public SearchResult search(String baseDN, SearchScope scope, DereferencePolicy derefPolicy, int sizeLimit, int timeLimit, boolean typesOnly, Filter filter, String ... attributes) throws LDAPSearchException {
        return this.connection.search(baseDN, scope, derefPolicy, sizeLimit, timeLimit, typesOnly, filter, attributes);
    }

    @Override
    public SearchResult search(SearchResultListener searchResultListener, String baseDN, SearchScope scope, DereferencePolicy derefPolicy, int sizeLimit, int timeLimit, boolean typesOnly, String filter, String ... attributes) throws LDAPSearchException {
        return this.connection.search(searchResultListener, baseDN, scope, derefPolicy, sizeLimit, timeLimit, typesOnly, filter, attributes);
    }

    @Override
    public SearchResult search(SearchResultListener searchResultListener, String baseDN, SearchScope scope, DereferencePolicy derefPolicy, int sizeLimit, int timeLimit, boolean typesOnly, Filter filter, String ... attributes) throws LDAPSearchException {
        return this.connection.search(searchResultListener, baseDN, scope, derefPolicy, sizeLimit, timeLimit, typesOnly, filter, attributes);
    }

    @Override
    public SearchResult search(SearchRequest searchRequest) throws LDAPSearchException {
        return this.connection.search(searchRequest);
    }

    @Override
    public SearchResult search(ReadOnlySearchRequest searchRequest) throws LDAPSearchException {
        return this.connection.search(searchRequest);
    }

    @Override
    public SearchResultEntry searchForEntry(String baseDN, SearchScope scope, String filter, String ... attributes) throws LDAPSearchException {
        return this.connection.searchForEntry(baseDN, scope, filter, attributes);
    }

    @Override
    public SearchResultEntry searchForEntry(String baseDN, SearchScope scope, Filter filter, String ... attributes) throws LDAPSearchException {
        return this.connection.searchForEntry(baseDN, scope, filter, attributes);
    }

    @Override
    public SearchResultEntry searchForEntry(String baseDN, SearchScope scope, DereferencePolicy derefPolicy, int timeLimit, boolean typesOnly, String filter, String ... attributes) throws LDAPSearchException {
        return this.connection.searchForEntry(baseDN, scope, derefPolicy, timeLimit, typesOnly, filter, attributes);
    }

    @Override
    public SearchResultEntry searchForEntry(String baseDN, SearchScope scope, DereferencePolicy derefPolicy, int timeLimit, boolean typesOnly, Filter filter, String ... attributes) throws LDAPSearchException {
        return this.connection.searchForEntry(baseDN, scope, derefPolicy, timeLimit, typesOnly, filter, attributes);
    }

    @Override
    public SearchResultEntry searchForEntry(SearchRequest searchRequest) throws LDAPSearchException {
        return this.connection.searchForEntry(searchRequest);
    }

    @Override
    public SearchResultEntry searchForEntry(ReadOnlySearchRequest searchRequest) throws LDAPSearchException {
        return this.connection.searchForEntry(searchRequest);
    }
}

