/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.listener;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.listener.ListenerMessages;
import com.unboundid.ldap.matchingrules.MatchingRule;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.schema.AttributeTypeDefinition;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.Mutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

@Mutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
final class InMemoryDirectoryServerEqualityAttributeIndex {
    private final AttributeTypeDefinition attributeType;
    private final Map<ASN1OctetString, TreeSet<DN>> indexMap;
    private final MatchingRule matchingRule;
    private final Schema schema;

    InMemoryDirectoryServerEqualityAttributeIndex(String attributeType, Schema schema) throws LDAPException {
        this.schema = schema;
        if (schema == null) {
            throw new LDAPException(ResultCode.PARAM_ERROR, ListenerMessages.ERR_DS_EQ_INDEX_NO_SCHEMA.get(attributeType));
        }
        this.attributeType = schema.getAttributeType(attributeType);
        if (this.attributeType == null) {
            throw new LDAPException(ResultCode.PARAM_ERROR, ListenerMessages.ERR_DS_EQ_INDEX_UNDEFINED_ATTRIBUTE_TYPE.get(attributeType));
        }
        this.matchingRule = MatchingRule.selectEqualityMatchingRule(attributeType, schema);
        this.indexMap = new HashMap<ASN1OctetString, TreeSet<DN>>(StaticUtils.computeMapCapacity(100));
    }

    AttributeTypeDefinition getAttributeType() {
        return this.attributeType;
    }

    synchronized void clear() {
        this.indexMap.clear();
    }

    @InternalUseOnly
    synchronized Map<ASN1OctetString, TreeSet<DN>> copyMap() {
        HashMap m = new HashMap(StaticUtils.computeMapCapacity(this.indexMap.size()));
        for (Map.Entry<ASN1OctetString, TreeSet<DN>> e : this.indexMap.entrySet()) {
            m.put(e.getKey(), new TreeSet(e.getValue()));
        }
        return Collections.unmodifiableMap(m);
    }

    synchronized Set<DN> getMatchingEntries(ASN1OctetString value) throws LDAPException {
        TreeSet<DN> dnSet = this.indexMap.get(this.matchingRule.normalize(value));
        if (dnSet == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(dnSet);
    }

    synchronized void processAdd(Entry entry) throws LDAPException {
        Attribute a = entry.getAttribute(this.attributeType.getNameOrOID(), this.schema);
        if (a != null) {
            DN dn = entry.getParsedDN();
            ASN1OctetString[] rawValues = a.getRawValues();
            ASN1OctetString[] normalizedValues = new ASN1OctetString[rawValues.length];
            for (int i = 0; i < rawValues.length; ++i) {
                normalizedValues[i] = this.matchingRule.normalize(rawValues[i]);
            }
            for (ASN1OctetString v : normalizedValues) {
                TreeSet<DN> dnSet = this.indexMap.get(v);
                if (dnSet == null) {
                    dnSet = new TreeSet();
                    this.indexMap.put(v, dnSet);
                }
                dnSet.add(dn);
            }
        }
    }

    synchronized void processDelete(Entry entry) throws LDAPException {
        Attribute a = entry.getAttribute(this.attributeType.getNameOrOID(), this.schema);
        if (a != null) {
            DN dn = entry.getParsedDN();
            ASN1OctetString[] rawValues = a.getRawValues();
            ASN1OctetString[] normalizedValues = new ASN1OctetString[rawValues.length];
            for (int i = 0; i < rawValues.length; ++i) {
                normalizedValues[i] = this.matchingRule.normalize(rawValues[i]);
            }
            for (ASN1OctetString v : normalizedValues) {
                TreeSet<DN> dnSet = this.indexMap.get(v);
                if (dnSet == null) continue;
                dnSet.remove(dn);
                if (!dnSet.isEmpty()) continue;
                this.indexMap.remove(v);
            }
        }
    }
}

