/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.worker;

import com.uber.cadence.common.RetryOptions;
import com.uber.cadence.converter.DataConverter;
import com.uber.cadence.converter.JsonDataConverter;
import com.uber.cadence.internal.metrics.NoopScope;
import com.uber.cadence.internal.worker.PollerOptions;
import com.uber.cadence.workflow.WorkflowInterceptor;
import com.uber.m3.tally.Scope;
import java.lang.management.ManagementFactory;
import java.util.Objects;
import java.util.function.Function;

public final class WorkerOptions {
    private final boolean disableWorkflowWorker;
    private final boolean disableActivityWorker;
    private final double workerActivitiesPerSecond;
    private final String identity;
    private final DataConverter dataConverter;
    private final int maxConcurrentActivityExecutionSize;
    private final int maxConcurrentWorkflowExecutionSize;
    private final int maxConcurrentLocalActivityExecutionSize;
    private final double taskListActivitiesPerSecond;
    private final PollerOptions activityPollerOptions;
    private final PollerOptions workflowPollerOptions;
    private final RetryOptions reportActivityCompletionRetryOptions;
    private final RetryOptions reportActivityFailureRetryOptions;
    private final RetryOptions reportWorkflowCompletionRetryOptions;
    private final RetryOptions reportWorkflowFailureRetryOptions;
    private final Function<WorkflowInterceptor, WorkflowInterceptor> interceptorFactory;
    private final Scope metricsScope;
    private final boolean enableLoggingInReplay;

    private WorkerOptions(boolean disableWorkflowWorker, boolean disableActivityWorker, double workerActivitiesPerSecond, String identity, DataConverter dataConverter, int maxConcurrentActivityExecutionSize, int maxConcurrentWorkflowExecutionSize, int maxConcurrentLocalActivityExecutionSize, double taskListActivitiesPerSecond, PollerOptions activityPollerOptions, PollerOptions workflowPollerOptions, RetryOptions reportActivityCompletionRetryOptions, RetryOptions reportActivityFailureRetryOptions, RetryOptions reportWorkflowCompletionRetryOptions, RetryOptions reportWorkflowFailureRetryOptions, Function<WorkflowInterceptor, WorkflowInterceptor> interceptorFactory, Scope metricsScope, boolean enableLoggingInReplay) {
        this.disableWorkflowWorker = disableWorkflowWorker;
        this.disableActivityWorker = disableActivityWorker;
        this.workerActivitiesPerSecond = workerActivitiesPerSecond;
        this.identity = identity;
        this.dataConverter = dataConverter;
        this.maxConcurrentActivityExecutionSize = maxConcurrentActivityExecutionSize;
        this.maxConcurrentWorkflowExecutionSize = maxConcurrentWorkflowExecutionSize;
        this.maxConcurrentLocalActivityExecutionSize = maxConcurrentLocalActivityExecutionSize;
        this.taskListActivitiesPerSecond = taskListActivitiesPerSecond;
        this.activityPollerOptions = activityPollerOptions;
        this.workflowPollerOptions = workflowPollerOptions;
        this.reportActivityCompletionRetryOptions = reportActivityCompletionRetryOptions;
        this.reportActivityFailureRetryOptions = reportActivityFailureRetryOptions;
        this.reportWorkflowCompletionRetryOptions = reportWorkflowCompletionRetryOptions;
        this.reportWorkflowFailureRetryOptions = reportWorkflowFailureRetryOptions;
        this.interceptorFactory = interceptorFactory;
        this.metricsScope = metricsScope;
        this.enableLoggingInReplay = enableLoggingInReplay;
    }

    public boolean isDisableWorkflowWorker() {
        return this.disableWorkflowWorker;
    }

    public boolean isDisableActivityWorker() {
        return this.disableActivityWorker;
    }

    public double getWorkerActivitiesPerSecond() {
        return this.workerActivitiesPerSecond;
    }

    public String getIdentity() {
        return this.identity;
    }

    public DataConverter getDataConverter() {
        return this.dataConverter;
    }

    public int getMaxConcurrentActivityExecutionSize() {
        return this.maxConcurrentActivityExecutionSize;
    }

    public int getMaxConcurrentWorkflowExecutionSize() {
        return this.maxConcurrentWorkflowExecutionSize;
    }

    public int getMaxConcurrentLocalActivityExecutionSize() {
        return this.maxConcurrentLocalActivityExecutionSize;
    }

    public PollerOptions getActivityPollerOptions() {
        return this.activityPollerOptions;
    }

    public PollerOptions getWorkflowPollerOptions() {
        return this.workflowPollerOptions;
    }

    public RetryOptions getReportActivityCompletionRetryOptions() {
        return this.reportActivityCompletionRetryOptions;
    }

    public RetryOptions getReportActivityFailureRetryOptions() {
        return this.reportActivityFailureRetryOptions;
    }

    public RetryOptions getReportWorkflowCompletionRetryOptions() {
        return this.reportWorkflowCompletionRetryOptions;
    }

    public RetryOptions getReportWorkflowFailureRetryOptions() {
        return this.reportWorkflowFailureRetryOptions;
    }

    public Function<WorkflowInterceptor, WorkflowInterceptor> getInterceptorFactory() {
        return this.interceptorFactory;
    }

    public Scope getMetricsScope() {
        return this.metricsScope;
    }

    public boolean getEnableLoggingInReplay() {
        return this.enableLoggingInReplay;
    }

    public String toString() {
        return "WorkerOptions{disableWorkflowWorker=" + this.disableWorkflowWorker + ", disableActivityWorker=" + this.disableActivityWorker + ", workerActivitiesPerSecond=" + this.workerActivitiesPerSecond + ", identity='" + this.identity + '\'' + ", dataConverter=" + this.dataConverter + ", maxConcurrentActivityExecutionSize=" + this.maxConcurrentActivityExecutionSize + ", maxConcurrentWorkflowExecutionSize=" + this.maxConcurrentWorkflowExecutionSize + ", maxConcurrentLocalActivityExecutionSize=" + this.maxConcurrentLocalActivityExecutionSize + ", taskListActivitiesPerSecond=" + this.taskListActivitiesPerSecond + ", activityPollerOptions=" + this.activityPollerOptions + ", workflowPollerOptions=" + this.workflowPollerOptions + ", reportActivityCompletionRetryOptions=" + this.reportActivityCompletionRetryOptions + ", reportActivityFailureRetryOptions=" + this.reportActivityFailureRetryOptions + ", reportWorkflowCompletionRetryOptions=" + this.reportWorkflowCompletionRetryOptions + ", reportWorkflowFailureRetryOptions=" + this.reportWorkflowFailureRetryOptions + '}';
    }

    public static final class Builder {
        private boolean disableWorkflowWorker;
        private boolean disableActivityWorker;
        private double workerActivitiesPerSecond;
        private String identity;
        private DataConverter dataConverter = JsonDataConverter.getInstance();
        private int maxConcurrentActivityExecutionSize = 100;
        private int maxConcurrentWorkflowExecutionSize = 50;
        private int maxConcurrentLocalActivityExecutionSize = 100;
        private double taskListActivitiesPerSecond = 100000.0;
        private PollerOptions activityPollerOptions;
        private PollerOptions workflowPollerOptions;
        private RetryOptions reportActivityCompletionRetryOptions;
        private RetryOptions reportActivityFailureRetryOptions;
        private RetryOptions reportWorkflowCompletionRetryOptions;
        private RetryOptions reportWorkflowFailureRetryOptions;
        private Function<WorkflowInterceptor, WorkflowInterceptor> interceptorFactory = n -> n;
        private Scope metricsScope;
        private boolean enableLoggingInReplay;

        public Builder setDisableWorkflowWorker(boolean disableWorkflowWorker) {
            this.disableWorkflowWorker = disableWorkflowWorker;
            return this;
        }

        public Builder setDisableActivityWorker(boolean disableActivityWorker) {
            this.disableActivityWorker = disableActivityWorker;
            return this;
        }

        public Builder setIdentity(String identity) {
            this.identity = Objects.requireNonNull(identity);
            return this;
        }

        public Builder setDataConverter(DataConverter dataConverter) {
            this.dataConverter = Objects.requireNonNull(dataConverter);
            return this;
        }

        public Builder setWorkerActivitiesPerSecond(double workerActivitiesPerSecond) {
            if (workerActivitiesPerSecond <= 0.0) {
                throw new IllegalArgumentException("Negative or zero: " + workerActivitiesPerSecond);
            }
            this.workerActivitiesPerSecond = workerActivitiesPerSecond;
            return this;
        }

        public Builder setMaxConcurrentActivityExecutionSize(int maxConcurrentActivityExecutionSize) {
            if (maxConcurrentActivityExecutionSize <= 0) {
                throw new IllegalArgumentException("Negative or zero: " + maxConcurrentActivityExecutionSize);
            }
            this.maxConcurrentActivityExecutionSize = maxConcurrentActivityExecutionSize;
            return this;
        }

        public Builder setMaxConcurrentWorkflowExecutionSize(int maxConcurrentWorkflowExecutionSize) {
            if (maxConcurrentWorkflowExecutionSize <= 0) {
                throw new IllegalArgumentException("Negative or zero: " + maxConcurrentWorkflowExecutionSize);
            }
            this.maxConcurrentWorkflowExecutionSize = maxConcurrentWorkflowExecutionSize;
            return this;
        }

        public Builder setMaxConcurrentLocalActivityExecutionSize(int maxConcurrentLocalActivityExecutionSize) {
            if (maxConcurrentLocalActivityExecutionSize <= 0) {
                throw new IllegalArgumentException("Negative or zero: " + maxConcurrentLocalActivityExecutionSize);
            }
            this.maxConcurrentLocalActivityExecutionSize = maxConcurrentLocalActivityExecutionSize;
            return this;
        }

        public Builder setActivityPollerOptions(PollerOptions activityPollerOptions) {
            this.activityPollerOptions = Objects.requireNonNull(activityPollerOptions);
            return this;
        }

        public Builder setWorkflowPollerOptions(PollerOptions workflowPollerOptions) {
            this.workflowPollerOptions = Objects.requireNonNull(workflowPollerOptions);
            return this;
        }

        public Builder setReportActivityCompletionRetryOptions(RetryOptions reportActivityCompletionRetryOptions) {
            this.reportActivityCompletionRetryOptions = Objects.requireNonNull(reportActivityCompletionRetryOptions);
            return this;
        }

        public Builder setReportActivityFailureRetryOptions(RetryOptions reportActivityFailureRetryOptions) {
            this.reportActivityFailureRetryOptions = Objects.requireNonNull(reportActivityFailureRetryOptions);
            return this;
        }

        public Builder setReportWorkflowCompletionRetryOptions(RetryOptions reportWorkflowCompletionRetryOptions) {
            this.reportWorkflowCompletionRetryOptions = Objects.requireNonNull(reportWorkflowCompletionRetryOptions);
            return this;
        }

        public Builder setReportWorkflowFailureRetryOptions(RetryOptions reportWorkflowFailureRetryOptions) {
            this.reportWorkflowFailureRetryOptions = Objects.requireNonNull(reportWorkflowFailureRetryOptions);
            return this;
        }

        public Builder setInterceptorFactory(Function<WorkflowInterceptor, WorkflowInterceptor> interceptorFactory) {
            this.interceptorFactory = Objects.requireNonNull(interceptorFactory);
            return this;
        }

        public Builder setMetricsScope(Scope metricsScope) {
            this.metricsScope = Objects.requireNonNull(metricsScope);
            return this;
        }

        public Builder setEnableLoggingInReplay(boolean enableLoggingInReplay) {
            this.enableLoggingInReplay = enableLoggingInReplay;
            return this;
        }

        public Builder setTaskListActivitiesPerSecond(double taskListActivitiesPerSecond) {
            this.taskListActivitiesPerSecond = taskListActivitiesPerSecond;
            return this;
        }

        public WorkerOptions build() {
            if (this.identity == null) {
                this.identity = ManagementFactory.getRuntimeMXBean().getName();
            }
            if (this.metricsScope == null) {
                this.metricsScope = NoopScope.getInstance();
            }
            return new WorkerOptions(this.disableWorkflowWorker, this.disableActivityWorker, this.workerActivitiesPerSecond, this.identity, this.dataConverter, this.maxConcurrentActivityExecutionSize, this.maxConcurrentWorkflowExecutionSize, this.maxConcurrentLocalActivityExecutionSize, this.taskListActivitiesPerSecond, this.activityPollerOptions, this.workflowPollerOptions, this.reportActivityCompletionRetryOptions, this.reportActivityFailureRetryOptions, this.reportWorkflowCompletionRetryOptions, this.reportWorkflowFailureRetryOptions, this.interceptorFactory, this.metricsScope, this.enableLoggingInReplay);
        }
    }
}

