/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.worker;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.uber.cadence.PollForDecisionTaskResponse;
import com.uber.cadence.common.WorkflowExecutionHistory;
import com.uber.cadence.internal.common.InternalUtils;
import com.uber.cadence.internal.metrics.NoopScope;
import com.uber.cadence.internal.replay.DeciderCache;
import com.uber.cadence.internal.sync.SyncActivityWorker;
import com.uber.cadence.internal.sync.SyncWorkflowWorker;
import com.uber.cadence.internal.worker.PollDecisionTaskDispatcher;
import com.uber.cadence.internal.worker.Poller;
import com.uber.cadence.internal.worker.PollerOptions;
import com.uber.cadence.internal.worker.SingleWorkerOptions;
import com.uber.cadence.internal.worker.Suspendable;
import com.uber.cadence.internal.worker.WorkflowPollTaskFactory;
import com.uber.cadence.serviceclient.IWorkflowService;
import com.uber.cadence.serviceclient.WorkflowServiceTChannel;
import com.uber.cadence.worker.WorkerOptions;
import com.uber.cadence.worker.WorkflowImplementationOptions;
import com.uber.cadence.workflow.Functions;
import com.uber.m3.tally.Scope;
import com.uber.m3.util.ImmutableMap;
import java.lang.reflect.Type;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Worker
implements Suspendable {
    private final WorkerOptions options;
    private final String taskList;
    private final SyncWorkflowWorker workflowWorker;
    private final SyncActivityWorker activityWorker;
    private final AtomicBoolean started = new AtomicBoolean();
    private final DeciderCache cache;
    private final String stickyTaskListName;
    private ThreadPoolExecutor threadPoolExecutor;

    private Worker(IWorkflowService service, String domain, String taskList, WorkerOptions options, DeciderCache cache, String stickyTaskListName, Duration stickyDecisionScheduleToStartTimeout, ThreadPoolExecutor threadPoolExecutor) {
        Objects.requireNonNull(service, "service should not be null");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)domain) ? 1 : 0) != 0, (Object)"domain should not be an empty string");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)taskList) ? 1 : 0) != 0, (Object)"taskList should not be an empty string");
        this.cache = cache;
        this.stickyTaskListName = stickyTaskListName;
        this.threadPoolExecutor = Objects.requireNonNull(threadPoolExecutor);
        this.taskList = taskList;
        this.options = (WorkerOptions)MoreObjects.firstNonNull((Object)options, (Object)new WorkerOptions.Builder().build());
        SingleWorkerOptions activityOptions = Worker.toActivityOptions(this.options, domain, taskList);
        this.activityWorker = this.options.isDisableActivityWorker() ? null : new SyncActivityWorker(service, domain, taskList, activityOptions);
        SingleWorkerOptions workflowOptions = Worker.toWorkflowOptions(this.options, domain, taskList);
        SingleWorkerOptions localActivityOptions = Worker.toLocalActivityOptions(this.options, domain, taskList);
        this.workflowWorker = this.options.isDisableWorkflowWorker() ? null : new SyncWorkflowWorker(service, domain, taskList, this.options.getInterceptorFactory(), workflowOptions, localActivityOptions, this.cache, this.stickyTaskListName, stickyDecisionScheduleToStartTimeout, this.threadPoolExecutor);
    }

    private static SingleWorkerOptions toActivityOptions(WorkerOptions options, String domain, String taskList) {
        ImmutableMap tags = new ImmutableMap.Builder(2).put((Object)"Domain", (Object)domain).put((Object)"TaskList", (Object)taskList).build();
        return new SingleWorkerOptions.Builder().setDataConverter(options.getDataConverter()).setIdentity(options.getIdentity()).setPollerOptions(options.getActivityPollerOptions()).setReportCompletionRetryOptions(options.getReportActivityCompletionRetryOptions()).setReportFailureRetryOptions(options.getReportActivityFailureRetryOptions()).setTaskExecutorThreadPoolSize(options.getMaxConcurrentActivityExecutionSize()).setMetricsScope(options.getMetricsScope().tagged((Map)tags)).setEnableLoggingInReplay(options.getEnableLoggingInReplay()).build();
    }

    private static SingleWorkerOptions toWorkflowOptions(WorkerOptions options, String domain, String taskList) {
        ImmutableMap tags = new ImmutableMap.Builder(2).put((Object)"Domain", (Object)domain).put((Object)"TaskList", (Object)taskList).build();
        return new SingleWorkerOptions.Builder().setDataConverter(options.getDataConverter()).setIdentity(options.getIdentity()).setPollerOptions(options.getWorkflowPollerOptions()).setReportCompletionRetryOptions(options.getReportWorkflowCompletionRetryOptions()).setReportFailureRetryOptions(options.getReportWorkflowFailureRetryOptions()).setTaskExecutorThreadPoolSize(options.getMaxConcurrentWorkflowExecutionSize()).setMetricsScope(options.getMetricsScope().tagged((Map)tags)).setEnableLoggingInReplay(options.getEnableLoggingInReplay()).build();
    }

    private static SingleWorkerOptions toLocalActivityOptions(WorkerOptions options, String domain, String taskList) {
        ImmutableMap tags = new ImmutableMap.Builder(2).put((Object)"Domain", (Object)domain).put((Object)"TaskList", (Object)taskList).build();
        return new SingleWorkerOptions.Builder().setDataConverter(options.getDataConverter()).setIdentity(options.getIdentity()).setPollerOptions(options.getWorkflowPollerOptions()).setReportCompletionRetryOptions(options.getReportWorkflowCompletionRetryOptions()).setReportFailureRetryOptions(options.getReportWorkflowFailureRetryOptions()).setTaskExecutorThreadPoolSize(options.getMaxConcurrentLocalActivityExecutionSize()).setMetricsScope(options.getMetricsScope().tagged((Map)tags)).setEnableLoggingInReplay(options.getEnableLoggingInReplay()).build();
    }

    public void registerWorkflowImplementationTypes(Class<?> ... workflowImplementationClasses) {
        Preconditions.checkState((this.workflowWorker != null ? 1 : 0) != 0, (Object)"registerWorkflowImplementationTypes is not allowed when disableWorkflowWorker is set in worker options");
        Preconditions.checkState((!this.started.get() ? 1 : 0) != 0, (Object)"registerWorkflowImplementationTypes is not allowed after worker has started");
        this.workflowWorker.setWorkflowImplementationTypes(new WorkflowImplementationOptions.Builder().build(), workflowImplementationClasses);
    }

    public void registerWorkflowImplementationTypes(WorkflowImplementationOptions options, Class<?> ... workflowImplementationClasses) {
        Preconditions.checkState((this.workflowWorker != null ? 1 : 0) != 0, (Object)"registerWorkflowImplementationTypes is not allowed when disableWorkflowWorker is set in worker options");
        Preconditions.checkState((!this.started.get() ? 1 : 0) != 0, (Object)"registerWorkflowImplementationTypes is not allowed after worker has started");
        this.workflowWorker.setWorkflowImplementationTypes(options, workflowImplementationClasses);
    }

    public <R> void addWorkflowImplementationFactory(WorkflowImplementationOptions options, Class<R> workflowInterface, Functions.Func<R> factory) {
        this.workflowWorker.addWorkflowImplementationFactory(options, workflowInterface, factory);
    }

    @VisibleForTesting
    public <R> void addWorkflowImplementationFactory(Class<R> workflowInterface, Functions.Func<R> factory) {
        this.workflowWorker.addWorkflowImplementationFactory(workflowInterface, factory);
    }

    public void registerActivitiesImplementations(Object ... activityImplementations) {
        Preconditions.checkState((!this.started.get() ? 1 : 0) != 0, (Object)"registerActivitiesImplementations is not allowed after worker has started");
        if (this.activityWorker != null) {
            this.activityWorker.setActivitiesImplementation(activityImplementations);
        }
        if (this.workflowWorker != null) {
            this.workflowWorker.setLocalActivitiesImplementation(activityImplementations);
        }
    }

    private void start() {
        if (!this.started.compareAndSet(false, true)) {
            return;
        }
        if (this.workflowWorker != null) {
            this.workflowWorker.start();
        }
        if (this.activityWorker != null) {
            this.activityWorker.start();
        }
    }

    private void shutdown() {
        if (this.activityWorker != null) {
            this.activityWorker.shutdown();
        }
        if (this.workflowWorker != null) {
            this.workflowWorker.shutdown();
        }
    }

    private void shutdownNow() {
        if (this.activityWorker != null) {
            this.activityWorker.shutdownNow();
        }
        if (this.workflowWorker != null) {
            this.workflowWorker.shutdownNow();
        }
    }

    private boolean isTerminated() {
        return this.activityWorker.isTerminated() && this.workflowWorker.isTerminated();
    }

    private void awaitTermination(long timeout, TimeUnit unit) {
        long timeoutMillis = InternalUtils.awaitTermination(this.activityWorker, unit.toMillis(timeout));
        InternalUtils.awaitTermination(this.workflowWorker, timeoutMillis);
    }

    public String toString() {
        return "Worker{options=" + this.options + '}';
    }

    public void replayWorkflowExecution(WorkflowExecutionHistory history) throws Exception {
        this.workflowWorker.queryWorkflowExecution(history, "__replay_only", String.class, (Type)((Object)String.class), new Object[0]);
    }

    public void replayWorkflowExecution(String jsonSerializedHistory) throws Exception {
        WorkflowExecutionHistory history = WorkflowExecutionHistory.fromJson(jsonSerializedHistory);
        this.replayWorkflowExecution(history);
    }

    public String getTaskList() {
        return this.taskList;
    }

    @Override
    public void suspendPolling() {
        if (this.workflowWorker != null) {
            this.workflowWorker.suspendPolling();
        }
        if (this.activityWorker != null) {
            this.activityWorker.suspendPolling();
        }
    }

    @Override
    public void resumePolling() {
        if (this.workflowWorker != null) {
            this.workflowWorker.resumePolling();
        }
        if (this.activityWorker != null) {
            this.activityWorker.resumePolling();
        }
    }

    @Override
    public boolean isSuspended() {
        boolean workflowWorkerSuspended = true;
        if (this.workflowWorker != null) {
            workflowWorkerSuspended = this.workflowWorker.isSuspended();
        }
        boolean activityWorkerSuspended = this.activityWorker.isSuspended();
        if (this.activityWorker != null) {
            this.activityWorker.resumePolling();
        }
        return workflowWorkerSuspended && activityWorkerSuspended;
    }

    public static class FactoryOptions {
        private final boolean disableStickyExecution;
        private final int cacheMaximumSize;
        private final int maxWorkflowThreadCount;
        private final int stickyDecisionScheduleToStartTimeoutInSeconds;
        private final PollerOptions stickyWorkflowPollerOptions;
        private final Scope metricsScope;

        private FactoryOptions(boolean disableStickyExecution, int cacheMaximumSize, int maxWorkflowThreadCount, int stickyDecisionScheduleToStartTimeoutInSeconds, PollerOptions stickyWorkflowPollerOptions, Scope metricsScope) {
            Preconditions.checkArgument((cacheMaximumSize > 0 ? 1 : 0) != 0, (Object)"cacheMaximumSize should be greater than 0");
            Preconditions.checkArgument((maxWorkflowThreadCount > 0 ? 1 : 0) != 0, (Object)"maxWorkflowThreadCount should be greater than 0");
            Preconditions.checkArgument((stickyDecisionScheduleToStartTimeoutInSeconds > 0 ? 1 : 0) != 0, (Object)"stickyDecisionScheduleToStartTimeoutInSeconds should be greater than 0");
            this.disableStickyExecution = disableStickyExecution;
            this.cacheMaximumSize = cacheMaximumSize;
            this.maxWorkflowThreadCount = maxWorkflowThreadCount;
            this.stickyDecisionScheduleToStartTimeoutInSeconds = stickyDecisionScheduleToStartTimeoutInSeconds;
            this.stickyWorkflowPollerOptions = stickyWorkflowPollerOptions == null ? new PollerOptions.Builder().setPollBackoffInitialInterval(Duration.ofMillis(200L)).setPollBackoffMaximumInterval(Duration.ofSeconds(20L)).setPollThreadCount(1).build() : stickyWorkflowPollerOptions;
            this.metricsScope = metricsScope == null ? NoopScope.getInstance() : metricsScope;
        }

        public static class Builder {
            private boolean disableStickyExecution;
            private int stickyDecisionScheduleToStartTimeoutInSeconds = 5;
            private int cacheMaximumSize = 600;
            private int maxWorkflowThreadCount = 600;
            private PollerOptions stickyWorkflowPollerOptions;
            private Scope metricScope;

            public Builder setDisableStickyExecution(boolean disableStickyExecution) {
                this.disableStickyExecution = disableStickyExecution;
                return this;
            }

            public Builder setCacheMaximumSize(int cacheMaximumSize) {
                this.cacheMaximumSize = cacheMaximumSize;
                return this;
            }

            public Builder setMaxWorkflowThreadCount(int maxWorkflowThreadCount) {
                this.maxWorkflowThreadCount = maxWorkflowThreadCount;
                return this;
            }

            public Builder setStickyDecisionScheduleToStartTimeoutInSeconds(int stickyDecisionScheduleToStartTimeoutInSeconds) {
                this.stickyDecisionScheduleToStartTimeoutInSeconds = stickyDecisionScheduleToStartTimeoutInSeconds;
                return this;
            }

            public Builder setStickyWorkflowPollerOptions(PollerOptions stickyWorkflowPollerOptions) {
                this.stickyWorkflowPollerOptions = stickyWorkflowPollerOptions;
                return this;
            }

            public Builder setMetricScope(Scope metricScope) {
                this.metricScope = metricScope;
                return this;
            }

            public FactoryOptions build() {
                return new FactoryOptions(this.disableStickyExecution, this.cacheMaximumSize, this.maxWorkflowThreadCount, this.stickyDecisionScheduleToStartTimeoutInSeconds, this.stickyWorkflowPollerOptions, this.metricScope);
            }
        }
    }

    public static final class Factory {
        private final List<Worker> workers = new ArrayList<Worker>();
        private final IWorkflowService workflowService;
        private final boolean closeServiceOnShutdown;
        private final String domain;
        private final UUID id = UUID.randomUUID();
        private final ThreadPoolExecutor workflowThreadPool;
        private final AtomicInteger workflowThreadCounter = new AtomicInteger();
        private final FactoryOptions factoryOptions;
        private Poller<PollForDecisionTaskResponse> stickyPoller;
        private PollDecisionTaskDispatcher dispatcher;
        private DeciderCache cache;
        private State state = State.Initial;
        private final String statusErrorMessage = "attempted to %s while in %s state. Acceptable States: %s";
        private static final Logger log = LoggerFactory.getLogger(Factory.class);

        public Factory(String domain) {
            this(new WorkflowServiceTChannel(), true, domain, null);
        }

        public Factory(String host, int port, String domain) {
            this(new WorkflowServiceTChannel(host, port), true, domain, null);
        }

        public Factory(String domain, FactoryOptions factoryOptions) {
            this(new WorkflowServiceTChannel(), true, domain, factoryOptions);
        }

        public Factory(String host, int port, String domain, FactoryOptions factoryOptions) {
            this(new WorkflowServiceTChannel(host, port), true, domain, factoryOptions);
        }

        public Factory(IWorkflowService workflowService, String domain) {
            this(workflowService, false, domain, null);
        }

        public Factory(IWorkflowService workflowService, String domain, FactoryOptions factoryOptions) {
            this(workflowService, false, domain, factoryOptions);
        }

        private Factory(IWorkflowService workflowService, boolean closeServiceOnShutdown, String domain, FactoryOptions factoryOptions) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)domain) ? 1 : 0) != 0, (Object)"domain should not be an empty string");
            this.domain = domain;
            this.workflowService = Objects.requireNonNull(workflowService, "workflowService should not be null");
            this.closeServiceOnShutdown = closeServiceOnShutdown;
            this.factoryOptions = factoryOptions = factoryOptions == null ? new FactoryOptions.Builder().build() : factoryOptions;
            this.workflowThreadPool = new ThreadPoolExecutor(0, this.factoryOptions.maxWorkflowThreadCount, 1L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
            this.workflowThreadPool.setThreadFactory(r -> new Thread(r, "workflow-thread-" + this.workflowThreadCounter.incrementAndGet()));
            if (this.factoryOptions.disableStickyExecution) {
                return;
            }
            Scope metricsScope = this.factoryOptions.metricsScope.tagged((Map)new ImmutableMap.Builder(2).put((Object)"Domain", (Object)domain).put((Object)"TaskList", (Object)this.getHostName()).build());
            this.cache = new DeciderCache(this.factoryOptions.cacheMaximumSize, metricsScope);
            this.dispatcher = new PollDecisionTaskDispatcher(workflowService);
            this.stickyPoller = new Poller<PollForDecisionTaskResponse>(this.id.toString(), (Poller.PollTask<PollForDecisionTaskResponse>)new WorkflowPollTaskFactory(workflowService, domain, this.getStickyTaskListName(), metricsScope, this.id.toString()).get(), this.dispatcher, this.factoryOptions.stickyWorkflowPollerOptions, metricsScope);
        }

        public Worker newWorker(String taskList) {
            return this.newWorker(taskList, null);
        }

        public synchronized Worker newWorker(String taskList, WorkerOptions options) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)taskList) ? 1 : 0) != 0, (Object)"taskList should not be an empty string");
            Preconditions.checkState((this.state == State.Initial ? 1 : 0) != 0, (Object)String.format("attempted to %s while in %s state. Acceptable States: %s", "create new worker", this.state.name(), State.Initial.name()));
            Worker worker = new Worker(this.workflowService, this.domain, taskList, options, this.cache, this.getStickyTaskListName(), Duration.ofSeconds(this.factoryOptions.stickyDecisionScheduleToStartTimeoutInSeconds), this.workflowThreadPool);
            this.workers.add(worker);
            if (!this.factoryOptions.disableStickyExecution) {
                this.dispatcher.subscribe(taskList, worker.workflowWorker);
            }
            return worker;
        }

        public synchronized void start() {
            Preconditions.checkState((this.state == State.Initial || this.state == State.Started ? 1 : 0) != 0, (Object)String.format("attempted to %s while in %s state. Acceptable States: %s", "start WorkerFactory", this.state.name(), String.format("%s, %s", State.Initial.name(), State.Initial.name())));
            if (this.state == State.Started) {
                return;
            }
            this.state = State.Started;
            for (Worker worker : this.workers) {
                worker.start();
            }
            if (this.stickyPoller != null) {
                this.stickyPoller.start();
            }
        }

        public synchronized boolean isStarted() {
            return this.state != State.Initial;
        }

        public synchronized boolean isShutdown() {
            return this.state == State.Shutdown;
        }

        public synchronized boolean isTerminated() {
            if (this.state != State.Shutdown) {
                return false;
            }
            if (this.stickyPoller != null && !this.stickyPoller.isTerminated()) {
                return false;
            }
            for (Worker worker : this.workers) {
                if (worker.isTerminated()) continue;
                return false;
            }
            return true;
        }

        public IWorkflowService getWorkflowService() {
            return this.workflowService;
        }

        public synchronized void shutdown() {
            log.info("shutdown");
            this.state = State.Shutdown;
            if (this.stickyPoller != null) {
                this.stickyPoller.shutdown();
                this.stickyPoller.awaitTermination(1L, TimeUnit.SECONDS);
            }
            for (Worker worker : this.workers) {
                worker.shutdown();
            }
            this.closeServiceWhenTerminated();
        }

        private void closeServiceWhenTerminated() {
            if (this.closeServiceOnShutdown) {
                ForkJoinPool.commonPool().execute(() -> {
                    this.awaitTermination(1L, TimeUnit.HOURS);
                    log.info("Closing workflow service client");
                    this.workflowService.close();
                });
            }
        }

        public synchronized void shutdownNow() {
            log.info("shutdownNow");
            this.state = State.Shutdown;
            if (this.stickyPoller != null) {
                this.stickyPoller.shutdownNow();
                this.stickyPoller.awaitTermination(1L, TimeUnit.SECONDS);
            }
            for (Worker worker : this.workers) {
                worker.shutdownNow();
            }
            this.closeServiceWhenTerminated();
        }

        public void awaitTermination(long timeout, TimeUnit unit) {
            log.info("awaitTermination begin");
            long timeoutMillis = unit.toMillis(timeout);
            timeoutMillis = InternalUtils.awaitTermination(this.stickyPoller, timeoutMillis);
            for (Worker worker : this.workers) {
                long t = timeoutMillis;
                timeoutMillis = InternalUtils.awaitTermination(timeoutMillis, () -> worker.awaitTermination(t, TimeUnit.MILLISECONDS));
            }
            log.info("awaitTermination done");
        }

        @VisibleForTesting
        DeciderCache getCache() {
            return this.cache;
        }

        @VisibleForTesting
        String getHostName() {
            try {
                return InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                return "UnknownHost";
            }
        }

        private String getStickyTaskListName() {
            return this.factoryOptions.disableStickyExecution ? null : String.format("%s:%s", this.getHostName(), this.id);
        }

        public synchronized void suspendPolling() {
            if (this.state != State.Started) {
                return;
            }
            log.info("suspendPolling");
            this.state = State.Suspended;
            if (this.stickyPoller != null) {
                this.stickyPoller.suspendPolling();
            }
            for (Worker worker : this.workers) {
                worker.suspendPolling();
            }
        }

        public synchronized void resumePolling() {
            if (this.state != State.Suspended) {
                return;
            }
            log.info("resumePolling");
            this.state = State.Started;
            if (this.stickyPoller != null) {
                this.stickyPoller.resumePolling();
            }
            for (Worker worker : this.workers) {
                worker.resumePolling();
            }
        }

        static enum State {
            Initial,
            Started,
            Suspended,
            Shutdown;

        }
    }
}

