/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.testing;

import com.google.common.annotations.VisibleForTesting;
import com.uber.cadence.converter.DataConverter;
import com.uber.cadence.converter.JsonDataConverter;
import com.uber.cadence.internal.metrics.NoopScope;
import com.uber.cadence.worker.Worker;
import com.uber.cadence.workflow.WorkflowInterceptor;
import com.uber.m3.tally.Scope;
import java.util.Objects;
import java.util.function.Function;

@VisibleForTesting
public final class TestEnvironmentOptions {
    private final DataConverter dataConverter;
    private final String domain;
    private final Function<WorkflowInterceptor, WorkflowInterceptor> interceptorFactory;
    private final Scope metricsScope;
    private final boolean enableLoggingInReplay;
    private final Worker.FactoryOptions workerFactoryOptions;

    private TestEnvironmentOptions(DataConverter dataConverter, String domain, Function<WorkflowInterceptor, WorkflowInterceptor> interceptorFactory, Scope metricsScope, Worker.FactoryOptions options, boolean enableLoggingInReplay) {
        this.dataConverter = dataConverter;
        this.domain = domain;
        this.interceptorFactory = interceptorFactory;
        this.metricsScope = metricsScope;
        this.workerFactoryOptions = options;
        this.enableLoggingInReplay = enableLoggingInReplay;
    }

    public DataConverter getDataConverter() {
        return this.dataConverter;
    }

    public String getDomain() {
        return this.domain;
    }

    public Function<WorkflowInterceptor, WorkflowInterceptor> getInterceptorFactory() {
        return this.interceptorFactory;
    }

    public Scope getMetricsScope() {
        return this.metricsScope;
    }

    public boolean isLoggingEnabledInReplay() {
        return this.enableLoggingInReplay;
    }

    public Worker.FactoryOptions getWorkerFactoryOptions() {
        return this.workerFactoryOptions;
    }

    public String toString() {
        return "TestEnvironmentOptions{dataConverter=" + this.dataConverter + ", domain='" + this.domain + '\'' + '}';
    }

    public static final class Builder {
        private DataConverter dataConverter = JsonDataConverter.getInstance();
        private String domain = "unit-test";
        private Function<WorkflowInterceptor, WorkflowInterceptor> interceptorFactory = n -> n;
        private Scope metricsScope;
        private boolean enableLoggingInReplay;
        private Worker.FactoryOptions factoryOptions;

        public Builder setDataConverter(DataConverter dataConverter) {
            this.dataConverter = Objects.requireNonNull(dataConverter);
            return this;
        }

        public Builder setDomain(String domain) {
            this.domain = Objects.requireNonNull(domain);
            return this;
        }

        public Builder setInterceptorFactory(Function<WorkflowInterceptor, WorkflowInterceptor> interceptorFactory) {
            this.interceptorFactory = Objects.requireNonNull(interceptorFactory);
            return this;
        }

        public Builder setMetricsScope(Scope metricsScope) {
            this.metricsScope = metricsScope;
            return this;
        }

        public Builder setFactoryOptions(Worker.FactoryOptions options) {
            this.factoryOptions = options;
            return this;
        }

        public Builder setEnableLoggingInReplay(boolean enableLoggingInReplay) {
            this.enableLoggingInReplay = enableLoggingInReplay;
            return this;
        }

        public TestEnvironmentOptions build() {
            if (this.metricsScope == null) {
                this.metricsScope = NoopScope.getInstance();
            }
            if (this.factoryOptions == null) {
                this.factoryOptions = new Worker.FactoryOptions.Builder().setDisableStickyExecution(false).build();
            }
            return new TestEnvironmentOptions(this.dataConverter, this.domain, this.interceptorFactory, this.metricsScope, this.factoryOptions, this.enableLoggingInReplay);
        }
    }
}

