/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.serviceclient;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.uber.cadence.BadRequestError;
import com.uber.cadence.ClientVersionNotSupportedError;
import com.uber.cadence.CountWorkflowExecutionsRequest;
import com.uber.cadence.CountWorkflowExecutionsResponse;
import com.uber.cadence.DeprecateDomainRequest;
import com.uber.cadence.DescribeDomainRequest;
import com.uber.cadence.DescribeDomainResponse;
import com.uber.cadence.DescribeTaskListRequest;
import com.uber.cadence.DescribeTaskListResponse;
import com.uber.cadence.DescribeWorkflowExecutionRequest;
import com.uber.cadence.DescribeWorkflowExecutionResponse;
import com.uber.cadence.DomainAlreadyExistsError;
import com.uber.cadence.DomainNotActiveError;
import com.uber.cadence.EntityNotExistsError;
import com.uber.cadence.GetSearchAttributesResponse;
import com.uber.cadence.GetWorkflowExecutionHistoryRequest;
import com.uber.cadence.GetWorkflowExecutionHistoryResponse;
import com.uber.cadence.InternalServiceError;
import com.uber.cadence.LimitExceededError;
import com.uber.cadence.ListClosedWorkflowExecutionsRequest;
import com.uber.cadence.ListClosedWorkflowExecutionsResponse;
import com.uber.cadence.ListDomainsRequest;
import com.uber.cadence.ListDomainsResponse;
import com.uber.cadence.ListOpenWorkflowExecutionsRequest;
import com.uber.cadence.ListOpenWorkflowExecutionsResponse;
import com.uber.cadence.ListWorkflowExecutionsRequest;
import com.uber.cadence.ListWorkflowExecutionsResponse;
import com.uber.cadence.PollForActivityTaskRequest;
import com.uber.cadence.PollForActivityTaskResponse;
import com.uber.cadence.PollForDecisionTaskRequest;
import com.uber.cadence.PollForDecisionTaskResponse;
import com.uber.cadence.QueryFailedError;
import com.uber.cadence.QueryWorkflowRequest;
import com.uber.cadence.QueryWorkflowResponse;
import com.uber.cadence.RecordActivityTaskHeartbeatByIDRequest;
import com.uber.cadence.RecordActivityTaskHeartbeatRequest;
import com.uber.cadence.RecordActivityTaskHeartbeatResponse;
import com.uber.cadence.RegisterDomainRequest;
import com.uber.cadence.RequestCancelWorkflowExecutionRequest;
import com.uber.cadence.ResetStickyTaskListRequest;
import com.uber.cadence.ResetStickyTaskListResponse;
import com.uber.cadence.ResetWorkflowExecutionRequest;
import com.uber.cadence.ResetWorkflowExecutionResponse;
import com.uber.cadence.RespondActivityTaskCanceledByIDRequest;
import com.uber.cadence.RespondActivityTaskCanceledRequest;
import com.uber.cadence.RespondActivityTaskCompletedByIDRequest;
import com.uber.cadence.RespondActivityTaskCompletedRequest;
import com.uber.cadence.RespondActivityTaskFailedByIDRequest;
import com.uber.cadence.RespondActivityTaskFailedRequest;
import com.uber.cadence.RespondDecisionTaskCompletedRequest;
import com.uber.cadence.RespondDecisionTaskCompletedResponse;
import com.uber.cadence.RespondDecisionTaskFailedRequest;
import com.uber.cadence.RespondQueryTaskCompletedRequest;
import com.uber.cadence.ServiceBusyError;
import com.uber.cadence.SignalWithStartWorkflowExecutionRequest;
import com.uber.cadence.SignalWorkflowExecutionRequest;
import com.uber.cadence.StartWorkflowExecutionRequest;
import com.uber.cadence.StartWorkflowExecutionResponse;
import com.uber.cadence.TerminateWorkflowExecutionRequest;
import com.uber.cadence.UpdateDomainRequest;
import com.uber.cadence.UpdateDomainResponse;
import com.uber.cadence.WorkflowExecutionAlreadyStartedError;
import com.uber.cadence.WorkflowService;
import com.uber.cadence.internal.Version;
import com.uber.cadence.internal.common.CheckedExceptionWrapper;
import com.uber.cadence.internal.metrics.NoopScope;
import com.uber.cadence.serviceclient.IWorkflowService;
import com.uber.m3.tally.Scope;
import com.uber.m3.tally.Stopwatch;
import com.uber.tchannel.api.ResponseCode;
import com.uber.tchannel.api.SubChannel;
import com.uber.tchannel.api.TChannel;
import com.uber.tchannel.api.TFuture;
import com.uber.tchannel.api.errors.TChannelError;
import com.uber.tchannel.messages.ThriftRequest;
import com.uber.tchannel.messages.ThriftResponse;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.thrift.TException;
import org.apache.thrift.async.AsyncMethodCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowServiceTChannel
implements IWorkflowService {
    private static final int DEFAULT_LOCAL_CADENCE_SERVER_PORT = 7933;
    private static final String LOCALHOST = "127.0.0.1";
    private static final long DEFAULT_RPC_TIMEOUT_MILLIS = 1000L;
    private static final long DEFAULT_POLL_RPC_TIMEOUT_MILLIS = 121000L;
    private static final long DEFAULT_QUERY_RPC_TIMEOUT_MILLIS = 10000L;
    private static final String DEFAULT_CLIENT_APP_NAME = "cadence-client";
    private static final String DEFAULT_SERVICE_NAME = "cadence-frontend";
    private static final Logger log = LoggerFactory.getLogger(WorkflowServiceTChannel.class);
    private static final String INTERFACE_NAME = "WorkflowService";
    private final ClientOptions options;
    private final Map<String, String> thriftHeaders;
    private final TChannel tChannel;
    private final SubChannel subChannel;

    public WorkflowServiceTChannel() {
        this(Strings.isNullOrEmpty((String)System.getenv("CADENCE_SEEDS")) ? LOCALHOST : System.getenv("CADENCE_SEEDS"), 7933, new ClientOptions.Builder().build());
    }

    public WorkflowServiceTChannel(String host, int port) {
        this(host, port, new ClientOptions.Builder().build());
    }

    public WorkflowServiceTChannel(String host, int port, ClientOptions options) {
        if (host == null) {
            throw new IllegalArgumentException("null host");
        }
        if (port <= 0) {
            throw new IllegalArgumentException("0 or negative port");
        }
        this.options = options;
        this.thriftHeaders = WorkflowServiceTChannel.getThriftHeaders(options);
        this.tChannel = new TChannel.Builder(options.getClientAppName()).build();
        try {
            InetAddress address = InetAddress.getByName(host);
            ArrayList<InetSocketAddress> peers = new ArrayList<InetSocketAddress>();
            peers.add(new InetSocketAddress(address, port));
            this.subChannel = this.tChannel.makeSubChannel(options.getServiceName()).setPeers(peers);
            log.info("Initialized TChannel for service " + this.subChannel.getServiceName() + ", LibraryVersion: " + Version.LIBRARY_VERSION + ", FeatureVersion: " + "1.2.0");
        }
        catch (UnknownHostException e) {
            this.tChannel.shutdown();
            throw new RuntimeException("Unable to get name of host " + host, e);
        }
    }

    public WorkflowServiceTChannel(SubChannel subChannel, ClientOptions options) {
        this.options = options;
        this.thriftHeaders = WorkflowServiceTChannel.getThriftHeaders(options);
        this.tChannel = null;
        this.subChannel = subChannel;
    }

    private static Map<String, String> getThriftHeaders(ClientOptions options) {
        String envHostname;
        String envUserName = System.getProperty("user.name");
        try {
            envHostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            envHostname = "localhost";
        }
        ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)"user-name", (Object)envUserName).put((Object)"host-name", (Object)envHostname).put((Object)"cadence-client-library-version", (Object)Version.LIBRARY_VERSION).put((Object)"cadence-client-feature-version", (Object)"1.2.0");
        if (options.headers != null) {
            for (Map.Entry entry : options.headers.entrySet()) {
                builder.put((Object)((String)entry.getKey()), (Object)((String)entry.getValue()));
            }
        }
        return builder.build();
    }

    private static String getEndpoint(String service, String method) {
        return String.format("%s::%s", service, method);
    }

    private <T> ThriftRequest<T> buildThriftRequest(String apiName, T body) {
        return this.buildThriftRequest(apiName, body, null);
    }

    private <T> ThriftRequest<T> buildThriftRequest(String apiName, T body, Long rpcTimeoutOverride) {
        String endpoint = WorkflowServiceTChannel.getEndpoint(INTERFACE_NAME, apiName);
        ThriftRequest.Builder builder = new ThriftRequest.Builder(this.options.getServiceName(), endpoint);
        builder.setHeaders(new HashMap<String, String>(this.thriftHeaders));
        if (rpcTimeoutOverride != null) {
            builder.setTimeout(rpcTimeoutOverride.longValue());
        } else {
            builder.setTimeout(this.options.getRpcTimeoutMillis());
        }
        for (Map.Entry<String, String> header : this.options.getTransportHeaders().entrySet()) {
            builder.setTransportHeader(header.getKey(), header.getValue());
        }
        builder.setBody(body);
        return builder.build();
    }

    private <T> ThriftResponse<T> doRemoteCall(ThriftRequest<?> request) throws TException {
        ThriftResponse response = null;
        try {
            TFuture future = this.subChannel.send(request);
            response = (ThriftResponse)future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new TException((Throwable)e);
        }
        catch (ExecutionException e) {
            throw new TException((Throwable)e);
        }
        catch (TChannelError e) {
            throw new TException("Rpc error", (Throwable)e);
        }
        this.throwOnRpcError(response);
        return response;
    }

    private <T> CompletableFuture<ThriftResponse<T>> doRemoteCallAsync(ThriftRequest<?> request) {
        CompletableFuture result = new CompletableFuture();
        TFuture future = null;
        try {
            future = this.subChannel.send(request);
        }
        catch (TChannelError tChannelError) {
            result.completeExceptionally(new TException((Throwable)tChannelError));
        }
        future.addCallback(response -> {
            if (response.isError()) {
                result.completeExceptionally(new TException("Rpc error:" + response.getError()));
            } else {
                result.complete((ThriftResponse)response);
            }
        });
        return result;
    }

    private void throwOnRpcError(ThriftResponse<?> response) throws TException {
        if (response.isError()) {
            throw new TException("Rpc error:" + response.getError());
        }
    }

    @Override
    public void close() {
        if (this.tChannel != null) {
            this.tChannel.shutdown();
        }
    }

    private <T> T measureRemoteCall(String scopeName, RemoteCall<T> call) throws TException {
        Scope scope = this.options.getMetricsScope().subScope(scopeName);
        scope.counter("cadence-request").inc(1L);
        Stopwatch sw = scope.timer("cadence-latency").start();
        try {
            T resp = call.apply();
            sw.stop();
            return resp;
        }
        catch (BadRequestError | DomainAlreadyExistsError | EntityNotExistsError | QueryFailedError | WorkflowExecutionAlreadyStartedError e) {
            sw.stop();
            scope.counter("cadence-invalid-request").inc(1L);
            throw e;
        }
        catch (TException e) {
            sw.stop();
            scope.counter("cadence-error").inc(1L);
            throw e;
        }
    }

    private void measureRemoteProc(String scopeName, RemoteProc proc) throws TException {
        this.measureRemoteCall(scopeName, () -> {
            proc.apply();
            return null;
        });
    }

    @Override
    public void RegisterDomain(RegisterDomainRequest request) throws TException {
        this.measureRemoteProc("cadence-RegisterDomain", () -> this.registerDomain(request));
    }

    private void registerDomain(RegisterDomainRequest registerRequest) throws TException {
        ThriftResponse response = null;
        try {
            ThriftRequest<WorkflowService.RegisterDomain_args> request = this.buildThriftRequest("RegisterDomain", new WorkflowService.RegisterDomain_args(registerRequest));
            response = this.doRemoteCall(request);
            WorkflowService.RegisterDomain_result result = (WorkflowService.RegisterDomain_result)response.getBody(WorkflowService.RegisterDomain_result.class);
            if (response.getResponseCode() == ResponseCode.OK) {
                return;
            }
            if (result.isSetBadRequestError()) {
                throw result.getBadRequestError();
            }
            if (result.isSetInternalServiceError()) {
                throw result.getInternalServiceError();
            }
            if (result.isSetDomainExistsError()) {
                throw result.getDomainExistsError();
            }
            if (result.isSetServiceBusyError()) {
                throw result.getServiceBusyError();
            }
            throw new TException("RegisterDomain failed with unknown error:" + result);
        }
        finally {
            if (response != null) {
                response.release();
            }
        }
    }

    @Override
    public DescribeDomainResponse DescribeDomain(DescribeDomainRequest describeRequest) throws TException {
        return this.measureRemoteCall("cadence-DescribeDomain", () -> this.describeDomain(describeRequest));
    }

    private DescribeDomainResponse describeDomain(DescribeDomainRequest describeRequest) throws TException {
        ThriftResponse response = null;
        try {
            ThriftRequest<WorkflowService.DescribeDomain_args> request = this.buildThriftRequest("DescribeDomain", new WorkflowService.DescribeDomain_args(describeRequest));
            response = this.doRemoteCall(request);
            WorkflowService.DescribeDomain_result result = (WorkflowService.DescribeDomain_result)response.getBody(WorkflowService.DescribeDomain_result.class);
            if (response.getResponseCode() == ResponseCode.OK) {
                DescribeDomainResponse describeDomainResponse = result.getSuccess();
                return describeDomainResponse;
            }
            if (result.isSetBadRequestError()) {
                throw result.getBadRequestError();
            }
            if (result.isSetInternalServiceError()) {
                throw result.getInternalServiceError();
            }
            if (result.isSetEntityNotExistError()) {
                throw result.getEntityNotExistError();
            }
            if (result.isSetServiceBusyError()) {
                throw result.getServiceBusyError();
            }
            throw new TException("DescribeDomain failed with unknown error:" + result);
        }
        finally {
            if (response != null) {
                response.release();
            }
        }
    }

    @Override
    public ListDomainsResponse ListDomains(ListDomainsRequest listRequest) throws BadRequestError, InternalServiceError, EntityNotExistsError, ServiceBusyError, TException {
        return this.measureRemoteCall("cadence-ListDomains", () -> this.listDomains(listRequest));
    }

    private ListDomainsResponse listDomains(ListDomainsRequest describeRequest) throws TException {
        ThriftResponse response = null;
        try {
            ThriftRequest<WorkflowService.ListDomains_args> request = this.buildThriftRequest("ListDomains", new WorkflowService.ListDomains_args(describeRequest));
            response = this.doRemoteCall(request);
            WorkflowService.ListDomains_result result = (WorkflowService.ListDomains_result)response.getBody(WorkflowService.ListDomains_result.class);
            if (response.getResponseCode() == ResponseCode.OK) {
                ListDomainsResponse listDomainsResponse = result.getSuccess();
                return listDomainsResponse;
            }
            if (result.isSetBadRequestError()) {
                throw result.getBadRequestError();
            }
            if (result.isSetInternalServiceError()) {
                throw result.getInternalServiceError();
            }
            if (result.isSetEntityNotExistError()) {
                throw result.getEntityNotExistError();
            }
            if (result.isSetServiceBusyError()) {
                throw result.getServiceBusyError();
            }
            throw new TException("ListDomains failed with unknown error:" + result);
        }
        finally {
            if (response != null) {
                response.release();
            }
        }
    }

    @Override
    public UpdateDomainResponse UpdateDomain(UpdateDomainRequest updateRequest) throws TException {
        return this.measureRemoteCall("cadence-UpdateDomain", () -> this.updateDomain(updateRequest));
    }

    private UpdateDomainResponse updateDomain(UpdateDomainRequest updateRequest) throws TException {
        ThriftResponse response = null;
        try {
            ThriftRequest<WorkflowService.UpdateDomain_args> request = this.buildThriftRequest("UpdateDomain", new WorkflowService.UpdateDomain_args(updateRequest));
            response = this.doRemoteCall(request);
            WorkflowService.UpdateDomain_result result = (WorkflowService.UpdateDomain_result)response.getBody(WorkflowService.UpdateDomain_result.class);
            if (response.getResponseCode() == ResponseCode.OK) {
                UpdateDomainResponse updateDomainResponse = result.getSuccess();
                return updateDomainResponse;
            }
            if (result.isSetBadRequestError()) {
                throw result.getBadRequestError();
            }
            if (result.isSetInternalServiceError()) {
                throw result.getInternalServiceError();
            }
            if (result.isSetEntityNotExistError()) {
                throw result.getEntityNotExistError();
            }
            if (result.isSetServiceBusyError()) {
                throw result.getServiceBusyError();
            }
            if (result.isSetDomainNotActiveError()) {
                throw result.getDomainNotActiveError();
            }
            throw new TException("UpdateDomain failed with unknown error:" + result);
        }
        finally {
            if (response != null) {
                response.release();
            }
        }
    }

    @Override
    public void DeprecateDomain(DeprecateDomainRequest deprecateRequest) throws TException {
        this.measureRemoteProc("cadence-DeprecateDomain", () -> this.deprecateDomain(deprecateRequest));
    }

    private void deprecateDomain(DeprecateDomainRequest deprecateRequest) throws TException {
        ThriftResponse response = null;
        try {
            ThriftRequest<WorkflowService.DeprecateDomain_args> request = this.buildThriftRequest("DeprecateDomain", new WorkflowService.DeprecateDomain_args(deprecateRequest));
            response = this.doRemoteCall(request);
            WorkflowService.DeprecateDomain_result result = (WorkflowService.DeprecateDomain_result)response.getBody(WorkflowService.DeprecateDomain_result.class);
            if (response.getResponseCode() == ResponseCode.OK) {
                return;
            }
            if (result.isSetBadRequestError()) {
                throw result.getBadRequestError();
            }
            if (result.isSetInternalServiceError()) {
                throw result.getInternalServiceError();
            }
            if (result.isSetEntityNotExistError()) {
                throw result.getEntityNotExistError();
            }
            if (result.isSetServiceBusyError()) {
                throw result.getServiceBusyError();
            }
            if (result.isSetDomainNotActiveError()) {
                throw result.getDomainNotActiveError();
            }
            throw new TException("DeprecateDomain failed with unknown error:" + result);
        }
        finally {
            if (response != null) {
                response.release();
            }
        }
    }

    @Override
    public StartWorkflowExecutionResponse StartWorkflowExecution(StartWorkflowExecutionRequest request) throws TException {
        return this.measureRemoteCall("cadence-StartWorkflowExecution", () -> this.startWorkflowExecution(request));
    }

    private StartWorkflowExecutionResponse startWorkflowExecution(StartWorkflowExecutionRequest startRequest) throws TException {
        startRequest.setRequestId(UUID.randomUUID().toString());
        ThriftResponse response = null;
        try {
            ThriftRequest<WorkflowService.StartWorkflowExecution_args> request = this.buildThriftRequest("StartWorkflowExecution", new WorkflowService.StartWorkflowExecution_args(startRequest));
            response = this.doRemoteCall(request);
            WorkflowService.StartWorkflowExecution_result result = (WorkflowService.StartWorkflowExecution_result)response.getBody(WorkflowService.StartWorkflowExecution_result.class);
            if (response.getResponseCode() == ResponseCode.OK) {
                StartWorkflowExecutionResponse startWorkflowExecutionResponse = result.getSuccess();
                return startWorkflowExecutionResponse;
            }
            if (result.isSetBadRequestError()) {
                throw result.getBadRequestError();
            }
            if (result.isSetInternalServiceError()) {
                throw result.getInternalServiceError();
            }
            if (result.isSetSessionAlreadyExistError()) {
                throw result.getSessionAlreadyExistError();
            }
            if (result.isSetServiceBusyError()) {
                throw result.getServiceBusyError();
            }
            if (result.isSetDomainNotActiveError()) {
                throw result.getDomainNotActiveError();
            }
            if (result.isSetLimitExceededError()) {
                throw result.getLimitExceededError();
            }
            if (result.isSetEntityNotExistError()) {
                throw result.getEntityNotExistError();
            }
            throw new TException("StartWorkflowExecution failed with unknown error:" + result);
        }
        finally {
            if (response != null) {
                response.release();
            }
        }
    }

    @Override
    public GetWorkflowExecutionHistoryResponse GetWorkflowExecutionHistory(GetWorkflowExecutionHistoryRequest request) throws TException {
        return this.measureRemoteCall("cadence-GetWorkflowExecutionHistory", () -> this.getWorkflowExecutionHistory(request));
    }

    private GetWorkflowExecutionHistoryResponse getWorkflowExecutionHistory(GetWorkflowExecutionHistoryRequest getRequest) throws TException {
        ThriftResponse response = null;
        try {
            ThriftRequest<WorkflowService.GetWorkflowExecutionHistory_args> request = getRequest.isWaitForNewEvent() ? this.buildThriftRequest("GetWorkflowExecutionHistory", new WorkflowService.GetWorkflowExecutionHistory_args(getRequest), this.options.getRpcLongPollTimeoutMillis()) : this.buildThriftRequest("GetWorkflowExecutionHistory", new WorkflowService.GetWorkflowExecutionHistory_args(getRequest));
            response = this.doRemoteCall(request);
            WorkflowService.GetWorkflowExecutionHistory_result result = (WorkflowService.GetWorkflowExecutionHistory_result)response.getBody(WorkflowService.GetWorkflowExecutionHistory_result.class);
            if (response.getResponseCode() == ResponseCode.OK) {
                GetWorkflowExecutionHistoryResponse getWorkflowExecutionHistoryResponse = result.getSuccess();
                return getWorkflowExecutionHistoryResponse;
            }
            if (result.isSetBadRequestError()) {
                throw result.getBadRequestError();
            }
            if (result.isSetInternalServiceError()) {
                throw result.getInternalServiceError();
            }
            if (result.isSetEntityNotExistError()) {
                throw result.getEntityNotExistError();
            }
            if (result.isSetServiceBusyError()) {
                throw result.getServiceBusyError();
            }
            if (result.isSetEntityNotExistError()) {
                throw result.getEntityNotExistError();
            }
            throw new TException("GetWorkflowExecutionHistory failed with unknown error:" + result);
        }
        finally {
            if (response != null) {
                response.release();
            }
        }
    }

    @Override
    public PollForDecisionTaskResponse PollForDecisionTask(PollForDecisionTaskRequest request) throws TException {
        return this.measureRemoteCall("cadence-PollForDecisionTask", () -> this.pollForDecisionTask(request));
    }

    private PollForDecisionTaskResponse pollForDecisionTask(PollForDecisionTaskRequest pollRequest) throws TException {
        ThriftResponse response = null;
        try {
            ThriftRequest<WorkflowService.PollForDecisionTask_args> request = this.buildThriftRequest("PollForDecisionTask", new WorkflowService.PollForDecisionTask_args(pollRequest), this.options.getRpcLongPollTimeoutMillis());
            response = this.doRemoteCall(request);
            WorkflowService.PollForDecisionTask_result result = (WorkflowService.PollForDecisionTask_result)response.getBody(WorkflowService.PollForDecisionTask_result.class);
            if (response.getResponseCode() == ResponseCode.OK) {
                PollForDecisionTaskResponse pollForDecisionTaskResponse = result.getSuccess();
                return pollForDecisionTaskResponse;
            }
            if (result.isSetBadRequestError()) {
                throw result.getBadRequestError();
            }
            if (result.isSetInternalServiceError()) {
                throw result.getInternalServiceError();
            }
            if (result.isSetServiceBusyError()) {
                throw result.getServiceBusyError();
            }
            if (result.isSetDomainNotActiveError()) {
                throw result.getDomainNotActiveError();
            }
            if (result.isSetLimitExceededError()) {
                throw result.getLimitExceededError();
            }
            if (result.isSetEntityNotExistError()) {
                throw result.getEntityNotExistError();
            }
            throw new TException("PollForDecisionTask failed with unknown error:" + result);
        }
        finally {
            if (response != null) {
                response.release();
            }
        }
    }

    @Override
    public RespondDecisionTaskCompletedResponse RespondDecisionTaskCompleted(RespondDecisionTaskCompletedRequest completedRequest) throws TException {
        return this.measureRemoteCall("cadence-RespondDecisionTaskCompleted", () -> this.respondDecisionTaskCompleted(completedRequest));
    }

    private RespondDecisionTaskCompletedResponse respondDecisionTaskCompleted(RespondDecisionTaskCompletedRequest completedRequest) throws TException {
        ThriftResponse response = null;
        try {
            ThriftRequest<WorkflowService.RespondDecisionTaskCompleted_args> request = this.buildThriftRequest("RespondDecisionTaskCompleted", new WorkflowService.RespondDecisionTaskCompleted_args(completedRequest));
            response = this.doRemoteCall(request);
            WorkflowService.RespondDecisionTaskCompleted_result result = (WorkflowService.RespondDecisionTaskCompleted_result)response.getBody(WorkflowService.RespondDecisionTaskCompleted_result.class);
            if (response.getResponseCode() == ResponseCode.OK) {
                RespondDecisionTaskCompletedResponse respondDecisionTaskCompletedResponse = result.getSuccess();
                return respondDecisionTaskCompletedResponse;
            }
            if (result.isSetBadRequestError()) {
                throw result.getBadRequestError();
            }
            if (result.isSetInternalServiceError()) {
                throw result.getInternalServiceError();
            }
            if (result.isSetServiceBusyError()) {
                throw result.getServiceBusyError();
            }
            if (result.isSetDomainNotActiveError()) {
                throw result.getDomainNotActiveError();
            }
            if (result.isSetLimitExceededError()) {
                throw result.getLimitExceededError();
            }
            if (result.isSetEntityNotExistError()) {
                throw result.getEntityNotExistError();
            }
            throw new TException("RespondDecisionTaskCompleted failed with unknown error:" + result);
        }
        finally {
            if (response != null) {
                response.release();
            }
        }
    }

    @Override
    public void RespondDecisionTaskFailed(RespondDecisionTaskFailedRequest request) throws TException {
        this.measureRemoteProc("cadence-RespondDecisionTaskFailed", () -> this.respondDecisionTaskFailed(request));
    }

    private void respondDecisionTaskFailed(RespondDecisionTaskFailedRequest failedRequest) throws TException {
        ThriftResponse response = null;
        try {
            ThriftRequest<WorkflowService.RespondDecisionTaskFailed_args> request = this.buildThriftRequest("RespondDecisionTaskFailed", new WorkflowService.RespondDecisionTaskFailed_args(failedRequest));
            response = this.doRemoteCall(request);
            WorkflowService.RespondDecisionTaskFailed_result result = (WorkflowService.RespondDecisionTaskFailed_result)response.getBody(WorkflowService.RespondDecisionTaskFailed_result.class);
            if (response.getResponseCode() == ResponseCode.OK) {
                return;
            }
            if (result.isSetBadRequestError()) {
                throw result.getBadRequestError();
            }
            if (result.isSetInternalServiceError()) {
                throw result.getInternalServiceError();
            }
            if (result.isSetEntityNotExistError()) {
                throw result.getEntityNotExistError();
            }
            if (result.isSetServiceBusyError()) {
                throw result.getServiceBusyError();
            }
            if (result.isSetDomainNotActiveError()) {
                throw result.getDomainNotActiveError();
            }
            if (result.isSetLimitExceededError()) {
                throw result.getLimitExceededError();
            }
            if (result.isSetEntityNotExistError()) {
                throw result.getEntityNotExistError();
            }
            throw new TException("RespondDecisionTaskFailed failed with unknown error:" + result);
        }
        finally {
            if (response != null) {
                response.release();
            }
        }
    }

    @Override
    public PollForActivityTaskResponse PollForActivityTask(PollForActivityTaskRequest request) throws TException {
        return this.measureRemoteCall("cadence-PollForActivityTask", () -> this.pollForActivityTask(request));
    }

    private PollForActivityTaskResponse pollForActivityTask(PollForActivityTaskRequest pollRequest) throws TException {
        ThriftResponse response = null;
        try {
            ThriftRequest<WorkflowService.PollForActivityTask_args> request = this.buildThriftRequest("PollForActivityTask", new WorkflowService.PollForActivityTask_args(pollRequest), this.options.getRpcLongPollTimeoutMillis());
            response = this.doRemoteCall(request);
            WorkflowService.PollForActivityTask_result result = (WorkflowService.PollForActivityTask_result)response.getBody(WorkflowService.PollForActivityTask_result.class);
            if (response.getResponseCode() == ResponseCode.OK) {
                PollForActivityTaskResponse pollForActivityTaskResponse = result.getSuccess();
                return pollForActivityTaskResponse;
            }
            if (result.isSetBadRequestError()) {
                throw result.getBadRequestError();
            }
            if (result.isSetInternalServiceError()) {
                throw result.getInternalServiceError();
            }
            if (result.isSetServiceBusyError()) {
                throw result.getServiceBusyError();
            }
            if (result.isSetEntityNotExistError()) {
                throw result.getEntityNotExistError();
            }
            if (result.isSetDomainNotActiveError()) {
                throw result.getDomainNotActiveError();
            }
            if (result.isSetLimitExceededError()) {
                throw result.getLimitExceededError();
            }
            throw new TException("PollForActivityTask failed with unknown error:" + result);
        }
        finally {
            if (response != null) {
                response.release();
            }
        }
    }

    @Override
    public RecordActivityTaskHeartbeatResponse RecordActivityTaskHeartbeat(RecordActivityTaskHeartbeatRequest request) throws TException {
        return this.measureRemoteCall("cadence-RecordActivityTaskHeartbeat", () -> this.recordActivityTaskHeartbeat(request));
    }

    private RecordActivityTaskHeartbeatResponse recordActivityTaskHeartbeat(RecordActivityTaskHeartbeatRequest heartbeatRequest) throws TException {
        ThriftResponse response = null;
        try {
            ThriftRequest<WorkflowService.RecordActivityTaskHeartbeat_args> request = this.buildThriftRequest("RecordActivityTaskHeartbeat", new WorkflowService.RecordActivityTaskHeartbeat_args(heartbeatRequest));
            response = this.doRemoteCall(request);
            WorkflowService.RecordActivityTaskHeartbeat_result result = (WorkflowService.RecordActivityTaskHeartbeat_result)response.getBody(WorkflowService.RecordActivityTaskHeartbeat_result.class);
            if (response.getResponseCode() == ResponseCode.OK) {
                RecordActivityTaskHeartbeatResponse recordActivityTaskHeartbeatResponse = result.getSuccess();
                return recordActivityTaskHeartbeatResponse;
            }
            if (result.isSetBadRequestError()) {
                throw result.getBadRequestError();
            }
            if (result.isSetInternalServiceError()) {
                throw result.getInternalServiceError();
            }
            if (result.isSetEntityNotExistError()) {
                throw result.getEntityNotExistError();
            }
            if (result.isSetServiceBusyError()) {
                throw result.getServiceBusyError();
            }
            if (result.isSetDomainNotActiveError()) {
                throw result.getDomainNotActiveError();
            }
            if (result.isSetLimitExceededError()) {
                throw result.getLimitExceededError();
            }
            throw new TException("RecordActivityTaskHeartbeat failed with unknown error:" + result);
        }
        finally {
            if (response != null) {
                response.release();
            }
        }
    }

    @Override
    public RecordActivityTaskHeartbeatResponse RecordActivityTaskHeartbeatByID(RecordActivityTaskHeartbeatByIDRequest heartbeatRequest) throws BadRequestError, InternalServiceError, EntityNotExistsError, DomainNotActiveError, LimitExceededError, ServiceBusyError, TException {
        return this.measureRemoteCall("cadence-RecordActivityTaskHeartbeatByID", () -> this.recordActivityTaskHeartbeatByID(heartbeatRequest));
    }

    private RecordActivityTaskHeartbeatResponse recordActivityTaskHeartbeatByID(RecordActivityTaskHeartbeatByIDRequest heartbeatRequest) throws TException {
        ThriftResponse response = null;
        try {
            ThriftRequest<WorkflowService.RecordActivityTaskHeartbeatByID_args> request = this.buildThriftRequest("RecordActivityTaskHeartbeatByID", new WorkflowService.RecordActivityTaskHeartbeatByID_args(heartbeatRequest));
            response = this.doRemoteCall(request);
            WorkflowService.RecordActivityTaskHeartbeatByID_result result = (WorkflowService.RecordActivityTaskHeartbeatByID_result)response.getBody(WorkflowService.RecordActivityTaskHeartbeatByID_result.class);
            if (response.getResponseCode() == ResponseCode.OK) {
                RecordActivityTaskHeartbeatResponse recordActivityTaskHeartbeatResponse = result.getSuccess();
                return recordActivityTaskHeartbeatResponse;
            }
            if (result.isSetBadRequestError()) {
                throw result.getBadRequestError();
            }
            if (result.isSetInternalServiceError()) {
                throw result.getInternalServiceError();
            }
            if (result.isSetEntityNotExistError()) {
                throw result.getEntityNotExistError();
            }
            if (result.isSetServiceBusyError()) {
                throw result.getServiceBusyError();
            }
            if (result.isSetDomainNotActiveError()) {
                throw result.getDomainNotActiveError();
            }
            if (result.isSetLimitExceededError()) {
                throw result.getLimitExceededError();
            }
            throw new TException("RecordActivityTaskHeartbeatByID failed with unknown error:" + result);
        }
        finally {
            if (response != null) {
                response.release();
            }
        }
    }

    @Override
    public void RespondActivityTaskCompleted(RespondActivityTaskCompletedRequest request) throws TException {
        this.measureRemoteProc("cadence-RespondActivityTaskCompleted", () -> this.respondActivityTaskCompleted(request));
    }

    private void respondActivityTaskCompleted(RespondActivityTaskCompletedRequest completeRequest) throws TException {
        ThriftResponse response = null;
        try {
            ThriftRequest<WorkflowService.RespondActivityTaskCompleted_args> request = this.buildThriftRequest("RespondActivityTaskCompleted", new WorkflowService.RespondActivityTaskCompleted_args(completeRequest));
            response = this.doRemoteCall(request);
            WorkflowService.RespondActivityTaskCompleted_result result = (WorkflowService.RespondActivityTaskCompleted_result)response.getBody(WorkflowService.RespondActivityTaskCompleted_result.class);
            if (response.getResponseCode() == ResponseCode.OK) {
                return;
            }
            if (result.isSetBadRequestError()) {
                throw result.getBadRequestError();
            }
            if (result.isSetInternalServiceError()) {
                throw result.getInternalServiceError();
            }
            if (result.isSetEntityNotExistError()) {
                throw result.getEntityNotExistError();
            }
            if (result.isSetServiceBusyError()) {
                throw result.getServiceBusyError();
            }
            if (result.isSetDomainNotActiveError()) {
                throw result.getDomainNotActiveError();
            }
            if (result.isSetLimitExceededError()) {
                throw result.getLimitExceededError();
            }
            throw new TException("RespondActivityTaskCompleted failed with unknown error:" + result);
        }
        finally {
            if (response != null) {
                response.release();
            }
        }
    }

    @Override
    public void RespondActivityTaskCompletedByID(RespondActivityTaskCompletedByIDRequest request) throws TException {
        this.measureRemoteProc("cadence-RespondActivityTaskCompletedByID", () -> this.respondActivityTaskCompletedByID(request));
    }

    private void respondActivityTaskCompletedByID(RespondActivityTaskCompletedByIDRequest completeRequest) throws TException {
        ThriftResponse response = null;
        try {
            ThriftRequest<WorkflowService.RespondActivityTaskCompletedByID_args> request = this.buildThriftRequest("RespondActivityTaskCompletedByID", new WorkflowService.RespondActivityTaskCompletedByID_args(completeRequest));
            response = this.doRemoteCall(request);
            WorkflowService.RespondActivityTaskCompletedByID_result result = (WorkflowService.RespondActivityTaskCompletedByID_result)response.getBody(WorkflowService.RespondActivityTaskCompletedByID_result.class);
            if (response.getResponseCode() == ResponseCode.OK) {
                return;
            }
            if (result.isSetBadRequestError()) {
                throw result.getBadRequestError();
            }
            if (result.isSetInternalServiceError()) {
                throw result.getInternalServiceError();
            }
            if (result.isSetEntityNotExistError()) {
                throw result.getEntityNotExistError();
            }
            if (result.isSetServiceBusyError()) {
                throw result.getServiceBusyError();
            }
            if (result.isSetDomainNotActiveError()) {
                throw result.getDomainNotActiveError();
            }
            if (result.isSetLimitExceededError()) {
                throw result.getLimitExceededError();
            }
            throw new TException("RespondActivityTaskCompletedByID failed with unknown error:" + result);
        }
        finally {
            if (response != null) {
                response.release();
            }
        }
    }

    @Override
    public void RespondActivityTaskFailed(RespondActivityTaskFailedRequest request) throws TException {
        this.measureRemoteProc("cadence-RespondActivityTaskFailed", () -> this.respondActivityTaskFailed(request));
    }

    private void respondActivityTaskFailed(RespondActivityTaskFailedRequest failRequest) throws TException {
        ThriftResponse response = null;
        try {
            ThriftRequest<WorkflowService.RespondActivityTaskFailed_args> request = this.buildThriftRequest("RespondActivityTaskFailed", new WorkflowService.RespondActivityTaskFailed_args(failRequest));
            response = this.doRemoteCall(request);
            WorkflowService.RespondActivityTaskFailed_result result = (WorkflowService.RespondActivityTaskFailed_result)response.getBody(WorkflowService.RespondActivityTaskFailed_result.class);
            if (response.getResponseCode() == ResponseCode.OK) {
                return;
            }
            if (result.isSetBadRequestError()) {
                throw result.getBadRequestError();
            }
            if (result.isSetInternalServiceError()) {
                throw result.getInternalServiceError();
            }
            if (result.isSetEntityNotExistError()) {
                throw result.getEntityNotExistError();
            }
            if (result.isSetServiceBusyError()) {
                throw result.getServiceBusyError();
            }
            if (result.isSetDomainNotActiveError()) {
                throw result.getDomainNotActiveError();
            }
            if (result.isSetLimitExceededError()) {
                throw result.getLimitExceededError();
            }
            throw new TException("RespondActivityTaskFailed failed with unknown error:" + result);
        }
        finally {
            if (response != null) {
                response.release();
            }
        }
    }

    @Override
    public void RespondActivityTaskFailedByID(RespondActivityTaskFailedByIDRequest request) throws TException {
        this.measureRemoteProc("cadence-RespondActivityTaskFailedByID", () -> this.respondActivityTaskFailedByID(request));
    }

    private void respondActivityTaskFailedByID(RespondActivityTaskFailedByIDRequest failRequest) throws TException {
        ThriftResponse response = null;
        try {
            ThriftRequest<WorkflowService.RespondActivityTaskFailedByID_args> request = this.buildThriftRequest("RespondActivityTaskFailedByID", new WorkflowService.RespondActivityTaskFailedByID_args(failRequest));
            response = this.doRemoteCall(request);
            WorkflowService.RespondActivityTaskFailedByID_result result = (WorkflowService.RespondActivityTaskFailedByID_result)response.getBody(WorkflowService.RespondActivityTaskFailedByID_result.class);
            if (response.getResponseCode() == ResponseCode.OK) {
                return;
            }
            if (result.isSetBadRequestError()) {
                throw result.getBadRequestError();
            }
            if (result.isSetInternalServiceError()) {
                throw result.getInternalServiceError();
            }
            if (result.isSetEntityNotExistError()) {
                throw result.getEntityNotExistError();
            }
            if (result.isSetServiceBusyError()) {
                throw result.getServiceBusyError();
            }
            if (result.isSetDomainNotActiveError()) {
                throw result.getDomainNotActiveError();
            }
            if (result.isSetLimitExceededError()) {
                throw result.getLimitExceededError();
            }
            throw new TException("RespondActivityTaskFailedByID failedByID with unknown error:" + result);
        }
        finally {
            if (response != null) {
                response.release();
            }
        }
    }

    @Override
    public void RespondActivityTaskCanceled(RespondActivityTaskCanceledRequest request) throws TException {
        this.measureRemoteProc("cadence-RespondActivityTaskCanceled", () -> this.respondActivityTaskCanceled(request));
    }

    private void respondActivityTaskCanceled(RespondActivityTaskCanceledRequest canceledRequest) throws TException {
        ThriftResponse response = null;
        try {
            ThriftRequest<WorkflowService.RespondActivityTaskCanceled_args> request = this.buildThriftRequest("RespondActivityTaskCanceled", new WorkflowService.RespondActivityTaskCanceled_args(canceledRequest));
            response = this.doRemoteCall(request);
            WorkflowService.RespondActivityTaskCanceled_result result = (WorkflowService.RespondActivityTaskCanceled_result)response.getBody(WorkflowService.RespondActivityTaskCanceled_result.class);
            if (response.getResponseCode() == ResponseCode.OK) {
                return;
            }
            if (result.isSetBadRequestError()) {
                throw result.getBadRequestError();
            }
            if (result.isSetInternalServiceError()) {
                throw result.getInternalServiceError();
            }
            if (result.isSetEntityNotExistError()) {
                throw result.getEntityNotExistError();
            }
            if (result.isSetServiceBusyError()) {
                throw result.getServiceBusyError();
            }
            if (result.isSetDomainNotActiveError()) {
                throw result.getDomainNotActiveError();
            }
            if (result.isSetLimitExceededError()) {
                throw result.getLimitExceededError();
            }
            throw new TException("RespondActivityTaskCanceled failed with unknown error:" + result);
        }
        finally {
            if (response != null) {
                response.release();
            }
        }
    }

    @Override
    public void RespondActivityTaskCanceledByID(RespondActivityTaskCanceledByIDRequest request) throws TException {
        this.measureRemoteProc("cadence-RespondActivityTaskCanceledByID", () -> this.respondActivityTaskCanceledByID(request));
    }

    private void respondActivityTaskCanceledByID(RespondActivityTaskCanceledByIDRequest canceledByIDRequest) throws TException {
        ThriftResponse response = null;
        try {
            ThriftRequest<WorkflowService.RespondActivityTaskCanceledByID_args> request = this.buildThriftRequest("RespondActivityTaskCanceledByID", new WorkflowService.RespondActivityTaskCanceledByID_args(canceledByIDRequest));
            response = this.doRemoteCall(request);
            WorkflowService.RespondActivityTaskCanceledByID_result result = (WorkflowService.RespondActivityTaskCanceledByID_result)response.getBody(WorkflowService.RespondActivityTaskCanceledByID_result.class);
            if (response.getResponseCode() == ResponseCode.OK) {
                return;
            }
            if (result.isSetBadRequestError()) {
                throw result.getBadRequestError();
            }
            if (result.isSetInternalServiceError()) {
                throw result.getInternalServiceError();
            }
            if (result.isSetEntityNotExistError()) {
                throw result.getEntityNotExistError();
            }
            if (result.isSetServiceBusyError()) {
                throw result.getServiceBusyError();
            }
            if (result.isSetDomainNotActiveError()) {
                throw result.getDomainNotActiveError();
            }
            if (result.isSetLimitExceededError()) {
                throw result.getLimitExceededError();
            }
            throw new TException("RespondActivityTaskCanceledByID failed with unknown error:" + result);
        }
        finally {
            if (response != null) {
                response.release();
            }
        }
    }

    @Override
    public void RequestCancelWorkflowExecution(RequestCancelWorkflowExecutionRequest request) throws TException {
        this.measureRemoteProc("cadence-RequestCancelWorkflowExecution", () -> this.requestCancelWorkflowExecution(request));
    }

    private void requestCancelWorkflowExecution(RequestCancelWorkflowExecutionRequest cancelRequest) throws TException {
        cancelRequest.setRequestId(UUID.randomUUID().toString());
        ThriftResponse response = null;
        try {
            ThriftRequest<WorkflowService.RequestCancelWorkflowExecution_args> request = this.buildThriftRequest("RequestCancelWorkflowExecution", new WorkflowService.RequestCancelWorkflowExecution_args(cancelRequest));
            response = this.doRemoteCall(request);
            WorkflowService.RequestCancelWorkflowExecution_result result = (WorkflowService.RequestCancelWorkflowExecution_result)response.getBody(WorkflowService.RequestCancelWorkflowExecution_result.class);
            if (response.getResponseCode() == ResponseCode.OK) {
                return;
            }
            if (result.isSetBadRequestError()) {
                throw result.getBadRequestError();
            }
            if (result.isSetInternalServiceError()) {
                throw result.getInternalServiceError();
            }
            if (result.isSetEntityNotExistError()) {
                throw result.getEntityNotExistError();
            }
            if (result.isSetCancellationAlreadyRequestedError()) {
                throw result.getCancellationAlreadyRequestedError();
            }
            if (result.isSetServiceBusyError()) {
                throw result.getServiceBusyError();
            }
            if (result.isSetDomainNotActiveError()) {
                throw result.getDomainNotActiveError();
            }
            if (result.isSetLimitExceededError()) {
                throw result.getLimitExceededError();
            }
            throw new TException("RequestCancelWorkflowExecution failed with unknown error:" + result);
        }
        finally {
            if (response != null) {
                response.release();
            }
        }
    }

    @Override
    public void SignalWorkflowExecution(SignalWorkflowExecutionRequest request) throws TException {
        this.measureRemoteProc("cadence-SignalWorkflowExecution", () -> this.signalWorkflowExecution(request));
    }

    private void signalWorkflowExecution(SignalWorkflowExecutionRequest signalRequest) throws TException {
        ThriftResponse response = null;
        try {
            ThriftRequest<WorkflowService.SignalWorkflowExecution_args> request = this.buildThriftRequest("SignalWorkflowExecution", new WorkflowService.SignalWorkflowExecution_args(signalRequest));
            response = this.doRemoteCall(request);
            WorkflowService.SignalWorkflowExecution_result result = (WorkflowService.SignalWorkflowExecution_result)response.getBody(WorkflowService.SignalWorkflowExecution_result.class);
            if (response.getResponseCode() == ResponseCode.OK) {
                return;
            }
            if (result.isSetBadRequestError()) {
                throw result.getBadRequestError();
            }
            if (result.isSetInternalServiceError()) {
                throw result.getInternalServiceError();
            }
            if (result.isSetEntityNotExistError()) {
                throw result.getEntityNotExistError();
            }
            if (result.isSetServiceBusyError()) {
                throw result.getServiceBusyError();
            }
            if (result.isSetDomainNotActiveError()) {
                throw result.getDomainNotActiveError();
            }
            if (result.isSetLimitExceededError()) {
                throw result.getLimitExceededError();
            }
            throw new TException("SignalWorkflowExecution failed with unknown error:" + result);
        }
        finally {
            if (response != null) {
                response.release();
            }
        }
    }

    @Override
    public StartWorkflowExecutionResponse SignalWithStartWorkflowExecution(SignalWithStartWorkflowExecutionRequest signalWithStartRequest) throws TException {
        return this.measureRemoteCall("cadence-SignalWithStartWorkflowExecution", () -> this.signalWithStartWorkflowExecution(signalWithStartRequest));
    }

    @Override
    public ResetWorkflowExecutionResponse ResetWorkflowExecution(ResetWorkflowExecutionRequest resetRequest) throws BadRequestError, InternalServiceError, EntityNotExistsError, ServiceBusyError, DomainNotActiveError, LimitExceededError, ClientVersionNotSupportedError, TException {
        return null;
    }

    private StartWorkflowExecutionResponse signalWithStartWorkflowExecution(SignalWithStartWorkflowExecutionRequest signalWithStartRequest) throws TException {
        signalWithStartRequest.setRequestId(UUID.randomUUID().toString());
        ThriftResponse response = null;
        try {
            ThriftRequest<WorkflowService.SignalWithStartWorkflowExecution_args> request = this.buildThriftRequest("SignalWithStartWorkflowExecution", new WorkflowService.SignalWithStartWorkflowExecution_args(signalWithStartRequest));
            response = this.doRemoteCall(request);
            WorkflowService.SignalWithStartWorkflowExecution_result result = (WorkflowService.SignalWithStartWorkflowExecution_result)response.getBody(WorkflowService.SignalWithStartWorkflowExecution_result.class);
            if (response.getResponseCode() == ResponseCode.OK) {
                StartWorkflowExecutionResponse startWorkflowExecutionResponse = result.getSuccess();
                return startWorkflowExecutionResponse;
            }
            if (result.isSetBadRequestError()) {
                throw result.getBadRequestError();
            }
            if (result.isSetInternalServiceError()) {
                throw result.getInternalServiceError();
            }
            if (result.isSetEntityNotExistError()) {
                throw result.getEntityNotExistError();
            }
            if (result.isSetServiceBusyError()) {
                throw result.getServiceBusyError();
            }
            if (result.isSetDomainNotActiveError()) {
                throw result.getDomainNotActiveError();
            }
            if (result.isSetLimitExceededError()) {
                throw result.getLimitExceededError();
            }
            if (result.isSetDomainNotActiveError()) {
                throw result.getDomainNotActiveError();
            }
            throw new TException("SignalWithStartWorkflowExecution failed with unknown error:" + result);
        }
        finally {
            if (response != null) {
                response.release();
            }
        }
    }

    @Override
    public void TerminateWorkflowExecution(TerminateWorkflowExecutionRequest request) throws TException {
        this.measureRemoteProc("cadence-TerminateWorkflowExecution", () -> this.terminateWorkflowExecution(request));
    }

    private void terminateWorkflowExecution(TerminateWorkflowExecutionRequest terminateRequest) throws TException {
        ThriftResponse response = null;
        try {
            ThriftRequest<WorkflowService.TerminateWorkflowExecution_args> request = this.buildThriftRequest("TerminateWorkflowExecution", new WorkflowService.TerminateWorkflowExecution_args(terminateRequest));
            response = this.doRemoteCall(request);
            WorkflowService.TerminateWorkflowExecution_result result = (WorkflowService.TerminateWorkflowExecution_result)response.getBody(WorkflowService.TerminateWorkflowExecution_result.class);
            if (response.getResponseCode() == ResponseCode.OK) {
                return;
            }
            if (result.isSetBadRequestError()) {
                throw result.getBadRequestError();
            }
            if (result.isSetInternalServiceError()) {
                throw result.getInternalServiceError();
            }
            if (result.isSetEntityNotExistError()) {
                throw result.getEntityNotExistError();
            }
            if (result.isSetServiceBusyError()) {
                throw result.getServiceBusyError();
            }
            if (result.isSetDomainNotActiveError()) {
                throw result.getDomainNotActiveError();
            }
            if (result.isSetLimitExceededError()) {
                throw result.getLimitExceededError();
            }
            throw new TException("TerminateWorkflowExecution failed with unknown error:" + result);
        }
        finally {
            if (response != null) {
                response.release();
            }
        }
    }

    @Override
    public ListOpenWorkflowExecutionsResponse ListOpenWorkflowExecutions(ListOpenWorkflowExecutionsRequest request) throws TException {
        return this.measureRemoteCall("cadence-ListOpenWorkflowExecutions", () -> this.listOpenWorkflowExecutions(request));
    }

    private ListOpenWorkflowExecutionsResponse listOpenWorkflowExecutions(ListOpenWorkflowExecutionsRequest listRequest) throws TException {
        ThriftResponse response = null;
        try {
            ThriftRequest<WorkflowService.ListOpenWorkflowExecutions_args> request = this.buildThriftRequest("ListOpenWorkflowExecutions", new WorkflowService.ListOpenWorkflowExecutions_args(listRequest));
            response = this.doRemoteCall(request);
            WorkflowService.ListOpenWorkflowExecutions_result result = (WorkflowService.ListOpenWorkflowExecutions_result)response.getBody(WorkflowService.ListOpenWorkflowExecutions_result.class);
            if (response.getResponseCode() == ResponseCode.OK) {
                ListOpenWorkflowExecutionsResponse listOpenWorkflowExecutionsResponse = result.getSuccess();
                return listOpenWorkflowExecutionsResponse;
            }
            if (result.isSetBadRequestError()) {
                throw result.getBadRequestError();
            }
            if (result.isSetInternalServiceError()) {
                throw result.getInternalServiceError();
            }
            if (result.isSetEntityNotExistError()) {
                throw result.getEntityNotExistError();
            }
            if (result.isSetServiceBusyError()) {
                throw result.getServiceBusyError();
            }
            if (result.isSetLimitExceededError()) {
                throw result.getLimitExceededError();
            }
            throw new TException("ListOpenWorkflowExecutions failed with unknown error:" + result);
        }
        finally {
            if (response != null) {
                response.release();
            }
        }
    }

    @Override
    public ListClosedWorkflowExecutionsResponse ListClosedWorkflowExecutions(ListClosedWorkflowExecutionsRequest request) throws TException {
        return this.measureRemoteCall("cadence-ListClosedWorkflowExecutions", () -> this.listClosedWorkflowExecutions(request));
    }

    private ListClosedWorkflowExecutionsResponse listClosedWorkflowExecutions(ListClosedWorkflowExecutionsRequest listRequest) throws TException {
        ThriftResponse response = null;
        try {
            ThriftRequest<WorkflowService.ListClosedWorkflowExecutions_args> request = this.buildThriftRequest("ListClosedWorkflowExecutions", new WorkflowService.ListClosedWorkflowExecutions_args(listRequest));
            response = this.doRemoteCall(request);
            WorkflowService.ListClosedWorkflowExecutions_result result = (WorkflowService.ListClosedWorkflowExecutions_result)response.getBody(WorkflowService.ListClosedWorkflowExecutions_result.class);
            if (response.getResponseCode() == ResponseCode.OK) {
                ListClosedWorkflowExecutionsResponse listClosedWorkflowExecutionsResponse = result.getSuccess();
                return listClosedWorkflowExecutionsResponse;
            }
            if (result.isSetBadRequestError()) {
                throw result.getBadRequestError();
            }
            if (result.isSetInternalServiceError()) {
                throw result.getInternalServiceError();
            }
            if (result.isSetEntityNotExistError()) {
                throw result.getEntityNotExistError();
            }
            if (result.isSetServiceBusyError()) {
                throw result.getServiceBusyError();
            }
            throw new TException("ListClosedWorkflowExecutions failed with unknown error:" + result);
        }
        finally {
            if (response != null) {
                response.release();
            }
        }
    }

    @Override
    public ListWorkflowExecutionsResponse ListWorkflowExecutions(ListWorkflowExecutionsRequest request) throws BadRequestError, InternalServiceError, EntityNotExistsError, ServiceBusyError, ClientVersionNotSupportedError, TException {
        return this.measureRemoteCall("cadence-ListWorkflowExecutions", () -> this.listWorkflowExecutions(request));
    }

    private ListWorkflowExecutionsResponse listWorkflowExecutions(ListWorkflowExecutionsRequest listRequest) throws TException {
        ThriftResponse response = null;
        try {
            ThriftRequest<WorkflowService.ListWorkflowExecutions_args> request = this.buildThriftRequest("ListWorkflowExecutions", new WorkflowService.ListWorkflowExecutions_args(listRequest));
            response = this.doRemoteCall(request);
            WorkflowService.ListWorkflowExecutions_result result = (WorkflowService.ListWorkflowExecutions_result)response.getBody(WorkflowService.ListWorkflowExecutions_result.class);
            if (response.getResponseCode() == ResponseCode.OK) {
                ListWorkflowExecutionsResponse listWorkflowExecutionsResponse = result.getSuccess();
                return listWorkflowExecutionsResponse;
            }
            if (result.isSetBadRequestError()) {
                throw result.getBadRequestError();
            }
            if (result.isSetInternalServiceError()) {
                throw result.getInternalServiceError();
            }
            if (result.isSetEntityNotExistError()) {
                throw result.getEntityNotExistError();
            }
            if (result.isSetServiceBusyError()) {
                throw result.getServiceBusyError();
            }
            if (result.isSetClientVersionNotSupportedError()) {
                throw result.getClientVersionNotSupportedError();
            }
            throw new TException("ListWorkflowExecutions failed with unknown error:" + result);
        }
        finally {
            if (response != null) {
                response.release();
            }
        }
    }

    @Override
    public ListWorkflowExecutionsResponse ScanWorkflowExecutions(ListWorkflowExecutionsRequest request) throws BadRequestError, InternalServiceError, EntityNotExistsError, ServiceBusyError, ClientVersionNotSupportedError, TException {
        return this.measureRemoteCall("cadence-ScanWorkflowExecutions", () -> this.scanWorkflowExecutions(request));
    }

    private ListWorkflowExecutionsResponse scanWorkflowExecutions(ListWorkflowExecutionsRequest listRequest) throws TException {
        ThriftResponse response = null;
        try {
            ThriftRequest<WorkflowService.ScanWorkflowExecutions_args> request = this.buildThriftRequest("ScanWorkflowExecutions", new WorkflowService.ScanWorkflowExecutions_args(listRequest));
            response = this.doRemoteCall(request);
            WorkflowService.ScanWorkflowExecutions_result result = (WorkflowService.ScanWorkflowExecutions_result)response.getBody(WorkflowService.ScanWorkflowExecutions_result.class);
            if (response.getResponseCode() == ResponseCode.OK) {
                ListWorkflowExecutionsResponse listWorkflowExecutionsResponse = result.getSuccess();
                return listWorkflowExecutionsResponse;
            }
            if (result.isSetBadRequestError()) {
                throw result.getBadRequestError();
            }
            if (result.isSetInternalServiceError()) {
                throw result.getInternalServiceError();
            }
            if (result.isSetEntityNotExistError()) {
                throw result.getEntityNotExistError();
            }
            if (result.isSetServiceBusyError()) {
                throw result.getServiceBusyError();
            }
            if (result.isSetClientVersionNotSupportedError()) {
                throw result.getClientVersionNotSupportedError();
            }
            throw new TException("ScanWorkflowExecutions failed with unknown error:" + result);
        }
        finally {
            if (response != null) {
                response.release();
            }
        }
    }

    @Override
    public CountWorkflowExecutionsResponse CountWorkflowExecutions(CountWorkflowExecutionsRequest countRequest) throws BadRequestError, InternalServiceError, EntityNotExistsError, ServiceBusyError, ClientVersionNotSupportedError, TException {
        return this.measureRemoteCall("cadence-CountWorkflowExecutions", () -> this.countWorkflowExecutions(countRequest));
    }

    private CountWorkflowExecutionsResponse countWorkflowExecutions(CountWorkflowExecutionsRequest countRequest) throws TException {
        ThriftResponse response = null;
        try {
            ThriftRequest<WorkflowService.CountWorkflowExecutions_args> request = this.buildThriftRequest("CountWorkflowExecutions", new WorkflowService.CountWorkflowExecutions_args(countRequest));
            response = this.doRemoteCall(request);
            WorkflowService.CountWorkflowExecutions_result result = (WorkflowService.CountWorkflowExecutions_result)response.getBody(WorkflowService.CountWorkflowExecutions_result.class);
            if (response.getResponseCode() == ResponseCode.OK) {
                CountWorkflowExecutionsResponse countWorkflowExecutionsResponse = result.getSuccess();
                return countWorkflowExecutionsResponse;
            }
            if (result.isSetBadRequestError()) {
                throw result.getBadRequestError();
            }
            if (result.isSetInternalServiceError()) {
                throw result.getInternalServiceError();
            }
            if (result.isSetEntityNotExistError()) {
                throw result.getEntityNotExistError();
            }
            if (result.isSetServiceBusyError()) {
                throw result.getServiceBusyError();
            }
            if (result.isSetClientVersionNotSupportedError()) {
                throw result.getClientVersionNotSupportedError();
            }
            throw new TException("CountWorkflowExecutions failed with unknown error:" + result);
        }
        finally {
            if (response != null) {
                response.release();
            }
        }
    }

    @Override
    public GetSearchAttributesResponse GetSearchAttributes() throws InternalServiceError, ServiceBusyError, ClientVersionNotSupportedError, TException {
        return this.measureRemoteCall("cadence-GetSearchAttributes", () -> this.getSearchAttributes());
    }

    private GetSearchAttributesResponse getSearchAttributes() throws TException {
        ThriftResponse response = null;
        try {
            ThriftRequest<WorkflowService.GetSearchAttributes_args> request = this.buildThriftRequest("GetSearchAttributes", new WorkflowService.GetSearchAttributes_args());
            response = this.doRemoteCall(request);
            WorkflowService.GetSearchAttributes_result result = (WorkflowService.GetSearchAttributes_result)response.getBody(WorkflowService.GetSearchAttributes_result.class);
            if (response.getResponseCode() == ResponseCode.OK) {
                GetSearchAttributesResponse getSearchAttributesResponse = result.getSuccess();
                return getSearchAttributesResponse;
            }
            if (result.isSetInternalServiceError()) {
                throw result.getInternalServiceError();
            }
            if (result.isSetServiceBusyError()) {
                throw result.getServiceBusyError();
            }
            if (result.isSetClientVersionNotSupportedError()) {
                throw result.getClientVersionNotSupportedError();
            }
            throw new TException("GetSearchAttributes failed with unknown error:" + result);
        }
        finally {
            if (response != null) {
                response.release();
            }
        }
    }

    @Override
    public void RespondQueryTaskCompleted(RespondQueryTaskCompletedRequest request) throws TException {
        this.measureRemoteProc("cadence-RespondQueryTaskCompleted", () -> this.respondQueryTaskCompleted(request));
    }

    private void respondQueryTaskCompleted(RespondQueryTaskCompletedRequest completeRequest) throws TException {
        ThriftResponse response = null;
        try {
            ThriftRequest<WorkflowService.RespondQueryTaskCompleted_args> request = this.buildThriftRequest("RespondQueryTaskCompleted", new WorkflowService.RespondQueryTaskCompleted_args(completeRequest));
            response = this.doRemoteCall(request);
            WorkflowService.RespondQueryTaskCompleted_result result = (WorkflowService.RespondQueryTaskCompleted_result)response.getBody(WorkflowService.RespondQueryTaskCompleted_result.class);
            if (response.getResponseCode() == ResponseCode.OK) {
                return;
            }
            if (result.isSetBadRequestError()) {
                throw result.getBadRequestError();
            }
            if (result.isSetInternalServiceError()) {
                throw result.getInternalServiceError();
            }
            if (result.isSetEntityNotExistError()) {
                throw result.getEntityNotExistError();
            }
            if (result.isSetServiceBusyError()) {
                throw result.getServiceBusyError();
            }
            if (result.isSetDomainNotActiveError()) {
                throw result.getDomainNotActiveError();
            }
            if (result.isSetLimitExceededError()) {
                throw result.getLimitExceededError();
            }
            throw new TException("RespondQueryTaskCompleted failed with unknown error:" + result);
        }
        finally {
            if (response != null) {
                response.release();
            }
        }
    }

    @Override
    public QueryWorkflowResponse QueryWorkflow(QueryWorkflowRequest request) throws TException {
        return this.measureRemoteCall("cadence-QueryWorkflow", () -> this.queryWorkflow(request));
    }

    private QueryWorkflowResponse queryWorkflow(QueryWorkflowRequest queryRequest) throws TException {
        ThriftResponse response = null;
        try {
            ThriftRequest<WorkflowService.QueryWorkflow_args> request = this.buildThriftRequest("QueryWorkflow", new WorkflowService.QueryWorkflow_args(queryRequest), this.options.getRpcQueryTimeoutMillis());
            response = this.doRemoteCall(request);
            WorkflowService.QueryWorkflow_result result = (WorkflowService.QueryWorkflow_result)response.getBody(WorkflowService.QueryWorkflow_result.class);
            if (response.getResponseCode() == ResponseCode.OK) {
                QueryWorkflowResponse queryWorkflowResponse = result.getSuccess();
                return queryWorkflowResponse;
            }
            if (result.isSetBadRequestError()) {
                throw result.getBadRequestError();
            }
            if (result.isSetInternalServiceError()) {
                throw result.getInternalServiceError();
            }
            if (result.isSetEntityNotExistError()) {
                throw result.getEntityNotExistError();
            }
            if (result.isSetQueryFailedError()) {
                throw result.getQueryFailedError();
            }
            throw new TException("QueryWorkflow failed with unknown error:" + result);
        }
        finally {
            if (response != null) {
                response.release();
            }
        }
    }

    @Override
    public ResetStickyTaskListResponse ResetStickyTaskList(ResetStickyTaskListRequest resetRequest) throws BadRequestError, InternalServiceError, EntityNotExistsError, LimitExceededError, ServiceBusyError, DomainNotActiveError, TException {
        return this.measureRemoteCall("cadence-ResetStickyTaskList", () -> this.resetStickyTaskList(resetRequest));
    }

    private ResetStickyTaskListResponse resetStickyTaskList(ResetStickyTaskListRequest queryRequest) throws TException {
        ThriftResponse response = null;
        try {
            ThriftRequest<WorkflowService.ResetStickyTaskList_args> request = this.buildThriftRequest("ResetStickyTaskList", new WorkflowService.ResetStickyTaskList_args(queryRequest), this.options.getRpcQueryTimeoutMillis());
            response = this.doRemoteCall(request);
            WorkflowService.ResetStickyTaskList_result result = (WorkflowService.ResetStickyTaskList_result)response.getBody(WorkflowService.ResetStickyTaskList_result.class);
            if (response.getResponseCode() == ResponseCode.OK) {
                ResetStickyTaskListResponse resetStickyTaskListResponse = result.getSuccess();
                return resetStickyTaskListResponse;
            }
            if (result.isSetBadRequestError()) {
                throw result.getBadRequestError();
            }
            if (result.isSetInternalServiceError()) {
                throw result.getInternalServiceError();
            }
            if (result.isSetEntityNotExistError()) {
                throw result.getEntityNotExistError();
            }
            if (result.isSetServiceBusyError()) {
                throw result.getServiceBusyError();
            }
            if (result.isSetDomainNotActiveError()) {
                throw result.getDomainNotActiveError();
            }
            if (result.isSetLimitExceededError()) {
                throw result.getLimitExceededError();
            }
            throw new TException("ResetStickyTaskList failed with unknown error:" + result);
        }
        finally {
            if (response != null) {
                response.release();
            }
        }
    }

    @Override
    public DescribeWorkflowExecutionResponse DescribeWorkflowExecution(DescribeWorkflowExecutionRequest request) throws TException {
        return this.measureRemoteCall("cadence-DescribeWorkflowExecution", () -> this.describeWorkflowExecution(request));
    }

    private DescribeWorkflowExecutionResponse describeWorkflowExecution(DescribeWorkflowExecutionRequest describeRequest) throws TException {
        ThriftResponse response = null;
        try {
            ThriftRequest<WorkflowService.DescribeWorkflowExecution_args> request = this.buildThriftRequest("DescribeWorkflowExecution", new WorkflowService.DescribeWorkflowExecution_args(describeRequest));
            response = this.doRemoteCall(request);
            WorkflowService.DescribeWorkflowExecution_result result = (WorkflowService.DescribeWorkflowExecution_result)response.getBody(WorkflowService.DescribeWorkflowExecution_result.class);
            if (response.getResponseCode() == ResponseCode.OK) {
                DescribeWorkflowExecutionResponse describeWorkflowExecutionResponse = result.getSuccess();
                return describeWorkflowExecutionResponse;
            }
            if (result.isSetBadRequestError()) {
                throw result.getBadRequestError();
            }
            if (result.isSetInternalServiceError()) {
                throw result.getInternalServiceError();
            }
            if (result.isSetEntityNotExistError()) {
                throw result.getEntityNotExistError();
            }
            if (result.isSetServiceBusyError()) {
                throw result.getServiceBusyError();
            }
            if (result.isSetLimitExceededError()) {
                throw result.getLimitExceededError();
            }
            throw new TException("DescribeWorkflowExecution failed with unknown error:" + result);
        }
        finally {
            if (response != null) {
                response.release();
            }
        }
    }

    @Override
    public DescribeTaskListResponse DescribeTaskList(DescribeTaskListRequest request) throws TException {
        return this.measureRemoteCall("cadence-DescribeTaskList", () -> this.describeTaskList(request));
    }

    private DescribeTaskListResponse describeTaskList(DescribeTaskListRequest describeRequest) throws TException {
        ThriftResponse response = null;
        try {
            ThriftRequest<WorkflowService.DescribeTaskList_args> request = this.buildThriftRequest("DescribeTaskList", new WorkflowService.DescribeTaskList_args(describeRequest));
            response = this.doRemoteCall(request);
            WorkflowService.DescribeTaskList_result result = (WorkflowService.DescribeTaskList_result)response.getBody(WorkflowService.DescribeTaskList_result.class);
            if (response.getResponseCode() == ResponseCode.OK) {
                DescribeTaskListResponse describeTaskListResponse = result.getSuccess();
                return describeTaskListResponse;
            }
            if (result.isSetBadRequestError()) {
                throw result.getBadRequestError();
            }
            if (result.isSetInternalServiceError()) {
                throw result.getInternalServiceError();
            }
            if (result.isSetEntityNotExistError()) {
                throw result.getEntityNotExistError();
            }
            if (result.isSetServiceBusyError()) {
                throw result.getServiceBusyError();
            }
            if (result.isSetLimitExceededError()) {
                throw result.getLimitExceededError();
            }
            throw new TException("DescribeTaskList failed with unknown error:" + result);
        }
        finally {
            if (response != null) {
                response.release();
            }
        }
    }

    @Override
    public void StartWorkflowExecution(StartWorkflowExecutionRequest startRequest, AsyncMethodCallback resultHandler) throws TException {
        throw new UnsupportedOperationException("not implemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void GetWorkflowExecutionHistory(GetWorkflowExecutionHistoryRequest getRequest, AsyncMethodCallback resultHandler) {
        CompletableFuture response = null;
        try {
            ThriftRequest<WorkflowService.GetWorkflowExecutionHistory_args> request = this.buildThriftRequest("GetWorkflowExecutionHistory", new WorkflowService.GetWorkflowExecutionHistory_args(getRequest));
            response = this.doRemoteCallAsync(request);
            ((CompletableFuture)response.whenComplete((r, e) -> {
                if (e != null) {
                    resultHandler.onError((Exception)CheckedExceptionWrapper.wrap(e));
                    return;
                }
                WorkflowService.GetWorkflowExecutionHistory_result result = (WorkflowService.GetWorkflowExecutionHistory_result)r.getBody(WorkflowService.GetWorkflowExecutionHistory_result.class);
                if (r.getResponseCode() == ResponseCode.OK) {
                    resultHandler.onComplete((Object)result.getSuccess());
                    return;
                }
                if (result.isSetBadRequestError()) {
                    resultHandler.onError((Exception)((Object)result.getBadRequestError()));
                    return;
                }
                if (result.isSetInternalServiceError()) {
                    resultHandler.onError((Exception)((Object)result.getInternalServiceError()));
                    return;
                }
                if (result.isSetEntityNotExistError()) {
                    resultHandler.onError((Exception)((Object)result.getEntityNotExistError()));
                    return;
                }
                if (result.isSetServiceBusyError()) {
                    resultHandler.onError((Exception)((Object)result.getServiceBusyError()));
                    return;
                }
                resultHandler.onError((Exception)((Object)new TException("GetWorkflowExecutionHistory failed with unknown error:" + result)));
            })).exceptionally(e -> {
                log.error("Unexpected error in GetWorkflowExecutionHistory", e);
                return null;
            });
            if (response == null || !response.isDone()) return;
        }
        catch (Throwable throwable) {
            if (response == null || !response.isDone()) throw throwable;
            ((ThriftResponse)response.join()).release();
            throw throwable;
        }
        response.join().release();
    }

    @Override
    public void PollForDecisionTask(PollForDecisionTaskRequest pollRequest, AsyncMethodCallback resultHandler) throws TException {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void RespondDecisionTaskCompleted(RespondDecisionTaskCompletedRequest completeRequest, AsyncMethodCallback resultHandler) throws TException {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void RespondDecisionTaskFailed(RespondDecisionTaskFailedRequest failedRequest, AsyncMethodCallback resultHandler) throws TException {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void PollForActivityTask(PollForActivityTaskRequest pollRequest, AsyncMethodCallback resultHandler) throws TException {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void RecordActivityTaskHeartbeat(RecordActivityTaskHeartbeatRequest heartbeatRequest, AsyncMethodCallback resultHandler) throws TException {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void RecordActivityTaskHeartbeatByID(RecordActivityTaskHeartbeatByIDRequest heartbeatRequest, AsyncMethodCallback resultHandler) throws TException {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void RespondActivityTaskCompleted(RespondActivityTaskCompletedRequest completeRequest, AsyncMethodCallback resultHandler) throws TException {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void RespondActivityTaskCompletedByID(RespondActivityTaskCompletedByIDRequest completeRequest, AsyncMethodCallback resultHandler) throws TException {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void RespondActivityTaskFailed(RespondActivityTaskFailedRequest failRequest, AsyncMethodCallback resultHandler) throws TException {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void RespondActivityTaskFailedByID(RespondActivityTaskFailedByIDRequest failRequest, AsyncMethodCallback resultHandler) throws TException {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void RespondActivityTaskCanceled(RespondActivityTaskCanceledRequest canceledRequest, AsyncMethodCallback resultHandler) throws TException {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void RespondActivityTaskCanceledByID(RespondActivityTaskCanceledByIDRequest canceledRequest, AsyncMethodCallback resultHandler) throws TException {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void RequestCancelWorkflowExecution(RequestCancelWorkflowExecutionRequest cancelRequest, AsyncMethodCallback resultHandler) throws TException {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void SignalWorkflowExecution(SignalWorkflowExecutionRequest signalRequest, AsyncMethodCallback resultHandler) throws TException {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void SignalWithStartWorkflowExecution(SignalWithStartWorkflowExecutionRequest signalWithStartRequest, AsyncMethodCallback resultHandler) throws TException {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void ResetWorkflowExecution(ResetWorkflowExecutionRequest resetRequest, AsyncMethodCallback resultHandler) throws TException {
    }

    @Override
    public void TerminateWorkflowExecution(TerminateWorkflowExecutionRequest terminateRequest, AsyncMethodCallback resultHandler) throws TException {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void ListOpenWorkflowExecutions(ListOpenWorkflowExecutionsRequest listRequest, AsyncMethodCallback resultHandler) throws TException {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void ListClosedWorkflowExecutions(ListClosedWorkflowExecutionsRequest listRequest, AsyncMethodCallback resultHandler) throws TException {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void ListWorkflowExecutions(ListWorkflowExecutionsRequest listRequest, AsyncMethodCallback resultHandler) throws TException {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void ScanWorkflowExecutions(ListWorkflowExecutionsRequest listRequest, AsyncMethodCallback resultHandler) throws TException {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void CountWorkflowExecutions(CountWorkflowExecutionsRequest countRequest, AsyncMethodCallback resultHandler) throws TException {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void GetSearchAttributes(AsyncMethodCallback resultHandler) throws TException {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void RespondQueryTaskCompleted(RespondQueryTaskCompletedRequest completeRequest, AsyncMethodCallback resultHandler) throws TException {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void ResetStickyTaskList(ResetStickyTaskListRequest resetRequest, AsyncMethodCallback resultHandler) throws TException {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void QueryWorkflow(QueryWorkflowRequest queryRequest, AsyncMethodCallback resultHandler) throws TException {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void DescribeWorkflowExecution(DescribeWorkflowExecutionRequest describeRequest, AsyncMethodCallback resultHandler) throws TException {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void DescribeTaskList(DescribeTaskListRequest request, AsyncMethodCallback resultHandler) throws TException {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void RegisterDomain(RegisterDomainRequest registerRequest, AsyncMethodCallback resultHandler) throws TException {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void DescribeDomain(DescribeDomainRequest describeRequest, AsyncMethodCallback resultHandler) throws TException {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void ListDomains(ListDomainsRequest listRequest, AsyncMethodCallback resultHandler) throws TException {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void UpdateDomain(UpdateDomainRequest updateRequest, AsyncMethodCallback resultHandler) throws TException {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void DeprecateDomain(DeprecateDomainRequest deprecateRequest, AsyncMethodCallback resultHandler) throws TException {
        throw new UnsupportedOperationException("not implemented");
    }

    static interface RemoteProc {
        public void apply() throws TException;
    }

    static interface RemoteCall<T> {
        public T apply() throws TException;
    }

    public static class ClientOptions {
        private final long rpcTimeoutMillis;
        private final long rpcLongPollTimeoutMillis;
        private final long rpcQueryTimeoutMillis;
        private final String serviceName;
        private final String clientAppName;
        private final Scope metricsScope;
        private final Map<String, String> transportHeaders;
        private final Map<String, String> headers;

        private ClientOptions(Builder builder) {
            this.rpcTimeoutMillis = builder.rpcTimeoutMillis;
            this.clientAppName = builder.clientAppName == null ? WorkflowServiceTChannel.DEFAULT_CLIENT_APP_NAME : builder.clientAppName;
            this.serviceName = builder.serviceName == null ? WorkflowServiceTChannel.DEFAULT_SERVICE_NAME : builder.serviceName;
            this.rpcLongPollTimeoutMillis = builder.rpcLongPollTimeoutMillis;
            this.rpcQueryTimeoutMillis = builder.rpcQueryTimeoutMillis;
            if (builder.metricsScope == null) {
                builder.metricsScope = NoopScope.getInstance();
            }
            this.metricsScope = builder.metricsScope;
            this.transportHeaders = builder.transportHeaders != null ? ImmutableMap.copyOf((Map)builder.transportHeaders) : ImmutableMap.of();
            this.headers = builder.headers != null ? ImmutableMap.copyOf((Map)builder.headers) : ImmutableMap.of();
        }

        public long getRpcTimeoutMillis() {
            return this.rpcTimeoutMillis;
        }

        public long getRpcLongPollTimeoutMillis() {
            return this.rpcLongPollTimeoutMillis;
        }

        public long getRpcQueryTimeoutMillis() {
            return this.rpcQueryTimeoutMillis;
        }

        public String getClientAppName() {
            return this.clientAppName;
        }

        public String getServiceName() {
            return this.serviceName;
        }

        public Scope getMetricsScope() {
            return this.metricsScope;
        }

        public Map<String, String> getTransportHeaders() {
            return this.transportHeaders;
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }

        public static class Builder {
            private String clientAppName = "cadence-client";
            private long rpcTimeoutMillis = 1000L;
            private long rpcLongPollTimeoutMillis = 121000L;
            public long rpcQueryTimeoutMillis = 10000L;
            public String serviceName;
            private Scope metricsScope;
            private Map<String, String> transportHeaders;
            private Map<String, String> headers;

            public Builder setRpcTimeout(long timeoutMillis) {
                this.rpcTimeoutMillis = timeoutMillis;
                return this;
            }

            public Builder setRpcLongPollTimeout(long timeoutMillis) {
                this.rpcLongPollTimeoutMillis = timeoutMillis;
                return this;
            }

            public Builder setQueryRpcTimeout(long timeoutMillis) {
                this.rpcQueryTimeoutMillis = timeoutMillis;
                return this;
            }

            public Builder setClientAppName(String clientAppName) {
                this.clientAppName = clientAppName;
                return this;
            }

            public Builder setServiceName(String serviceName) {
                this.serviceName = serviceName;
                return this;
            }

            public Builder setMetricsScope(Scope metricsScope) {
                this.metricsScope = metricsScope;
                return this;
            }

            public Builder setTransportHeaders(Map<String, String> transportHeaders) {
                this.transportHeaders = transportHeaders;
                return this;
            }

            public Builder setHeaders(Map<String, String> headers) {
                this.headers = headers;
                return this;
            }

            public ClientOptions build() {
                return new ClientOptions(this);
            }
        }
    }
}

