/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.worker;

import com.google.common.base.Strings;
import com.uber.cadence.BadRequestError;
import com.uber.cadence.DomainNotActiveError;
import com.uber.cadence.EntityNotExistsError;
import com.uber.cadence.GetWorkflowExecutionHistoryResponse;
import com.uber.cadence.History;
import com.uber.cadence.HistoryEvent;
import com.uber.cadence.PollForDecisionTaskResponse;
import com.uber.cadence.RespondDecisionTaskCompletedRequest;
import com.uber.cadence.RespondDecisionTaskFailedRequest;
import com.uber.cadence.RespondQueryTaskCompletedRequest;
import com.uber.cadence.WorkflowExecution;
import com.uber.cadence.WorkflowExecutionStartedEventAttributes;
import com.uber.cadence.WorkflowQuery;
import com.uber.cadence.WorkflowType;
import com.uber.cadence.common.RetryOptions;
import com.uber.cadence.common.WorkflowExecutionHistory;
import com.uber.cadence.internal.common.Retryer;
import com.uber.cadence.internal.common.WorkflowExecutionUtils;
import com.uber.cadence.internal.worker.DecisionTaskHandler;
import com.uber.cadence.internal.worker.NoopSuspendableWorker;
import com.uber.cadence.internal.worker.PollTaskExecutor;
import com.uber.cadence.internal.worker.Poller;
import com.uber.cadence.internal.worker.PollerOptions;
import com.uber.cadence.internal.worker.SingleWorkerOptions;
import com.uber.cadence.internal.worker.SuspendableWorker;
import com.uber.cadence.internal.worker.WorkflowPollTask;
import com.uber.cadence.internal.worker.WorkflowRunLockManager;
import com.uber.cadence.serviceclient.IWorkflowService;
import com.uber.m3.tally.Scope;
import com.uber.m3.tally.Stopwatch;
import com.uber.m3.util.ImmutableMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.function.Consumer;
import org.apache.thrift.TException;
import org.slf4j.MDC;

public final class WorkflowWorker
implements SuspendableWorker,
Consumer<PollForDecisionTaskResponse> {
    private static final String POLL_THREAD_NAME_PREFIX = "Workflow Poller taskList=";
    private SuspendableWorker poller = new NoopSuspendableWorker();
    private PollTaskExecutor<PollForDecisionTaskResponse> pollTaskExecutor;
    private final DecisionTaskHandler handler;
    private final IWorkflowService service;
    private final String domain;
    private final String taskList;
    private final SingleWorkerOptions options;
    private final String stickyTaskListName;
    private final WorkflowRunLockManager runLocks = new WorkflowRunLockManager();

    public WorkflowWorker(IWorkflowService service, String domain, String taskList, SingleWorkerOptions options, DecisionTaskHandler handler, String stickyTaskListName) {
        this.service = Objects.requireNonNull(service);
        this.domain = Objects.requireNonNull(domain);
        this.taskList = Objects.requireNonNull(taskList);
        this.handler = handler;
        this.stickyTaskListName = stickyTaskListName;
        PollerOptions pollerOptions = options.getPollerOptions();
        if (pollerOptions.getPollThreadNamePrefix() == null) {
            pollerOptions = new PollerOptions.Builder(pollerOptions).setPollThreadNamePrefix("Workflow Poller taskList=\"" + taskList + "\", domain=\"" + domain + "\"").build();
        }
        this.options = new SingleWorkerOptions.Builder(options).setPollerOptions(pollerOptions).build();
    }

    @Override
    public void start() {
        if (this.handler.isAnyTypeSupported()) {
            this.pollTaskExecutor = new PollTaskExecutor<PollForDecisionTaskResponse>(this.domain, this.taskList, this.options, new TaskHandlerImpl(this.handler));
            this.poller = new Poller<PollForDecisionTaskResponse>(this.options.getIdentity(), new WorkflowPollTask(this.service, this.domain, this.taskList, this.options.getMetricsScope(), this.options.getIdentity()), this.pollTaskExecutor, this.options.getPollerOptions(), this.options.getMetricsScope());
            this.poller.start();
            this.options.getMetricsScope().counter("cadence-worker-start").inc(1L);
        }
    }

    @Override
    public boolean isStarted() {
        return this.poller.isStarted();
    }

    @Override
    public boolean isShutdown() {
        return this.poller.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.poller.isTerminated();
    }

    public byte[] queryWorkflowExecution(WorkflowExecution exec, String queryType, byte[] args) throws Exception {
        GetWorkflowExecutionHistoryResponse historyResponse = WorkflowExecutionUtils.getHistoryPage(null, this.service, this.domain, exec);
        History history = historyResponse.getHistory();
        WorkflowExecutionHistory workflowExecutionHistory = new WorkflowExecutionHistory(history.getEvents());
        return this.queryWorkflowExecution(queryType, args, workflowExecutionHistory, historyResponse.getNextPageToken());
    }

    public byte[] queryWorkflowExecution(String jsonSerializedHistory, String queryType, byte[] args) throws Exception {
        WorkflowExecutionHistory history = WorkflowExecutionHistory.fromJson(jsonSerializedHistory);
        return this.queryWorkflowExecution(queryType, args, history, null);
    }

    public byte[] queryWorkflowExecution(WorkflowExecutionHistory history, String queryType, byte[] args) throws Exception {
        return this.queryWorkflowExecution(queryType, args, history, null);
    }

    private byte[] queryWorkflowExecution(String queryType, byte[] args, WorkflowExecutionHistory history, byte[] nextPageToken) throws Exception {
        PollForDecisionTaskResponse task = new PollForDecisionTaskResponse();
        task.setWorkflowExecution(history.getWorkflowExecution());
        task.setStartedEventId(Long.MAX_VALUE);
        task.setPreviousStartedEventId(Long.MAX_VALUE);
        task.setNextPageToken(nextPageToken);
        WorkflowQuery query = new WorkflowQuery();
        query.setQueryType(queryType).setQueryArgs(args);
        task.setQuery(query);
        List<HistoryEvent> events = history.getEvents();
        HistoryEvent startedEvent = events.get(0);
        WorkflowExecutionStartedEventAttributes started = startedEvent.getWorkflowExecutionStartedEventAttributes();
        if (started == null) {
            throw new IllegalStateException("First event of the history is not WorkflowExecutionStarted: " + startedEvent);
        }
        WorkflowType workflowType = started.getWorkflowType();
        task.setWorkflowType(workflowType);
        task.setHistory(new History().setEvents(events));
        DecisionTaskHandler.Result result = this.handler.handleDecisionTask(task);
        if (result.getQueryCompleted() != null) {
            RespondQueryTaskCompletedRequest r = result.getQueryCompleted();
            if (r.getErrorMessage() != null) {
                throw new RuntimeException("query failure for " + history.getWorkflowExecution() + ", queryType=" + queryType + ", args=" + Arrays.toString(args) + ", error=" + r.getErrorMessage());
            }
            return r.getQueryResult();
        }
        throw new RuntimeException("Query returned wrong response: " + result);
    }

    @Override
    public void shutdown() {
        this.poller.shutdown();
    }

    @Override
    public void shutdownNow() {
        this.poller.shutdownNow();
    }

    @Override
    public void awaitTermination(long timeout, TimeUnit unit) {
        if (!this.poller.isStarted()) {
            return;
        }
        this.poller.awaitTermination(timeout, unit);
    }

    @Override
    public void suspendPolling() {
        this.poller.suspendPolling();
    }

    @Override
    public void resumePolling() {
        this.poller.resumePolling();
    }

    @Override
    public boolean isSuspended() {
        return this.poller.isSuspended();
    }

    @Override
    public void accept(PollForDecisionTaskResponse pollForDecisionTaskResponse) {
        this.pollTaskExecutor.process(pollForDecisionTaskResponse);
    }

    private class TaskHandlerImpl
    implements PollTaskExecutor.TaskHandler<PollForDecisionTaskResponse> {
        final DecisionTaskHandler handler;

        private TaskHandlerImpl(DecisionTaskHandler handler) {
            this.handler = handler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handle(PollForDecisionTaskResponse task) throws Exception {
            Scope metricsScope = WorkflowWorker.this.options.getMetricsScope().tagged((Map)ImmutableMap.of((Object)"WorkflowType", (Object)task.getWorkflowType().getName()));
            MDC.put((String)"WorkflowID", (String)task.getWorkflowExecution().getWorkflowId());
            MDC.put((String)"WorkflowType", (String)task.getWorkflowType().getName());
            MDC.put((String)"RunID", (String)task.getWorkflowExecution().getRunId());
            Lock runLock = null;
            if (!Strings.isNullOrEmpty((String)WorkflowWorker.this.stickyTaskListName)) {
                runLock = WorkflowWorker.this.runLocks.getLockForLocking(task.getWorkflowExecution().getRunId());
                runLock.lock();
            }
            try {
                Stopwatch sw = metricsScope.timer("cadence-decision-execution-latency").start();
                DecisionTaskHandler.Result response = this.handler.handleDecisionTask(task);
                sw.stop();
                sw = metricsScope.timer("cadence-decision-response-latency").start();
                this.sendReply(WorkflowWorker.this.service, task.getTaskToken(), response);
                sw.stop();
                metricsScope.counter("cadence-decision-task-completed").inc(1L);
            }
            finally {
                MDC.remove((String)"WorkflowID");
                MDC.remove((String)"WorkflowType");
                MDC.remove((String)"RunID");
                if (runLock != null) {
                    WorkflowWorker.this.runLocks.unlock(task.getWorkflowExecution().getRunId());
                }
            }
        }

        @Override
        public Throwable wrapFailure(PollForDecisionTaskResponse task, Throwable failure) {
            WorkflowExecution execution = task.getWorkflowExecution();
            return new RuntimeException("Failure processing decision task. WorkflowID=" + execution.getWorkflowId() + ", RunID=" + execution.getRunId(), failure);
        }

        private void sendReply(IWorkflowService service, byte[] taskToken, DecisionTaskHandler.Result response) throws TException {
            RetryOptions ro = response.getRequestRetryOptions();
            RespondDecisionTaskCompletedRequest taskCompleted = response.getTaskCompleted();
            if (taskCompleted != null) {
                ro = WorkflowWorker.this.options.getReportCompletionRetryOptions().merge(ro).addDoNotRetry(BadRequestError.class, EntityNotExistsError.class, DomainNotActiveError.class);
                taskCompleted.setIdentity(WorkflowWorker.this.options.getIdentity());
                taskCompleted.setTaskToken(taskToken);
                Retryer.retry(ro, () -> service.RespondDecisionTaskCompleted(taskCompleted));
            } else {
                RespondDecisionTaskFailedRequest taskFailed = response.getTaskFailed();
                if (taskFailed != null) {
                    ro = WorkflowWorker.this.options.getReportFailureRetryOptions().merge(ro).addDoNotRetry(BadRequestError.class, EntityNotExistsError.class, DomainNotActiveError.class);
                    taskFailed.setIdentity(WorkflowWorker.this.options.getIdentity());
                    taskFailed.setTaskToken(taskToken);
                    Retryer.retry(ro, () -> service.RespondDecisionTaskFailed(taskFailed));
                } else {
                    RespondQueryTaskCompletedRequest queryCompleted = response.getQueryCompleted();
                    if (queryCompleted != null) {
                        queryCompleted.setTaskToken(taskToken);
                        service.RespondQueryTaskCompleted(queryCompleted);
                    }
                }
            }
        }
    }
}

