/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.worker;

import com.uber.cadence.common.RetryOptions;
import com.uber.cadence.converter.DataConverter;
import com.uber.cadence.converter.JsonDataConverter;
import com.uber.cadence.internal.common.Retryer;
import com.uber.cadence.internal.metrics.NoopScope;
import com.uber.cadence.internal.worker.PollerOptions;
import com.uber.m3.tally.Scope;
import java.time.Duration;

public final class SingleWorkerOptions {
    private final String identity;
    private final DataConverter dataConverter;
    private final int taskExecutorThreadPoolSize;
    private final double taskListActivitiesPerSecond;
    private final PollerOptions pollerOptions;
    private final RetryOptions reportCompletionRetryOptions;
    private final RetryOptions reportFailureRetryOptions;
    private final Scope metricsScope;
    private final boolean enableLoggingInReplay;

    private SingleWorkerOptions(String identity, DataConverter dataConverter, int taskExecutorThreadPoolSize, double taskListActivitiesPerSecond, PollerOptions pollerOptions, RetryOptions reportCompletionRetryOptions, RetryOptions reportFailureRetryOptions, Scope metricsScope, boolean enableLoggingInReplay) {
        this.identity = identity;
        this.dataConverter = dataConverter;
        this.taskExecutorThreadPoolSize = taskExecutorThreadPoolSize;
        this.taskListActivitiesPerSecond = taskListActivitiesPerSecond;
        this.pollerOptions = pollerOptions;
        this.reportCompletionRetryOptions = reportCompletionRetryOptions;
        this.reportFailureRetryOptions = reportFailureRetryOptions;
        this.metricsScope = metricsScope;
        this.enableLoggingInReplay = enableLoggingInReplay;
    }

    public String getIdentity() {
        return this.identity;
    }

    public DataConverter getDataConverter() {
        return this.dataConverter;
    }

    int getTaskExecutorThreadPoolSize() {
        return this.taskExecutorThreadPoolSize;
    }

    PollerOptions getPollerOptions() {
        return this.pollerOptions;
    }

    RetryOptions getReportCompletionRetryOptions() {
        return this.reportCompletionRetryOptions;
    }

    RetryOptions getReportFailureRetryOptions() {
        return this.reportFailureRetryOptions;
    }

    double getTaskListActivitiesPerSecond() {
        return this.taskListActivitiesPerSecond;
    }

    public Scope getMetricsScope() {
        return this.metricsScope;
    }

    public boolean getEnableLoggingInReplay() {
        return this.enableLoggingInReplay;
    }

    public static final class Builder {
        private String identity;
        private DataConverter dataConverter;
        private int taskExecutorThreadPoolSize = 100;
        private double taskListActivitiesPerSecond;
        private PollerOptions pollerOptions;
        private RetryOptions reportCompletionRetryOptions;
        private RetryOptions reportFailureRetryOptions;
        private Scope metricsScope;
        private boolean enableLoggingInReplay;

        public Builder() {
        }

        public Builder(SingleWorkerOptions options) {
            this.identity = options.getIdentity();
            this.dataConverter = options.getDataConverter();
            this.pollerOptions = options.getPollerOptions();
            this.taskListActivitiesPerSecond = options.getTaskListActivitiesPerSecond();
            this.taskExecutorThreadPoolSize = options.getTaskExecutorThreadPoolSize();
            this.reportCompletionRetryOptions = options.getReportCompletionRetryOptions();
            this.reportFailureRetryOptions = options.getReportFailureRetryOptions();
            this.metricsScope = options.getMetricsScope();
            this.enableLoggingInReplay = options.getEnableLoggingInReplay();
        }

        public Builder setIdentity(String identity) {
            this.identity = identity;
            return this;
        }

        public Builder setDataConverter(DataConverter dataConverter) {
            this.dataConverter = dataConverter;
            return this;
        }

        public Builder setTaskExecutorThreadPoolSize(int taskExecutorThreadPoolSize) {
            this.taskExecutorThreadPoolSize = taskExecutorThreadPoolSize;
            return this;
        }

        public Builder setPollerOptions(PollerOptions pollerOptions) {
            this.pollerOptions = pollerOptions;
            return this;
        }

        public Builder setMetricsScope(Scope metricsScope) {
            this.metricsScope = metricsScope;
            return this;
        }

        public Builder setEnableLoggingInReplay(boolean enableLoggingInReplay) {
            this.enableLoggingInReplay = enableLoggingInReplay;
            return this;
        }

        public Builder setTaskListActivitiesPerSecond(double taskListActivitiesPerSecond) {
            this.taskListActivitiesPerSecond = taskListActivitiesPerSecond;
            return this;
        }

        public Builder setReportCompletionRetryOptions(RetryOptions reportCompletionRetryOptions) {
            this.reportCompletionRetryOptions = reportCompletionRetryOptions;
            return this;
        }

        public Builder setReportFailureRetryOptions(RetryOptions reportFailureRetryOptions) {
            this.reportFailureRetryOptions = reportFailureRetryOptions;
            return this;
        }

        public SingleWorkerOptions build() {
            if (this.reportCompletionRetryOptions == null) {
                this.reportCompletionRetryOptions = Retryer.DEFAULT_SERVICE_OPERATION_RETRY_OPTIONS;
            }
            if (this.reportFailureRetryOptions == null) {
                this.reportFailureRetryOptions = Retryer.DEFAULT_SERVICE_OPERATION_RETRY_OPTIONS;
            }
            if (this.pollerOptions == null) {
                this.pollerOptions = new PollerOptions.Builder().setPollBackoffInitialInterval(Duration.ofMillis(200L)).setPollBackoffMaximumInterval(Duration.ofSeconds(20L)).setPollThreadCount(1).build();
            }
            if (this.dataConverter == null) {
                this.dataConverter = JsonDataConverter.getInstance();
            }
            if (this.metricsScope == null) {
                this.metricsScope = NoopScope.getInstance();
            }
            return new SingleWorkerOptions(this.identity, this.dataConverter, this.taskExecutorThreadPoolSize, this.taskListActivitiesPerSecond, this.pollerOptions, this.reportCompletionRetryOptions, this.reportFailureRetryOptions, this.metricsScope, this.enableLoggingInReplay);
        }
    }
}

