/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.worker;

import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PollerOptions {
    private static final Logger log = LoggerFactory.getLogger(PollerOptions.class);
    private final int maximumPollRateIntervalMilliseconds;
    private final double maximumPollRatePerSecond;
    private final double pollBackoffCoefficient;
    private final Duration pollBackoffInitialInterval;
    private final Duration pollBackoffMaximumInterval;
    private final int pollThreadCount;
    private final Thread.UncaughtExceptionHandler uncaughtExceptionHandler;
    private final String pollThreadNamePrefix;

    private PollerOptions(int maximumPollRateIntervalMilliseconds, double maximumPollRatePerSecond, double pollBackoffCoefficient, Duration pollBackoffInitialInterval, Duration pollBackoffMaximumInterval, int pollThreadCount, Thread.UncaughtExceptionHandler uncaughtExceptionHandler, String pollThreadNamePrefix) {
        this.maximumPollRateIntervalMilliseconds = maximumPollRateIntervalMilliseconds;
        this.maximumPollRatePerSecond = maximumPollRatePerSecond;
        this.pollBackoffCoefficient = pollBackoffCoefficient;
        this.pollBackoffInitialInterval = pollBackoffInitialInterval;
        this.pollBackoffMaximumInterval = pollBackoffMaximumInterval;
        this.pollThreadCount = pollThreadCount;
        this.uncaughtExceptionHandler = uncaughtExceptionHandler;
        this.pollThreadNamePrefix = pollThreadNamePrefix;
    }

    public int getMaximumPollRateIntervalMilliseconds() {
        return this.maximumPollRateIntervalMilliseconds;
    }

    public double getMaximumPollRatePerSecond() {
        return this.maximumPollRatePerSecond;
    }

    public double getPollBackoffCoefficient() {
        return this.pollBackoffCoefficient;
    }

    public Duration getPollBackoffInitialInterval() {
        return this.pollBackoffInitialInterval;
    }

    public Duration getPollBackoffMaximumInterval() {
        return this.pollBackoffMaximumInterval;
    }

    public int getPollThreadCount() {
        return this.pollThreadCount;
    }

    public Thread.UncaughtExceptionHandler getUncaughtExceptionHandler() {
        return this.uncaughtExceptionHandler;
    }

    public String getPollThreadNamePrefix() {
        return this.pollThreadNamePrefix;
    }

    public String toString() {
        return "PollerOptions{maximumPollRateIntervalMilliseconds=" + this.maximumPollRateIntervalMilliseconds + ", maximumPollRatePerSecond=" + this.maximumPollRatePerSecond + ", pollBackoffCoefficient=" + this.pollBackoffCoefficient + ", pollBackoffInitialInterval=" + this.pollBackoffInitialInterval + ", pollBackoffMaximumInterval=" + this.pollBackoffMaximumInterval + ", pollThreadCount=" + this.pollThreadCount + ", pollThreadNamePrefix='" + this.pollThreadNamePrefix + '\'' + '}';
    }

    public static final class Builder {
        private int maximumPollRateIntervalMilliseconds = 1000;
        private double maximumPollRatePerSecond;
        private double pollBackoffCoefficient = 2.0;
        private Duration pollBackoffInitialInterval = Duration.ofMillis(100L);
        private Duration pollBackoffMaximumInterval = Duration.ofMinutes(1L);
        private int pollThreadCount = 1;
        private String pollThreadNamePrefix;
        private Thread.UncaughtExceptionHandler uncaughtExceptionHandler;

        public Builder() {
        }

        public Builder(PollerOptions o) {
            if (o == null) {
                return;
            }
            this.maximumPollRateIntervalMilliseconds = o.getMaximumPollRateIntervalMilliseconds();
            this.maximumPollRatePerSecond = o.getMaximumPollRatePerSecond();
            this.pollBackoffCoefficient = o.getPollBackoffCoefficient();
            this.pollBackoffInitialInterval = o.getPollBackoffInitialInterval();
            this.pollBackoffMaximumInterval = o.getPollBackoffMaximumInterval();
            this.pollThreadCount = o.getPollThreadCount();
            this.pollThreadNamePrefix = o.getPollThreadNamePrefix();
            this.uncaughtExceptionHandler = o.getUncaughtExceptionHandler();
        }

        public Builder setMaximumPollRateIntervalMilliseconds(int maximumPollRateIntervalMilliseconds) {
            this.maximumPollRateIntervalMilliseconds = maximumPollRateIntervalMilliseconds;
            return this;
        }

        public Builder setMaximumPollRatePerSecond(double maximumPollRatePerSecond) {
            this.maximumPollRatePerSecond = maximumPollRatePerSecond;
            return this;
        }

        public Builder setPollBackoffCoefficient(double pollBackoffCoefficient) {
            this.pollBackoffCoefficient = pollBackoffCoefficient;
            return this;
        }

        public Builder setPollBackoffInitialInterval(Duration pollBackoffInitialInterval) {
            this.pollBackoffInitialInterval = pollBackoffInitialInterval;
            return this;
        }

        public Builder setPollBackoffMaximumInterval(Duration pollBackoffMaximumInterval) {
            this.pollBackoffMaximumInterval = pollBackoffMaximumInterval;
            return this;
        }

        public Builder setPollThreadCount(int pollThreadCount) {
            this.pollThreadCount = pollThreadCount;
            return this;
        }

        public Builder setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
            this.uncaughtExceptionHandler = uncaughtExceptionHandler;
            return this;
        }

        public Builder setPollThreadNamePrefix(String pollThreadNamePrefix) {
            this.pollThreadNamePrefix = pollThreadNamePrefix;
            return this;
        }

        public PollerOptions build() {
            if (this.uncaughtExceptionHandler == null) {
                this.uncaughtExceptionHandler = (t, e) -> log.error("uncaught exception", e);
            }
            return new PollerOptions(this.maximumPollRateIntervalMilliseconds, this.maximumPollRatePerSecond, this.pollBackoffCoefficient, this.pollBackoffInitialInterval, this.pollBackoffMaximumInterval, this.pollThreadCount, this.uncaughtExceptionHandler, this.pollThreadNamePrefix);
        }
    }
}

