/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.worker;

import com.uber.cadence.EventType;
import com.uber.cadence.HistoryEvent;
import com.uber.cadence.MarkerRecordedEventAttributes;
import com.uber.cadence.PollForActivityTaskResponse;
import com.uber.cadence.common.RetryOptions;
import com.uber.cadence.internal.common.LocalActivityMarkerData;
import com.uber.cadence.internal.replay.ExecuteLocalActivityParameters;
import com.uber.cadence.internal.worker.ActivityTaskHandler;
import com.uber.cadence.internal.worker.LocalActivityPollTask;
import com.uber.cadence.internal.worker.NoopSuspendableWorker;
import com.uber.cadence.internal.worker.PollTaskExecutor;
import com.uber.cadence.internal.worker.Poller;
import com.uber.cadence.internal.worker.PollerOptions;
import com.uber.cadence.internal.worker.SingleWorkerOptions;
import com.uber.cadence.internal.worker.SuspendableWorker;
import com.uber.m3.tally.Scope;
import com.uber.m3.tally.Stopwatch;
import com.uber.m3.util.ImmutableMap;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.LongSupplier;

public final class LocalActivityWorker
implements SuspendableWorker {
    private static final String POLL_THREAD_NAME_PREFIX = "Local Activity Poller taskList=";
    private SuspendableWorker poller = new NoopSuspendableWorker();
    private final ActivityTaskHandler handler;
    private final String domain;
    private final String taskList;
    private final SingleWorkerOptions options;
    private final LocalActivityPollTask laPollTask;

    public LocalActivityWorker(String domain, String taskList, SingleWorkerOptions options, ActivityTaskHandler handler) {
        this.domain = Objects.requireNonNull(domain);
        this.taskList = Objects.requireNonNull(taskList);
        this.handler = handler;
        this.laPollTask = new LocalActivityPollTask();
        PollerOptions pollerOptions = options.getPollerOptions();
        if (pollerOptions.getPollThreadNamePrefix() == null) {
            pollerOptions = new PollerOptions.Builder(pollerOptions).setPollThreadNamePrefix("Local Activity Poller taskList=\"" + taskList + "\", domain=\"" + domain + "\"").build();
        }
        this.options = new SingleWorkerOptions.Builder(options).setPollerOptions(pollerOptions).build();
    }

    @Override
    public void start() {
        if (this.handler.isAnyTypeSupported()) {
            this.poller = new Poller<Task>(this.options.getIdentity(), this.laPollTask, new PollTaskExecutor<Task>(this.domain, this.taskList, this.options, new TaskHandlerImpl(this.handler)), this.options.getPollerOptions(), this.options.getMetricsScope());
            this.poller.start();
            this.options.getMetricsScope().counter("cadence-worker-start").inc(1L);
        }
    }

    @Override
    public boolean isStarted() {
        return this.poller.isStarted();
    }

    @Override
    public boolean isShutdown() {
        return this.poller.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.poller.isTerminated();
    }

    @Override
    public void shutdown() {
        this.poller.shutdown();
    }

    @Override
    public void shutdownNow() {
        this.poller.shutdownNow();
    }

    @Override
    public void awaitTermination(long timeout, TimeUnit unit) {
        this.poller.awaitTermination(timeout, unit);
    }

    @Override
    public void suspendPolling() {
        this.poller.suspendPolling();
    }

    @Override
    public void resumePolling() {
        this.poller.resumePolling();
    }

    @Override
    public boolean isSuspended() {
        return this.poller.isSuspended();
    }

    public BiFunction<Task, Duration, Boolean> getLocalActivityTaskPoller() {
        return this.laPollTask;
    }

    private class TaskHandlerImpl
    implements PollTaskExecutor.TaskHandler<Task> {
        final ActivityTaskHandler handler;

        private TaskHandlerImpl(ActivityTaskHandler handler) {
            this.handler = handler;
        }

        @Override
        public void handle(Task task) throws Exception {
            task.taskStartTime = System.currentTimeMillis();
            ActivityTaskHandler.Result result = this.handleLocalActivity(task);
            LocalActivityMarkerData.Builder markerBuilder = new LocalActivityMarkerData.Builder();
            markerBuilder.setActivityId(task.params.getActivityId());
            markerBuilder.setActivityType(task.params.getActivityType());
            long replayTimeMillis = task.currentTimeMillis.getAsLong() + (System.currentTimeMillis() - task.replayTimeUpdatedAtMillis.getAsLong());
            markerBuilder.setReplayTimeMillis(replayTimeMillis);
            if (result.getTaskCompleted() != null) {
                markerBuilder.setResult(result.getTaskCompleted().getResult());
            } else if (result.getTaskFailedResult() != null) {
                markerBuilder.setTaskFailedRequest(result.getTaskFailedResult().getTaskFailedRequest());
                markerBuilder.setAttempt(result.getAttempt());
                markerBuilder.setBackoff(result.getBackoff());
            } else {
                markerBuilder.setTaskCancelledRequest(result.getTaskCancelled());
            }
            LocalActivityMarkerData marker = markerBuilder.build();
            HistoryEvent event = new HistoryEvent();
            event.setEventType(EventType.MarkerRecorded);
            MarkerRecordedEventAttributes attributes = new MarkerRecordedEventAttributes().setMarkerName("LocalActivity").setHeader(marker.getHeader(LocalActivityWorker.this.options.getDataConverter())).setDetails(marker.getResult());
            event.setMarkerRecordedEventAttributes(attributes);
            task.eventConsumer.accept(event);
        }

        @Override
        public Throwable wrapFailure(Task task, Throwable failure) {
            return new RuntimeException("Failure processing local activity task.", failure);
        }

        private ActivityTaskHandler.Result handleLocalActivity(Task task) throws InterruptedException {
            ImmutableMap activityTypeTag = new ImmutableMap.Builder(1).put((Object)"ActivityType", (Object)task.params.getActivityType().getName()).build();
            Scope metricsScope = LocalActivityWorker.this.options.getMetricsScope().tagged((Map)activityTypeTag);
            metricsScope.counter("cadence-local-activity-total").inc(1L);
            PollForActivityTaskResponse pollTask = new PollForActivityTaskResponse();
            pollTask.setActivityType(task.params.getActivityType());
            pollTask.setInput(task.params.getInput());
            pollTask.setAttempt(task.params.getAttempt());
            Stopwatch sw = metricsScope.timer("cadence-local-activity-execution-latency").start();
            ActivityTaskHandler.Result result = this.handler.handle(pollTask, metricsScope, true);
            sw.stop();
            result.setAttempt(task.params.getAttempt());
            if (result.getTaskCompleted() != null || result.getTaskCancelled() != null || task.params.getRetryOptions() == null) {
                return result;
            }
            RetryOptions retryOptions = task.params.getRetryOptions();
            long sleepMillis = retryOptions.calculateSleepTime(task.params.getAttempt());
            long elapsedTask = System.currentTimeMillis() - task.taskStartTime;
            long elapsedTotal = elapsedTask + task.params.getElapsedTime();
            if (retryOptions.shouldRethrow(result.getTaskFailedResult().getFailure(), task.params.getAttempt(), elapsedTotal, sleepMillis)) {
                return result;
            }
            result.setBackoff(Duration.ofMillis(sleepMillis));
            if (elapsedTask + sleepMillis < (long)(task.decisionTimeoutSeconds * 1000)) {
                Thread.sleep(sleepMillis);
                task.params.setAttempt(task.params.getAttempt() + 1);
                return this.handleLocalActivity(task);
            }
            return result;
        }
    }

    public static class Task {
        private final ExecuteLocalActivityParameters params;
        private final Consumer<HistoryEvent> eventConsumer;
        private final LongSupplier currentTimeMillis;
        private final LongSupplier replayTimeUpdatedAtMillis;
        long taskStartTime;
        private final int decisionTimeoutSeconds;

        public Task(ExecuteLocalActivityParameters params, Consumer<HistoryEvent> eventConsumer, int decisionTimeoutSeconds, LongSupplier currentTimeMillis, LongSupplier replayTimeUpdatedAtMillis) {
            this.params = params;
            this.eventConsumer = eventConsumer;
            this.currentTimeMillis = currentTimeMillis;
            this.replayTimeUpdatedAtMillis = replayTimeUpdatedAtMillis;
            this.decisionTimeoutSeconds = decisionTimeoutSeconds;
        }
    }
}

