/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.worker;

import com.uber.cadence.InternalServiceError;
import com.uber.cadence.PollForActivityTaskRequest;
import com.uber.cadence.PollForActivityTaskResponse;
import com.uber.cadence.ServiceBusyError;
import com.uber.cadence.TaskList;
import com.uber.cadence.TaskListMetadata;
import com.uber.cadence.internal.worker.ActivityWorker;
import com.uber.cadence.internal.worker.Poller;
import com.uber.cadence.internal.worker.SingleWorkerOptions;
import com.uber.cadence.serviceclient.IWorkflowService;
import com.uber.m3.tally.Stopwatch;
import com.uber.m3.util.Duration;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ActivityPollTask
implements Poller.PollTask<ActivityWorker.MeasurableActivityTask> {
    private final IWorkflowService service;
    private final String domain;
    private final String taskList;
    private final SingleWorkerOptions options;
    private static final Logger log = LoggerFactory.getLogger(ActivityPollTask.class);

    public ActivityPollTask(IWorkflowService service, String domain, String taskList, SingleWorkerOptions options) {
        this.service = service;
        this.domain = domain;
        this.taskList = taskList;
        this.options = options;
    }

    @Override
    public ActivityWorker.MeasurableActivityTask poll() throws TException {
        PollForActivityTaskResponse result;
        this.options.getMetricsScope().counter("cadence-activity-poll-total").inc(1L);
        Stopwatch sw = this.options.getMetricsScope().timer("cadence-activity-poll-latency").start();
        Stopwatch e2eSW = this.options.getMetricsScope().timer("cadence-activity-endtoend-latency").start();
        PollForActivityTaskRequest pollRequest = new PollForActivityTaskRequest();
        pollRequest.setDomain(this.domain);
        pollRequest.setIdentity(this.options.getIdentity());
        pollRequest.setTaskList(new TaskList().setName(this.taskList));
        if (this.options.getTaskListActivitiesPerSecond() > 0.0) {
            TaskListMetadata metadata = new TaskListMetadata();
            metadata.setMaxTasksPerSecond(this.options.getTaskListActivitiesPerSecond());
            pollRequest.setTaskListMetadata(metadata);
        }
        if (log.isDebugEnabled()) {
            log.debug("poll request begin: " + pollRequest);
        }
        try {
            result = this.service.PollForActivityTask(pollRequest);
        }
        catch (InternalServiceError | ServiceBusyError e) {
            this.options.getMetricsScope().counter("cadence-activity-poll-transient-failed").inc(1L);
            throw e;
        }
        catch (TException e) {
            this.options.getMetricsScope().counter("cadence-activity-poll-failed").inc(1L);
            throw e;
        }
        if (result == null || result.getTaskToken() == null) {
            if (log.isDebugEnabled()) {
                log.debug("poll request returned no task");
            }
            this.options.getMetricsScope().counter("cadence-activity-poll-no-task").inc(1L);
            return null;
        }
        if (log.isTraceEnabled()) {
            log.trace("poll request returned " + result);
        }
        this.options.getMetricsScope().counter("cadence-activity-poll-succeed").inc(1L);
        this.options.getMetricsScope().timer("cadence-activity-scheduled-to-start-latency").record(Duration.ofNanos((long)(result.getStartedTimestamp() - result.getScheduledTimestampOfThisAttempt())));
        sw.stop();
        return new ActivityWorker.MeasurableActivityTask(result, e2eSW);
    }
}

