/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.testservice;

import com.uber.cadence.BadRequestError;
import com.uber.cadence.EntityNotExistsError;
import com.uber.cadence.EventType;
import com.uber.cadence.GetWorkflowExecutionHistoryRequest;
import com.uber.cadence.GetWorkflowExecutionHistoryResponse;
import com.uber.cadence.History;
import com.uber.cadence.HistoryEvent;
import com.uber.cadence.HistoryEventFilterType;
import com.uber.cadence.InternalServiceError;
import com.uber.cadence.PollForActivityTaskRequest;
import com.uber.cadence.PollForActivityTaskResponse;
import com.uber.cadence.PollForDecisionTaskRequest;
import com.uber.cadence.PollForDecisionTaskResponse;
import com.uber.cadence.StickyExecutionAttributes;
import com.uber.cadence.WorkflowExecution;
import com.uber.cadence.WorkflowExecutionInfo;
import com.uber.cadence.internal.common.WorkflowExecutionUtils;
import com.uber.cadence.internal.testservice.ExecutionId;
import com.uber.cadence.internal.testservice.RequestContext;
import com.uber.cadence.internal.testservice.SelfAdvancingTimer;
import com.uber.cadence.internal.testservice.SelfAdvancingTimerImpl;
import com.uber.cadence.internal.testservice.TestWorkflowStore;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

class TestWorkflowStoreImpl
implements TestWorkflowStore {
    private final Lock lock = new ReentrantLock();
    private final Map<ExecutionId, HistoryStore> histories = new HashMap<ExecutionId, HistoryStore>();
    private final Map<TestWorkflowStore.TaskListId, BlockingQueue<PollForActivityTaskResponse>> activityTaskLists = new HashMap<TestWorkflowStore.TaskListId, BlockingQueue<PollForActivityTaskResponse>>();
    private final Map<TestWorkflowStore.TaskListId, BlockingQueue<PollForDecisionTaskResponse>> decisionTaskLists = new HashMap<TestWorkflowStore.TaskListId, BlockingQueue<PollForDecisionTaskResponse>>();
    private final SelfAdvancingTimer timerService = new SelfAdvancingTimerImpl(System.currentTimeMillis());

    public TestWorkflowStoreImpl() {
        this.timerService.lockTimeSkipping("TestWorkflowStoreImpl constructor");
    }

    @Override
    public SelfAdvancingTimer getTimer() {
        return this.timerService;
    }

    @Override
    public long currentTimeMillis() {
        return this.timerService.getClock().getAsLong();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long save(RequestContext ctx) throws InternalServiceError, EntityNotExistsError, BadRequestError {
        List<RequestContext.Timer> timers;
        List<TestWorkflowStore.ActivityTask> activityTasks;
        long result;
        this.lock.lock();
        boolean historiesEmpty = this.histories.isEmpty();
        try {
            ExecutionId executionId = ctx.getExecutionId();
            HistoryStore history = this.histories.get(executionId);
            List<HistoryEvent> events = ctx.getEvents();
            if (history == null) {
                if (events.isEmpty() || events.get(0).getEventType() != EventType.WorkflowExecutionStarted) {
                    throw new IllegalStateException("No history found for " + executionId);
                }
                history = new HistoryStore(executionId, this.lock);
                this.histories.put(executionId, history);
            }
            history.checkNextEventId(ctx.getInitialEventId());
            history.addAllLocked(events, ctx.currentTimeInNanoseconds());
            result = history.getNextEventIdLocked();
            this.timerService.updateLocks(ctx.getTimerLocks(), "TestWorkflowStoreImpl save");
            ctx.fireCallbacks(history.getEventsLocked().size());
        }
        finally {
            if (historiesEmpty && !this.histories.isEmpty()) {
                this.timerService.unlockTimeSkipping("TestWorkflowStoreImpl save");
            }
            this.lock.unlock();
        }
        TestWorkflowStore.DecisionTask decisionTask = ctx.getDecisionTask();
        if (decisionTask != null) {
            StickyExecutionAttributes attributes = ctx.getWorkflowMutableState().getStickyExecutionAttributes();
            TestWorkflowStore.TaskListId id = new TestWorkflowStore.TaskListId(decisionTask.getTaskListId().getDomain(), attributes == null ? decisionTask.getTaskListId().getTaskListName() : attributes.getWorkerTaskList().getName());
            BlockingQueue<PollForDecisionTaskResponse> decisionsQueue = this.getDecisionTaskListQueue(id);
            decisionsQueue.add(decisionTask.getTask());
        }
        if ((activityTasks = ctx.getActivityTasks()) != null) {
            for (TestWorkflowStore.ActivityTask activityTask : activityTasks) {
                BlockingQueue<PollForActivityTaskResponse> activitiesQueue = this.getActivityTaskListQueue(activityTask.getTaskListId());
                activitiesQueue.add(activityTask.getTask());
            }
        }
        if ((timers = ctx.getTimers()) != null) {
            for (RequestContext.Timer t : timers) {
                this.timerService.schedule(Duration.ofSeconds(t.getDelaySeconds()), t.getCallback(), t.getTaskInfo());
            }
        }
        return result;
    }

    @Override
    public void applyTimersAndLocks(RequestContext ctx) {
        this.lock.lock();
        try {
            this.timerService.updateLocks(ctx.getTimerLocks(), "TestWorkflowStoreImpl applyTimersAndLocks");
        }
        finally {
            this.lock.unlock();
        }
        List<RequestContext.Timer> timers = ctx.getTimers();
        if (timers != null) {
            for (RequestContext.Timer t : timers) {
                this.timerService.schedule(Duration.ofSeconds(t.getDelaySeconds()), t.getCallback(), t.getTaskInfo());
            }
        }
        ctx.clearTimersAndLocks();
    }

    @Override
    public void registerDelayedCallback(Duration delay, Runnable r) {
        this.timerService.schedule(delay, r, "registerDelayedCallback");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BlockingQueue<PollForActivityTaskResponse> getActivityTaskListQueue(TestWorkflowStore.TaskListId taskListId) {
        this.lock.lock();
        try {
            BlockingQueue<PollForActivityTaskResponse> activitiesQueue = this.activityTaskLists.get(taskListId);
            if (activitiesQueue == null) {
                activitiesQueue = new LinkedBlockingQueue<PollForActivityTaskResponse>();
                this.activityTaskLists.put(taskListId, activitiesQueue);
            }
            BlockingQueue<PollForActivityTaskResponse> blockingQueue = activitiesQueue;
            return blockingQueue;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BlockingQueue<PollForDecisionTaskResponse> getDecisionTaskListQueue(TestWorkflowStore.TaskListId taskListId) {
        this.lock.lock();
        try {
            BlockingQueue<PollForDecisionTaskResponse> decisionsQueue = this.decisionTaskLists.get(taskListId);
            if (decisionsQueue == null) {
                decisionsQueue = new LinkedBlockingQueue<PollForDecisionTaskResponse>();
                this.decisionTaskLists.put(taskListId, decisionsQueue);
            }
            BlockingQueue<PollForDecisionTaskResponse> blockingQueue = decisionsQueue;
            return blockingQueue;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public PollForDecisionTaskResponse pollForDecisionTask(PollForDecisionTaskRequest pollRequest) throws InterruptedException {
        TestWorkflowStore.TaskListId taskListId = new TestWorkflowStore.TaskListId(pollRequest.getDomain(), pollRequest.getTaskList().getName());
        BlockingQueue<PollForDecisionTaskResponse> decisionsQueue = this.getDecisionTaskListQueue(taskListId);
        return decisionsQueue.take();
    }

    @Override
    public PollForActivityTaskResponse pollForActivityTask(PollForActivityTaskRequest pollRequest) throws InterruptedException {
        TestWorkflowStore.TaskListId taskListId = new TestWorkflowStore.TaskListId(pollRequest.getDomain(), pollRequest.getTaskList().getName());
        BlockingQueue<PollForActivityTaskResponse> activityTaskQueue = this.getActivityTaskListQueue(taskListId);
        return activityTaskQueue.take();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendQueryTask(ExecutionId executionId, TestWorkflowStore.TaskListId taskList, PollForDecisionTaskResponse task) throws EntityNotExistsError {
        this.lock.lock();
        try {
            HistoryStore historyStore = this.getHistoryStore(executionId);
            ArrayList<HistoryEvent> events = new ArrayList<HistoryEvent>(historyStore.getEventsLocked());
            History history = new History();
            if (taskList.getTaskListName().equals(task.getWorkflowExecutionTaskList().getName())) {
                history.setEvents(events);
            } else {
                history.setEvents(new ArrayList<HistoryEvent>());
            }
            task.setHistory(history);
        }
        finally {
            this.lock.unlock();
        }
        BlockingQueue<PollForDecisionTaskResponse> decisionsQueue = this.getDecisionTaskListQueue(taskList);
        decisionsQueue.add(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetWorkflowExecutionHistoryResponse getWorkflowExecutionHistory(ExecutionId executionId, GetWorkflowExecutionHistoryRequest getRequest) throws EntityNotExistsError {
        long expectedNextEventId;
        HistoryStore history;
        this.lock.lock();
        try {
            history = this.getHistoryStore(executionId);
            if (!getRequest.isWaitForNewEvent() && getRequest.getHistoryEventFilterType() != HistoryEventFilterType.CLOSE_EVENT) {
                List<HistoryEvent> events = history.getEventsLocked();
                ArrayList<HistoryEvent> eventsCopy = new ArrayList<HistoryEvent>(events);
                GetWorkflowExecutionHistoryResponse getWorkflowExecutionHistoryResponse = new GetWorkflowExecutionHistoryResponse().setHistory(new History().setEvents(eventsCopy));
                return getWorkflowExecutionHistoryResponse;
            }
            expectedNextEventId = history.getNextEventIdLocked();
        }
        finally {
            this.lock.unlock();
        }
        List<HistoryEvent> events = history.waitForNewEvents(expectedNextEventId, getRequest.getHistoryEventFilterType());
        GetWorkflowExecutionHistoryResponse result = new GetWorkflowExecutionHistoryResponse();
        if (events != null) {
            result.setHistory(new History().setEvents(events));
        }
        return result;
    }

    private HistoryStore getHistoryStore(ExecutionId executionId) throws EntityNotExistsError {
        HistoryStore result = this.histories.get(executionId);
        if (result == null) {
            WorkflowExecution execution = executionId.getExecution();
            throw new EntityNotExistsError(String.format("Workflow execution result not found.  WorkflowId: %s, RunId: %s", execution.getWorkflowId(), execution.getRunId()));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getDiagnostics(StringBuilder result) {
        result.append("Stored Workflows:\n");
        this.lock.lock();
        try {
            for (Map.Entry<ExecutionId, HistoryStore> entry : this.histories.entrySet()) {
                result.append(entry.getKey());
                result.append("\n");
                result.append(WorkflowExecutionUtils.prettyPrintHistory(entry.getValue().getEventsLocked().iterator(), true));
                result.append("\n");
            }
        }
        finally {
            this.lock.unlock();
        }
        this.timerService.getDiagnostics(result);
    }

    @Override
    public List<WorkflowExecutionInfo> listWorkflows(TestWorkflowStore.WorkflowState state, Optional<String> filterWorkflowId) {
        ArrayList<WorkflowExecutionInfo> result = new ArrayList<WorkflowExecutionInfo>();
        for (Map.Entry<ExecutionId, HistoryStore> entry : this.histories.entrySet()) {
            WorkflowExecutionInfo info;
            List<HistoryEvent> history;
            String workflowId;
            ExecutionId executionId;
            if (state == TestWorkflowStore.WorkflowState.OPEN) {
                if (entry.getValue().isCompleted()) continue;
                executionId = entry.getKey();
                workflowId = executionId.getWorkflowId().getWorkflowId();
                if (filterWorkflowId.isPresent() && !workflowId.equals(filterWorkflowId.get())) continue;
                history = entry.getValue().getHistory();
                info = new WorkflowExecutionInfo().setExecution(executionId.getExecution()).setHistoryLength(history.size()).setStartTime(history.get(0).getTimestamp()).setType(history.get(0).getWorkflowExecutionStartedEventAttributes().getWorkflowType());
                result.add(info);
                continue;
            }
            if (!entry.getValue().isCompleted()) continue;
            executionId = entry.getKey();
            workflowId = executionId.getWorkflowId().getWorkflowId();
            if (filterWorkflowId.isPresent() && !workflowId.equals(filterWorkflowId.get())) continue;
            history = entry.getValue().getHistory();
            info = new WorkflowExecutionInfo().setExecution(executionId.getExecution()).setHistoryLength(history.size()).setStartTime(history.get(0).getTimestamp()).setType(history.get(0).getWorkflowExecutionStartedEventAttributes().getWorkflowType()).setCloseStatus(WorkflowExecutionUtils.getCloseStatus(history.get(history.size() - 1)));
            result.add(info);
        }
        return result;
    }

    @Override
    public void close() {
        this.timerService.shutdown();
    }

    private static class HistoryStore {
        private final Lock lock;
        private final Condition newEventsCondition;
        private final ExecutionId id;
        private final List<HistoryEvent> history = new ArrayList<HistoryEvent>();
        private boolean completed;

        private HistoryStore(ExecutionId id, Lock lock) {
            this.id = id;
            this.lock = lock;
            this.newEventsCondition = lock.newCondition();
        }

        public boolean isCompleted() {
            return this.completed;
        }

        public List<HistoryEvent> getHistory() {
            return this.history;
        }

        private void checkNextEventId(long nextEventId) {
            if (nextEventId != (long)this.history.size() + 1L && nextEventId != 0L && this.history.size() != 0) {
                throw new IllegalStateException("NextEventId=" + nextEventId + ", historySize=" + this.history.size() + " for " + this.id);
            }
        }

        void addAllLocked(List<HistoryEvent> events, long timeInNanos) throws EntityNotExistsError {
            for (HistoryEvent event : events) {
                if (this.completed) {
                    throw new EntityNotExistsError("Attempt to add an event after a completion event: " + WorkflowExecutionUtils.prettyPrintHistoryEvent(event));
                }
                event.setEventId((long)this.history.size() + 1L);
                if (!event.isSetTimestamp()) {
                    event.setTimestamp(timeInNanos);
                }
                this.history.add(event);
                this.completed = this.completed || WorkflowExecutionUtils.isWorkflowExecutionCompletedEvent(event);
            }
            this.newEventsCondition.signal();
        }

        long getNextEventIdLocked() {
            return (long)this.history.size() + 1L;
        }

        List<HistoryEvent> getEventsLocked() {
            return this.history;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        List<HistoryEvent> waitForNewEvents(long expectedNextEventId, HistoryEventFilterType filterType) {
            block13: {
                this.lock.lock();
                while (true) {
                    if (this.completed || this.getNextEventIdLocked() > expectedNextEventId) {
                        if (filterType == HistoryEventFilterType.CLOSE_EVENT) {
                            if (this.completed) {
                                ArrayList<HistoryEvent> result = new ArrayList<HistoryEvent>(1);
                                result.add(this.history.get(this.history.size() - 1));
                                ArrayList<HistoryEvent> arrayList = result;
                                return arrayList;
                            }
                            expectedNextEventId = this.getNextEventIdLocked();
                            continue;
                        }
                        break block13;
                    }
                    try {
                        this.newEventsCondition.await();
                    }
                    catch (InterruptedException e) {
                        List<HistoryEvent> list = null;
                        this.lock.unlock();
                        return list;
                    }
                }
                finally {
                    this.lock.unlock();
                }
            }
            ArrayList<HistoryEvent> result = new ArrayList<HistoryEvent>((int)(this.getNextEventIdLocked() - expectedNextEventId));
            int i = (int)expectedNextEventId;
            while (true) {
                if ((long)i >= this.getNextEventIdLocked()) {
                    ArrayList<HistoryEvent> arrayList = result;
                    return arrayList;
                }
                result.add(this.history.get(i));
                ++i;
            }
        }
    }
}

