/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.sync;

import com.uber.cadence.internal.sync.DestroyWorkflowThreadError;
import com.uber.cadence.internal.sync.Status;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.function.Consumer;
import java.util.function.Supplier;

class WorkflowThreadContext {
    private final Lock lock;
    private final Condition yieldCondition;
    private final Condition runCondition;
    private final Condition evaluationCondition;
    private Status status = Status.CREATED;
    private Consumer<String> evaluationFunction;
    private Throwable unhandledException;
    private boolean inRunUntilBlocked;
    private boolean remainedBlocked;
    private String yieldReason;
    private boolean destroyRequested;

    WorkflowThreadContext(Lock lock) {
        this.lock = lock;
        this.yieldCondition = lock.newCondition();
        this.runCondition = lock.newCondition();
        this.evaluationCondition = lock.newCondition();
    }

    public void initialYield() {
        Status status = this.getStatus();
        if (status == Status.DONE) {
            throw new DestroyWorkflowThreadError("done in initialYield");
        }
        if (status != Status.RUNNING) {
            throw new IllegalStateException("not in RUNNING but in " + (Object)((Object)status) + " state");
        }
        this.yield("created", () -> true);
    }

    public void yield(String reason, Supplier<Boolean> unblockFunction) {
        if (unblockFunction == null) {
            throw new IllegalArgumentException("null unblockFunction");
        }
        this.lock.lock();
        try {
            while (!this.inRunUntilBlocked || !unblockFunction.get().booleanValue()) {
                if (this.destroyRequested) {
                    throw new DestroyWorkflowThreadError();
                }
                this.status = Status.YIELDED;
                this.runCondition.signal();
                this.yieldCondition.await();
                this.mayBeEvaluate(reason);
                this.yieldReason = reason;
            }
        }
        catch (InterruptedException e) {
            throw new Error("Unexpected interrupt", e);
        }
        finally {
            this.setStatus(Status.RUNNING);
            this.remainedBlocked = false;
            this.yieldReason = null;
            this.lock.unlock();
        }
    }

    private void mayBeEvaluate(String reason) {
        if (this.status == Status.EVALUATING) {
            try {
                this.evaluationFunction.accept(reason);
            }
            catch (Exception e) {
                this.evaluationFunction.accept(e.toString());
            }
            finally {
                this.status = Status.YIELDED;
                this.evaluationCondition.signal();
            }
        }
    }

    public void evaluateInCoroutineContext(Consumer<String> function) {
        this.lock.lock();
        try {
            if (function == null) {
                throw new IllegalArgumentException("null function");
            }
            if (this.status != Status.YIELDED && this.status != Status.RUNNING) {
                throw new IllegalStateException("Not in yielded status: " + (Object)((Object)this.status));
            }
            if (this.evaluationFunction != null) {
                throw new IllegalStateException("Already evaluating");
            }
            if (this.inRunUntilBlocked) {
                throw new IllegalStateException("Running runUntilBlocked");
            }
            this.evaluationFunction = function;
            this.status = Status.EVALUATING;
            this.yieldCondition.signal();
            while (this.status == Status.EVALUATING) {
                this.evaluationCondition.await();
            }
        }
        catch (InterruptedException e) {
            throw new Error("Unexpected interrupt", e);
        }
        finally {
            this.evaluationFunction = null;
            this.lock.unlock();
        }
    }

    public Status getStatus() {
        this.lock.lock();
        try {
            Status status = this.status;
            return status;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setStatus(Status status) {
        this.lock.lock();
        try {
            this.status = status;
            if (this.isDone()) {
                this.runCondition.signal();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isDone() {
        this.lock.lock();
        try {
            boolean bl = this.status == Status.DONE;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Throwable getUnhandledException() {
        this.lock.lock();
        try {
            Throwable throwable = this.unhandledException;
            return throwable;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setUnhandledException(Throwable unhandledException) {
        this.lock.lock();
        try {
            this.unhandledException = unhandledException;
        }
        finally {
            this.lock.unlock();
        }
    }

    public String getYieldReason() {
        return this.yieldReason;
    }

    public boolean runUntilBlocked() {
        this.lock.lock();
        try {
            if (this.status == Status.DONE) {
                boolean bl = false;
                return bl;
            }
            if (this.evaluationFunction != null) {
                throw new IllegalStateException("Cannot runUntilBlocked while evaluating");
            }
            this.inRunUntilBlocked = true;
            if (this.status != Status.CREATED) {
                this.status = Status.RUNNING;
            }
            this.remainedBlocked = true;
            this.yieldCondition.signal();
            while (this.status == Status.RUNNING || this.status == Status.CREATED) {
                this.runCondition.await();
                if (this.evaluationFunction == null) continue;
                throw new IllegalStateException("Cannot runUntilBlocked while evaluating");
            }
            boolean bl = !this.remainedBlocked;
            return bl;
        }
        catch (InterruptedException e) {
            throw new Error("Unexpected interrupt", e);
        }
        finally {
            this.inRunUntilBlocked = false;
            this.lock.unlock();
        }
    }

    public boolean isDestroyRequested() {
        this.lock.lock();
        try {
            boolean bl = this.destroyRequested;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void destroy() {
        this.lock.lock();
        try {
            this.destroyRequested = true;
            if (this.status == Status.CREATED || this.status == Status.RUNNING || this.status == Status.DONE) {
                this.status = Status.DONE;
                return;
            }
        }
        finally {
            this.lock.unlock();
        }
        this.evaluateInCoroutineContext(r -> {
            throw new DestroyWorkflowThreadError();
        });
        this.runUntilBlocked();
    }

    public void exit() {
        this.lock.lock();
        try {
            this.destroyRequested = true;
        }
        finally {
            this.lock.unlock();
        }
        throw new DestroyWorkflowThreadError();
    }
}

