/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.sync;

import com.uber.cadence.PollForDecisionTaskResponse;
import com.uber.cadence.WorkflowExecution;
import com.uber.cadence.common.WorkflowExecutionHistory;
import com.uber.cadence.converter.DataConverter;
import com.uber.cadence.internal.common.InternalUtils;
import com.uber.cadence.internal.replay.DeciderCache;
import com.uber.cadence.internal.replay.ReplayDecisionTaskHandler;
import com.uber.cadence.internal.sync.POJOActivityTaskHandler;
import com.uber.cadence.internal.sync.POJOWorkflowImplementationFactory;
import com.uber.cadence.internal.worker.LocalActivityWorker;
import com.uber.cadence.internal.worker.SingleWorkerOptions;
import com.uber.cadence.internal.worker.SuspendableWorker;
import com.uber.cadence.internal.worker.WorkflowWorker;
import com.uber.cadence.serviceclient.IWorkflowService;
import com.uber.cadence.worker.WorkflowImplementationOptions;
import com.uber.cadence.workflow.Functions;
import com.uber.cadence.workflow.WorkflowInterceptor;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;

public class SyncWorkflowWorker
implements SuspendableWorker,
Consumer<PollForDecisionTaskResponse> {
    private final WorkflowWorker workflowWorker;
    private final LocalActivityWorker laWorker;
    private final POJOWorkflowImplementationFactory factory;
    private final DataConverter dataConverter;
    private final POJOActivityTaskHandler laTaskHandler;
    private final ScheduledExecutorService heartbeatExecutor = Executors.newScheduledThreadPool(4);

    public SyncWorkflowWorker(IWorkflowService service, String domain, String taskList, Function<WorkflowInterceptor, WorkflowInterceptor> interceptorFactory, SingleWorkerOptions workflowOptions, SingleWorkerOptions localActivityOptions, DeciderCache cache, String stickyTaskListName, Duration stickyDecisionScheduleToStartTimeout, ThreadPoolExecutor workflowThreadPool) {
        Objects.requireNonNull(workflowThreadPool);
        this.dataConverter = workflowOptions.getDataConverter();
        this.factory = new POJOWorkflowImplementationFactory(workflowOptions.getDataConverter(), workflowThreadPool, interceptorFactory, cache);
        this.laTaskHandler = new POJOActivityTaskHandler(service, domain, localActivityOptions.getDataConverter(), this.heartbeatExecutor);
        this.laWorker = new LocalActivityWorker(domain, taskList, localActivityOptions, this.laTaskHandler);
        ReplayDecisionTaskHandler taskHandler = new ReplayDecisionTaskHandler(domain, this.factory, cache, workflowOptions, stickyTaskListName, stickyDecisionScheduleToStartTimeout, service, this.laWorker.getLocalActivityTaskPoller());
        this.workflowWorker = new WorkflowWorker(service, domain, taskList, workflowOptions, taskHandler, stickyTaskListName);
    }

    public void setWorkflowImplementationTypes(WorkflowImplementationOptions options, Class<?>[] workflowImplementationTypes) {
        this.factory.setWorkflowImplementationTypes(options, workflowImplementationTypes);
    }

    public <R> void addWorkflowImplementationFactory(WorkflowImplementationOptions options, Class<R> clazz, Functions.Func<R> factory) {
        this.factory.addWorkflowImplementationFactory(options, clazz, factory);
    }

    public <R> void addWorkflowImplementationFactory(Class<R> clazz, Functions.Func<R> factory) {
        this.factory.addWorkflowImplementationFactory(clazz, factory);
    }

    public void setLocalActivitiesImplementation(Object ... activitiesImplementation) {
        this.laTaskHandler.setLocalActivitiesImplementation(activitiesImplementation);
    }

    @Override
    public void start() {
        this.workflowWorker.start();
        this.laWorker.start();
    }

    @Override
    public boolean isStarted() {
        return this.workflowWorker.isStarted() && this.laWorker.isStarted();
    }

    @Override
    public boolean isShutdown() {
        return this.workflowWorker.isShutdown() && this.laWorker.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.workflowWorker.isTerminated() && this.laWorker.isTerminated();
    }

    @Override
    public void shutdown() {
        this.laWorker.shutdown();
        this.workflowWorker.shutdown();
    }

    @Override
    public void shutdownNow() {
        this.laWorker.shutdownNow();
        this.workflowWorker.shutdownNow();
    }

    @Override
    public void awaitTermination(long timeout, TimeUnit unit) {
        long timeoutMillis = InternalUtils.awaitTermination(this.laWorker, unit.toMillis(timeout));
        InternalUtils.awaitTermination(this.workflowWorker, timeoutMillis);
    }

    @Override
    public void suspendPolling() {
        this.workflowWorker.suspendPolling();
        this.laWorker.suspendPolling();
    }

    @Override
    public void resumePolling() {
        this.workflowWorker.resumePolling();
        this.laWorker.resumePolling();
    }

    @Override
    public boolean isSuspended() {
        return this.workflowWorker.isSuspended() && this.laWorker.isSuspended();
    }

    public <R> R queryWorkflowExecution(WorkflowExecution execution, String queryType, Class<R> resultClass, Type resultType, Object[] args) throws Exception {
        byte[] serializedArgs = this.dataConverter.toData(args);
        byte[] result = this.workflowWorker.queryWorkflowExecution(execution, queryType, serializedArgs);
        return this.dataConverter.fromData(result, resultClass, resultType);
    }

    public <R> R queryWorkflowExecution(WorkflowExecutionHistory history, String queryType, Class<R> resultClass, Type resultType, Object[] args) throws Exception {
        byte[] serializedArgs = this.dataConverter.toData(args);
        byte[] result = this.workflowWorker.queryWorkflowExecution(history, queryType, serializedArgs);
        return this.dataConverter.fromData(result, resultClass, resultType);
    }

    @Override
    public void accept(PollForDecisionTaskResponse pollForDecisionTaskResponse) {
        this.workflowWorker.accept(pollForDecisionTaskResponse);
    }
}

