/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.sync;

import com.uber.cadence.ActivityType;
import com.uber.cadence.SearchAttributes;
import com.uber.cadence.WorkflowExecution;
import com.uber.cadence.WorkflowType;
import com.uber.cadence.activity.ActivityOptions;
import com.uber.cadence.activity.LocalActivityOptions;
import com.uber.cadence.common.RetryOptions;
import com.uber.cadence.converter.DataConverter;
import com.uber.cadence.internal.common.InternalUtils;
import com.uber.cadence.internal.common.OptionsUtils;
import com.uber.cadence.internal.common.RetryParameters;
import com.uber.cadence.internal.replay.ActivityTaskFailedException;
import com.uber.cadence.internal.replay.ActivityTaskTimeoutException;
import com.uber.cadence.internal.replay.ChildWorkflowTaskFailedException;
import com.uber.cadence.internal.replay.ContinueAsNewWorkflowExecutionParameters;
import com.uber.cadence.internal.replay.DecisionContext;
import com.uber.cadence.internal.replay.ExecuteActivityParameters;
import com.uber.cadence.internal.replay.ExecuteLocalActivityParameters;
import com.uber.cadence.internal.replay.SignalExternalWorkflowParameters;
import com.uber.cadence.internal.replay.StartChildWorkflowExecutionParameters;
import com.uber.cadence.internal.sync.DeterministicRunner;
import com.uber.cadence.internal.sync.SimulatedTimeoutExceptionInternal;
import com.uber.cadence.internal.sync.WorkflowInternal;
import com.uber.cadence.internal.sync.WorkflowRetryerInternal;
import com.uber.cadence.internal.sync.WorkflowThread;
import com.uber.cadence.internal.sync.WorkflowTimers;
import com.uber.cadence.workflow.ActivityException;
import com.uber.cadence.workflow.ActivityFailureException;
import com.uber.cadence.workflow.ActivityTimeoutException;
import com.uber.cadence.workflow.CancellationScope;
import com.uber.cadence.workflow.ChildWorkflowException;
import com.uber.cadence.workflow.ChildWorkflowFailureException;
import com.uber.cadence.workflow.ChildWorkflowOptions;
import com.uber.cadence.workflow.ChildWorkflowTimedOutException;
import com.uber.cadence.workflow.CompletablePromise;
import com.uber.cadence.workflow.ContinueAsNewOptions;
import com.uber.cadence.workflow.Functions;
import com.uber.cadence.workflow.Promise;
import com.uber.cadence.workflow.SignalExternalWorkflowException;
import com.uber.cadence.workflow.Workflow;
import com.uber.cadence.workflow.WorkflowInterceptor;
import com.uber.m3.tally.Scope;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SyncDecisionContext
implements WorkflowInterceptor {
    private static final Logger log = LoggerFactory.getLogger(SyncDecisionContext.class);
    private final DecisionContext context;
    private DeterministicRunner runner;
    private final DataConverter converter;
    private final WorkflowInterceptor headInterceptor;
    private final WorkflowTimers timers = new WorkflowTimers();
    private final Map<String, Functions.Func1<byte[], byte[]>> queryCallbacks = new HashMap<String, Functions.Func1<byte[], byte[]>>();
    private final byte[] lastCompletionResult;

    public SyncDecisionContext(DecisionContext context, DataConverter converter, Function<WorkflowInterceptor, WorkflowInterceptor> interceptorFactory, byte[] lastCompletionResult) {
        this.context = context;
        this.converter = converter;
        WorkflowInterceptor interceptor = interceptorFactory.apply(this);
        if (interceptor == null) {
            log.warn("WorkflowInterceptor factory returned null interceptor");
            interceptor = this;
        }
        this.headInterceptor = interceptor;
        this.lastCompletionResult = lastCompletionResult;
    }

    public void setRunner(DeterministicRunner runner) {
        this.runner = runner;
    }

    public DeterministicRunner getRunner() {
        return this.runner;
    }

    public WorkflowInterceptor getWorkflowInterceptor() {
        return this.headInterceptor;
    }

    public <T> Promise<T> executeActivity(String activityName, Class<T> resultClass, Type resultType, Object[] args, ActivityOptions options) {
        RetryOptions retryOptions = options.getRetryOptions();
        if (retryOptions != null && !this.context.isServerSideActivityRetry()) {
            return WorkflowRetryerInternal.retryAsync(retryOptions, () -> this.executeActivityOnce(activityName, options, args, resultClass, resultType));
        }
        return this.executeActivityOnce(activityName, options, args, resultClass, resultType);
    }

    private <T> Promise<T> executeActivityOnce(String name, ActivityOptions options, Object[] args, Class<T> returnClass, Type returnType) {
        byte[] input = this.converter.toData(args);
        Promise<byte[]> binaryResult = this.executeActivityOnce(name, options, input);
        if (returnClass == Void.TYPE) {
            return binaryResult.thenApply(r -> null);
        }
        return binaryResult.thenApply(r -> this.converter.fromData((byte[])r, returnClass, returnType));
    }

    private Promise<byte[]> executeActivityOnce(String name, ActivityOptions options, byte[] input) {
        ActivityCallback callback = new ActivityCallback();
        ExecuteActivityParameters params = this.constructExecuteActivityParameters(name, options, input);
        Consumer<Exception> cancellationCallback = this.context.scheduleActivityTask(params, callback::invoke);
        CancellationScope.current().getCancellationRequest().thenApply(reason -> {
            cancellationCallback.accept(new CancellationException((String)reason));
            return null;
        });
        return callback.result;
    }

    private RuntimeException mapActivityException(Exception failure) {
        if (failure == null) {
            return null;
        }
        if (failure instanceof CancellationException) {
            return (CancellationException)failure;
        }
        if (failure instanceof ActivityTaskFailedException) {
            Exception cause;
            ActivityTaskFailedException taskFailed = (ActivityTaskFailedException)failure;
            String causeClassName = taskFailed.getReason();
            try {
                Class<?> cc;
                Class<?> causeClass = cc = Class.forName(causeClassName);
                cause = (Exception)this.getDataConverter().fromData(taskFailed.getDetails(), causeClass, causeClass);
            }
            catch (Exception e) {
                cause = e;
            }
            if (cause instanceof SimulatedTimeoutExceptionInternal) {
                SimulatedTimeoutExceptionInternal testTimeout = (SimulatedTimeoutExceptionInternal)cause;
                return new ActivityTimeoutException(taskFailed.getEventId(), taskFailed.getActivityType(), taskFailed.getActivityId(), testTimeout.getTimeoutType(), testTimeout.getDetails(), this.getDataConverter());
            }
            return new ActivityFailureException(taskFailed.getEventId(), taskFailed.getActivityType(), taskFailed.getActivityId(), cause);
        }
        if (failure instanceof ActivityTaskTimeoutException) {
            ActivityTaskTimeoutException timedOut = (ActivityTaskTimeoutException)failure;
            return new ActivityTimeoutException(timedOut.getEventId(), timedOut.getActivityType(), timedOut.getActivityId(), timedOut.getTimeoutType(), timedOut.getDetails(), this.getDataConverter());
        }
        if (failure instanceof ActivityException) {
            return (ActivityException)failure;
        }
        throw new IllegalArgumentException("Unexpected exception type: " + failure.getClass().getName(), failure);
    }

    @Override
    public <R> Promise<R> executeLocalActivity(String activityName, Class<R> resultClass, Type resultType, Object[] args, LocalActivityOptions options) {
        if (options.getRetryOptions() != null) {
            options.getRetryOptions().validate();
        }
        long startTime = WorkflowInternal.currentTimeMillis();
        return WorkflowRetryerInternal.retryAsync((attempt, currentStart) -> this.executeLocalActivityOnce(activityName, options, args, resultClass, resultType, currentStart - startTime, (int)attempt), 1, startTime);
    }

    private <T> Promise<T> executeLocalActivityOnce(String name, LocalActivityOptions options, Object[] args, Class<T> returnClass, Type returnType, long elapsed, int attempt) {
        byte[] input = this.converter.toData(args);
        Promise<byte[]> binaryResult = this.executeLocalActivityOnce(name, options, input, elapsed, attempt);
        if (returnClass == Void.TYPE) {
            return binaryResult.thenApply(r -> null);
        }
        return binaryResult.thenApply(r -> this.converter.fromData((byte[])r, returnClass, returnType));
    }

    private Promise<byte[]> executeLocalActivityOnce(String name, LocalActivityOptions options, byte[] input, long elapsed, int attempt) {
        ActivityCallback callback = new ActivityCallback();
        ExecuteLocalActivityParameters params = this.constructExecuteLocalActivityParameters(name, options, input, elapsed, attempt);
        Consumer<Exception> cancellationCallback = this.context.scheduleLocalActivityTask(params, callback::invoke);
        CancellationScope.current().getCancellationRequest().thenApply(reason -> {
            cancellationCallback.accept(new CancellationException((String)reason));
            return null;
        });
        return callback.result;
    }

    private ExecuteActivityParameters constructExecuteActivityParameters(String name, ActivityOptions options, byte[] input) {
        ExecuteActivityParameters parameters = new ExecuteActivityParameters();
        String taskList = options.getTaskList();
        if (taskList == null) {
            taskList = this.context.getTaskList();
        }
        parameters.withActivityType(new ActivityType().setName(name)).withInput(input).withTaskList(taskList).withScheduleToStartTimeoutSeconds(options.getScheduleToStartTimeout().getSeconds()).withStartToCloseTimeoutSeconds(options.getStartToCloseTimeout().getSeconds()).withScheduleToCloseTimeoutSeconds(options.getScheduleToCloseTimeout().getSeconds()).setHeartbeatTimeoutSeconds(options.getHeartbeatTimeout().getSeconds());
        RetryOptions retryOptions = options.getRetryOptions();
        if (retryOptions != null) {
            parameters.setRetryParameters(new RetryParameters(retryOptions));
        }
        return parameters;
    }

    private ExecuteLocalActivityParameters constructExecuteLocalActivityParameters(String name, LocalActivityOptions options, byte[] input, long elapsed, int attempt) {
        ExecuteLocalActivityParameters parameters = new ExecuteLocalActivityParameters();
        parameters.withActivityType(new ActivityType().setName(name)).withInput(input).withScheduleToCloseTimeoutSeconds(options.getScheduleToCloseTimeout().getSeconds());
        RetryOptions retryOptions = options.getRetryOptions();
        if (retryOptions != null) {
            parameters.setRetryOptions(retryOptions);
        }
        parameters.setAttempt(attempt);
        parameters.setElapsedTime(elapsed);
        return parameters;
    }

    @Override
    public <R> WorkflowInterceptor.WorkflowResult<R> executeChildWorkflow(String workflowType, Class<R> returnClass, Type returnType, Object[] args, ChildWorkflowOptions options) {
        byte[] input = this.converter.toData(args);
        CompletablePromise<WorkflowExecution> execution = Workflow.newPromise();
        Promise<byte[]> output = this.executeChildWorkflow(workflowType, options, input, execution);
        Promise<Object> result = output.thenApply(b -> this.converter.fromData((byte[])b, returnClass, returnType));
        return new WorkflowInterceptor.WorkflowResult<Object>(result, execution);
    }

    private Promise<byte[]> executeChildWorkflow(String name, ChildWorkflowOptions options, byte[] input, CompletablePromise<WorkflowExecution> executionResult) {
        RetryOptions retryOptions = options.getRetryOptions();
        if (retryOptions != null && !this.context.isServerSideChildWorkflowRetry()) {
            ChildWorkflowOptions o1 = new ChildWorkflowOptions.Builder().setTaskList(options.getTaskList()).setExecutionStartToCloseTimeout(options.getExecutionStartToCloseTimeout()).setTaskStartToCloseTimeout(options.getTaskStartToCloseTimeout()).setWorkflowId(options.getWorkflowId()).setWorkflowIdReusePolicy(options.getWorkflowIdReusePolicy()).setChildPolicy(options.getChildPolicy()).build();
            return WorkflowRetryerInternal.retryAsync(retryOptions, () -> this.executeChildWorkflowOnce(name, o1, input, executionResult));
        }
        return this.executeChildWorkflowOnce(name, options, input, executionResult);
    }

    private Promise<byte[]> executeChildWorkflowOnce(String name, ChildWorkflowOptions options, byte[] input, CompletablePromise<WorkflowExecution> executionResult) {
        RetryParameters retryParameters = null;
        RetryOptions retryOptions = options.getRetryOptions();
        if (retryOptions != null) {
            retryParameters = new RetryParameters(retryOptions);
        }
        StartChildWorkflowExecutionParameters parameters = new StartChildWorkflowExecutionParameters.Builder().setWorkflowType(new WorkflowType().setName(name)).setWorkflowId(options.getWorkflowId()).setInput(input).setChildPolicy(options.getChildPolicy()).setExecutionStartToCloseTimeoutSeconds(options.getExecutionStartToCloseTimeout().getSeconds()).setDomain(options.getDomain()).setTaskList(options.getTaskList()).setTaskStartToCloseTimeoutSeconds(options.getTaskStartToCloseTimeout().getSeconds()).setWorkflowIdReusePolicy(options.getWorkflowIdReusePolicy()).setRetryParameters(retryParameters).setCronSchedule(options.getCronSchedule()).build();
        CompletablePromise<byte[]> result = Workflow.newPromise();
        Consumer<Exception> cancellationCallback = this.context.startChildWorkflow(parameters, executionResult::complete, (output, failure) -> {
            if (failure != null) {
                this.runner.executeInWorkflowThread("child workflow failure callback", () -> result.completeExceptionally(this.mapChildWorkflowException((Exception)failure)));
            } else {
                this.runner.executeInWorkflowThread("child workflow completion callback", () -> result.complete((byte[])output));
            }
        });
        CancellationScope.current().getCancellationRequest().thenApply(reason -> {
            cancellationCallback.accept(new CancellationException((String)reason));
            return null;
        });
        return result;
    }

    private RuntimeException mapChildWorkflowException(Exception failure) {
        Exception cause;
        if (failure == null) {
            return null;
        }
        if (failure instanceof CancellationException) {
            return (CancellationException)failure;
        }
        if (failure instanceof ChildWorkflowException) {
            return (ChildWorkflowException)failure;
        }
        if (!(failure instanceof ChildWorkflowTaskFailedException)) {
            return new IllegalArgumentException("Unexpected exception type: ", failure);
        }
        ChildWorkflowTaskFailedException taskFailed = (ChildWorkflowTaskFailedException)failure;
        String causeClassName = taskFailed.getReason();
        try {
            Class<?> causeClass = Class.forName(causeClassName);
            cause = (Exception)this.getDataConverter().fromData(taskFailed.getDetails(), causeClass, causeClass);
        }
        catch (Exception e) {
            cause = e;
        }
        if (cause instanceof SimulatedTimeoutExceptionInternal) {
            return new ChildWorkflowTimedOutException(taskFailed.getEventId(), taskFailed.getWorkflowExecution(), taskFailed.getWorkflowType());
        }
        return new ChildWorkflowFailureException(taskFailed.getEventId(), taskFailed.getWorkflowExecution(), taskFailed.getWorkflowType(), cause);
    }

    @Override
    public Promise<Void> newTimer(Duration delay) {
        Objects.requireNonNull(delay);
        long delaySeconds = OptionsUtils.roundUpToSeconds(delay).getSeconds();
        if (delaySeconds < 0L) {
            throw new IllegalArgumentException("negative delay");
        }
        if (delaySeconds == 0L) {
            return Workflow.newPromise(null);
        }
        CompletablePromise<Void> timer = Workflow.newPromise();
        long fireTime = this.context.currentTimeMillis() + TimeUnit.SECONDS.toMillis(delaySeconds);
        this.timers.addTimer(fireTime, timer);
        CancellationScope.current().getCancellationRequest().thenApply(reason -> {
            this.timers.removeTimer(fireTime, timer);
            timer.completeExceptionally(new CancellationException((String)reason));
            return null;
        });
        return timer;
    }

    @Override
    public <R> R sideEffect(Class<R> resultClass, Type resultType, Functions.Func<R> func) {
        DataConverter dataConverter = this.getDataConverter();
        byte[] result = this.context.sideEffect(() -> {
            Object r = func.apply();
            return dataConverter.toData(r);
        });
        return dataConverter.fromData(result, resultClass, resultType);
    }

    @Override
    public <R> R mutableSideEffect(String id, Class<R> resultClass, Type resultType, BiPredicate<R, R> updated, Functions.Func<R> func) {
        AtomicReference unserializedResult = new AtomicReference();
        Optional<byte[]> optionalBytes = this.context.mutableSideEffect(id, this.converter, storedBinary -> {
            Optional<Object> stored = storedBinary.map(b -> this.converter.fromData((byte[])b, resultClass, resultType));
            Object funcResult = Objects.requireNonNull(func.apply(), "mutableSideEffect function returned null");
            if (!stored.isPresent() || updated.test(stored.get(), funcResult)) {
                unserializedResult.set(funcResult);
                return Optional.of(this.converter.toData(funcResult));
            }
            return Optional.empty();
        });
        if (!optionalBytes.isPresent()) {
            throw new IllegalArgumentException("No value found for mutableSideEffectId=" + id + ", during replay it usually indicates a different workflow runId than the original one");
        }
        byte[] binaryResult = optionalBytes.get();
        Object unserialized = unserializedResult.get();
        if (unserialized != null) {
            return (R)unserialized;
        }
        return this.converter.fromData(binaryResult, resultClass, resultType);
    }

    @Override
    public int getVersion(String changeID, int minSupported, int maxSupported) {
        return this.context.getVersion(changeID, this.converter, minSupported, maxSupported);
    }

    void fireTimers() {
        this.timers.fireTimers(this.context.currentTimeMillis());
    }

    boolean hasTimersToFire() {
        return this.timers.hasTimersToFire(this.context.currentTimeMillis());
    }

    long getNextFireTime() {
        return this.timers.getNextFireTime();
    }

    public byte[] query(String type, byte[] args) {
        Functions.Func1<byte[], byte[]> callback = this.queryCallbacks.get(type);
        if (callback == null) {
            throw new IllegalArgumentException("Unknown query type: " + type + ", knownTypes=" + this.queryCallbacks.keySet());
        }
        return callback.apply(args);
    }

    @Override
    public void registerQuery(String queryType, Type[] argTypes, Functions.Func1<Object[], Object> callback) {
        this.queryCallbacks.put(queryType, input -> {
            Object[] args = this.converter.fromDataArray((byte[])input, argTypes);
            Object result = callback.apply(args);
            return this.converter.toData(result);
        });
    }

    @Override
    public UUID randomUUID() {
        return this.context.randomUUID();
    }

    @Override
    public Random newRandom() {
        return this.context.newRandom();
    }

    public DataConverter getDataConverter() {
        return this.converter;
    }

    boolean isReplaying() {
        return this.context.isReplaying();
    }

    public DecisionContext getContext() {
        return this.context;
    }

    @Override
    public Promise<Void> signalExternalWorkflow(WorkflowExecution execution, String signalName, Object[] args) {
        SignalExternalWorkflowParameters parameters = new SignalExternalWorkflowParameters();
        parameters.setSignalName(signalName);
        parameters.setWorkflowId(execution.getWorkflowId());
        parameters.setRunId(execution.getRunId());
        byte[] input = this.getDataConverter().toData(args);
        parameters.setInput(input);
        CompletablePromise<Void> result = Workflow.newPromise();
        Consumer<Exception> cancellationCallback = this.context.signalWorkflowExecution(parameters, (output, failure) -> {
            if (failure != null) {
                this.runner.executeInWorkflowThread("child workflow failure callback", () -> result.completeExceptionally(this.mapSignalWorkflowException((Exception)failure)));
            } else {
                this.runner.executeInWorkflowThread("child workflow completion callback", () -> result.complete((Void)output));
            }
        });
        CancellationScope.current().getCancellationRequest().thenApply(reason -> {
            cancellationCallback.accept(new CancellationException((String)reason));
            return null;
        });
        return result;
    }

    @Override
    public void sleep(Duration duration) {
        WorkflowThread.await(duration.toMillis(), "sleep", () -> {
            CancellationScope.throwCancelled();
            return false;
        });
    }

    @Override
    public boolean await(Duration timeout, String reason, Supplier<Boolean> unblockCondition) {
        return WorkflowThread.await(timeout.toMillis(), reason, unblockCondition);
    }

    @Override
    public void await(String reason, Supplier<Boolean> unblockCondition) {
        WorkflowThread.await(reason, unblockCondition);
    }

    @Override
    public void continueAsNew(Optional<String> workflowType, Optional<ContinueAsNewOptions> options, Object[] args) {
        ContinueAsNewWorkflowExecutionParameters parameters = new ContinueAsNewWorkflowExecutionParameters();
        if (workflowType.isPresent()) {
            parameters.setWorkflowType(workflowType.get());
        }
        if (options.isPresent()) {
            ContinueAsNewOptions ops = options.get();
            parameters.setExecutionStartToCloseTimeoutSeconds((int)ops.getExecutionStartToCloseTimeout().getSeconds());
            parameters.setTaskStartToCloseTimeoutSeconds((int)ops.getTaskStartToCloseTimeout().getSeconds());
            parameters.setTaskList(ops.getTaskList());
        }
        parameters.setInput(this.getDataConverter().toData(args));
        this.context.continueAsNewOnCompletion(parameters);
        WorkflowThread.exit(null);
    }

    @Override
    public Promise<Void> cancelWorkflow(WorkflowExecution execution) {
        return this.context.requestCancelWorkflowExecution(execution);
    }

    private RuntimeException mapSignalWorkflowException(Exception failure) {
        if (failure == null) {
            return null;
        }
        if (failure instanceof CancellationException) {
            return (CancellationException)failure;
        }
        if (!(failure instanceof SignalExternalWorkflowException)) {
            return new IllegalArgumentException("Unexpected exception type: ", failure);
        }
        return (SignalExternalWorkflowException)failure;
    }

    public Scope getMetricsScope() {
        return this.context.getMetricsScope();
    }

    public boolean isLoggingEnabledInReplay() {
        return this.context.getEnableLoggingInReplay();
    }

    public <R> R getLastCompletionResult(Class<R> resultClass, Type resultType) {
        if (this.lastCompletionResult == null || this.lastCompletionResult.length == 0) {
            return null;
        }
        DataConverter dataConverter = this.getDataConverter();
        return dataConverter.fromData(this.lastCompletionResult, resultClass, resultType);
    }

    @Override
    public void upsertSearchAttributes(Map<String, Object> searchAttributes) {
        if (searchAttributes.isEmpty()) {
            throw new IllegalArgumentException("Empty search attributes");
        }
        SearchAttributes attr = InternalUtils.convertMapToSearchAttributes(searchAttributes);
        this.context.upsertSearchAttributes(attr);
    }

    private class ActivityCallback {
        private CompletablePromise<byte[]> result = Workflow.newPromise();

        private ActivityCallback() {
        }

        public void invoke(byte[] output, Exception failure) {
            if (failure != null) {
                SyncDecisionContext.this.runner.executeInWorkflowThread("activity failure callback", () -> this.result.completeExceptionally(SyncDecisionContext.this.mapActivityException(failure)));
            } else {
                SyncDecisionContext.this.runner.executeInWorkflowThread("activity completion callback", () -> this.result.complete(output));
            }
        }
    }
}

