/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.sync;

import com.uber.cadence.ChildPolicy;
import com.uber.cadence.SearchAttributes;
import com.uber.cadence.WorkflowExecution;
import com.uber.cadence.WorkflowType;
import com.uber.cadence.converter.DataConverter;
import com.uber.cadence.converter.JsonDataConverter;
import com.uber.cadence.internal.common.CheckedExceptionWrapper;
import com.uber.cadence.internal.metrics.NoopScope;
import com.uber.cadence.internal.replay.ContinueAsNewWorkflowExecutionParameters;
import com.uber.cadence.internal.replay.DeciderCache;
import com.uber.cadence.internal.replay.DecisionContext;
import com.uber.cadence.internal.replay.ExecuteActivityParameters;
import com.uber.cadence.internal.replay.ExecuteLocalActivityParameters;
import com.uber.cadence.internal.replay.SignalExternalWorkflowParameters;
import com.uber.cadence.internal.replay.StartChildWorkflowExecutionParameters;
import com.uber.cadence.internal.sync.CancellationScopeImpl;
import com.uber.cadence.internal.sync.DeterministicRunner;
import com.uber.cadence.internal.sync.RunnerLocalInternal;
import com.uber.cadence.internal.sync.SyncDecisionContext;
import com.uber.cadence.internal.sync.WorkflowThread;
import com.uber.cadence.internal.sync.WorkflowThreadImpl;
import com.uber.cadence.workflow.Functions;
import com.uber.cadence.workflow.Promise;
import com.uber.m3.tally.Scope;
import java.time.Duration;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DeterministicRunnerImpl
implements DeterministicRunner {
    private static final Logger log = LoggerFactory.getLogger(DeterministicRunnerImpl.class);
    static final String WORKFLOW_ROOT_THREAD_NAME = "workflow-root";
    private static final ThreadLocal<WorkflowThread> currentThreadThreadLocal = new ThreadLocal();
    private final Lock lock = new ReentrantLock();
    private final ExecutorService threadPool;
    private final SyncDecisionContext decisionContext;
    private final Deque<WorkflowThread> threads = new ArrayDeque<WorkflowThread>();
    private final Map<RunnerLocalInternal<?>, Object> runnerLocalMap = new HashMap();
    private final List<WorkflowThread> threadsToAdd = Collections.synchronizedList(new ArrayList());
    private final List<NamedRunnable> toExecuteInWorkflowThread = new ArrayList<NamedRunnable>();
    private final Supplier<Long> clock;
    private DeciderCache cache;
    private boolean inRunUntilAllBlocked;
    private boolean closeRequested;
    private boolean closed;
    private long nextWakeUpTime;
    private Set<Promise> failedPromises = new HashSet<Promise>();
    private boolean exitRequested;
    private Object exitValue;
    private WorkflowThread rootWorkflowThread;
    private final CancellationScopeImpl runnerCancellationScope;

    static WorkflowThread currentThreadInternal() {
        WorkflowThread result = currentThreadThreadLocal.get();
        if (result == null) {
            throw new Error("Called from non workflow or workflow callback thread");
        }
        return result;
    }

    static void setCurrentThreadInternal(WorkflowThread coroutine) {
        currentThreadThreadLocal.set(coroutine);
    }

    DeterministicRunnerImpl(Runnable root) {
        this(System::currentTimeMillis, root);
    }

    DeterministicRunnerImpl(Supplier<Long> clock, Runnable root) {
        this(DeterministicRunnerImpl.getDefaultThreadPool(), DeterministicRunnerImpl.newDummySyncDecisionContext(), clock, root, null);
    }

    private static ThreadPoolExecutor getDefaultThreadPool() {
        ThreadPoolExecutor result = new ThreadPoolExecutor(0, 1000, 1L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
        result.setThreadFactory(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "deterministic runner thread");
            }
        });
        return result;
    }

    DeterministicRunnerImpl(ExecutorService threadPool, SyncDecisionContext decisionContext, Supplier<Long> clock, Runnable root) {
        this(threadPool, decisionContext, clock, root, null);
    }

    DeterministicRunnerImpl(ExecutorService threadPool, SyncDecisionContext decisionContext, Supplier<Long> clock, Runnable root, DeciderCache cache) {
        this.threadPool = threadPool;
        this.decisionContext = decisionContext != null ? decisionContext : DeterministicRunnerImpl.newDummySyncDecisionContext();
        this.clock = clock;
        this.cache = cache;
        this.runnerCancellationScope = new CancellationScopeImpl(true, null, null);
        this.rootWorkflowThread = new WorkflowThreadImpl(true, threadPool, this, WORKFLOW_ROOT_THREAD_NAME, false, this.runnerCancellationScope, root, cache);
        this.threads.addLast(this.rootWorkflowThread);
        this.rootWorkflowThread.start();
    }

    private static SyncDecisionContext newDummySyncDecisionContext() {
        return new SyncDecisionContext(new DummyDecisionContext(), JsonDataConverter.getInstance(), next -> next, null);
    }

    SyncDecisionContext getDecisionContext() {
        return this.decisionContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runUntilAllBlocked() throws Throwable {
        this.lock.lock();
        try {
            boolean progress;
            this.checkClosed();
            this.inRunUntilAllBlocked = true;
            Throwable unhandledException = null;
            block3: do {
                this.threadsToAdd.clear();
                if (!this.toExecuteInWorkflowThread.isEmpty()) {
                    ArrayList<WorkflowThreadImpl> callbackThreads = new ArrayList<WorkflowThreadImpl>(this.toExecuteInWorkflowThread.size());
                    for (NamedRunnable nr : this.toExecuteInWorkflowThread) {
                        WorkflowThreadImpl thread = new WorkflowThreadImpl(false, this.threadPool, this, nr.name, false, this.runnerCancellationScope, nr.runnable, this.cache);
                        callbackThreads.add(thread);
                    }
                    for (int i = callbackThreads.size() - 1; i >= 0; --i) {
                        this.threads.addFirst((WorkflowThread)callbackThreads.get(i));
                    }
                }
                this.toExecuteInWorkflowThread.clear();
                progress = false;
                Iterator<WorkflowThread> ci = this.threads.iterator();
                this.nextWakeUpTime = 0L;
                while (ci.hasNext()) {
                    WorkflowThread c = ci.next();
                    boolean bl = progress = c.runUntilBlocked() || progress;
                    if (this.exitRequested) {
                        this.close();
                        break block3;
                    }
                    if (c.isDone()) {
                        ci.remove();
                        if (c.getUnhandledException() == null) continue;
                        unhandledException = c.getUnhandledException();
                        break;
                    }
                    long t = c.getBlockedUntil();
                    if (t <= this.nextWakeUpTime) continue;
                    this.nextWakeUpTime = t;
                }
                if (unhandledException != null) {
                    this.close();
                    throw unhandledException;
                }
                for (WorkflowThread c : this.threadsToAdd) {
                    this.threads.addLast(c);
                }
            } while (progress && !this.threads.isEmpty());
            if (this.nextWakeUpTime < this.currentTimeMillis()) {
                this.nextWakeUpTime = 0L;
            }
        }
        finally {
            this.inRunUntilAllBlocked = false;
            if (this.closeRequested) {
                this.close();
            }
            this.lock.unlock();
        }
    }

    @Override
    public boolean isDone() {
        this.lock.lock();
        try {
            boolean bl = this.closed || this.threads.isEmpty();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Object getExitValue() {
        this.lock.lock();
        try {
            if (!this.closed) {
                throw new Error("not done");
            }
        }
        finally {
            this.lock.unlock();
        }
        return this.exitValue;
    }

    @Override
    public void cancel(String reason) {
        this.executeInWorkflowThread("cancel workflow callback", () -> this.rootWorkflowThread.cancel(reason));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        ArrayList threadFutures = new ArrayList();
        this.lock.lock();
        if (this.closed) {
            this.lock.unlock();
            return;
        }
        this.closeRequested = true;
        if (this.inRunUntilAllBlocked) {
            this.lock.unlock();
            return;
        }
        try {
            for (WorkflowThread workflowThread : this.threadsToAdd) {
                this.threads.addLast(workflowThread);
            }
            this.threadsToAdd.clear();
            for (WorkflowThread workflowThread : this.threads) {
                threadFutures.add(workflowThread.stopNow());
            }
            this.threads.clear();
            HashSet<Promise> failedPromisesLoop = new HashSet<Promise>(this.failedPromises);
            for (Promise f : failedPromisesLoop) {
                if (!f.isCompleted()) {
                    throw new Error("expected failed");
                }
                try {
                    f.get();
                    throw new Error("unreachable");
                }
                catch (RuntimeException e) {
                    log.warn("Promise that was completedExceptionally was never accessed. The ignored exception:", (Throwable)CheckedExceptionWrapper.unwrap(e));
                }
            }
        }
        finally {
            this.closed = true;
            this.lock.unlock();
        }
        for (Future future : threadFutures) {
            try {
                future.get();
            }
            catch (InterruptedException e) {
                throw new Error("Unexpected interrupt", e);
            }
            catch (ExecutionException e) {
                throw new Error("Unexpected failure stopping coroutine", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String stackTrace() {
        StringBuilder result = new StringBuilder();
        this.lock.lock();
        try {
            this.checkClosed();
            for (WorkflowThread coroutine : this.threads) {
                if (result.length() > 0) {
                    result.append("\n");
                }
                coroutine.addStackTrace(result);
            }
        }
        finally {
            this.lock.unlock();
        }
        return result.toString();
    }

    private void checkClosed() {
        if (this.closed) {
            throw new Error("closed");
        }
    }

    @Override
    public long currentTimeMillis() {
        return this.clock.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNextWakeUpTime() {
        this.lock.lock();
        try {
            this.checkClosed();
            if (this.decisionContext != null) {
                long nextFireTime = this.decisionContext.getNextFireTime();
                if (this.nextWakeUpTime == 0L) {
                    long l = nextFireTime;
                    return l;
                }
                if (nextFireTime == 0L) {
                    long l = this.nextWakeUpTime;
                    return l;
                }
                long l = Math.min(this.nextWakeUpTime, nextFireTime);
                return l;
            }
            long l = this.nextWakeUpTime;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    WorkflowThread newThread(Runnable runnable, boolean detached, String name) {
        this.checkWorkflowThreadOnly();
        this.checkClosed();
        WorkflowThreadImpl result = new WorkflowThreadImpl(false, this.threadPool, this, name, detached, CancellationScopeImpl.current(), runnable, this.cache);
        this.threadsToAdd.add(result);
        return result;
    }

    @Override
    public void executeInWorkflowThread(String name, Runnable runnable) {
        this.lock.lock();
        try {
            this.checkClosed();
            this.toExecuteInWorkflowThread.add(new NamedRunnable(name, runnable));
        }
        finally {
            this.lock.unlock();
        }
    }

    Lock getLock() {
        return this.lock;
    }

    void registerFailedPromise(Promise promise) {
        this.failedPromises.add(promise);
    }

    void forgetFailedPromise(Promise promise) {
        this.failedPromises.remove(promise);
    }

    <R> void exit(R value) {
        this.checkClosed();
        this.checkWorkflowThreadOnly();
        this.exitValue = value;
        this.exitRequested = true;
    }

    private void checkWorkflowThreadOnly() {
        if (!this.inRunUntilAllBlocked) {
            throw new Error("called from non workflow thread");
        }
    }

    <T> Optional<T> getRunnerLocal(RunnerLocalInternal<T> key) {
        if (!this.runnerLocalMap.containsKey(key)) {
            return Optional.empty();
        }
        return Optional.of(this.runnerLocalMap.get(key));
    }

    <T> void setRunnerLocal(RunnerLocalInternal<T> key, T value) {
        this.runnerLocalMap.put(key, value);
    }

    private static final class DummyDecisionContext
    implements DecisionContext {
        private DummyDecisionContext() {
        }

        @Override
        public WorkflowExecution getWorkflowExecution() {
            throw new UnsupportedOperationException("not implemented");
        }

        @Override
        public WorkflowType getWorkflowType() {
            return new WorkflowType().setName("dummy-workflow");
        }

        @Override
        public boolean isCancelRequested() {
            throw new UnsupportedOperationException("not implemented");
        }

        @Override
        public ContinueAsNewWorkflowExecutionParameters getContinueAsNewOnCompletion() {
            throw new UnsupportedOperationException("not implemented");
        }

        @Override
        public void setContinueAsNewOnCompletion(ContinueAsNewWorkflowExecutionParameters continueParameters) {
            throw new UnsupportedOperationException("not implemented");
        }

        @Override
        public int getExecutionStartToCloseTimeoutSeconds() {
            throw new UnsupportedOperationException("not implemented");
        }

        @Override
        public String getTaskList() {
            return "dummy-task-list";
        }

        @Override
        public String getDomain() {
            return "dummy-domain";
        }

        @Override
        public String getWorkflowId() {
            return "dummy-workflow-id";
        }

        @Override
        public String getRunId() {
            return "dummy-run-id";
        }

        @Override
        public Duration getExecutionStartToCloseTimeout() {
            throw new UnsupportedOperationException("not implemented");
        }

        @Override
        public Duration getDecisionTaskTimeout() {
            throw new UnsupportedOperationException("not implemented");
        }

        @Override
        public ChildPolicy getChildPolicy() {
            return ChildPolicy.TERMINATE;
        }

        @Override
        public SearchAttributes getSearchAttributes() {
            throw new UnsupportedOperationException("not implemented");
        }

        @Override
        public Consumer<Exception> scheduleActivityTask(ExecuteActivityParameters parameters, BiConsumer<byte[], Exception> callback) {
            throw new UnsupportedOperationException("not implemented");
        }

        @Override
        public Consumer<Exception> scheduleLocalActivityTask(ExecuteLocalActivityParameters parameters, BiConsumer<byte[], Exception> callback) {
            throw new UnsupportedOperationException("not implemented");
        }

        @Override
        public Consumer<Exception> startChildWorkflow(StartChildWorkflowExecutionParameters parameters, Consumer<WorkflowExecution> executionCallback, BiConsumer<byte[], Exception> callback) {
            throw new UnsupportedOperationException("not implemented");
        }

        @Override
        public boolean isServerSideChildWorkflowRetry() {
            throw new UnsupportedOperationException("not implemented");
        }

        @Override
        public boolean isServerSideActivityRetry() {
            throw new UnsupportedOperationException("not implemented");
        }

        @Override
        public Consumer<Exception> signalWorkflowExecution(SignalExternalWorkflowParameters signalParameters, BiConsumer<Void, Exception> callback) {
            throw new UnsupportedOperationException("not implemented");
        }

        @Override
        public Promise<Void> requestCancelWorkflowExecution(WorkflowExecution execution) {
            throw new UnsupportedOperationException("not implemented");
        }

        @Override
        public void continueAsNewOnCompletion(ContinueAsNewWorkflowExecutionParameters parameters) {
            throw new UnsupportedOperationException("not implemented");
        }

        @Override
        public Optional<byte[]> mutableSideEffect(String id, DataConverter converter, Functions.Func1<Optional<byte[]>, Optional<byte[]>> func) {
            return func.apply(Optional.empty());
        }

        @Override
        public long currentTimeMillis() {
            throw new UnsupportedOperationException("not implemented");
        }

        @Override
        public boolean isReplaying() {
            throw new UnsupportedOperationException("not implemented");
        }

        @Override
        public Consumer<Exception> createTimer(long delaySeconds, Consumer<Exception> callback) {
            throw new UnsupportedOperationException("not implemented");
        }

        @Override
        public byte[] sideEffect(Functions.Func<byte[]> func) {
            throw new UnsupportedOperationException("not implemented");
        }

        @Override
        public int getVersion(String changeID, DataConverter converter, int minSupported, int maxSupported) {
            throw new UnsupportedOperationException("not implemented");
        }

        @Override
        public Random newRandom() {
            throw new UnsupportedOperationException("not implemented");
        }

        @Override
        public Scope getMetricsScope() {
            return NoopScope.getInstance();
        }

        @Override
        public boolean getEnableLoggingInReplay() {
            return false;
        }

        @Override
        public UUID randomUUID() {
            return UUID.randomUUID();
        }

        @Override
        public void upsertSearchAttributes(SearchAttributes searchAttributes) {
            throw new UnsupportedOperationException("not implemented");
        }
    }

    private static class NamedRunnable {
        private final String name;
        private final Runnable runnable;

        private NamedRunnable(String name, Runnable runnable) {
            this.name = name;
            this.runnable = runnable;
        }
    }
}

