/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.sync;

import com.uber.cadence.internal.sync.ActivityExecutionContext;

final class CurrentActivityExecutionContext {
    private static final ThreadLocal<ActivityExecutionContext> CURRENT = new ThreadLocal();

    public static ActivityExecutionContext get() {
        ActivityExecutionContext result = CURRENT.get();
        if (result == null) {
            throw new IllegalStateException("ActivityExecutionContext can be used only inside of activity implementation methods and in the same thread that invoked an activity.");
        }
        return result;
    }

    public static boolean isSet() {
        return CURRENT.get() != null;
    }

    public static void set(ActivityExecutionContext context) {
        if (context == null) {
            throw new IllegalArgumentException("null context");
        }
        if (CURRENT.get() != null) {
            throw new IllegalStateException("current already set");
        }
        CURRENT.set(context);
    }

    public static void unset() {
        CURRENT.set(null);
    }

    private CurrentActivityExecutionContext() {
    }
}

