/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.sync;

import com.uber.cadence.workflow.CompletablePromise;
import com.uber.cadence.workflow.Functions;
import com.uber.cadence.workflow.Promise;
import com.uber.cadence.workflow.Workflow;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

class AllOfPromise<G>
implements Promise<List<G>> {
    private G[] result;
    private final CompletablePromise<List<G>> impl = Workflow.newPromise();
    private int notReadyCount;

    AllOfPromise(Promise<G>[] promises) {
        this.result = new Object[promises.length];
        int index = 0;
        for (Promise<G> f : promises) {
            this.addPromise(index, f);
            ++index;
        }
    }

    public AllOfPromise(Collection<Promise<G>> promises) {
        this.result = new Object[promises.size()];
        int index = 0;
        for (Promise<G> f : promises) {
            this.addPromise(index, f);
            ++index;
        }
    }

    private void addPromise(int index, Promise<G> f) {
        if (f.isCompleted()) {
            this.result[index] = f.get();
        } else {
            ++this.notReadyCount;
            int i = index;
            f.handle((? super V r, RuntimeException e) -> {
                if (this.notReadyCount == 0) {
                    throw new Error("Unexpected 0 count");
                }
                if (this.impl.isCompleted()) {
                    return null;
                }
                if (e != null) {
                    this.impl.completeExceptionally((RuntimeException)e);
                }
                this.result[i] = r;
                if (--this.notReadyCount == 0) {
                    this.impl.complete(Arrays.asList(this.result));
                }
                return null;
            });
        }
    }

    @Override
    public <U> Promise<U> thenApply(Functions.Func1<? super List<G>, ? extends U> fn) {
        return this.impl.thenApply(fn);
    }

    @Override
    public <U> Promise<U> handle(Functions.Func2<? super List<G>, RuntimeException, ? extends U> fn) {
        return this.impl.handle(fn);
    }

    @Override
    public <U> Promise<U> thenCompose(Functions.Func1<? super List<G>, ? extends Promise<U>> func) {
        return this.impl.thenCompose(func);
    }

    @Override
    public Promise<List<G>> exceptionally(Functions.Func1<Throwable, ? extends List<G>> fn) {
        return this.impl.exceptionally(fn);
    }

    @Override
    public boolean isCompleted() {
        return this.impl.isCompleted();
    }

    @Override
    public List<G> get() {
        return (List)this.impl.get();
    }

    @Override
    public List<G> get(List<G> defaultValue) {
        return this.impl.get(defaultValue);
    }

    @Override
    public List<G> get(long timeout, TimeUnit unit) throws TimeoutException {
        return (List)this.impl.get(timeout, unit);
    }

    @Override
    public List<G> get(long timeout, TimeUnit unit, List<G> defaultValue) {
        return this.impl.get(timeout, unit, defaultValue);
    }

    @Override
    public RuntimeException getFailure() {
        return this.impl.getFailure();
    }
}

