/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.sync;

import com.uber.cadence.activity.ActivityMethod;
import com.uber.cadence.common.MethodRetry;
import com.uber.cadence.internal.common.InternalUtils;
import com.uber.cadence.internal.sync.AsyncInternal;
import com.uber.cadence.internal.sync.WorkflowInternal;
import com.uber.cadence.workflow.Workflow;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

abstract class ActivityInvocationHandlerBase
implements InvocationHandler {
    private final Map<Method, Function<Object[], Object>> methodFunctions = new HashMap<Method, Function<Object[], Object>>();

    ActivityInvocationHandlerBase() {
    }

    static <T> T newProxy(Class<T> activityInterface, InvocationHandler invocationHandler) {
        return (T)Proxy.newProxyInstance(WorkflowInternal.class.getClassLoader(), new Class[]{activityInterface, AsyncInternal.AsyncMarker.class}, invocationHandler);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) {
        Function<Object[], Object> function = this.methodFunctions.get(method);
        if (function == null) {
            try {
                if (method.equals(Object.class.getMethod("toString", new Class[0]))) {
                    return "ActivityInvocationHandlerBase";
                }
                if (!method.getDeclaringClass().isInterface()) {
                    throw new IllegalArgumentException("Interface type is expected: " + method.getDeclaringClass());
                }
                MethodRetry methodRetry = method.getAnnotation(MethodRetry.class);
                ActivityMethod activityMethod = method.getAnnotation(ActivityMethod.class);
                String activityName = activityMethod == null || activityMethod.name().isEmpty() ? InternalUtils.getSimpleName(method) : activityMethod.name();
                function = this.getActivityFunc(method, methodRetry, activityMethod, activityName);
                this.methodFunctions.put(method, function);
            }
            catch (NoSuchMethodException e) {
                throw Workflow.wrap(e);
            }
        }
        return InternalUtils.getValueOrDefault(function.apply(args), method.getReturnType());
    }

    protected abstract Function<Object[], Object> getActivityFunc(Method var1, MethodRetry var2, ActivityMethod var3, String var4);
}

