/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.replay;

import com.uber.cadence.Decision;
import com.uber.cadence.DecisionType;
import com.uber.cadence.HistoryEvent;
import com.uber.cadence.SignalExternalWorkflowExecutionDecisionAttributes;
import com.uber.cadence.internal.replay.DecisionId;
import com.uber.cadence.internal.replay.DecisionState;
import com.uber.cadence.internal.replay.DecisionStateMachineBase;

class SignalDecisionStateMachine
extends DecisionStateMachineBase {
    private SignalExternalWorkflowExecutionDecisionAttributes attributes;
    private boolean canceled;

    public SignalDecisionStateMachine(DecisionId id, SignalExternalWorkflowExecutionDecisionAttributes attributes) {
        super(id);
        this.attributes = attributes;
    }

    SignalDecisionStateMachine(DecisionId id, SignalExternalWorkflowExecutionDecisionAttributes attributes, DecisionState state) {
        super(id, state);
        this.attributes = attributes;
    }

    @Override
    public Decision getDecision() {
        switch (this.state) {
            case CREATED: {
                return this.createSignalExternalWorkflowExecutionDecision();
            }
        }
        return null;
    }

    @Override
    public boolean isDone() {
        return this.state == DecisionState.COMPLETED || this.canceled;
    }

    @Override
    public boolean cancel(Runnable immediateCancellationCallback) {
        this.stateHistory.add("cancel");
        boolean result = false;
        switch (this.state) {
            case CREATED: 
            case INITIATED: {
                this.state = DecisionState.COMPLETED;
                if (immediateCancellationCallback != null) {
                    immediateCancellationCallback.run();
                }
                result = true;
                break;
            }
            case DECISION_SENT: {
                this.state = DecisionState.CANCELED_BEFORE_INITIATED;
                if (immediateCancellationCallback != null) {
                    immediateCancellationCallback.run();
                }
                result = true;
                break;
            }
            default: {
                this.failStateTransition();
            }
        }
        this.canceled = true;
        this.stateHistory.add(this.state.toString());
        return result;
    }

    @Override
    public void handleInitiatedEvent(HistoryEvent event) {
        this.stateHistory.add("handleInitiatedEvent");
        switch (this.state) {
            case DECISION_SENT: {
                this.state = DecisionState.INITIATED;
                break;
            }
            case CANCELED_BEFORE_INITIATED: {
                break;
            }
            default: {
                this.failStateTransition();
            }
        }
        this.stateHistory.add(this.state.toString());
    }

    @Override
    public void handleInitiationFailedEvent(HistoryEvent event) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void handleStartedEvent(HistoryEvent event) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void handleCompletionEvent() {
        this.stateHistory.add("handleCompletionEvent");
        switch (this.state) {
            case INITIATED: 
            case DECISION_SENT: 
            case CANCELED_BEFORE_INITIATED: {
                this.state = DecisionState.COMPLETED;
                break;
            }
            case COMPLETED: {
                break;
            }
            default: {
                this.failStateTransition();
            }
        }
        this.stateHistory.add(this.state.toString());
    }

    @Override
    public void handleCancellationInitiatedEvent() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void handleCancellationFailureEvent(HistoryEvent event) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void handleCancellationEvent() {
        throw new UnsupportedOperationException();
    }

    private Decision createSignalExternalWorkflowExecutionDecision() {
        Decision decision = new Decision();
        decision.setSignalExternalWorkflowExecutionDecisionAttributes(this.attributes);
        decision.setDecisionType(DecisionType.SignalExternalWorkflowExecution);
        return decision;
    }
}

