/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.replay;

import com.google.common.collect.PeekingIterator;
import com.uber.cadence.EventType;
import com.uber.cadence.HistoryEvent;
import com.uber.cadence.PollForDecisionTaskResponse;
import com.uber.cadence.internal.common.WorkflowExecutionUtils;
import com.uber.cadence.internal.worker.DecisionTaskWithHistoryIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

class HistoryHelper {
    private final DecisionTaskWithHistoryIterator decisionTaskWithHistoryIterator;
    private final DecisionEventsIterator iterator;

    HistoryHelper(DecisionTaskWithHistoryIterator decisionTasks, long replayCurrentTimeMilliseconds) {
        this.decisionTaskWithHistoryIterator = decisionTasks;
        this.iterator = new DecisionEventsIterator(decisionTasks, replayCurrentTimeMilliseconds);
    }

    public DecisionEventsIterator getIterator() {
        return this.iterator;
    }

    public PollForDecisionTaskResponse getDecisionTask() {
        return this.decisionTaskWithHistoryIterator.getDecisionTask();
    }

    public String toString() {
        return WorkflowExecutionUtils.prettyPrintHistory(this.decisionTaskWithHistoryIterator.getDecisionTask().getHistory().getEvents().iterator(), true);
    }

    long getPreviousStartedEventId() {
        return this.getDecisionTask().getPreviousStartedEventId();
    }

    static class DecisionEventsIterator
    implements Iterator<DecisionEvents> {
        private EventsIterator events;
        private long replayCurrentTimeMilliseconds;

        DecisionEventsIterator(DecisionTaskWithHistoryIterator decisionTaskWithHistoryIterator, long replayCurrentTimeMilliseconds) {
            this.events = new EventsIterator(decisionTaskWithHistoryIterator.getHistory());
            this.replayCurrentTimeMilliseconds = replayCurrentTimeMilliseconds;
        }

        @Override
        public boolean hasNext() {
            return this.events.hasNext();
        }

        @Override
        public DecisionEvents next() {
            ArrayList<HistoryEvent> decisionEvents = new ArrayList<HistoryEvent>();
            ArrayList<HistoryEvent> newEvents = new ArrayList<HistoryEvent>();
            boolean replay = true;
            long nextDecisionEventId = -1L;
            while (this.events.hasNext()) {
                HistoryEvent event = this.events.next();
                EventType eventType = event.getEventType();
                if (eventType == EventType.DecisionTaskCompleted && nextDecisionEventId == -1L) {
                    nextDecisionEventId = event.getEventId() + 1L;
                    break;
                }
                if (eventType == EventType.DecisionTaskStarted || !this.events.hasNext()) {
                    this.replayCurrentTimeMilliseconds = TimeUnit.NANOSECONDS.toMillis(event.getTimestamp());
                    if (!this.events.hasNext()) {
                        replay = false;
                        nextDecisionEventId = event.getEventId() + 2L;
                        break;
                    }
                    HistoryEvent peeked = this.events.peek();
                    EventType peekedType = peeked.getEventType();
                    if (peekedType == EventType.DecisionTaskTimedOut || peekedType == EventType.DecisionTaskFailed) continue;
                    if (peekedType == EventType.DecisionTaskCompleted) {
                        this.events.next();
                        nextDecisionEventId = peeked.getEventId() + 1L;
                        break;
                    }
                    throw new Error("Unexpected event after DecisionTaskStarted: " + peeked + " DecisionTaskStarted Event: " + event);
                }
                newEvents.add(event);
            }
            while (this.events.hasNext() && WorkflowExecutionUtils.isDecisionEvent(this.events.peek())) {
                decisionEvents.add(this.events.next());
            }
            DecisionEvents result = new DecisionEvents(newEvents, decisionEvents, replay, this.replayCurrentTimeMilliseconds, nextDecisionEventId);
            return result;
        }
    }

    private static final class EventsIterator
    implements PeekingIterator<HistoryEvent> {
        private Iterator<HistoryEvent> events;
        private HistoryEvent next;

        EventsIterator(Iterator<HistoryEvent> events) {
            this.events = events;
            if (events.hasNext()) {
                this.next = events.next();
            }
        }

        public HistoryEvent peek() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.next;
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public HistoryEvent next() {
            HistoryEvent result = this.next;
            this.next = this.events.hasNext() ? this.events.next() : null;
            return result;
        }

        public void remove() {
            throw new UnsupportedOperationException("not implemented");
        }
    }

    static final class DecisionEvents {
        private final List<HistoryEvent> events;
        private final List<HistoryEvent> decisionEvents;
        private final List<HistoryEvent> markers = new ArrayList<HistoryEvent>();
        private final boolean replay;
        private final long replayCurrentTimeMilliseconds;
        private final long nextDecisionEventId;

        DecisionEvents(List<HistoryEvent> events, List<HistoryEvent> decisionEvents, boolean replay, long replayCurrentTimeMilliseconds, long nextDecisionEventId) {
            if (replayCurrentTimeMilliseconds <= 0L) {
                throw new Error("replayCurrentTimeMilliseconds is not set");
            }
            if (nextDecisionEventId <= 0L) {
                throw new Error("nextDecisionEventId is not set");
            }
            this.events = events;
            this.decisionEvents = decisionEvents;
            for (HistoryEvent event : decisionEvents) {
                if (event.getEventType() != EventType.MarkerRecorded) continue;
                this.markers.add(event);
            }
            this.replay = replay;
            this.replayCurrentTimeMilliseconds = replayCurrentTimeMilliseconds;
            this.nextDecisionEventId = nextDecisionEventId;
        }

        public List<HistoryEvent> getEvents() {
            return this.events;
        }

        List<HistoryEvent> getDecisionEvents() {
            return this.decisionEvents;
        }

        Optional<HistoryEvent> getOptionalDecisionEvent(long eventId) {
            int index = (int)(eventId - this.nextDecisionEventId);
            if (index < 0 || index >= this.decisionEvents.size()) {
                return Optional.empty();
            }
            return Optional.of(this.decisionEvents.get(index));
        }

        public List<HistoryEvent> getMarkers() {
            return this.markers;
        }

        public boolean isReplay() {
            return this.replay;
        }

        public long getReplayCurrentTimeMilliseconds() {
            return this.replayCurrentTimeMilliseconds;
        }

        public long getNextDecisionEventId() {
            return this.nextDecisionEventId;
        }

        public String toString() {
            return "DecisionEvents{events=" + WorkflowExecutionUtils.prettyPrintHistory(this.events.iterator(), true) + ", decisionEvents=" + WorkflowExecutionUtils.prettyPrintHistory(this.decisionEvents.iterator(), true) + ", replay=" + this.replay + ", replayCurrentTimeMilliseconds=" + this.replayCurrentTimeMilliseconds + ", nextDecisionEventId=" + this.nextDecisionEventId + '}';
        }
    }
}

