/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.replay;

import com.uber.cadence.ActivityTaskCancelRequestedEventAttributes;
import com.uber.cadence.ActivityTaskCanceledEventAttributes;
import com.uber.cadence.ActivityTaskScheduledEventAttributes;
import com.uber.cadence.ActivityTaskStartedEventAttributes;
import com.uber.cadence.CancelWorkflowExecutionDecisionAttributes;
import com.uber.cadence.ChildWorkflowExecutionCanceledEventAttributes;
import com.uber.cadence.ChildWorkflowExecutionCompletedEventAttributes;
import com.uber.cadence.ChildWorkflowExecutionFailedEventAttributes;
import com.uber.cadence.ChildWorkflowExecutionStartedEventAttributes;
import com.uber.cadence.ChildWorkflowExecutionTerminatedEventAttributes;
import com.uber.cadence.ChildWorkflowExecutionTimedOutEventAttributes;
import com.uber.cadence.CompleteWorkflowExecutionDecisionAttributes;
import com.uber.cadence.ContinueAsNewWorkflowExecutionDecisionAttributes;
import com.uber.cadence.Decision;
import com.uber.cadence.DecisionType;
import com.uber.cadence.EventType;
import com.uber.cadence.ExternalWorkflowExecutionCancelRequestedEventAttributes;
import com.uber.cadence.FailWorkflowExecutionDecisionAttributes;
import com.uber.cadence.Header;
import com.uber.cadence.HistoryEvent;
import com.uber.cadence.MarkerRecordedEventAttributes;
import com.uber.cadence.PollForDecisionTaskResponse;
import com.uber.cadence.RecordMarkerDecisionAttributes;
import com.uber.cadence.RequestCancelActivityTaskFailedEventAttributes;
import com.uber.cadence.RequestCancelExternalWorkflowExecutionDecisionAttributes;
import com.uber.cadence.RequestCancelExternalWorkflowExecutionFailedEventAttributes;
import com.uber.cadence.ScheduleActivityTaskDecisionAttributes;
import com.uber.cadence.SearchAttributes;
import com.uber.cadence.SignalExternalWorkflowExecutionDecisionAttributes;
import com.uber.cadence.StartChildWorkflowExecutionDecisionAttributes;
import com.uber.cadence.StartChildWorkflowExecutionFailedEventAttributes;
import com.uber.cadence.StartChildWorkflowExecutionInitiatedEventAttributes;
import com.uber.cadence.StartTimerDecisionAttributes;
import com.uber.cadence.TaskList;
import com.uber.cadence.TimerCanceledEventAttributes;
import com.uber.cadence.TimerFiredEventAttributes;
import com.uber.cadence.UpsertWorkflowSearchAttributesDecisionAttributes;
import com.uber.cadence.WorkflowExecutionStartedEventAttributes;
import com.uber.cadence.WorkflowType;
import com.uber.cadence.internal.common.WorkflowExecutionUtils;
import com.uber.cadence.internal.replay.ActivityDecisionStateMachine;
import com.uber.cadence.internal.replay.ChildWorkflowDecisionStateMachine;
import com.uber.cadence.internal.replay.CompleteWorkflowStateMachine;
import com.uber.cadence.internal.replay.ContinueAsNewWorkflowExecutionParameters;
import com.uber.cadence.internal.replay.DecisionId;
import com.uber.cadence.internal.replay.DecisionStateMachine;
import com.uber.cadence.internal.replay.DecisionTarget;
import com.uber.cadence.internal.replay.ExternalWorkflowCancellationDecisionStateMachine;
import com.uber.cadence.internal.replay.HistoryHelper;
import com.uber.cadence.internal.replay.MarkerDecisionStateMachine;
import com.uber.cadence.internal.replay.NonDeterminisicWorkflowError;
import com.uber.cadence.internal.replay.SignalDecisionStateMachine;
import com.uber.cadence.internal.replay.TimerDecisionStateMachine;
import com.uber.cadence.internal.replay.UpsertSearchAttributesDecisionStateMachine;
import com.uber.cadence.internal.worker.WorkflowExecutionException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

class DecisionsHelper {
    private static final int MAXIMUM_DECISIONS_PER_COMPLETION = 10000;
    static final String FORCE_IMMEDIATE_DECISION_TIMER = "FORCE_IMMEDIATE_DECISION";
    private static final String NON_DETERMINISTIC_MESSAGE = "The possible causes are a nondeterministic workflow definition code or an incompatible change in the workflow definition.";
    private final PollForDecisionTaskResponse task;
    private long nextDecisionEventId;
    private long idCounter;
    private HistoryHelper.DecisionEvents decisionEvents;
    private final Map<DecisionId, DecisionStateMachine> decisions = new LinkedHashMap<DecisionId, DecisionStateMachine>(100, 0.75f, true);
    private final Map<String, Long> activityIdToScheduledEventId = new HashMap<String, Long>();

    DecisionsHelper(PollForDecisionTaskResponse task) {
        this.task = task;
    }

    long getNextDecisionEventId() {
        return this.nextDecisionEventId;
    }

    long scheduleActivityTask(ScheduleActivityTaskDecisionAttributes schedule) {
        this.addAllMissingVersionMarker(false, Optional.empty());
        long nextDecisionEventId = this.getNextDecisionEventId();
        DecisionId decisionId = new DecisionId(DecisionTarget.ACTIVITY, nextDecisionEventId);
        this.activityIdToScheduledEventId.put(schedule.getActivityId(), nextDecisionEventId);
        this.addDecision(decisionId, new ActivityDecisionStateMachine(decisionId, schedule));
        return nextDecisionEventId;
    }

    boolean requestCancelActivityTask(long scheduledEventId, Runnable immediateCancellationCallback) {
        DecisionStateMachine decision = this.getDecision(new DecisionId(DecisionTarget.ACTIVITY, scheduledEventId));
        if (decision.cancel(immediateCancellationCallback)) {
            ++this.nextDecisionEventId;
        }
        return decision.isDone();
    }

    void handleActivityTaskStarted(HistoryEvent event) {
        ActivityTaskStartedEventAttributes attributes = event.getActivityTaskStartedEventAttributes();
        DecisionStateMachine decision = this.getDecision(new DecisionId(DecisionTarget.ACTIVITY, attributes.getScheduledEventId()));
        decision.handleStartedEvent(event);
    }

    void handleActivityTaskScheduled(HistoryEvent event) {
        DecisionStateMachine decision = this.getDecision(new DecisionId(DecisionTarget.ACTIVITY, event.getEventId()));
        decision.handleInitiatedEvent(event);
    }

    boolean handleActivityTaskClosed(long scheduledEventId) {
        DecisionStateMachine decision = this.getDecision(new DecisionId(DecisionTarget.ACTIVITY, scheduledEventId));
        decision.handleCompletionEvent();
        return decision.isDone();
    }

    boolean handleActivityTaskCancelRequested(HistoryEvent event) {
        ActivityTaskCancelRequestedEventAttributes attributes = event.getActivityTaskCancelRequestedEventAttributes();
        String activityId = attributes.getActivityId();
        long scheduledEventId = this.getActivityScheduledEventId(activityId);
        DecisionStateMachine decision = this.getDecision(new DecisionId(DecisionTarget.ACTIVITY, scheduledEventId));
        decision.handleCancellationInitiatedEvent();
        return decision.isDone();
    }

    private long getActivityScheduledEventId(String activityId) {
        Long scheduledEventId = this.activityIdToScheduledEventId.get(activityId);
        if (scheduledEventId == null) {
            throw new Error("Unknown activityID: " + activityId);
        }
        return scheduledEventId;
    }

    boolean handleActivityTaskCanceled(HistoryEvent event) {
        ActivityTaskCanceledEventAttributes attributes = event.getActivityTaskCanceledEventAttributes();
        DecisionStateMachine decision = this.getDecision(new DecisionId(DecisionTarget.ACTIVITY, attributes.getScheduledEventId()));
        decision.handleCancellationEvent();
        return decision.isDone();
    }

    boolean handleRequestCancelActivityTaskFailed(HistoryEvent event) {
        RequestCancelActivityTaskFailedEventAttributes attributes = event.getRequestCancelActivityTaskFailedEventAttributes();
        String activityId = attributes.getActivityId();
        long scheduledEventId = this.getActivityScheduledEventId(activityId);
        DecisionStateMachine decision = this.getDecision(new DecisionId(DecisionTarget.ACTIVITY, scheduledEventId));
        decision.handleCancellationFailureEvent(event);
        return decision.isDone();
    }

    long startChildWorkflowExecution(StartChildWorkflowExecutionDecisionAttributes childWorkflow) {
        this.addAllMissingVersionMarker(false, Optional.empty());
        long nextDecisionEventId = this.getNextDecisionEventId();
        DecisionId decisionId = new DecisionId(DecisionTarget.CHILD_WORKFLOW, nextDecisionEventId);
        this.addDecision(decisionId, new ChildWorkflowDecisionStateMachine(decisionId, childWorkflow));
        return nextDecisionEventId;
    }

    boolean isChildWorkflowExecutionInitiatedWithRetryOptions() {
        Optional<HistoryEvent> optionalEvent = this.getOptionalDecisionEvent(this.nextDecisionEventId);
        if (!optionalEvent.isPresent()) {
            return true;
        }
        HistoryEvent event = optionalEvent.get();
        if (event.getEventType() != EventType.StartChildWorkflowExecutionInitiated) {
            return false;
        }
        StartChildWorkflowExecutionInitiatedEventAttributes attr = event.getStartChildWorkflowExecutionInitiatedEventAttributes();
        if (attr == null) {
            throw new Error("Corrupted event: " + event);
        }
        return attr.getRetryPolicy() != null;
    }

    boolean isActivityScheduledWithRetryOptions() {
        Optional<HistoryEvent> optionalEvent = this.getOptionalDecisionEvent(this.nextDecisionEventId);
        if (!optionalEvent.isPresent()) {
            return true;
        }
        HistoryEvent event = optionalEvent.get();
        if (event.getEventType() != EventType.ActivityTaskScheduled) {
            return false;
        }
        ActivityTaskScheduledEventAttributes attr = event.getActivityTaskScheduledEventAttributes();
        if (attr == null) {
            throw new Error("Corrupted event: " + event);
        }
        return attr.getRetryPolicy() != null;
    }

    void handleStartChildWorkflowExecutionInitiated(HistoryEvent event) {
        DecisionStateMachine decision = this.getDecision(new DecisionId(DecisionTarget.CHILD_WORKFLOW, event.getEventId()));
        decision.handleInitiatedEvent(event);
    }

    boolean handleStartChildWorkflowExecutionFailed(HistoryEvent event) {
        StartChildWorkflowExecutionFailedEventAttributes attributes = event.getStartChildWorkflowExecutionFailedEventAttributes();
        long initiatedEventId = attributes.getInitiatedEventId();
        DecisionStateMachine decision = this.getDecision(new DecisionId(DecisionTarget.CHILD_WORKFLOW, initiatedEventId));
        decision.handleInitiationFailedEvent(event);
        return decision.isDone();
    }

    long requestCancelExternalWorkflowExecution(RequestCancelExternalWorkflowExecutionDecisionAttributes schedule) {
        this.addAllMissingVersionMarker(false, Optional.empty());
        long nextDecisionEventId = this.getNextDecisionEventId();
        DecisionId decisionId = new DecisionId(DecisionTarget.CANCEL_EXTERNAL_WORKFLOW, nextDecisionEventId);
        this.addDecision(decisionId, new ExternalWorkflowCancellationDecisionStateMachine(decisionId, schedule));
        return nextDecisionEventId;
    }

    void handleRequestCancelExternalWorkflowExecutionInitiated(HistoryEvent event) {
        DecisionStateMachine decision = this.getDecision(new DecisionId(DecisionTarget.CANCEL_EXTERNAL_WORKFLOW, event.getEventId()));
        decision.handleInitiatedEvent(event);
    }

    void handleExternalWorkflowExecutionCancelRequested(HistoryEvent event) {
        ExternalWorkflowExecutionCancelRequestedEventAttributes attributes = event.getExternalWorkflowExecutionCancelRequestedEventAttributes();
        DecisionStateMachine decision = this.getDecision(new DecisionId(DecisionTarget.CANCEL_EXTERNAL_WORKFLOW, attributes.getInitiatedEventId()));
        decision.handleCompletionEvent();
    }

    void handleRequestCancelExternalWorkflowExecutionFailed(HistoryEvent event) {
        RequestCancelExternalWorkflowExecutionFailedEventAttributes attributes = event.getRequestCancelExternalWorkflowExecutionFailedEventAttributes();
        DecisionStateMachine decision = this.getDecision(new DecisionId(DecisionTarget.CANCEL_EXTERNAL_WORKFLOW, attributes.getInitiatedEventId()));
        decision.handleCompletionEvent();
    }

    long signalExternalWorkflowExecution(SignalExternalWorkflowExecutionDecisionAttributes signal) {
        this.addAllMissingVersionMarker(false, Optional.empty());
        long nextDecisionEventId = this.getNextDecisionEventId();
        DecisionId decisionId = new DecisionId(DecisionTarget.SIGNAL_EXTERNAL_WORKFLOW, nextDecisionEventId);
        this.addDecision(decisionId, new SignalDecisionStateMachine(decisionId, signal));
        return nextDecisionEventId;
    }

    void cancelSignalExternalWorkflowExecution(long initiatedEventId, Runnable immediateCancellationCallback) {
        DecisionStateMachine decision = this.getDecision(new DecisionId(DecisionTarget.SIGNAL_EXTERNAL_WORKFLOW, initiatedEventId));
        if (decision.cancel(immediateCancellationCallback)) {
            ++this.nextDecisionEventId;
        }
    }

    boolean handleSignalExternalWorkflowExecutionFailed(long initiatedEventId) {
        DecisionStateMachine decision = this.getDecision(new DecisionId(DecisionTarget.SIGNAL_EXTERNAL_WORKFLOW, initiatedEventId));
        decision.handleCompletionEvent();
        return decision.isDone();
    }

    boolean handleExternalWorkflowExecutionSignaled(long initiatedEventId) {
        DecisionStateMachine decision = this.getDecision(new DecisionId(DecisionTarget.SIGNAL_EXTERNAL_WORKFLOW, initiatedEventId));
        decision.handleCompletionEvent();
        return decision.isDone();
    }

    long startTimer(StartTimerDecisionAttributes request) {
        this.addAllMissingVersionMarker(false, Optional.empty());
        long startEventId = this.getNextDecisionEventId();
        DecisionId decisionId = new DecisionId(DecisionTarget.TIMER, startEventId);
        this.addDecision(decisionId, new TimerDecisionStateMachine(decisionId, request));
        return startEventId;
    }

    boolean cancelTimer(long startEventId, Runnable immediateCancellationCallback) {
        DecisionStateMachine decision = this.getDecision(new DecisionId(DecisionTarget.TIMER, startEventId));
        if (decision.isDone()) {
            return true;
        }
        if (decision.cancel(immediateCancellationCallback)) {
            ++this.nextDecisionEventId;
        }
        return decision.isDone();
    }

    void handleChildWorkflowExecutionStarted(HistoryEvent event) {
        ChildWorkflowExecutionStartedEventAttributes attributes = event.getChildWorkflowExecutionStartedEventAttributes();
        DecisionStateMachine decision = this.getDecision(new DecisionId(DecisionTarget.CHILD_WORKFLOW, attributes.getInitiatedEventId()));
        decision.handleStartedEvent(event);
    }

    boolean handleChildWorkflowExecutionCompleted(ChildWorkflowExecutionCompletedEventAttributes attributes) {
        DecisionStateMachine decision = this.getDecision(new DecisionId(DecisionTarget.CHILD_WORKFLOW, attributes.getInitiatedEventId()));
        decision.handleCompletionEvent();
        return decision.isDone();
    }

    boolean handleChildWorkflowExecutionTimedOut(ChildWorkflowExecutionTimedOutEventAttributes attributes) {
        DecisionStateMachine decision = this.getDecision(new DecisionId(DecisionTarget.CHILD_WORKFLOW, attributes.getInitiatedEventId()));
        decision.handleCompletionEvent();
        return decision.isDone();
    }

    boolean handleChildWorkflowExecutionTerminated(ChildWorkflowExecutionTerminatedEventAttributes attributes) {
        DecisionStateMachine decision = this.getDecision(new DecisionId(DecisionTarget.CHILD_WORKFLOW, attributes.getInitiatedEventId()));
        decision.handleCompletionEvent();
        return decision.isDone();
    }

    boolean handleChildWorkflowExecutionFailed(ChildWorkflowExecutionFailedEventAttributes attributes) {
        DecisionStateMachine decision = this.getDecision(new DecisionId(DecisionTarget.CHILD_WORKFLOW, attributes.getInitiatedEventId()));
        decision.handleCompletionEvent();
        return decision.isDone();
    }

    boolean handleChildWorkflowExecutionCanceled(ChildWorkflowExecutionCanceledEventAttributes attributes) {
        DecisionStateMachine decision = this.getDecision(new DecisionId(DecisionTarget.CHILD_WORKFLOW, attributes.getInitiatedEventId()));
        decision.handleCancellationEvent();
        return decision.isDone();
    }

    void handleSignalExternalWorkflowExecutionInitiated(HistoryEvent event) {
        DecisionStateMachine decision = this.getDecision(new DecisionId(DecisionTarget.SIGNAL_EXTERNAL_WORKFLOW, event.getEventId()));
        decision.handleInitiatedEvent(event);
    }

    boolean handleTimerClosed(TimerFiredEventAttributes attributes) {
        DecisionStateMachine decision = this.getDecision(new DecisionId(DecisionTarget.TIMER, attributes.getStartedEventId()));
        decision.handleCompletionEvent();
        return decision.isDone();
    }

    boolean handleTimerCanceled(HistoryEvent event) {
        TimerCanceledEventAttributes attributes = event.getTimerCanceledEventAttributes();
        DecisionStateMachine decision = this.getDecision(new DecisionId(DecisionTarget.TIMER, attributes.getStartedEventId()));
        decision.handleCancellationEvent();
        return decision.isDone();
    }

    boolean handleCancelTimerFailed(HistoryEvent event) {
        long startedEventId = event.getEventId();
        DecisionStateMachine decision = this.getDecision(new DecisionId(DecisionTarget.TIMER, startedEventId));
        decision.handleCancellationFailureEvent(event);
        return decision.isDone();
    }

    void handleTimerStarted(HistoryEvent event) {
        DecisionStateMachine decision = this.getDecision(new DecisionId(DecisionTarget.TIMER, event.getEventId()));
        decision.handleInitiatedEvent(event);
    }

    void completeWorkflowExecution(byte[] output) {
        this.addAllMissingVersionMarker(false, Optional.empty());
        Decision decision = new Decision();
        CompleteWorkflowExecutionDecisionAttributes complete = new CompleteWorkflowExecutionDecisionAttributes();
        complete.setResult(output);
        decision.setCompleteWorkflowExecutionDecisionAttributes(complete);
        decision.setDecisionType(DecisionType.CompleteWorkflowExecution);
        DecisionId decisionId = new DecisionId(DecisionTarget.SELF, 0L);
        this.addDecision(decisionId, new CompleteWorkflowStateMachine(decisionId, decision));
    }

    void continueAsNewWorkflowExecution(ContinueAsNewWorkflowExecutionParameters continueParameters) {
        this.addAllMissingVersionMarker(false, Optional.empty());
        WorkflowExecutionStartedEventAttributes startedEvent = this.task.getHistory().getEvents().get(0).getWorkflowExecutionStartedEventAttributes();
        ContinueAsNewWorkflowExecutionDecisionAttributes attributes = new ContinueAsNewWorkflowExecutionDecisionAttributes();
        attributes.setInput(continueParameters.getInput());
        String workflowType = continueParameters.getWorkflowType();
        if (workflowType != null && !workflowType.isEmpty()) {
            attributes.setWorkflowType(new WorkflowType().setName(workflowType));
        } else {
            attributes.setWorkflowType(this.task.getWorkflowType());
        }
        int executionStartToClose = continueParameters.getExecutionStartToCloseTimeoutSeconds();
        if (executionStartToClose == 0) {
            executionStartToClose = startedEvent.getExecutionStartToCloseTimeoutSeconds();
        }
        attributes.setExecutionStartToCloseTimeoutSeconds(executionStartToClose);
        int taskStartToClose = continueParameters.getTaskStartToCloseTimeoutSeconds();
        if (taskStartToClose == 0) {
            taskStartToClose = startedEvent.getTaskStartToCloseTimeoutSeconds();
        }
        attributes.setTaskStartToCloseTimeoutSeconds(taskStartToClose);
        String taskList = continueParameters.getTaskList();
        if (taskList == null || taskList.isEmpty()) {
            taskList = startedEvent.getTaskList().getName();
        }
        TaskList tl = new TaskList();
        tl.setName(taskList);
        attributes.setTaskList(tl);
        Decision decision = new Decision();
        decision.setDecisionType(DecisionType.ContinueAsNewWorkflowExecution);
        decision.setContinueAsNewWorkflowExecutionDecisionAttributes(attributes);
        DecisionId decisionId = new DecisionId(DecisionTarget.SELF, 0L);
        this.addDecision(decisionId, new CompleteWorkflowStateMachine(decisionId, decision));
    }

    void failWorkflowExecution(WorkflowExecutionException failure) {
        this.addAllMissingVersionMarker(false, Optional.empty());
        Decision decision = new Decision();
        FailWorkflowExecutionDecisionAttributes failAttributes = new FailWorkflowExecutionDecisionAttributes();
        failAttributes.setReason(failure.getReason());
        failAttributes.setDetails(failure.getDetails());
        decision.setFailWorkflowExecutionDecisionAttributes(failAttributes);
        decision.setDecisionType(DecisionType.FailWorkflowExecution);
        DecisionId decisionId = new DecisionId(DecisionTarget.SELF, 0L);
        this.addDecision(decisionId, new CompleteWorkflowStateMachine(decisionId, decision));
    }

    void cancelWorkflowExecution() {
        this.addAllMissingVersionMarker(false, Optional.empty());
        Decision decision = new Decision();
        CancelWorkflowExecutionDecisionAttributes cancel = new CancelWorkflowExecutionDecisionAttributes();
        cancel.setDetails((byte[])null);
        decision.setCancelWorkflowExecutionDecisionAttributes(cancel);
        decision.setDecisionType(DecisionType.CancelWorkflowExecution);
        DecisionId decisionId = new DecisionId(DecisionTarget.SELF, 0L);
        this.addDecision(decisionId, new CompleteWorkflowStateMachine(decisionId, decision));
    }

    void recordMarker(String markerName, Header header, byte[] details) {
        RecordMarkerDecisionAttributes marker = new RecordMarkerDecisionAttributes().setMarkerName(markerName).setHeader(header).setDetails(details);
        Decision decision = new Decision().setDecisionType(DecisionType.RecordMarker).setRecordMarkerDecisionAttributes(marker);
        long nextDecisionEventId = this.getNextDecisionEventId();
        DecisionId decisionId = new DecisionId(DecisionTarget.MARKER, nextDecisionEventId);
        this.addDecision(decisionId, new MarkerDecisionStateMachine(decisionId, decision));
    }

    void upsertSearchAttributes(SearchAttributes searchAttributes) {
        UpsertWorkflowSearchAttributesDecisionAttributes decisionAttr = new UpsertWorkflowSearchAttributesDecisionAttributes().setSearchAttributes(searchAttributes);
        Decision decision = new Decision().setDecisionType(DecisionType.UpsertWorkflowSearchAttributes).setUpsertWorkflowSearchAttributesDecisionAttributes(decisionAttr);
        long nextDecisionEventId = this.getNextDecisionEventId();
        DecisionId decisionId = new DecisionId(DecisionTarget.UPSERT_SEARCH_ATTRIBUTES, nextDecisionEventId);
        this.addDecision(decisionId, new UpsertSearchAttributesDecisionStateMachine(decisionId, decision));
    }

    List<Decision> getDecisions() {
        List<Decision> result = new ArrayList<Decision>(10001);
        for (DecisionStateMachine decisionStateMachine : this.decisions.values()) {
            Decision decision = decisionStateMachine.getDecision();
            if (decision == null) continue;
            result.add(decision);
        }
        int size = result.size();
        if (size > 10000 && !this.isCompletionEvent((Decision)result.get(9998))) {
            result = result.subList(0, 9999);
            StartTimerDecisionAttributes attributes = new StartTimerDecisionAttributes();
            attributes.setStartToFireTimeoutSeconds(0L);
            attributes.setTimerId(FORCE_IMMEDIATE_DECISION_TIMER);
            Decision d = new Decision();
            d.setStartTimerDecisionAttributes(attributes);
            d.setDecisionType(DecisionType.StartTimer);
            result.add(d);
        }
        return result;
    }

    private boolean isCompletionEvent(Decision decision) {
        DecisionType type = decision.getDecisionType();
        switch (type) {
            case CancelWorkflowExecution: 
            case CompleteWorkflowExecution: 
            case FailWorkflowExecution: 
            case ContinueAsNewWorkflowExecution: {
                return true;
            }
        }
        return false;
    }

    public void handleDecisionTaskStartedEvent(HistoryHelper.DecisionEvents decision) {
        this.decisionEvents = decision;
        this.nextDecisionEventId = decision.getNextDecisionEventId();
    }

    void notifyDecisionSent() {
        int count = 0;
        Iterator<DecisionStateMachine> iterator = this.decisions.values().iterator();
        DecisionStateMachine next = null;
        DecisionStateMachine decisionStateMachine = this.getNextDecision(iterator);
        while (decisionStateMachine != null) {
            next = this.getNextDecision(iterator);
            if (++count == 10000 && next != null && !this.isCompletionEvent(next.getDecision())) break;
            decisionStateMachine.handleDecisionTaskStartedEvent();
            decisionStateMachine = next;
        }
        if (next != null && count < 10000) {
            next.handleDecisionTaskStartedEvent();
        }
    }

    private DecisionStateMachine getNextDecision(Iterator<DecisionStateMachine> iterator) {
        DecisionStateMachine result = null;
        while (result == null && iterator.hasNext()) {
            result = iterator.next();
            if (result.getDecision() != null) continue;
            result = null;
        }
        return result;
    }

    public String toString() {
        return WorkflowExecutionUtils.prettyPrintDecisions(this.getDecisions());
    }

    PollForDecisionTaskResponse getTask() {
        return this.task;
    }

    private void addDecision(DecisionId decisionId, DecisionStateMachine decision) {
        Objects.requireNonNull(decisionId);
        this.decisions.put(decisionId, decision);
        ++this.nextDecisionEventId;
    }

    void addAllMissingVersionMarker(boolean isNextDecisionVersionMarker, Optional<Predicate<MarkerRecordedEventAttributes>> isDifferentChange) {
        boolean added;
        while (added = this.addMissingVersionMarker(isNextDecisionVersionMarker, isDifferentChange)) {
        }
    }

    private boolean addMissingVersionMarker(boolean isNextDecisionVersionMarker, Optional<Predicate<MarkerRecordedEventAttributes>> changeIdEquals) {
        Optional<HistoryEvent> optionalEvent = this.getOptionalDecisionEvent(this.nextDecisionEventId);
        if (!optionalEvent.isPresent()) {
            return false;
        }
        HistoryEvent event = optionalEvent.get();
        if (event.getEventType() != EventType.MarkerRecorded) {
            return false;
        }
        if (!event.getMarkerRecordedEventAttributes().getMarkerName().equals("Version")) {
            return false;
        }
        if (isNextDecisionVersionMarker && (!changeIdEquals.isPresent() || changeIdEquals.get().test(event.getMarkerRecordedEventAttributes()))) {
            return false;
        }
        RecordMarkerDecisionAttributes marker = new RecordMarkerDecisionAttributes().setMarkerName("Version").setHeader(event.getMarkerRecordedEventAttributes().getHeader()).setDetails(event.getMarkerRecordedEventAttributes().getDetails());
        Decision markerDecision = new Decision().setDecisionType(DecisionType.RecordMarker).setRecordMarkerDecisionAttributes(marker);
        DecisionId markerDecisionId = new DecisionId(DecisionTarget.MARKER, this.nextDecisionEventId);
        this.decisions.put(markerDecisionId, new MarkerDecisionStateMachine(markerDecisionId, markerDecision));
        ++this.nextDecisionEventId;
        return true;
    }

    private DecisionStateMachine getDecision(DecisionId decisionId) {
        DecisionStateMachine result = this.decisions.get(decisionId);
        if (result == null) {
            throw new NonDeterminisicWorkflowError("Unknown " + decisionId + ". " + NON_DETERMINISTIC_MESSAGE);
        }
        return result;
    }

    String getAndIncrementNextId() {
        return String.valueOf(this.idCounter++);
    }

    Optional<HistoryEvent> getOptionalDecisionEvent(long eventId) {
        return this.decisionEvents.getOptionalDecisionEvent(eventId);
    }
}

