/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.replay;

import com.uber.cadence.ChildPolicy;
import com.uber.cadence.DecisionTaskFailedCause;
import com.uber.cadence.DecisionTaskFailedEventAttributes;
import com.uber.cadence.HistoryEvent;
import com.uber.cadence.PollForDecisionTaskResponse;
import com.uber.cadence.SearchAttributes;
import com.uber.cadence.TimerFiredEventAttributes;
import com.uber.cadence.UpsertWorkflowSearchAttributesEventAttributes;
import com.uber.cadence.WorkflowExecution;
import com.uber.cadence.WorkflowExecutionStartedEventAttributes;
import com.uber.cadence.WorkflowType;
import com.uber.cadence.converter.DataConverter;
import com.uber.cadence.internal.metrics.ReplayAwareScope;
import com.uber.cadence.internal.replay.ActivityDecisionContext;
import com.uber.cadence.internal.replay.ClockDecisionContext;
import com.uber.cadence.internal.replay.ContinueAsNewWorkflowExecutionParameters;
import com.uber.cadence.internal.replay.DecisionContext;
import com.uber.cadence.internal.replay.DecisionsHelper;
import com.uber.cadence.internal.replay.ExecuteActivityParameters;
import com.uber.cadence.internal.replay.ExecuteLocalActivityParameters;
import com.uber.cadence.internal.replay.HistoryEventHandler;
import com.uber.cadence.internal.replay.ReplayDecider;
import com.uber.cadence.internal.replay.SignalExternalWorkflowParameters;
import com.uber.cadence.internal.replay.StartChildWorkflowExecutionParameters;
import com.uber.cadence.internal.replay.WorkflowContext;
import com.uber.cadence.internal.replay.WorkflowDecisionContext;
import com.uber.cadence.internal.worker.LocalActivityWorker;
import com.uber.cadence.internal.worker.SingleWorkerOptions;
import com.uber.cadence.workflow.Functions;
import com.uber.cadence.workflow.Promise;
import com.uber.cadence.workflow.Workflow;
import com.uber.m3.tally.Scope;
import java.time.Duration;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DecisionContextImpl
implements DecisionContext,
HistoryEventHandler {
    private static final Logger log = LoggerFactory.getLogger(DecisionContextImpl.class);
    private final ActivityDecisionContext activityClient;
    private final WorkflowDecisionContext workflowClient;
    private final ClockDecisionContext workflowClock;
    private final WorkflowContext workflowContext;
    private final Scope metricsScope;
    private final boolean enableLoggingInReplay;

    DecisionContextImpl(DecisionsHelper decisionsHelper, String domain, PollForDecisionTaskResponse decisionTask, WorkflowExecutionStartedEventAttributes startedAttributes, SingleWorkerOptions options, BiFunction<LocalActivityWorker.Task, Duration, Boolean> laTaskPoller, ReplayDecider replayDecider) {
        this.activityClient = new ActivityDecisionContext(decisionsHelper);
        this.workflowContext = new WorkflowContext(domain, decisionTask, startedAttributes);
        this.workflowClient = new WorkflowDecisionContext(decisionsHelper, this.workflowContext);
        this.workflowClock = new ClockDecisionContext(decisionsHelper, laTaskPoller, replayDecider, options.getDataConverter());
        this.enableLoggingInReplay = options.getEnableLoggingInReplay();
        this.metricsScope = new ReplayAwareScope(options.getMetricsScope(), this, this.workflowClock::currentTimeMillis);
    }

    @Override
    public boolean getEnableLoggingInReplay() {
        return this.enableLoggingInReplay;
    }

    @Override
    public UUID randomUUID() {
        return this.workflowClient.randomUUID();
    }

    @Override
    public Random newRandom() {
        return this.workflowClient.newRandom();
    }

    @Override
    public Scope getMetricsScope() {
        return this.metricsScope;
    }

    @Override
    public WorkflowExecution getWorkflowExecution() {
        return this.workflowContext.getWorkflowExecution();
    }

    @Override
    public WorkflowType getWorkflowType() {
        return this.workflowContext.getWorkflowType();
    }

    @Override
    public boolean isCancelRequested() {
        return this.workflowContext.isCancelRequested();
    }

    void setCancelRequested(boolean flag) {
        this.workflowContext.setCancelRequested(flag);
    }

    @Override
    public ContinueAsNewWorkflowExecutionParameters getContinueAsNewOnCompletion() {
        return this.workflowContext.getContinueAsNewOnCompletion();
    }

    @Override
    public void setContinueAsNewOnCompletion(ContinueAsNewWorkflowExecutionParameters continueParameters) {
        this.workflowContext.setContinueAsNewOnCompletion(continueParameters);
    }

    @Override
    public int getExecutionStartToCloseTimeoutSeconds() {
        return this.workflowContext.getExecutionStartToCloseTimeoutSeconds();
    }

    @Override
    public Duration getDecisionTaskTimeout() {
        return Duration.ofSeconds(this.workflowContext.getDecisionTaskTimeoutSeconds());
    }

    @Override
    public ChildPolicy getChildPolicy() {
        return this.workflowContext.getChildPolicy();
    }

    @Override
    public String getTaskList() {
        return this.workflowContext.getTaskList();
    }

    @Override
    public String getDomain() {
        return this.workflowContext.getDomain();
    }

    @Override
    public String getWorkflowId() {
        return this.workflowContext.getWorkflowExecution().getWorkflowId();
    }

    @Override
    public String getRunId() {
        return this.workflowContext.getWorkflowExecution().getRunId();
    }

    @Override
    public Duration getExecutionStartToCloseTimeout() {
        return Duration.ofSeconds(this.workflowContext.getExecutionStartToCloseTimeoutSeconds());
    }

    @Override
    public SearchAttributes getSearchAttributes() {
        return this.workflowContext.getSearchAttributes();
    }

    @Override
    public Consumer<Exception> scheduleActivityTask(ExecuteActivityParameters parameters, BiConsumer<byte[], Exception> callback) {
        return this.activityClient.scheduleActivityTask(parameters, callback);
    }

    @Override
    public Consumer<Exception> scheduleLocalActivityTask(ExecuteLocalActivityParameters parameters, BiConsumer<byte[], Exception> callback) {
        return this.workflowClock.scheduleLocalActivityTask(parameters, callback);
    }

    @Override
    public Consumer<Exception> startChildWorkflow(StartChildWorkflowExecutionParameters parameters, Consumer<WorkflowExecution> executionCallback, BiConsumer<byte[], Exception> callback) {
        return this.workflowClient.startChildWorkflow(parameters, executionCallback, callback);
    }

    @Override
    public boolean isServerSideChildWorkflowRetry() {
        return this.workflowClient.isChildWorkflowExecutionStartedWithRetryOptions();
    }

    @Override
    public boolean isServerSideActivityRetry() {
        return this.activityClient.isActivityScheduledWithRetryOptions();
    }

    @Override
    public Consumer<Exception> signalWorkflowExecution(SignalExternalWorkflowParameters signalParameters, BiConsumer<Void, Exception> callback) {
        return this.workflowClient.signalWorkflowExecution(signalParameters, callback);
    }

    @Override
    public Promise<Void> requestCancelWorkflowExecution(WorkflowExecution execution) {
        this.workflowClient.requestCancelWorkflowExecution(execution);
        return Workflow.newPromise(null);
    }

    @Override
    public void continueAsNewOnCompletion(ContinueAsNewWorkflowExecutionParameters parameters) {
        this.workflowClient.continueAsNewOnCompletion(parameters);
    }

    void setReplayCurrentTimeMilliseconds(long replayCurrentTimeMilliseconds) {
        if (replayCurrentTimeMilliseconds < this.workflowClock.currentTimeMillis()) {
            if (log.isWarnEnabled()) {
                log.warn("Trying to set workflow clock back from " + this.workflowClock.currentTimeMillis() + " to " + replayCurrentTimeMilliseconds + ". This will be a no-op.");
            }
            return;
        }
        this.workflowClock.setReplayCurrentTimeMilliseconds(replayCurrentTimeMilliseconds);
    }

    long getReplayCurrentTimeMilliseconds() {
        return this.workflowClock.currentTimeMillis();
    }

    @Override
    public boolean isReplaying() {
        return this.workflowClock.isReplaying();
    }

    @Override
    public Consumer<Exception> createTimer(long delaySeconds, Consumer<Exception> callback) {
        return this.workflowClock.createTimer(delaySeconds, callback);
    }

    @Override
    public byte[] sideEffect(Functions.Func<byte[]> func) {
        return this.workflowClock.sideEffect(func);
    }

    @Override
    public Optional<byte[]> mutableSideEffect(String id, DataConverter converter, Functions.Func1<Optional<byte[]>, Optional<byte[]>> func) {
        return this.workflowClock.mutableSideEffect(id, converter, func);
    }

    @Override
    public int getVersion(String changeID, DataConverter converter, int minSupported, int maxSupported) {
        return this.workflowClock.getVersion(changeID, converter, minSupported, maxSupported);
    }

    @Override
    public long currentTimeMillis() {
        return this.workflowClock.currentTimeMillis();
    }

    void setReplaying(boolean replaying) {
        this.workflowClock.setReplaying(replaying);
    }

    @Override
    public void handleActivityTaskCanceled(HistoryEvent event) {
        this.activityClient.handleActivityTaskCanceled(event);
    }

    @Override
    public void handleActivityTaskCompleted(HistoryEvent event) {
        this.activityClient.handleActivityTaskCompleted(event);
    }

    @Override
    public void handleActivityTaskFailed(HistoryEvent event) {
        this.activityClient.handleActivityTaskFailed(event);
    }

    @Override
    public void handleActivityTaskTimedOut(HistoryEvent event) {
        this.activityClient.handleActivityTaskTimedOut(event);
    }

    @Override
    public void handleChildWorkflowExecutionCancelRequested(HistoryEvent event) {
    }

    @Override
    public void handleChildWorkflowExecutionCanceled(HistoryEvent event) {
        this.workflowClient.handleChildWorkflowExecutionCanceled(event);
    }

    @Override
    public void handleChildWorkflowExecutionStarted(HistoryEvent event) {
        this.workflowClient.handleChildWorkflowExecutionStarted(event);
    }

    @Override
    public void handleChildWorkflowExecutionTimedOut(HistoryEvent event) {
        this.workflowClient.handleChildWorkflowExecutionTimedOut(event);
    }

    @Override
    public void handleChildWorkflowExecutionTerminated(HistoryEvent event) {
        this.workflowClient.handleChildWorkflowExecutionTerminated(event);
    }

    @Override
    public void handleStartChildWorkflowExecutionFailed(HistoryEvent event) {
        this.workflowClient.handleStartChildWorkflowExecutionFailed(event);
    }

    @Override
    public void handleChildWorkflowExecutionFailed(HistoryEvent event) {
        this.workflowClient.handleChildWorkflowExecutionFailed(event);
    }

    @Override
    public void handleChildWorkflowExecutionCompleted(HistoryEvent event) {
        this.workflowClient.handleChildWorkflowExecutionCompleted(event);
    }

    @Override
    public void handleTimerFired(TimerFiredEventAttributes attributes) {
        this.workflowClock.handleTimerFired(attributes);
    }

    @Override
    public void handleTimerCanceled(HistoryEvent event) {
        this.workflowClock.handleTimerCanceled(event);
    }

    void handleSignalExternalWorkflowExecutionFailed(HistoryEvent event) {
        this.workflowClient.handleSignalExternalWorkflowExecutionFailed(event);
    }

    @Override
    public void handleExternalWorkflowExecutionSignaled(HistoryEvent event) {
        this.workflowClient.handleExternalWorkflowExecutionSignaled(event);
    }

    @Override
    public void handleMarkerRecorded(HistoryEvent event) {
        this.workflowClock.handleMarkerRecorded(event);
    }

    public void handleDecisionTaskFailed(HistoryEvent event) {
        DecisionTaskFailedEventAttributes attr = event.getDecisionTaskFailedEventAttributes();
        if (attr != null && attr.getCause() == DecisionTaskFailedCause.RESET_WORKFLOW) {
            this.workflowContext.setCurrentRunId(attr.getNewRunId());
        }
    }

    boolean startUnstartedLaTasks(Duration maxWaitAllowed) {
        return this.workflowClock.startUnstartedLaTasks(maxWaitAllowed);
    }

    int numPendingLaTasks() {
        return this.workflowClock.numPendingLaTasks();
    }

    void awaitTaskCompletion(Duration duration) throws InterruptedException {
        this.workflowClock.awaitTaskCompletion(duration);
    }

    @Override
    public void upsertSearchAttributes(SearchAttributes searchAttributes) {
        this.workflowClock.upsertSearchAttributes(searchAttributes);
        this.workflowContext.mergeSearchAttributes(searchAttributes);
    }

    @Override
    public void handleUpsertSearchAttributes(HistoryEvent event) {
        UpsertWorkflowSearchAttributesEventAttributes attr = event.getUpsertWorkflowSearchAttributesEventAttributes();
        if (attr != null) {
            SearchAttributes searchAttributes = attr.getSearchAttributes();
            this.workflowContext.mergeSearchAttributes(searchAttributes);
        }
    }
}

