/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.replay;

import com.google.common.base.Strings;
import com.uber.cadence.ActivityType;
import com.uber.cadence.HistoryEvent;
import com.uber.cadence.MarkerRecordedEventAttributes;
import com.uber.cadence.SearchAttributes;
import com.uber.cadence.StartTimerDecisionAttributes;
import com.uber.cadence.TimerCanceledEventAttributes;
import com.uber.cadence.TimerFiredEventAttributes;
import com.uber.cadence.converter.DataConverter;
import com.uber.cadence.internal.common.LocalActivityMarkerData;
import com.uber.cadence.internal.replay.DecisionsHelper;
import com.uber.cadence.internal.replay.ExecuteLocalActivityParameters;
import com.uber.cadence.internal.replay.MarkerHandler;
import com.uber.cadence.internal.replay.OpenRequestInfo;
import com.uber.cadence.internal.replay.ReplayDecider;
import com.uber.cadence.internal.worker.LocalActivityWorker;
import com.uber.cadence.workflow.ActivityFailureException;
import com.uber.cadence.workflow.Functions;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClockDecisionContext {
    private static final String SIDE_EFFECT_MARKER_NAME = "SideEffect";
    private static final String MUTABLE_SIDE_EFFECT_MARKER_NAME = "MutableSideEffect";
    public static final String VERSION_MARKER_NAME = "Version";
    public static final String LOCAL_ACTIVITY_MARKER_NAME = "LocalActivity";
    private static final Logger log = LoggerFactory.getLogger(ClockDecisionContext.class);
    private final DecisionsHelper decisions;
    private final Map<Long, OpenRequestInfo<?, Long>> scheduledTimers = new HashMap();
    private long replayCurrentTimeMilliseconds = -1L;
    private long replayTimeUpdatedAtMillis = -1L;
    private boolean replaying = true;
    private final Map<Long, byte[]> sideEffectResults = new HashMap<Long, byte[]>();
    private final MarkerHandler mutableSideEffectHandler;
    private final MarkerHandler versionHandler;
    private final BiFunction<LocalActivityWorker.Task, Duration, Boolean> laTaskPoller;
    private final Map<String, OpenRequestInfo<byte[], ActivityType>> pendingLaTasks = new HashMap<String, OpenRequestInfo<byte[], ActivityType>>();
    private final Map<String, ExecuteLocalActivityParameters> unstartedLaTasks = new HashMap<String, ExecuteLocalActivityParameters>();
    private final ReplayDecider replayDecider;
    private final DataConverter dataConverter;
    private final Lock laTaskLock = new ReentrantLock();
    private final Condition taskCondition = this.laTaskLock.newCondition();
    private boolean taskCompleted = false;

    ClockDecisionContext(DecisionsHelper decisions, BiFunction<LocalActivityWorker.Task, Duration, Boolean> laTaskPoller, ReplayDecider replayDecider, DataConverter dataConverter) {
        this.decisions = decisions;
        this.mutableSideEffectHandler = new MarkerHandler(decisions, MUTABLE_SIDE_EFFECT_MARKER_NAME, () -> this.replaying);
        this.versionHandler = new MarkerHandler(decisions, VERSION_MARKER_NAME, () -> this.replaying);
        this.laTaskPoller = laTaskPoller;
        this.replayDecider = replayDecider;
        this.dataConverter = dataConverter;
    }

    public long currentTimeMillis() {
        return this.replayCurrentTimeMilliseconds;
    }

    private long replayTimeUpdatedAtMillis() {
        return this.replayTimeUpdatedAtMillis;
    }

    void setReplayCurrentTimeMilliseconds(long replayCurrentTimeMilliseconds) {
        if (this.replayCurrentTimeMilliseconds < replayCurrentTimeMilliseconds) {
            this.replayCurrentTimeMilliseconds = replayCurrentTimeMilliseconds;
            this.replayTimeUpdatedAtMillis = System.currentTimeMillis();
        }
    }

    boolean isReplaying() {
        return this.replaying;
    }

    Consumer<Exception> createTimer(long delaySeconds, Consumer<Exception> callback) {
        if (delaySeconds < 0L) {
            throw new IllegalArgumentException("Negative delaySeconds: " + delaySeconds);
        }
        if (delaySeconds == 0L) {
            callback.accept(null);
            return null;
        }
        long firingTime = this.currentTimeMillis() + TimeUnit.SECONDS.toMillis(delaySeconds);
        OpenRequestInfo<Object, Long> context = new OpenRequestInfo<Object, Long>(firingTime);
        StartTimerDecisionAttributes timer = new StartTimerDecisionAttributes();
        timer.setStartToFireTimeoutSeconds(delaySeconds);
        timer.setTimerId(String.valueOf(this.decisions.getAndIncrementNextId()));
        long startEventId = this.decisions.startTimer(timer);
        context.setCompletionHandle((ctx, e) -> callback.accept((Exception)e));
        this.scheduledTimers.put(startEventId, context);
        return new TimerCancellationHandler(startEventId);
    }

    void setReplaying(boolean replaying) {
        this.replaying = replaying;
    }

    void handleTimerFired(TimerFiredEventAttributes attributes) {
        OpenRequestInfo<?, Long> scheduled;
        long startedEventId = attributes.getStartedEventId();
        if (this.decisions.handleTimerClosed(attributes) && (scheduled = this.scheduledTimers.remove(startedEventId)) != null) {
            long firingTime = scheduled.getUserContext();
            if (this.replayCurrentTimeMilliseconds < firingTime) {
                this.setReplayCurrentTimeMilliseconds(firingTime);
            }
            BiConsumer<?, Exception> completionCallback = scheduled.getCompletionCallback();
            completionCallback.accept(null, null);
        }
    }

    void handleTimerCanceled(HistoryEvent event) {
        TimerCanceledEventAttributes attributes = event.getTimerCanceledEventAttributes();
        long startedEventId = attributes.getStartedEventId();
        if (this.decisions.handleTimerCanceled(event)) {
            this.timerCancelled(startedEventId, null);
        }
    }

    private void timerCancelled(long startEventId, Exception reason) {
        OpenRequestInfo<?, Long> scheduled = this.scheduledTimers.remove(startEventId);
        if (scheduled == null) {
            return;
        }
        BiConsumer<?, Exception> context = scheduled.getCompletionCallback();
        CancellationException exception = new CancellationException("Cancelled by request");
        exception.initCause(reason);
        context.accept(null, exception);
    }

    byte[] sideEffect(Functions.Func<byte[]> func) {
        byte[] result;
        this.decisions.addAllMissingVersionMarker(false, Optional.empty());
        long sideEffectEventId = this.decisions.getNextDecisionEventId();
        if (this.replaying) {
            result = this.sideEffectResults.get(sideEffectEventId);
            if (result == null) {
                throw new Error("No cached result found for SideEffect EventID=" + sideEffectEventId);
            }
        } else {
            try {
                result = func.apply();
            }
            catch (Error e) {
                throw e;
            }
            catch (Exception e) {
                throw new Error("sideEffect function failed", e);
            }
        }
        this.decisions.recordMarker(SIDE_EFFECT_MARKER_NAME, null, result);
        return result;
    }

    Optional<byte[]> mutableSideEffect(String id, DataConverter converter, Functions.Func1<Optional<byte[]>, Optional<byte[]>> func) {
        this.decisions.addAllMissingVersionMarker(false, Optional.empty());
        return this.mutableSideEffectHandler.handle(id, converter, func);
    }

    void upsertSearchAttributes(SearchAttributes searchAttributes) {
        this.decisions.upsertSearchAttributes(searchAttributes);
    }

    void handleMarkerRecorded(HistoryEvent event) {
        MarkerRecordedEventAttributes attributes = event.getMarkerRecordedEventAttributes();
        String name = attributes.getMarkerName();
        if (SIDE_EFFECT_MARKER_NAME.equals(name)) {
            this.sideEffectResults.put(event.getEventId(), attributes.getDetails());
        } else if (LOCAL_ACTIVITY_MARKER_NAME.equals(name)) {
            this.handleLocalActivityMarker(attributes);
        } else if (!MUTABLE_SIDE_EFFECT_MARKER_NAME.equals(name) && !VERSION_MARKER_NAME.equals(name) && log.isWarnEnabled()) {
            log.warn("Unexpected marker: " + event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleLocalActivityMarker(MarkerRecordedEventAttributes attributes) {
        LocalActivityMarkerData marker = LocalActivityMarkerData.fromEventAttributes(attributes, this.dataConverter);
        if (this.pendingLaTasks.containsKey(marker.getActivityId())) {
            log.debug("Handle LocalActivityMarker for activity " + marker.getActivityId());
            this.decisions.recordMarker(LOCAL_ACTIVITY_MARKER_NAME, marker.getHeader(this.dataConverter), attributes.getDetails());
            OpenRequestInfo<byte[], ActivityType> scheduled = this.pendingLaTasks.remove(marker.getActivityId());
            this.unstartedLaTasks.remove(marker.getActivityId());
            RuntimeException failure = null;
            if (marker.getIsCancelled()) {
                failure = new CancellationException(marker.getErrReason());
            } else if (marker.getErrJson() != null) {
                Throwable cause = this.dataConverter.fromData(marker.getErrJson(), Throwable.class, (Type)((Object)Throwable.class));
                ActivityType activityType = new ActivityType();
                activityType.setName(marker.getActivityType());
                failure = new ActivityFailureException(attributes.getDecisionTaskCompletedEventId(), activityType, marker.getActivityId(), cause, marker.getAttempt(), marker.getBackoff());
            }
            BiConsumer<byte[], Exception> completionHandle = scheduled.getCompletionCallback();
            completionHandle.accept(marker.getResult(), failure);
            this.setReplayCurrentTimeMilliseconds(marker.getReplayTimeMillis());
            this.laTaskLock.lock();
            try {
                this.taskCompleted = true;
                this.taskCondition.signal();
            }
            finally {
                this.laTaskLock.unlock();
            }
        }
    }

    int getVersion(String changeId, DataConverter converter, int minSupported, int maxSupported) {
        Predicate<MarkerRecordedEventAttributes> changeIdEquals = attributes -> {
            MarkerHandler.MarkerInterface markerData = MarkerHandler.MarkerInterface.fromEventAttributes(attributes, converter);
            return markerData.getId().equals(changeId);
        };
        this.decisions.addAllMissingVersionMarker(true, Optional.of(changeIdEquals));
        Optional<byte[]> result = this.versionHandler.handle(changeId, converter, stored -> {
            if (stored.isPresent()) {
                return Optional.empty();
            }
            return Optional.of(converter.toData(maxSupported));
        });
        if (!result.isPresent()) {
            return -1;
        }
        int version = converter.fromData(result.get(), Integer.class, (Type)((Object)Integer.class));
        this.validateVersion(changeId, version, minSupported, maxSupported);
        return version;
    }

    private void validateVersion(String changeID, int version, int minSupported, int maxSupported) {
        if (version < minSupported || version > maxSupported) {
            throw new Error(String.format("Version %d of changeID %s is not supported. Supported version is between %d and %d.", version, changeID, minSupported, maxSupported));
        }
    }

    Consumer<Exception> scheduleLocalActivityTask(ExecuteLocalActivityParameters params, BiConsumer<byte[], Exception> callback) {
        OpenRequestInfo<byte[], ActivityType> context = new OpenRequestInfo<byte[], ActivityType>(params.getActivityType());
        context.setCompletionHandle(callback);
        if (Strings.isNullOrEmpty((String)params.getActivityId())) {
            params.setActivityId(this.decisions.getAndIncrementNextId());
        }
        this.pendingLaTasks.put(params.getActivityId(), context);
        this.unstartedLaTasks.put(params.getActivityId(), params);
        return null;
    }

    boolean startUnstartedLaTasks(Duration maxWaitAllowed) {
        long startTime = System.currentTimeMillis();
        for (ExecuteLocalActivityParameters params : this.unstartedLaTasks.values()) {
            long currTime = System.currentTimeMillis();
            maxWaitAllowed = maxWaitAllowed.minus(Duration.ofMillis(currTime - startTime));
            boolean applied = this.laTaskPoller.apply(new LocalActivityWorker.Task(params, this.replayDecider, this.replayDecider.getDecisionTimeoutSeconds(), this::currentTimeMillis, this::replayTimeUpdatedAtMillis), maxWaitAllowed);
            if (applied) continue;
            return false;
        }
        this.unstartedLaTasks.clear();
        return true;
    }

    int numPendingLaTasks() {
        return this.pendingLaTasks.size();
    }

    void awaitTaskCompletion(Duration duration) throws InterruptedException {
        this.laTaskLock.lock();
        try {
            while (!this.taskCompleted) {
                this.taskCondition.awaitNanos(duration.toNanos());
            }
            this.taskCompleted = false;
        }
        finally {
            this.laTaskLock.unlock();
        }
    }

    private final class TimerCancellationHandler
    implements Consumer<Exception> {
        private final long startEventId;

        TimerCancellationHandler(long timerId) {
            this.startEventId = timerId;
        }

        @Override
        public void accept(Exception reason) {
            ClockDecisionContext.this.decisions.cancelTimer(this.startEventId, () -> ClockDecisionContext.this.timerCancelled(this.startEventId, reason));
        }
    }
}

