/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.common;

import com.google.common.io.CharStreams;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.uber.cadence.ActivityType;
import com.uber.cadence.BadRequestError;
import com.uber.cadence.Decision;
import com.uber.cadence.DecisionType;
import com.uber.cadence.DescribeWorkflowExecutionRequest;
import com.uber.cadence.DescribeWorkflowExecutionResponse;
import com.uber.cadence.EntityNotExistsError;
import com.uber.cadence.EventType;
import com.uber.cadence.GetWorkflowExecutionHistoryRequest;
import com.uber.cadence.GetWorkflowExecutionHistoryResponse;
import com.uber.cadence.History;
import com.uber.cadence.HistoryEvent;
import com.uber.cadence.HistoryEventFilterType;
import com.uber.cadence.TaskList;
import com.uber.cadence.WorkflowExecution;
import com.uber.cadence.WorkflowExecutionCloseStatus;
import com.uber.cadence.WorkflowExecutionContinuedAsNewEventAttributes;
import com.uber.cadence.WorkflowExecutionFailedEventAttributes;
import com.uber.cadence.WorkflowExecutionInfo;
import com.uber.cadence.WorkflowExecutionTerminatedEventAttributes;
import com.uber.cadence.WorkflowExecutionTimedOutEventAttributes;
import com.uber.cadence.WorkflowType;
import com.uber.cadence.client.WorkflowTerminatedException;
import com.uber.cadence.client.WorkflowTimedOutException;
import com.uber.cadence.common.RetryOptions;
import com.uber.cadence.common.WorkflowExecutionHistory;
import com.uber.cadence.internal.common.CheckedExceptionWrapper;
import com.uber.cadence.internal.common.Retryer;
import com.uber.cadence.internal.common.WorkflowExecutionFailedException;
import com.uber.cadence.serviceclient.IWorkflowService;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.time.Duration;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.async.AsyncMethodCallback;

public class WorkflowExecutionUtils {
    private static final String INDENTATION = "  ";
    private static RetryOptions retryParameters = new RetryOptions.Builder().setBackoffCoefficient(2.0).setInitialInterval(Duration.ofMillis(500L)).setMaximumInterval(Duration.ofSeconds(30L)).setMaximumAttempts(Integer.MAX_VALUE).setDoNotRetry(BadRequestError.class, EntityNotExistsError.class).build();

    public static byte[] getWorkflowExecutionResult(IWorkflowService service, String domain, WorkflowExecution workflowExecution, Optional<String> workflowType, long timeout, TimeUnit unit) throws TimeoutException, CancellationException, WorkflowExecutionFailedException, WorkflowTerminatedException, WorkflowTimedOutException, EntityNotExistsError {
        HistoryEvent closeEvent = WorkflowExecutionUtils.getInstanceCloseEvent(service, domain, workflowExecution, timeout, unit);
        return WorkflowExecutionUtils.getResultFromCloseEvent(workflowExecution, workflowType, closeEvent);
    }

    public static CompletableFuture<byte[]> getWorkflowExecutionResultAsync(IWorkflowService service, String domain, WorkflowExecution workflowExecution, Optional<String> workflowType, long timeout, TimeUnit unit) {
        return WorkflowExecutionUtils.getInstanceCloseEventAsync(service, domain, workflowExecution, timeout, unit).thenApply(closeEvent -> WorkflowExecutionUtils.getResultFromCloseEvent(workflowExecution, workflowType, closeEvent));
    }

    private static byte[] getResultFromCloseEvent(WorkflowExecution workflowExecution, Optional<String> workflowType, HistoryEvent closeEvent) {
        if (closeEvent == null) {
            throw new IllegalStateException("Workflow is still running");
        }
        switch (closeEvent.getEventType()) {
            case WorkflowExecutionCompleted: {
                return closeEvent.getWorkflowExecutionCompletedEventAttributes().getResult();
            }
            case WorkflowExecutionCanceled: {
                byte[] details = closeEvent.getWorkflowExecutionCanceledEventAttributes().getDetails();
                String message = details != null ? new String(details, StandardCharsets.UTF_8) : null;
                throw new CancellationException(message);
            }
            case WorkflowExecutionFailed: {
                WorkflowExecutionFailedEventAttributes failed = closeEvent.getWorkflowExecutionFailedEventAttributes();
                throw new WorkflowExecutionFailedException(failed.getReason(), failed.getDetails(), failed.getDecisionTaskCompletedEventId());
            }
            case WorkflowExecutionTerminated: {
                WorkflowExecutionTerminatedEventAttributes terminated = closeEvent.getWorkflowExecutionTerminatedEventAttributes();
                throw new WorkflowTerminatedException(workflowExecution, workflowType, terminated.getReason(), terminated.getIdentity(), terminated.getDetails());
            }
            case WorkflowExecutionTimedOut: {
                WorkflowExecutionTimedOutEventAttributes timedOut = closeEvent.getWorkflowExecutionTimedOutEventAttributes();
                throw new WorkflowTimedOutException(workflowExecution, workflowType, timedOut.getTimeoutType());
            }
        }
        throw new RuntimeException("Workflow end state is not completed: " + WorkflowExecutionUtils.prettyPrintHistoryEvent(closeEvent));
    }

    public static HistoryEvent getInstanceCloseEvent(IWorkflowService service, String domain, WorkflowExecution workflowExecution, long timeout, TimeUnit unit) throws TimeoutException, EntityNotExistsError {
        HistoryEvent event;
        byte[] pageToken = null;
        long start = System.currentTimeMillis();
        while (true) {
            GetWorkflowExecutionHistoryResponse response;
            GetWorkflowExecutionHistoryRequest r = new GetWorkflowExecutionHistoryRequest();
            r.setDomain(domain);
            r.setExecution(workflowExecution);
            r.setHistoryEventFilterType(HistoryEventFilterType.CLOSE_EVENT);
            r.setNextPageToken(pageToken);
            r.setWaitForNewEvent(true);
            try {
                response = Retryer.retryWithResult(retryParameters, () -> service.GetWorkflowExecutionHistory(r));
            }
            catch (EntityNotExistsError e) {
                throw e;
            }
            catch (TException e) {
                throw CheckedExceptionWrapper.wrap(e);
            }
            if (timeout != 0L && System.currentTimeMillis() - start > unit.toMillis(timeout)) {
                throw new TimeoutException("WorkflowId=" + workflowExecution.getWorkflowId() + ", runId=" + workflowExecution.getRunId() + ", timeout=" + timeout + ", unit=" + (Object)((Object)unit));
            }
            pageToken = response.getNextPageToken();
            History history = response.getHistory();
            if (history == null || history.getEvents().size() <= 0) continue;
            event = history.getEvents().get(0);
            if (!WorkflowExecutionUtils.isWorkflowExecutionCompletedEvent(event)) {
                throw new RuntimeException("Last history event is not completion event: " + event);
            }
            if (event.getEventType() != EventType.WorkflowExecutionContinuedAsNew) break;
            pageToken = null;
            workflowExecution = new WorkflowExecution().setWorkflowId(workflowExecution.getWorkflowId()).setRunId(event.getWorkflowExecutionContinuedAsNewEventAttributes().getNewExecutionRunId());
        }
        return event;
    }

    private static CompletableFuture<HistoryEvent> getInstanceCloseEventAsync(IWorkflowService service, String domain, WorkflowExecution workflowExecution, long timeout, TimeUnit unit) {
        return WorkflowExecutionUtils.getInstanceCloseEventAsync(service, domain, workflowExecution, null, timeout, unit);
    }

    private static CompletableFuture<HistoryEvent> getInstanceCloseEventAsync(IWorkflowService service, String domain, WorkflowExecution workflowExecution, byte[] pageToken, long timeout, TimeUnit unit) {
        long start = System.currentTimeMillis();
        GetWorkflowExecutionHistoryRequest request = new GetWorkflowExecutionHistoryRequest();
        request.setDomain(domain);
        request.setExecution(workflowExecution);
        request.setHistoryEventFilterType(HistoryEventFilterType.CLOSE_EVENT);
        request.setNextPageToken(pageToken);
        CompletableFuture<GetWorkflowExecutionHistoryResponse> response = WorkflowExecutionUtils.getWorkflowExecutionHistoryAsync(service, request);
        return response.thenComposeAsync(r -> {
            if (timeout != 0L && System.currentTimeMillis() - start > unit.toMillis(timeout)) {
                throw CheckedExceptionWrapper.wrap(new TimeoutException("WorkflowId=" + workflowExecution.getWorkflowId() + ", runId=" + workflowExecution.getRunId() + ", timeout=" + timeout + ", unit=" + (Object)((Object)unit)));
            }
            History history = r.getHistory();
            if (history == null || history.getEvents().size() == 0) {
                return WorkflowExecutionUtils.getInstanceCloseEventAsync(service, domain, workflowExecution, pageToken, timeout, unit);
            }
            HistoryEvent event = history.getEvents().get(0);
            if (!WorkflowExecutionUtils.isWorkflowExecutionCompletedEvent(event)) {
                throw new RuntimeException("Last history event is not completion event: " + event);
            }
            if (event.getEventType() == EventType.WorkflowExecutionContinuedAsNew) {
                WorkflowExecution nextWorkflowExecution = new WorkflowExecution().setWorkflowId(workflowExecution.getWorkflowId()).setRunId(event.getWorkflowExecutionContinuedAsNewEventAttributes().getNewExecutionRunId());
                return WorkflowExecutionUtils.getInstanceCloseEventAsync(service, domain, nextWorkflowExecution, r.getNextPageToken(), timeout, unit);
            }
            return CompletableFuture.completedFuture(event);
        });
    }

    private static CompletableFuture<GetWorkflowExecutionHistoryResponse> getWorkflowExecutionHistoryAsync(IWorkflowService service, GetWorkflowExecutionHistoryRequest r) {
        return Retryer.retryWithResultAsync(retryParameters, () -> {
            final CompletableFuture result = new CompletableFuture();
            try {
                service.GetWorkflowExecutionHistory(r, (AsyncMethodCallback)new AsyncMethodCallback<GetWorkflowExecutionHistoryResponse>(){

                    public void onComplete(GetWorkflowExecutionHistoryResponse response) {
                        result.complete(response);
                    }

                    public void onError(Exception exception) {
                        result.completeExceptionally(exception);
                    }
                });
            }
            catch (TException e) {
                result.completeExceptionally(e);
            }
            return result;
        });
    }

    public static boolean isWorkflowExecutionCompletedEvent(HistoryEvent event) {
        return event != null && (event.getEventType() == EventType.WorkflowExecutionCompleted || event.getEventType() == EventType.WorkflowExecutionCanceled || event.getEventType() == EventType.WorkflowExecutionFailed || event.getEventType() == EventType.WorkflowExecutionTimedOut || event.getEventType() == EventType.WorkflowExecutionContinuedAsNew || event.getEventType() == EventType.WorkflowExecutionTerminated);
    }

    public static boolean isWorkflowExecutionCompleteDecision(Decision decision) {
        return decision != null && (decision.getDecisionType() == DecisionType.CompleteWorkflowExecution || decision.getDecisionType() == DecisionType.CancelWorkflowExecution || decision.getDecisionType() == DecisionType.FailWorkflowExecution || decision.getDecisionType() == DecisionType.ContinueAsNewWorkflowExecution);
    }

    public static boolean isActivityTaskClosedEvent(HistoryEvent event) {
        return event != null && (event.getEventType() == EventType.ActivityTaskCompleted || event.getEventType() == EventType.ActivityTaskCanceled || event.getEventType() == EventType.ActivityTaskFailed || event.getEventType() == EventType.ActivityTaskTimedOut);
    }

    public static boolean isExternalWorkflowClosedEvent(HistoryEvent event) {
        return event != null && (event.getEventType() == EventType.ChildWorkflowExecutionCompleted || event.getEventType() == EventType.ChildWorkflowExecutionCanceled || event.getEventType() == EventType.ChildWorkflowExecutionFailed || event.getEventType() == EventType.ChildWorkflowExecutionTerminated || event.getEventType() == EventType.ChildWorkflowExecutionTimedOut);
    }

    public static WorkflowExecution getWorkflowIdFromExternalWorkflowCompletedEvent(HistoryEvent event) {
        if (event != null) {
            if (event.getEventType() == EventType.ChildWorkflowExecutionCompleted) {
                return event.getChildWorkflowExecutionCompletedEventAttributes().getWorkflowExecution();
            }
            if (event.getEventType() == EventType.ChildWorkflowExecutionCanceled) {
                return event.getChildWorkflowExecutionCanceledEventAttributes().getWorkflowExecution();
            }
            if (event.getEventType() == EventType.ChildWorkflowExecutionFailed) {
                return event.getChildWorkflowExecutionFailedEventAttributes().getWorkflowExecution();
            }
            if (event.getEventType() == EventType.ChildWorkflowExecutionTerminated) {
                return event.getChildWorkflowExecutionTerminatedEventAttributes().getWorkflowExecution();
            }
            if (event.getEventType() == EventType.ChildWorkflowExecutionTimedOut) {
                return event.getChildWorkflowExecutionTimedOutEventAttributes().getWorkflowExecution();
            }
        }
        return null;
    }

    public static String getId(HistoryEvent historyEvent) {
        String id = null;
        if (historyEvent != null && historyEvent.getEventType() == EventType.StartChildWorkflowExecutionFailed) {
            id = historyEvent.getStartChildWorkflowExecutionFailedEventAttributes().getWorkflowId();
        }
        return id;
    }

    public static String getFailureCause(HistoryEvent historyEvent) {
        String failureCause = null;
        if (historyEvent != null) {
            failureCause = historyEvent.getEventType() == EventType.StartChildWorkflowExecutionFailed ? historyEvent.getStartChildWorkflowExecutionFailedEventAttributes().getCause().toString() : "Cannot extract failure cause from " + (Object)((Object)historyEvent.getEventType());
        }
        return failureCause;
    }

    public static WorkflowExecutionCloseStatus waitForWorkflowInstanceCompletion(IWorkflowService service, String domain, WorkflowExecution workflowExecution) throws EntityNotExistsError {
        try {
            return WorkflowExecutionUtils.waitForWorkflowInstanceCompletion(service, domain, workflowExecution, 0L, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            throw new Error("should never happen", e);
        }
    }

    public static WorkflowExecutionCloseStatus waitForWorkflowInstanceCompletion(IWorkflowService service, String domain, WorkflowExecution workflowExecution, long timeout, TimeUnit unit) throws TimeoutException, EntityNotExistsError {
        HistoryEvent closeEvent = WorkflowExecutionUtils.getInstanceCloseEvent(service, domain, workflowExecution, timeout, unit);
        return WorkflowExecutionUtils.getCloseStatus(closeEvent);
    }

    public static WorkflowExecutionCloseStatus getCloseStatus(HistoryEvent event) {
        switch (event.getEventType()) {
            case WorkflowExecutionCanceled: {
                return WorkflowExecutionCloseStatus.CANCELED;
            }
            case WorkflowExecutionFailed: {
                return WorkflowExecutionCloseStatus.FAILED;
            }
            case WorkflowExecutionTimedOut: {
                return WorkflowExecutionCloseStatus.TIMED_OUT;
            }
            case WorkflowExecutionContinuedAsNew: {
                return WorkflowExecutionCloseStatus.CONTINUED_AS_NEW;
            }
            case WorkflowExecutionCompleted: {
                return WorkflowExecutionCloseStatus.COMPLETED;
            }
            case WorkflowExecutionTerminated: {
                return WorkflowExecutionCloseStatus.TERMINATED;
            }
        }
        throw new IllegalArgumentException("Not close event: " + event);
    }

    public static WorkflowExecutionCloseStatus waitForWorkflowInstanceCompletionAcrossGenerations(IWorkflowService service, String domain, WorkflowExecution workflowExecution, long timeout, TimeUnit unit) throws TimeoutException, EntityNotExistsError {
        WorkflowExecution lastExecutionToRun = workflowExecution;
        long millisecondsAtFirstWait = System.currentTimeMillis();
        WorkflowExecutionCloseStatus lastExecutionToRunCloseStatus = WorkflowExecutionUtils.waitForWorkflowInstanceCompletion(service, domain, lastExecutionToRun, timeout, unit);
        while (lastExecutionToRunCloseStatus == WorkflowExecutionCloseStatus.CONTINUED_AS_NEW) {
            HistoryEvent closeEvent = WorkflowExecutionUtils.getInstanceCloseEvent(service, domain, lastExecutionToRun, timeout, unit);
            WorkflowExecutionContinuedAsNewEventAttributes continuedAsNewAttributes = closeEvent.getWorkflowExecutionContinuedAsNewEventAttributes();
            WorkflowExecution newGenerationExecution = new WorkflowExecution();
            newGenerationExecution.setRunId(continuedAsNewAttributes.getNewExecutionRunId());
            newGenerationExecution.setWorkflowId(lastExecutionToRun.getWorkflowId());
            long currentTime = System.currentTimeMillis();
            long millisecondsSinceFirstWait = currentTime - millisecondsAtFirstWait;
            long timeoutInSecondsForNextWait = unit.toMillis(timeout) - millisecondsSinceFirstWait / 1000L;
            lastExecutionToRunCloseStatus = WorkflowExecutionUtils.waitForWorkflowInstanceCompletion(service, domain, newGenerationExecution, timeoutInSecondsForNextWait, TimeUnit.MILLISECONDS);
            lastExecutionToRun = newGenerationExecution;
        }
        return lastExecutionToRunCloseStatus;
    }

    public static WorkflowExecutionCloseStatus waitForWorkflowInstanceCompletionAcrossGenerations(IWorkflowService service, String domain, WorkflowExecution workflowExecution) throws InterruptedException, EntityNotExistsError {
        try {
            return WorkflowExecutionUtils.waitForWorkflowInstanceCompletionAcrossGenerations(service, domain, workflowExecution, 0L, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            throw new Error("should never happen", e);
        }
    }

    public static WorkflowExecutionInfo describeWorkflowInstance(IWorkflowService service, String domain, WorkflowExecution workflowExecution) {
        DescribeWorkflowExecutionRequest describeRequest = new DescribeWorkflowExecutionRequest();
        describeRequest.setDomain(domain);
        describeRequest.setExecution(workflowExecution);
        DescribeWorkflowExecutionResponse executionDetail = null;
        try {
            executionDetail = service.DescribeWorkflowExecution(describeRequest);
        }
        catch (TException e) {
            throw new RuntimeException(e);
        }
        WorkflowExecutionInfo instanceMetadata = executionDetail.getWorkflowExecutionInfo();
        return instanceMetadata;
    }

    public static GetWorkflowExecutionHistoryResponse getHistoryPage(byte[] nextPageToken, IWorkflowService service, String domain, WorkflowExecution workflowExecution) {
        GetWorkflowExecutionHistoryResponse history;
        GetWorkflowExecutionHistoryRequest getHistoryRequest = new GetWorkflowExecutionHistoryRequest();
        getHistoryRequest.setDomain(domain);
        getHistoryRequest.setExecution(workflowExecution);
        getHistoryRequest.setNextPageToken(nextPageToken);
        try {
            history = service.GetWorkflowExecutionHistory(getHistoryRequest);
        }
        catch (TException e) {
            throw new Error(e);
        }
        if (history == null) {
            throw new IllegalArgumentException("unknown workflow execution: " + workflowExecution);
        }
        return history;
    }

    public static String prettyPrintHistory(IWorkflowService service, String domain, WorkflowExecution workflowExecution) {
        return WorkflowExecutionUtils.prettyPrintHistory(service, domain, workflowExecution, true);
    }

    public static String prettyPrintHistory(IWorkflowService service, String domain, WorkflowExecution workflowExecution, boolean showWorkflowTasks) {
        Iterator<HistoryEvent> events = WorkflowExecutionUtils.getHistory(service, domain, workflowExecution);
        return WorkflowExecutionUtils.prettyPrintHistory(events, showWorkflowTasks);
    }

    public static Iterator<HistoryEvent> getHistory(final IWorkflowService service, final String domain, final WorkflowExecution workflowExecution) {
        return new Iterator<HistoryEvent>(){
            byte[] nextPageToken;
            Iterator<HistoryEvent> current;
            {
                this.getNextPage();
            }

            @Override
            public boolean hasNext() {
                return this.current.hasNext() || this.nextPageToken != null;
            }

            @Override
            public HistoryEvent next() {
                if (this.current.hasNext()) {
                    return this.current.next();
                }
                this.getNextPage();
                return this.current.next();
            }

            private void getNextPage() {
                GetWorkflowExecutionHistoryResponse history = WorkflowExecutionUtils.getHistoryPage(this.nextPageToken, service, domain, workflowExecution);
                this.current = history.getHistory().getEvents().iterator();
                this.nextPageToken = history.getNextPageToken();
            }
        };
    }

    public static String prettyPrintHistory(History history, boolean showWorkflowTasks) {
        return WorkflowExecutionUtils.prettyPrintHistory(history.getEvents().iterator(), showWorkflowTasks);
    }

    public static String prettyPrintHistory(Iterator<HistoryEvent> events, boolean showWorkflowTasks) {
        StringBuilder result = new StringBuilder();
        result.append("{");
        boolean first = true;
        long firstTimestamp = 0L;
        while (events.hasNext()) {
            HistoryEvent event = events.next();
            if (!showWorkflowTasks && event.getEventType().toString().startsWith("WorkflowTask")) continue;
            if (first) {
                first = false;
                firstTimestamp = event.getTimestamp();
            } else {
                result.append(",");
            }
            result.append("\n");
            result.append(INDENTATION);
            result.append(WorkflowExecutionUtils.prettyPrintHistoryEvent(event, firstTimestamp));
        }
        result.append("\n}");
        return result.toString();
    }

    public static String prettyPrintDecisions(Iterable<Decision> decisions) {
        StringBuilder result = new StringBuilder();
        result.append("{");
        boolean first = true;
        for (Decision decision : decisions) {
            if (first) {
                first = false;
            } else {
                result.append(",");
            }
            result.append("\n");
            result.append(INDENTATION);
            result.append(WorkflowExecutionUtils.prettyPrintDecision(decision));
        }
        result.append("\n}");
        return result.toString();
    }

    public static String prettyPrintHistoryEvent(HistoryEvent event) {
        return WorkflowExecutionUtils.prettyPrintHistoryEvent(event, -1L);
    }

    private static String prettyPrintHistoryEvent(HistoryEvent event, long firstTimestamp) {
        String eventType = event.getEventType().toString();
        StringBuilder result = new StringBuilder();
        result.append(event.getEventId());
        result.append(": ");
        result.append(eventType);
        if (firstTimestamp > 0L) {
            long timestamp = (event.getTimestamp() - firstTimestamp) / 1000000L;
            result.append(String.format(" [%s ms]", timestamp));
        }
        result.append(" ");
        result.append(WorkflowExecutionUtils.prettyPrintObject(WorkflowExecutionUtils.getEventAttributes(event), "getFieldValue", true, INDENTATION, false, false));
        return result.toString();
    }

    private static Object getEventAttributes(HistoryEvent event) {
        try {
            Method m = HistoryEvent.class.getMethod("get" + (Object)((Object)event.getEventType()) + "EventAttributes", new Class[0]);
            return m.invoke((Object)event, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            return event;
        }
    }

    public static String prettyPrintDecision(Decision decision) {
        return WorkflowExecutionUtils.prettyPrintObject(decision, "getFieldValue", true, INDENTATION, true, true);
    }

    private static String prettyPrintObject(Object object, String methodToSkip, boolean skipNullsAndEmptyCollections, String indentation, boolean skipLevel, boolean printTypeName) {
        StringBuilder result = new StringBuilder();
        if (object == null) {
            return "null";
        }
        Class<?> clz = object.getClass();
        if (Number.class.isAssignableFrom(clz)) {
            return String.valueOf(object);
        }
        if (Boolean.class.isAssignableFrom(clz)) {
            return String.valueOf(object);
        }
        if (clz.equals(String.class)) {
            return (String)object;
        }
        if (clz.equals(byte[].class)) {
            return new String((byte[])object, StandardCharsets.UTF_8);
        }
        if (ByteBuffer.class.isAssignableFrom(clz)) {
            byte[] bytes = TBaseHelper.byteBufferToByteArray((ByteBuffer)((ByteBuffer)object));
            return new String(bytes, StandardCharsets.UTF_8);
        }
        if (clz.equals(Date.class)) {
            return String.valueOf(object);
        }
        if (clz.equals(TaskList.class)) {
            return String.valueOf(((TaskList)object).getName());
        }
        if (clz.equals(ActivityType.class)) {
            return String.valueOf(((ActivityType)object).getName());
        }
        if (clz.equals(WorkflowType.class)) {
            return String.valueOf(((WorkflowType)object).getName());
        }
        if (Map.Entry.class.isAssignableFrom(clz)) {
            result.append(WorkflowExecutionUtils.prettyPrintObject(((Map.Entry)object).getKey(), methodToSkip, skipNullsAndEmptyCollections, "", skipLevel, printTypeName));
            result.append("=");
            result.append(WorkflowExecutionUtils.prettyPrintObject(((Map.Entry)object).getValue(), methodToSkip, skipNullsAndEmptyCollections, "", skipLevel, printTypeName));
            return result.toString();
        }
        if (Map.class.isAssignableFrom(clz)) {
            result.append("{ ");
            String prefix = "";
            for (Map.Entry entry : ((Map)object).entrySet()) {
                result.append(prefix);
                prefix = ", ";
                result.append(WorkflowExecutionUtils.prettyPrintObject(entry, methodToSkip, skipNullsAndEmptyCollections, "", skipLevel, printTypeName));
            }
            result.append(" }");
            return result.toString();
        }
        if (Collection.class.isAssignableFrom(clz)) {
            return String.valueOf(object);
        }
        if (!skipLevel) {
            if (printTypeName) {
                result.append(object.getClass().getSimpleName());
                result.append(" ");
            }
            result.append("{");
        }
        Method[] eventMethods = object.getClass().getDeclaredMethods();
        boolean first = true;
        for (Method method : eventMethods) {
            Object value;
            String name = method.getName();
            if (!name.startsWith("get") || name.equals("getDecisionType") || method.getParameterCount() != 0 || !Modifier.isPublic(method.getModifiers()) || name.equals(methodToSkip) || name.equals("getClass") || Modifier.isStatic(method.getModifiers())) continue;
            try {
                value = method.invoke(object, (Object[])null);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e.getTargetException());
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (skipNullsAndEmptyCollections && (value == null || value instanceof Map && ((Map)value).isEmpty() || value instanceof Collection && ((Collection)value).isEmpty())) continue;
            if (!skipLevel) {
                if (first) {
                    first = false;
                } else {
                    result.append(";");
                }
                result.append("\n");
                result.append(indentation);
                result.append(INDENTATION);
                result.append(name.substring(3));
                result.append(" = ");
                if (name.equals("getDetails") && value instanceof byte[]) {
                    String details = new String((byte[])value, StandardCharsets.UTF_8);
                    details = WorkflowExecutionUtils.prettyPrintJson(details, "    ");
                    String replacement = "\n" + indentation + INDENTATION;
                    details = details.replaceAll("\\n|\\\\n", replacement);
                    result.append(details);
                    continue;
                }
                result.append(WorkflowExecutionUtils.prettyPrintObject(value, methodToSkip, skipNullsAndEmptyCollections, indentation + INDENTATION, false, false));
                continue;
            }
            result.append(WorkflowExecutionUtils.prettyPrintObject(value, methodToSkip, skipNullsAndEmptyCollections, indentation, false, printTypeName));
        }
        if (!skipLevel) {
            result.append("\n");
            result.append(indentation);
            result.append("}");
        }
        return result.toString();
    }

    public static boolean containsEvent(List<HistoryEvent> history, EventType eventType) {
        for (HistoryEvent event : history) {
            if (event.getEventType() != eventType) continue;
            return true;
        }
        return false;
    }

    private static String prettyPrintJson(String jsonValue, String stackIndentation) {
        JsonParser parser = new JsonParser();
        try {
            JsonObject json = parser.parse(jsonValue).getAsJsonObject();
            WorkflowExecutionUtils.fixStackTrace((JsonElement)json, stackIndentation);
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            return gson.toJson((JsonElement)json);
        }
        catch (Exception e) {
            return jsonValue;
        }
    }

    private static void fixStackTrace(JsonElement json, String stackIndentation) {
        if (!json.isJsonObject()) {
            return;
        }
        for (Map.Entry entry : json.getAsJsonObject().entrySet()) {
            if ("stackTrace".equals(entry.getKey())) {
                String value = ((JsonElement)entry.getValue()).getAsString();
                String replacement = "\n" + stackIndentation;
                String fixed = value.replaceAll("\\n", replacement);
                entry.setValue(new JsonPrimitive(fixed));
                continue;
            }
            WorkflowExecutionUtils.fixStackTrace((JsonElement)entry.getValue(), stackIndentation + INDENTATION);
        }
    }

    public static boolean isDecisionEvent(HistoryEvent event) {
        EventType eventType = event.getEventType();
        boolean result = event != null && (eventType == EventType.ActivityTaskScheduled || eventType == EventType.StartChildWorkflowExecutionInitiated || eventType == EventType.TimerStarted || eventType == EventType.WorkflowExecutionCompleted || eventType == EventType.WorkflowExecutionFailed || eventType == EventType.WorkflowExecutionCanceled || eventType == EventType.WorkflowExecutionContinuedAsNew || eventType == EventType.ActivityTaskCancelRequested || eventType == EventType.RequestCancelActivityTaskFailed || eventType == EventType.TimerCanceled || eventType == EventType.CancelTimerFailed || eventType == EventType.RequestCancelExternalWorkflowExecutionInitiated || eventType == EventType.MarkerRecorded || eventType == EventType.SignalExternalWorkflowExecutionInitiated || eventType == EventType.UpsertWorkflowSearchAttributes);
        return result;
    }

    public static EventType getEventTypeForDecision(DecisionType decisionType) {
        switch (decisionType) {
            case ScheduleActivityTask: {
                return EventType.ActivityTaskScheduled;
            }
            case RequestCancelActivityTask: {
                return EventType.ActivityTaskCancelRequested;
            }
            case StartTimer: {
                return EventType.TimerStarted;
            }
            case CompleteWorkflowExecution: {
                return EventType.WorkflowExecutionCompleted;
            }
            case FailWorkflowExecution: {
                return EventType.WorkflowExecutionFailed;
            }
            case CancelTimer: {
                return EventType.TimerCanceled;
            }
            case CancelWorkflowExecution: {
                return EventType.WorkflowExecutionCanceled;
            }
            case RequestCancelExternalWorkflowExecution: {
                return EventType.ExternalWorkflowExecutionCancelRequested;
            }
            case RecordMarker: {
                return EventType.MarkerRecorded;
            }
            case ContinueAsNewWorkflowExecution: {
                return EventType.WorkflowExecutionContinuedAsNew;
            }
            case StartChildWorkflowExecution: {
                return EventType.StartChildWorkflowExecutionInitiated;
            }
            case SignalExternalWorkflowExecution: {
                return EventType.SignalExternalWorkflowExecutionInitiated;
            }
            case UpsertWorkflowSearchAttributes: {
                return EventType.UpsertWorkflowSearchAttributes;
            }
        }
        throw new IllegalArgumentException("Unknown decisionType");
    }

    public static WorkflowExecutionHistory readHistoryFromResource(String resourceFileName) throws IOException {
        ClassLoader classLoader = WorkflowExecutionUtils.class.getClassLoader();
        String historyUrl = classLoader.getResource(resourceFileName).getFile();
        File historyFile = new File(historyUrl);
        return WorkflowExecutionUtils.readHistory(historyFile);
    }

    public static WorkflowExecutionHistory readHistory(File historyFile) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(historyFile.toPath(), StandardCharsets.UTF_8);){
            String jsonHistory = CharStreams.toString((Readable)reader);
            WorkflowExecutionHistory workflowExecutionHistory = WorkflowExecutionHistory.fromJson(jsonHistory);
            return workflowExecutionHistory;
        }
    }
}

