/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.common;

import com.uber.cadence.ChildPolicy;
import com.uber.cadence.WorkflowIdReusePolicy;
import com.uber.cadence.WorkflowType;
import com.uber.cadence.client.WorkflowOptions;
import com.uber.cadence.common.RetryOptions;
import com.uber.cadence.internal.common.RetryParameters;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class StartWorkflowExecutionParameters {
    private String workflowId;
    private WorkflowType workflowType;
    private String taskList;
    private byte[] input;
    private long executionStartToCloseTimeoutSeconds;
    private long taskStartToCloseTimeoutSeconds;
    private ChildPolicy childPolicy;
    private WorkflowIdReusePolicy workflowIdReusePolicy;
    private RetryParameters retryParameters;
    private String cronSchedule;
    private Map<String, byte[]> memo;
    private Map<String, byte[]> searchAttributes;

    public String getWorkflowId() {
        return this.workflowId;
    }

    public void setWorkflowId(String workflowId) {
        this.workflowId = workflowId;
    }

    public StartWorkflowExecutionParameters withWorkflowId(String workflowId) {
        this.workflowId = workflowId;
        return this;
    }

    public WorkflowType getWorkflowType() {
        return this.workflowType;
    }

    public void setWorkflowType(WorkflowType workflowType) {
        this.workflowType = workflowType;
    }

    public StartWorkflowExecutionParameters withWorkflowType(WorkflowType workflowType) {
        this.workflowType = workflowType;
        return this;
    }

    public WorkflowIdReusePolicy getWorkflowIdReusePolicy() {
        return this.workflowIdReusePolicy;
    }

    public void setWorkflowIdReusePolicy(WorkflowIdReusePolicy workflowIdReusePolicy) {
        this.workflowIdReusePolicy = workflowIdReusePolicy;
    }

    public StartWorkflowExecutionParameters withWorkflowIdReusePolicy(WorkflowIdReusePolicy workflowIdReusePolicy) {
        this.workflowIdReusePolicy = workflowIdReusePolicy;
        return this;
    }

    public String getTaskList() {
        return this.taskList;
    }

    public void setTaskList(String taskList) {
        this.taskList = taskList;
    }

    public StartWorkflowExecutionParameters withTaskList(String taskList) {
        this.taskList = taskList;
        return this;
    }

    public byte[] getInput() {
        return this.input;
    }

    public void setInput(byte[] input) {
        this.input = input;
    }

    public StartWorkflowExecutionParameters withInput(byte[] input) {
        this.input = input;
        return this;
    }

    public long getExecutionStartToCloseTimeoutSeconds() {
        return this.executionStartToCloseTimeoutSeconds;
    }

    public void setExecutionStartToCloseTimeoutSeconds(long executionStartToCloseTimeoutSeconds) {
        this.executionStartToCloseTimeoutSeconds = executionStartToCloseTimeoutSeconds;
    }

    public StartWorkflowExecutionParameters withExecutionStartToCloseTimeoutSeconds(long executionStartToCloseTimeoutSeconds) {
        this.executionStartToCloseTimeoutSeconds = executionStartToCloseTimeoutSeconds;
        return this;
    }

    public long getTaskStartToCloseTimeoutSeconds() {
        return this.taskStartToCloseTimeoutSeconds;
    }

    public void setTaskStartToCloseTimeoutSeconds(long taskStartToCloseTimeoutSeconds) {
        this.taskStartToCloseTimeoutSeconds = taskStartToCloseTimeoutSeconds;
    }

    public StartWorkflowExecutionParameters withTaskStartToCloseTimeoutSeconds(int taskStartToCloseTimeoutSeconds) {
        this.taskStartToCloseTimeoutSeconds = taskStartToCloseTimeoutSeconds;
        return this;
    }

    public ChildPolicy getChildPolicy() {
        return this.childPolicy;
    }

    public void setChildPolicy(ChildPolicy childPolicy) {
        this.childPolicy = childPolicy;
    }

    public StartWorkflowExecutionParameters withChildPolicy(ChildPolicy childPolicy) {
        this.childPolicy = childPolicy;
        return this;
    }

    public RetryParameters getRetryParameters() {
        return this.retryParameters;
    }

    public void setRetryParameters(RetryParameters retryParameters) {
        this.retryParameters = retryParameters;
    }

    public String getCronSchedule() {
        return this.cronSchedule;
    }

    public void setCronSchedule(String cronSchedule) {
        this.cronSchedule = cronSchedule;
    }

    public Map<String, byte[]> getMemo() {
        return this.memo;
    }

    public void setMemo(Map<String, byte[]> memo) {
        this.memo = memo;
    }

    public Map<String, byte[]> getSearchAttributes() {
        return this.searchAttributes;
    }

    public void setSearchAttributes(Map<String, byte[]> searchAttributes) {
        this.searchAttributes = searchAttributes;
    }

    public StartWorkflowExecutionParameters withRetryParameters(RetryParameters retryParameters) {
        this.retryParameters = retryParameters;
        return this;
    }

    public static StartWorkflowExecutionParameters fromWorkflowOptions(WorkflowOptions options) {
        StartWorkflowExecutionParameters parameters = new StartWorkflowExecutionParameters();
        parameters.setExecutionStartToCloseTimeoutSeconds(StartWorkflowExecutionParameters.getSeconds(options.getExecutionStartToCloseTimeout()));
        parameters.setTaskStartToCloseTimeoutSeconds(StartWorkflowExecutionParameters.getSeconds(options.getTaskStartToCloseTimeout()));
        parameters.setTaskList(options.getTaskList());
        parameters.setChildPolicy(options.getChildPolicy());
        parameters.setWorkflowIdReusePolicy(options.getWorkflowIdReusePolicy());
        RetryOptions retryOptions = options.getRetryOptions();
        if (retryOptions != null) {
            RetryParameters rp = new RetryParameters();
            rp.setBackoffCoefficient(retryOptions.getBackoffCoefficient());
            rp.setExpirationIntervalInSeconds(StartWorkflowExecutionParameters.getSeconds(retryOptions.getExpiration()));
            rp.setInitialIntervalInSeconds(StartWorkflowExecutionParameters.getSeconds(retryOptions.getInitialInterval()));
            rp.setMaximumIntervalInSeconds(StartWorkflowExecutionParameters.getSeconds(retryOptions.getMaximumInterval()));
            rp.setMaximumAttempts(retryOptions.getMaximumAttempts());
            ArrayList<String> reasons = new ArrayList<String>();
            List<Class<? extends Throwable>> doNotRetry = retryOptions.getDoNotRetry();
            if (doNotRetry != null) {
                for (Class<? extends Throwable> r : doNotRetry) {
                    reasons.add(r.getName());
                }
                rp.setNonRetriableErrorReasons(reasons);
            }
            parameters.setRetryParameters(rp);
        }
        if (options.getCronSchedule() != null) {
            parameters.setCronSchedule(options.getCronSchedule());
        }
        return parameters;
    }

    private static int getSeconds(Duration expiration) {
        if (expiration == null) {
            return 0;
        }
        return (int)expiration.getSeconds();
    }

    public String toString() {
        return "StartWorkflowExecutionParameters{workflowId='" + this.workflowId + '\'' + ", workflowType=" + this.workflowType + ", taskList='" + this.taskList + '\'' + ", input=" + Arrays.toString(this.input) + ", executionStartToCloseTimeoutSeconds=" + this.executionStartToCloseTimeoutSeconds + ", taskStartToCloseTimeoutSeconds=" + this.taskStartToCloseTimeoutSeconds + ", childPolicy=" + (Object)((Object)this.childPolicy) + ", workflowIdReusePolicy=" + (Object)((Object)this.workflowIdReusePolicy) + ", retryParameters=" + this.retryParameters + ", cronSchedule='" + this.cronSchedule + '\'' + ", memo='" + this.memo + '\'' + ", searchAttributes='" + this.searchAttributes + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StartWorkflowExecutionParameters that = (StartWorkflowExecutionParameters)o;
        return this.executionStartToCloseTimeoutSeconds == that.executionStartToCloseTimeoutSeconds && this.taskStartToCloseTimeoutSeconds == that.taskStartToCloseTimeoutSeconds && Objects.equals(this.workflowId, that.workflowId) && Objects.equals(this.workflowType, that.workflowType) && Objects.equals(this.taskList, that.taskList) && Arrays.equals(this.input, that.input) && this.childPolicy == that.childPolicy && this.workflowIdReusePolicy == that.workflowIdReusePolicy && Objects.equals(this.retryParameters, that.retryParameters) && Objects.equals(this.cronSchedule, that.cronSchedule) && Objects.equals(this.memo, that.memo) && Objects.equals(this.searchAttributes, that.searchAttributes);
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this.workflowId, this.workflowType, this.taskList, this.executionStartToCloseTimeoutSeconds, this.taskStartToCloseTimeoutSeconds, this.childPolicy, this.workflowIdReusePolicy, this.retryParameters, this.cronSchedule, this.memo, this.searchAttributes});
        result = 31 * result + Arrays.hashCode(this.input);
        return result;
    }
}

