/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.common;

import com.uber.cadence.BadRequestError;
import com.uber.cadence.CancellationAlreadyRequestedError;
import com.uber.cadence.DomainAlreadyExistsError;
import com.uber.cadence.DomainNotActiveError;
import com.uber.cadence.EntityNotExistsError;
import com.uber.cadence.QueryFailedError;
import com.uber.cadence.WorkflowExecutionAlreadyStartedError;
import com.uber.cadence.common.RetryOptions;
import com.uber.cadence.internal.common.AsyncBackoffThrottler;
import com.uber.cadence.internal.common.BackoffThrottler;
import com.uber.cadence.internal.common.CheckedExceptionWrapper;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Retryer {
    public static final RetryOptions DEFAULT_SERVICE_OPERATION_RETRY_OPTIONS;
    private static final Duration RETRY_SERVICE_OPERATION_INITIAL_INTERVAL;
    private static final Duration RETRY_SERVICE_OPERATION_EXPIRATION_INTERVAL;
    private static final double RETRY_SERVICE_OPERATION_BACKOFF = 1.2;
    private static final Logger log;

    public static <T extends Throwable> void retry(RetryOptions options, RetryableProc<T> r) throws T {
        Retryer.retryWithResult(options, () -> {
            r.apply();
            return null;
        });
    }

    public static <R, T extends Throwable> R retryWithResult(RetryOptions options, RetryableFunc<R, T> r) throws T {
        int attempt = 0;
        long startTime = System.currentTimeMillis();
        BackoffThrottler throttler = new BackoffThrottler(options.getInitialInterval(), options.getMaximumInterval(), options.getBackoffCoefficient());
        while (true) {
            try {
                ++attempt;
                throttler.throttle();
                R result = r.apply();
                throttler.success();
                return result;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return null;
            }
            catch (Exception e) {
                throttler.failure();
                if (options.getDoNotRetry() != null) {
                    for (Class<? extends Throwable> exceptionToNotRetry : options.getDoNotRetry()) {
                        if (!exceptionToNotRetry.isAssignableFrom(e.getClass())) continue;
                        Retryer.rethrow(e);
                    }
                }
                long elapsed = System.currentTimeMillis() - startTime;
                int maxAttempts = options.getMaximumAttempts();
                Duration expiration = options.getExpiration();
                if (maxAttempts > 0 && attempt >= maxAttempts || expiration != null && elapsed >= expiration.toMillis()) {
                    Retryer.rethrow(e);
                }
                log.warn("Retrying after failure", (Throwable)e);
                continue;
            }
            break;
        }
    }

    public static <R> CompletableFuture<R> retryWithResultAsync(RetryOptions options, Supplier<CompletableFuture<R>> function) {
        int attempt = 0;
        long startTime = System.currentTimeMillis();
        AsyncBackoffThrottler throttler = new AsyncBackoffThrottler(options.getInitialInterval(), options.getMaximumInterval(), options.getBackoffCoefficient());
        CompletableFuture unwrappedExceptionResult = new CompletableFuture();
        CompletableFuture<R> result = Retryer.retryWithResultAsync(options, function, attempt + 1, startTime, throttler);
        CompletionStage ignored = result.handle((r, e) -> {
            if (e == null) {
                unwrappedExceptionResult.complete(r);
            } else {
                unwrappedExceptionResult.completeExceptionally(CheckedExceptionWrapper.unwrap(e));
            }
            return null;
        });
        return unwrappedExceptionResult;
    }

    private static <R> CompletableFuture<R> retryWithResultAsync(RetryOptions options, Supplier<CompletableFuture<R>> function, int attempt, long startTime, AsyncBackoffThrottler throttler) {
        options.validate();
        return ((CompletableFuture)((CompletableFuture)throttler.throttle().thenCompose(ignore -> {
            try {
                CompletableFuture result = (CompletableFuture)function.get();
                if (result == null) {
                    return CompletableFuture.completedFuture(null);
                }
                return result.handle((r, e) -> {
                    if (e == null) {
                        throttler.success();
                        return r;
                    }
                    throttler.failure();
                    throw CheckedExceptionWrapper.wrap(e);
                });
            }
            catch (Throwable e2) {
                throttler.failure();
                throw CheckedExceptionWrapper.wrap(e2);
            }
        })).handle((r, e) -> Retryer.failOrRetry(options, function, attempt, startTime, throttler, r, e))).thenCompose(pair -> {
            if (pair.getException() != null) {
                throw CheckedExceptionWrapper.wrap(pair.getException());
            }
            return pair.getValue();
        });
    }

    private static <R> ValueExceptionPair<R> failOrRetry(RetryOptions options, Supplier<CompletableFuture<R>> function, int attempt, long startTime, AsyncBackoffThrottler throttler, R r, Throwable e) {
        int maxAttempts;
        if (e == null) {
            return new ValueExceptionPair<R>(CompletableFuture.completedFuture(r), null);
        }
        if (e instanceof CompletionException) {
            e = e.getCause();
        }
        if (e instanceof Error) {
            return new ValueExceptionPair(null, e);
        }
        e = CheckedExceptionWrapper.unwrap((Exception)e);
        long elapsed = System.currentTimeMillis() - startTime;
        if (options.getDoNotRetry() != null) {
            for (Class<? extends Throwable> exceptionToNotRetry : options.getDoNotRetry()) {
                if (!exceptionToNotRetry.isAssignableFrom(e.getClass())) continue;
                return new ValueExceptionPair(null, e);
            }
        }
        if ((maxAttempts = options.getMaximumAttempts()) > 0 && attempt >= maxAttempts || options.getExpiration() != null && elapsed >= options.getExpiration().toMillis()) {
            return new ValueExceptionPair(null, e);
        }
        log.debug("Retrying after failure", e);
        CompletableFuture<R> next = Retryer.retryWithResultAsync(options, function, attempt + 1, startTime, throttler);
        return new ValueExceptionPair<R>(next, null);
    }

    private static <T extends Throwable> void rethrow(Exception e) throws T {
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        Exception toRethrow = e;
        throw toRethrow;
    }

    private Retryer() {
    }

    static {
        RETRY_SERVICE_OPERATION_INITIAL_INTERVAL = Duration.ofMillis(20L);
        RETRY_SERVICE_OPERATION_EXPIRATION_INTERVAL = Duration.ofMinutes(1L);
        RetryOptions.Builder roBuilder = new RetryOptions.Builder().setInitialInterval(RETRY_SERVICE_OPERATION_INITIAL_INTERVAL).setExpiration(RETRY_SERVICE_OPERATION_EXPIRATION_INTERVAL).setBackoffCoefficient(1.2);
        Duration maxInterval = RETRY_SERVICE_OPERATION_EXPIRATION_INTERVAL.dividedBy(10L);
        if (maxInterval.compareTo(RETRY_SERVICE_OPERATION_INITIAL_INTERVAL) < 0) {
            maxInterval = RETRY_SERVICE_OPERATION_INITIAL_INTERVAL;
        }
        roBuilder.setMaximumInterval(maxInterval);
        roBuilder.setDoNotRetry(BadRequestError.class, EntityNotExistsError.class, WorkflowExecutionAlreadyStartedError.class, DomainAlreadyExistsError.class, QueryFailedError.class, DomainNotActiveError.class, CancellationAlreadyRequestedError.class);
        DEFAULT_SERVICE_OPERATION_RETRY_OPTIONS = roBuilder.validateBuildWithDefaults();
        log = LoggerFactory.getLogger(Retryer.class);
    }

    private static class ValueExceptionPair<V> {
        private final CompletableFuture<V> value;
        private final Throwable exception;

        public ValueExceptionPair(CompletableFuture<V> value, Throwable exception) {
            this.value = value;
            this.exception = exception;
        }

        public CompletableFuture<V> getValue() {
            return this.value;
        }

        public Throwable getException() {
            return this.exception;
        }
    }

    public static interface RetryableFunc<R, E extends Throwable> {
        public R apply() throws E;
    }

    public static interface RetryableProc<E extends Throwable> {
        public void apply() throws E;
    }
}

