/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.common;

import com.google.common.base.Defaults;
import com.uber.cadence.SearchAttributes;
import com.uber.cadence.TaskList;
import com.uber.cadence.TaskListKind;
import com.uber.cadence.converter.DataConverter;
import com.uber.cadence.converter.JsonDataConverter;
import com.uber.cadence.internal.worker.Shutdownable;
import com.uber.cadence.workflow.WorkflowMethod;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

public final class InternalUtils {
    public static String getSimpleName(Method method) {
        return method.getDeclaringClass().getSimpleName() + "::" + method.getName();
    }

    public static String getWorkflowType(Method method, WorkflowMethod workflowMethod) {
        String workflowName = workflowMethod.name();
        if (workflowName.isEmpty()) {
            return InternalUtils.getSimpleName(method);
        }
        return workflowName;
    }

    public static Method getWorkflowMethod(Class<?> workflowInterface) {
        Method result = null;
        for (Method m : workflowInterface.getMethods()) {
            if (m.getAnnotation(WorkflowMethod.class) == null) continue;
            if (result != null) {
                throw new IllegalArgumentException("Workflow interface must have exactly one method annotated with @WorkflowMethod. Found \"" + result + "\" and \"" + m + "\"");
            }
            result = m;
        }
        if (result == null) {
            throw new IllegalArgumentException("Method annotated with @WorkflowMethod is not found at " + workflowInterface);
        }
        return result;
    }

    public static TaskList createStickyTaskList(String taskListName) {
        TaskList tl = new TaskList();
        tl.setName(taskListName);
        tl.setKind(TaskListKind.STICKY);
        return tl;
    }

    public static TaskList createNormalTaskList(String taskListName) {
        TaskList tl = new TaskList();
        tl.setName(taskListName);
        tl.setKind(TaskListKind.NORMAL);
        return tl;
    }

    public static long awaitTermination(Shutdownable s, long timeoutMillis) {
        if (s == null) {
            return timeoutMillis;
        }
        return InternalUtils.awaitTermination(timeoutMillis, () -> s.awaitTermination(timeoutMillis, TimeUnit.MILLISECONDS));
    }

    public static long awaitTermination(ExecutorService s, long timeoutMillis) {
        if (s == null) {
            return timeoutMillis;
        }
        return InternalUtils.awaitTermination(timeoutMillis, () -> {
            try {
                s.awaitTermination(timeoutMillis, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
    }

    public static long awaitTermination(long timeoutMillis, Runnable toTerminate) {
        long started = System.currentTimeMillis();
        toTerminate.run();
        long remainingTimeout = timeoutMillis - (System.currentTimeMillis() - started);
        if (remainingTimeout < 0L) {
            remainingTimeout = 0L;
        }
        return remainingTimeout;
    }

    public static Object getValueOrDefault(Object value, Class<?> valueClass) {
        if (value != null) {
            return value;
        }
        return Defaults.defaultValue(valueClass);
    }

    public static SearchAttributes convertMapToSearchAttributes(Map<String, Object> searchAttributes) {
        DataConverter converter = JsonDataConverter.getInstance();
        HashMap<String, ByteBuffer> mapOfByteBuffer = new HashMap<String, ByteBuffer>();
        searchAttributes.forEach((key, value) -> mapOfByteBuffer.put((String)key, ByteBuffer.wrap(converter.toData(value))));
        return new SearchAttributes().setIndexedFields(mapOfByteBuffer);
    }

    private InternalUtils() {
    }
}

