/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.converter;

import com.google.common.base.Defaults;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.uber.cadence.converter.CustomThrowableTypeAdapter;
import com.uber.cadence.converter.DataConverter;
import com.uber.cadence.converter.DataConverterException;
import com.uber.cadence.converter.TBaseTypeAdapterFactory;
import com.uber.cadence.converter.TEnumTypeAdapterFactory;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;

public final class JsonDataConverter
implements DataConverter {
    private static final DataConverter INSTANCE = new JsonDataConverter();
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final String TYPE_FIELD_NAME = "type";
    private static final String JSON_CONVERTER_TYPE = "JSON";
    private static final String CLASS_NAME_FIELD_NAME = "className";
    private final Gson gson;
    private final JsonParser parser = new JsonParser();

    public static DataConverter getInstance() {
        return INSTANCE;
    }

    private JsonDataConverter() {
        this(b -> b);
    }

    public JsonDataConverter(Function<GsonBuilder, GsonBuilder> builderInterceptor) {
        GsonBuilder gsonBuilder = new GsonBuilder().serializeNulls().registerTypeAdapterFactory((TypeAdapterFactory)new ThrowableTypeAdapterFactory()).registerTypeAdapterFactory((TypeAdapterFactory)new TBaseTypeAdapterFactory()).registerTypeAdapterFactory((TypeAdapterFactory)new TEnumTypeAdapterFactory());
        GsonBuilder intercepted = builderInterceptor.apply(gsonBuilder);
        this.gson = intercepted.create();
    }

    @Override
    public byte[] toData(Object ... values) throws DataConverterException {
        if (values == null || values.length == 0) {
            return null;
        }
        try {
            if (values.length == 1) {
                Object value = values[0];
                String json = this.gson.toJson(value);
                return json.getBytes(StandardCharsets.UTF_8);
            }
            String json = this.gson.toJson((Object)values);
            return json.getBytes(StandardCharsets.UTF_8);
        }
        catch (DataConverterException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new DataConverterException(e);
        }
    }

    @Override
    public <T> T fromData(byte[] content, Class<T> valueClass, Type valueType) throws DataConverterException {
        if (content == null) {
            return null;
        }
        try {
            return (T)this.gson.fromJson(new String(content, StandardCharsets.UTF_8), valueType);
        }
        catch (Exception e) {
            throw new DataConverterException(content, new Type[]{valueType}, e);
        }
    }

    @Override
    public Object[] fromDataArray(byte[] content, Type ... valueTypes) throws DataConverterException {
        try {
            JsonArray array;
            if (content == null) {
                if (valueTypes.length == 0) {
                    return EMPTY_OBJECT_ARRAY;
                }
                throw new DataConverterException("Content doesn't match expected arguments", content, valueTypes);
            }
            if (valueTypes.length == 1) {
                Object result = this.gson.fromJson(new String(content, StandardCharsets.UTF_8), valueTypes[0]);
                return new Object[]{result};
            }
            JsonElement element = this.parser.parse(new String(content, StandardCharsets.UTF_8));
            if (element instanceof JsonArray) {
                array = element.getAsJsonArray();
            } else {
                array = new JsonArray();
                array.add(element);
            }
            Object[] result = new Object[valueTypes.length];
            for (int i = 0; i < valueTypes.length; ++i) {
                if (i >= array.size()) {
                    Type t = valueTypes[i];
                    if (t instanceof Class) {
                        result[i] = Defaults.defaultValue((Class)((Class)t));
                        continue;
                    }
                    result[i] = null;
                    continue;
                }
                result[i] = this.gson.fromJson(array.get(i), valueTypes[i]);
            }
            return result;
        }
        catch (DataConverterException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DataConverterException(content, valueTypes, e);
        }
    }

    private static class ThrowableTypeAdapterFactory
    implements TypeAdapterFactory {
        private ThrowableTypeAdapterFactory() {
        }

        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            if (DataConverter.class.isAssignableFrom(typeToken.getRawType())) {
                return new TypeAdapter<T>(){

                    public void write(JsonWriter out, T value) throws IOException {
                        out.beginObject();
                        out.name(JsonDataConverter.TYPE_FIELD_NAME).value(JsonDataConverter.JSON_CONVERTER_TYPE);
                        out.endObject();
                    }

                    public T read(JsonReader in) throws IOException {
                        in.beginObject();
                        if (!in.nextName().equals(JsonDataConverter.TYPE_FIELD_NAME)) {
                            throw new IOException("Cannot deserialize DataConverter. Missing type field");
                        }
                        String value = in.nextString();
                        if (!JsonDataConverter.JSON_CONVERTER_TYPE.equals(value)) {
                            throw new IOException("Cannot deserialize DataConverter. Expected type is JSON. Found " + value);
                        }
                        in.endObject();
                        return JsonDataConverter.getInstance();
                    }
                };
            }
            if (Class.class.isAssignableFrom(typeToken.getRawType())) {
                return new TypeAdapter<T>(){

                    public void write(JsonWriter out, T value) throws IOException {
                        out.beginObject();
                        String className = ((Class)value).getName();
                        out.name(JsonDataConverter.CLASS_NAME_FIELD_NAME).value(className);
                        out.endObject();
                    }

                    public T read(JsonReader in) throws IOException {
                        in.beginObject();
                        if (!in.nextName().equals(JsonDataConverter.CLASS_NAME_FIELD_NAME)) {
                            throw new IOException("Cannot deserialize class. Missing className field");
                        }
                        String className = in.nextString();
                        try {
                            Class<?> result = Class.forName(className);
                            in.endObject();
                            return result;
                        }
                        catch (ClassNotFoundException e) {
                            throw new RuntimeException(e);
                        }
                    }
                };
            }
            if (!Throwable.class.isAssignableFrom(typeToken.getRawType())) {
                return null;
            }
            return new CustomThrowableTypeAdapter(gson, this).nullSafe();
        }
    }
}

