/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.converter;

import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class DataConverterException
extends RuntimeException {
    public DataConverterException(byte[] content, Type[] valueTypes, Throwable cause) {
        super(DataConverterException.toMessage(null, content, valueTypes), cause);
    }

    public DataConverterException(Throwable cause) {
        super(cause);
    }

    public DataConverterException(String message, Throwable cause) {
        super(message, cause);
    }

    public DataConverterException(String message, byte[] content, Type[] valueTypes) {
        super(DataConverterException.toMessage(message, content, valueTypes));
    }

    private static String toMessage(String message, byte[] content, Type[] valueTypes) {
        if (content == null && valueTypes == null) {
            return message;
        }
        StringBuilder result = new StringBuilder();
        if (message != null && message.length() > 0) {
            result.append(message);
            result.append(" ");
        }
        result.append("when parsing:\"");
        result.append(DataConverterException.truncateContent(content));
        result.append("\" into following types: ");
        result.append(Arrays.toString(valueTypes));
        return result.toString();
    }

    private static String truncateContent(byte[] content) {
        if (content == null) {
            return "";
        }
        int maxIndex = Math.min(content.length, 255);
        return new String(content, 0, maxIndex, StandardCharsets.UTF_8);
    }
}

