/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.common;

import com.google.common.base.Defaults;
import com.uber.cadence.common.MethodRetry;
import com.uber.cadence.workflow.ActivityFailureException;
import com.uber.cadence.workflow.ChildWorkflowFailureException;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class RetryOptions {
    private static final double DEFAULT_BACKOFF_COEFFICIENT = 2.0;
    private static final int DEFAULT_MAXIMUM_MULTIPLIER = 100;
    private final Duration initialInterval;
    private final double backoffCoefficient;
    private final Duration expiration;
    private final int maximumAttempts;
    private final Duration maximumInterval;
    private final List<Class<? extends Throwable>> doNotRetry;

    public static RetryOptions merge(MethodRetry r, RetryOptions o) {
        double coefficient;
        Duration maximum;
        Duration expiration;
        if (r == null) {
            if (o == null) {
                return null;
            }
            return new Builder(o).validateBuildWithDefaults();
        }
        if (o == null) {
            o = new Builder().build();
        }
        Duration initial = RetryOptions.merge(r.initialIntervalSeconds(), o.getInitialInterval());
        Builder builder = new Builder();
        if (initial != null) {
            builder.setInitialInterval(initial);
        }
        if ((expiration = RetryOptions.merge(r.expirationSeconds(), o.getExpiration())) != null) {
            builder.setExpiration(expiration);
        }
        if ((maximum = RetryOptions.merge(r.maximumIntervalSeconds(), o.getMaximumInterval())) != null) {
            builder.setMaximumInterval(maximum);
        }
        if ((coefficient = RetryOptions.merge(r.backoffCoefficient(), o.getBackoffCoefficient(), Double.TYPE).doubleValue()) != 0.0) {
            builder.setBackoffCoefficient(coefficient);
        } else {
            builder.setBackoffCoefficient(2.0);
        }
        return builder.setMaximumAttempts(RetryOptions.merge(r.maximumAttempts(), o.getMaximumAttempts(), Integer.TYPE)).setDoNotRetry(RetryOptions.merge(r.doNotRetry(), o.getDoNotRetry())).validateBuildWithDefaults();
    }

    public RetryOptions merge(RetryOptions o) {
        if (o == null) {
            return this;
        }
        return new Builder().setInitialInterval(RetryOptions.merge(this.getInitialInterval(), o.getInitialInterval(), Duration.class)).setExpiration(RetryOptions.merge(this.getExpiration(), o.getExpiration(), Duration.class)).setMaximumInterval(RetryOptions.merge(this.getMaximumInterval(), o.getMaximumInterval(), Duration.class)).setBackoffCoefficient(RetryOptions.merge(this.getBackoffCoefficient(), o.getBackoffCoefficient(), Double.TYPE)).setMaximumAttempts(RetryOptions.merge(this.getMaximumAttempts(), o.getMaximumAttempts(), Integer.TYPE)).setDoNotRetry(this.merge(this.getDoNotRetry(), o.getDoNotRetry())).validateBuildWithDefaults();
    }

    @SafeVarargs
    public final RetryOptions addDoNotRetry(Class<? extends Throwable> ... doNotRetry) {
        if (doNotRetry == null) {
            return this;
        }
        double backoffCoefficient = this.getBackoffCoefficient();
        if (backoffCoefficient == 0.0) {
            backoffCoefficient = 2.0;
        }
        Builder builder = new Builder().setInitialInterval(this.getInitialInterval()).setExpiration(this.getExpiration()).setMaximumInterval(this.getMaximumInterval()).setBackoffCoefficient(backoffCoefficient).setDoNotRetry(this.merge(this.getDoNotRetry(), Arrays.asList(doNotRetry)));
        if (this.getMaximumAttempts() > 0) {
            builder.setMaximumAttempts(this.getMaximumAttempts());
        }
        return builder.validateBuildWithDefaults();
    }

    private RetryOptions(Duration initialInterval, double backoffCoefficient, Duration expiration, int maximumAttempts, Duration maximumInterval, List<Class<? extends Throwable>> doNotRetry) {
        this.initialInterval = initialInterval;
        this.backoffCoefficient = backoffCoefficient;
        this.expiration = expiration;
        this.maximumAttempts = maximumAttempts;
        this.maximumInterval = maximumInterval;
        this.doNotRetry = doNotRetry != null ? Collections.unmodifiableList(doNotRetry) : null;
    }

    public Duration getInitialInterval() {
        return this.initialInterval;
    }

    public double getBackoffCoefficient() {
        return this.backoffCoefficient;
    }

    public Duration getExpiration() {
        return this.expiration;
    }

    public int getMaximumAttempts() {
        return this.maximumAttempts;
    }

    public Duration getMaximumInterval() {
        return this.maximumInterval;
    }

    public void validate() {
        if (this.initialInterval == null) {
            throw new IllegalStateException("required property initialInterval not set");
        }
        if (this.expiration == null && this.maximumAttempts <= 0) {
            throw new IllegalArgumentException("both MaximumAttempts and Expiration on retry policy are not set, at least one of them must be set");
        }
        if (this.maximumInterval != null && this.maximumInterval.compareTo(this.initialInterval) < 0) {
            throw new IllegalStateException("maximumInterval(" + this.maximumInterval + ") cannot be smaller than initialInterval(" + this.initialInterval);
        }
        if (this.backoffCoefficient != 0.0 && this.backoffCoefficient < 1.0) {
            throw new IllegalArgumentException("coefficient less than 1");
        }
        if (this.maximumAttempts != 0 && this.maximumAttempts < 0) {
            throw new IllegalArgumentException("negative maximum attempts");
        }
    }

    public List<Class<? extends Throwable>> getDoNotRetry() {
        return this.doNotRetry;
    }

    public String toString() {
        return "RetryOptions{initialInterval=" + this.initialInterval + ", backoffCoefficient=" + this.backoffCoefficient + ", expiration=" + this.expiration + ", maximumAttempts=" + this.maximumAttempts + ", maximumInterval=" + this.maximumInterval + ", doNotRetry=" + this.doNotRetry + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RetryOptions that = (RetryOptions)o;
        return Double.compare(that.backoffCoefficient, this.backoffCoefficient) == 0 && this.maximumAttempts == that.maximumAttempts && Objects.equals(this.initialInterval, that.initialInterval) && Objects.equals(this.expiration, that.expiration) && Objects.equals(this.maximumInterval, that.maximumInterval) && Objects.equals(this.doNotRetry, that.doNotRetry);
    }

    public int hashCode() {
        return Objects.hash(this.initialInterval, this.backoffCoefficient, this.expiration, this.maximumAttempts, this.maximumInterval, this.doNotRetry);
    }

    private static <G> G merge(G annotation, G options, Class<G> type) {
        if (!Defaults.defaultValue(type).equals(options)) {
            return options;
        }
        return annotation;
    }

    private static Duration merge(long aSeconds, Duration o) {
        if (o != null) {
            return o;
        }
        return aSeconds == 0L ? null : Duration.ofSeconds(aSeconds);
    }

    private static Class<? extends Throwable>[] merge(Class<? extends Throwable>[] a, List<Class<? extends Throwable>> o) {
        if (o != null) {
            Class[] result = new Class[o.size()];
            return o.toArray(result);
        }
        return a.length == 0 ? null : a;
    }

    private Class<? extends Throwable>[] merge(List<Class<? extends Throwable>> o1, List<Class<? extends Throwable>> o2) {
        if (o2 != null) {
            Class[] result = new Class[o2.size()];
            return o2.toArray(result);
        }
        if (o1.size() > 0) {
            Class[] result = new Class[o1.size()];
            return o1.toArray(result);
        }
        return null;
    }

    public long calculateSleepTime(long attempt) {
        double coefficient = this.backoffCoefficient == 0.0 ? 2.0 : this.backoffCoefficient;
        double sleepMillis = Math.pow(coefficient, attempt - 1L) * (double)this.initialInterval.toMillis();
        if (this.maximumInterval == null) {
            return (long)Math.min(sleepMillis, (double)(this.initialInterval.toMillis() * 100L));
        }
        return Math.min((long)sleepMillis, this.maximumInterval.toMillis());
    }

    public boolean shouldRethrow(Throwable e, long attempt, long elapsed, long sleepTime) {
        if (e instanceof ActivityFailureException || e instanceof ChildWorkflowFailureException) {
            e = e.getCause();
        }
        if (this.doNotRetry != null) {
            for (Class<? extends Throwable> doNotRetry : this.doNotRetry) {
                if (!doNotRetry.equals(e.getClass())) continue;
                return true;
            }
        }
        if (this.maximumAttempts != 0 && attempt >= (long)this.maximumAttempts) {
            return true;
        }
        return this.expiration != null && elapsed + sleepTime >= this.expiration.toMillis();
    }

    public static final class Builder {
        private Duration initialInterval;
        private Duration expiration;
        private double backoffCoefficient;
        private int maximumAttempts;
        private Duration maximumInterval;
        private List<Class<? extends Throwable>> doNotRetry;

        public Builder() {
        }

        public Builder(RetryOptions o) {
            if (o == null) {
                return;
            }
            this.backoffCoefficient = o.getBackoffCoefficient();
            this.maximumAttempts = o.getMaximumAttempts();
            this.expiration = o.getExpiration();
            this.initialInterval = o.getInitialInterval();
            this.maximumInterval = o.getMaximumInterval();
            this.doNotRetry = o.getDoNotRetry();
        }

        public Builder setInitialInterval(Duration initialInterval) {
            Objects.requireNonNull(initialInterval);
            if (initialInterval.isNegative() || initialInterval.isZero()) {
                throw new IllegalArgumentException("Invalid interval: " + initialInterval);
            }
            this.initialInterval = initialInterval;
            return this;
        }

        public Builder setExpiration(Duration expiration) {
            Objects.requireNonNull(expiration);
            if (expiration.isNegative() || expiration.isZero()) {
                throw new IllegalArgumentException("Invalid interval: " + expiration);
            }
            this.expiration = expiration;
            return this;
        }

        public Builder setBackoffCoefficient(double backoffCoefficient) {
            if (backoffCoefficient < 1.0) {
                throw new IllegalArgumentException("coefficient less than 1.0: " + backoffCoefficient);
            }
            this.backoffCoefficient = backoffCoefficient;
            return this;
        }

        public Builder setMaximumAttempts(int maximumAttempts) {
            if (maximumAttempts < 1) {
                throw new IllegalArgumentException("Invalid maximumAttempts: " + maximumAttempts);
            }
            this.maximumAttempts = maximumAttempts;
            return this;
        }

        public Builder setMaximumInterval(Duration maximumInterval) {
            Objects.requireNonNull(maximumInterval);
            if (maximumInterval.isNegative() || maximumInterval.isZero()) {
                throw new IllegalArgumentException("Invalid interval: " + maximumInterval);
            }
            this.maximumInterval = maximumInterval;
            return this;
        }

        @SafeVarargs
        public final Builder setDoNotRetry(Class<? extends Throwable> ... doNotRetry) {
            if (doNotRetry != null) {
                this.doNotRetry = Arrays.asList(doNotRetry);
            }
            return this;
        }

        public RetryOptions build() {
            return new RetryOptions(this.initialInterval, this.backoffCoefficient, this.expiration, this.maximumAttempts, this.maximumInterval, this.doNotRetry);
        }

        public RetryOptions validateBuildWithDefaults() {
            double backoff = this.backoffCoefficient;
            if (backoff == 0.0) {
                backoff = 2.0;
            }
            RetryOptions result = new RetryOptions(this.initialInterval, backoff, this.expiration, this.maximumAttempts, this.maximumInterval, this.doNotRetry);
            result.validate();
            return result;
        }
    }
}

