/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.client;

import com.uber.cadence.WorkflowExecution;
import com.uber.cadence.client.WorkflowException;
import java.util.Optional;

public final class WorkflowFailureException
extends WorkflowException {
    private final long decisionTaskCompletedEventId;

    public WorkflowFailureException(WorkflowExecution execution, Optional<String> workflowType, long decisionTaskCompletedEventId, Throwable failure) {
        super(WorkflowFailureException.getMessage(execution, workflowType), execution, workflowType, failure);
        this.decisionTaskCompletedEventId = decisionTaskCompletedEventId;
    }

    private static String getMessage(WorkflowExecution execution, Optional<String> workflowType) {
        StringBuilder result = new StringBuilder();
        if (workflowType.isPresent()) {
            result.append("WorkflowType=\"");
            result.append(workflowType.get());
            result.append("\", ");
        }
        result.append("WorkflowID=\"");
        result.append(execution.getWorkflowId());
        result.append("\", RunID=\"");
        result.append(execution.getRunId());
        return result.toString();
    }

    public long getDecisionTaskCompletedEventId() {
        return this.decisionTaskCompletedEventId;
    }
}

