/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.client;

import com.uber.cadence.WorkflowExecution;
import java.util.Optional;

public class WorkflowException
extends RuntimeException {
    private final WorkflowExecution execution;
    private final Optional<String> workflowType;

    protected WorkflowException(String message, WorkflowExecution execution, Optional<String> workflowType, Throwable cause) {
        super(WorkflowException.getMessage(message, execution, workflowType), cause);
        this.execution = execution;
        this.workflowType = workflowType;
    }

    private static String getMessage(String message, WorkflowExecution execution, Optional<String> workflowType) {
        StringBuilder result = new StringBuilder();
        if (message != null) {
            result.append(message);
            result.append(", ");
        }
        if (workflowType.isPresent()) {
            result.append("WorkflowType=\"");
            result.append(workflowType.get());
        }
        if (execution != null) {
            if (result.length() > 0) {
                result.append("\", ");
            }
            result.append("WorkflowExecution=\"");
            result.append(execution);
            result.append("\"");
        }
        return result.toString();
    }

    public WorkflowExecution getExecution() {
        return this.execution;
    }

    public Optional<String> getWorkflowType() {
        return this.workflowType;
    }
}

