/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.client;

import com.uber.cadence.client.WorkflowClientInterceptor;
import com.uber.cadence.converter.DataConverter;
import com.uber.cadence.converter.JsonDataConverter;
import com.uber.cadence.internal.metrics.NoopScope;
import com.uber.m3.tally.Scope;
import java.util.Objects;

public final class WorkflowClientOptions {
    private static final WorkflowClientInterceptor[] EMPTY_INTERCEPTOR_ARRAY = new WorkflowClientInterceptor[0];
    private final DataConverter dataConverter;
    private final WorkflowClientInterceptor[] interceptors;
    private final Scope metricsScope;

    private WorkflowClientOptions(DataConverter dataConverter, WorkflowClientInterceptor[] interceptors, Scope metricsScope) {
        this.dataConverter = dataConverter;
        this.interceptors = interceptors;
        this.metricsScope = metricsScope;
    }

    public DataConverter getDataConverter() {
        return this.dataConverter;
    }

    public WorkflowClientInterceptor[] getInterceptors() {
        return this.interceptors;
    }

    public Scope getMetricsScope() {
        return this.metricsScope;
    }

    static /* synthetic */ WorkflowClientInterceptor[] access$000() {
        return EMPTY_INTERCEPTOR_ARRAY;
    }

    public static final class Builder {
        private DataConverter dataConverter = JsonDataConverter.getInstance();
        private WorkflowClientInterceptor[] interceptors = WorkflowClientOptions.access$000();
        private Scope metricsScope;

        public Builder() {
        }

        public Builder(WorkflowClientOptions options) {
            this.dataConverter = options.getDataConverter();
            this.interceptors = options.getInterceptors();
            this.metricsScope = options.getMetricsScope();
        }

        public Builder setDataConverter(DataConverter dataConverter) {
            this.dataConverter = Objects.requireNonNull(dataConverter);
            return this;
        }

        public Builder setInterceptors(WorkflowClientInterceptor ... interceptors) {
            this.interceptors = Objects.requireNonNull(interceptors);
            return this;
        }

        public Builder setMetricsScope(Scope metricsScope) {
            this.metricsScope = Objects.requireNonNull(metricsScope);
            return this;
        }

        public WorkflowClientOptions build() {
            if (this.metricsScope == null) {
                this.metricsScope = NoopScope.getInstance();
            }
            return new WorkflowClientOptions(this.dataConverter, this.interceptors, this.metricsScope);
        }
    }
}

