/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.activity;

import com.uber.cadence.activity.ActivityMethod;
import com.uber.cadence.activity.ActivityOptions;
import com.uber.cadence.common.MethodRetry;
import com.uber.cadence.common.RetryOptions;
import com.uber.cadence.internal.common.OptionsUtils;
import java.time.Duration;
import java.util.Objects;

public final class LocalActivityOptions {
    private final Duration scheduleToCloseTimeout;
    private final RetryOptions retryOptions;

    public static LocalActivityOptions merge(ActivityMethod a, MethodRetry r, LocalActivityOptions o) {
        if (a == null) {
            if (r == null) {
                return new Builder(o).validateAndBuildWithDefaults();
            }
            RetryOptions mergedR = RetryOptions.merge(r, o.getRetryOptions());
            return new Builder().setRetryOptions(mergedR).validateAndBuildWithDefaults();
        }
        if (o == null) {
            o = new Builder().build();
        }
        return new Builder().setScheduleToCloseTimeout(ActivityOptions.mergeDuration(a.scheduleToCloseTimeoutSeconds(), o.getScheduleToCloseTimeout())).setRetryOptions(RetryOptions.merge(r, o.getRetryOptions())).validateAndBuildWithDefaults();
    }

    private LocalActivityOptions(Duration scheduleToCloseTimeout, RetryOptions retryOptions) {
        this.scheduleToCloseTimeout = scheduleToCloseTimeout;
        this.retryOptions = retryOptions;
    }

    public Duration getScheduleToCloseTimeout() {
        return this.scheduleToCloseTimeout;
    }

    public RetryOptions getRetryOptions() {
        return this.retryOptions;
    }

    public String toString() {
        return "LocalActivityOptions{scheduleToCloseTimeout=" + this.scheduleToCloseTimeout + ", retryOptions=" + this.retryOptions + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalActivityOptions that = (LocalActivityOptions)o;
        return Objects.equals(this.scheduleToCloseTimeout, that.scheduleToCloseTimeout) && Objects.equals(this.retryOptions, that.retryOptions);
    }

    public int hashCode() {
        return Objects.hash(this.scheduleToCloseTimeout, this.retryOptions);
    }

    public static final class Builder {
        private Duration scheduleToCloseTimeout;
        private RetryOptions retryOptions;

        public Builder() {
        }

        public Builder(LocalActivityOptions options) {
            if (options == null) {
                return;
            }
            this.scheduleToCloseTimeout = options.getScheduleToCloseTimeout();
            this.retryOptions = options.retryOptions;
        }

        public Builder setScheduleToCloseTimeout(Duration scheduleToCloseTimeout) {
            this.scheduleToCloseTimeout = scheduleToCloseTimeout;
            return this;
        }

        public Builder setRetryOptions(RetryOptions retryOptions) {
            this.retryOptions = retryOptions;
            return this;
        }

        public LocalActivityOptions build() {
            return new LocalActivityOptions(this.scheduleToCloseTimeout, this.retryOptions);
        }

        public LocalActivityOptions validateAndBuildWithDefaults() {
            RetryOptions ro = null;
            if (this.retryOptions != null) {
                ro = new RetryOptions.Builder(this.retryOptions).validateBuildWithDefaults();
            }
            return new LocalActivityOptions(OptionsUtils.roundUpToSeconds(this.scheduleToCloseTimeout), ro);
        }
    }
}

