/*
 * Decompiled with CFR 0.152.
 */
package parquet.pig.summary;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import parquet.pig.summary.FieldSummaryData;
import parquet.pig.summary.SummaryData;
import parquet.pig.summary.ValueStat;

public class TupleSummaryData
extends SummaryData {
    private static final Logger LOG = Logger.getLogger(TupleSummaryData.class.getName());
    private List<FieldSummaryData> fields = new ArrayList<FieldSummaryData>();
    private ValueStat size = new ValueStat();

    public void addTuple(Schema schema, Tuple tuple) {
        super.add(tuple);
        int tupleSize = tuple.size();
        this.size.add(tupleSize);
        this.ensureSize(tupleSize);
        for (int i = 0; i < tupleSize; ++i) {
            FieldSummaryData fieldSummaryData = this.fields.get(i);
            try {
                Schema.FieldSchema field = this.getField(schema, i);
                fieldSummaryData.setName(this.getName(field));
                Object o = tuple.get(i);
                fieldSummaryData.add(this.getSchema(field), o);
                continue;
            }
            catch (ExecException e) {
                LOG.log(Level.WARNING, "Can't get value from tuple", e);
                fieldSummaryData.addError();
            }
        }
    }

    private void ensureSize(int sizeToEnsure) {
        while (this.fields.size() < sizeToEnsure) {
            this.fields.add(new FieldSummaryData());
        }
    }

    @Override
    public void merge(SummaryData other) {
        super.merge(other);
        TupleSummaryData otherTupleSummaryData = (TupleSummaryData)other;
        this.size.merge(otherTupleSummaryData.size);
        this.ensureSize(otherTupleSummaryData.fields.size());
        for (int i = 0; i < otherTupleSummaryData.fields.size(); ++i) {
            this.fields.get(i).merge(otherTupleSummaryData.fields.get(i));
        }
    }

    public List<FieldSummaryData> getFields() {
        return this.fields;
    }

    public void setFields(List<FieldSummaryData> fields) {
        this.fields = fields;
    }

    public ValueStat getSize() {
        return this.size;
    }

    public void setSize(ValueStat size) {
        this.size = size;
    }
}

