/*
 * Decompiled with CFR 0.152.
 */
package parquet.pig.summary;

import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import parquet.pig.summary.FieldSummaryData;
import parquet.pig.summary.SummaryData;
import parquet.pig.summary.ValueStat;

public class BagSummaryData
extends SummaryData {
    private ValueStat size = new ValueStat();
    private FieldSummaryData content;

    public void add(Schema schema, DataBag bag) {
        super.add(bag);
        this.size.add(bag.size());
        Schema.FieldSchema field = this.getField(schema, 0);
        if (bag.size() > 0L && this.content == null) {
            this.content = new FieldSummaryData();
            this.content.setName(this.getName(field));
        }
        for (Tuple tuple : bag) {
            this.content.add(this.getSchema(field), tuple);
        }
    }

    @Override
    public void merge(SummaryData other) {
        super.merge(other);
        BagSummaryData otherBagSummary = (BagSummaryData)other;
        this.size.merge(otherBagSummary.size);
        this.content = BagSummaryData.merge(this.content, otherBagSummary.content);
    }

    public FieldSummaryData getContent() {
        return this.content;
    }

    public void setContent(FieldSummaryData content) {
        this.content = content;
    }

    public ValueStat getSize() {
        return this.size;
    }

    public void setSize(ValueStat size) {
        this.size = size;
    }
}

