/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet.serde;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.SettableMapObjectInspector;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.Writable;

public abstract class AbstractParquetMapInspector
implements SettableMapObjectInspector {
    protected final ObjectInspector keyInspector;
    protected final ObjectInspector valueInspector;

    public AbstractParquetMapInspector(ObjectInspector keyInspector, ObjectInspector valueInspector) {
        this.keyInspector = keyInspector;
        this.valueInspector = valueInspector;
    }

    public String getTypeName() {
        return "map<" + this.keyInspector.getTypeName() + "," + this.valueInspector.getTypeName() + ">";
    }

    public ObjectInspector.Category getCategory() {
        return ObjectInspector.Category.MAP;
    }

    public ObjectInspector getMapKeyObjectInspector() {
        return this.keyInspector;
    }

    public ObjectInspector getMapValueObjectInspector() {
        return this.valueInspector;
    }

    public Map<?, ?> getMap(Object data) {
        if (data == null) {
            return null;
        }
        if (data instanceof ArrayWritable) {
            Writable[] mapContainer = ((ArrayWritable)data).get();
            if (mapContainer == null || mapContainer.length == 0) {
                return null;
            }
            Writable[] mapArray = ((ArrayWritable)mapContainer[0]).get();
            HashMap<Writable, Writable> map = new HashMap<Writable, Writable>();
            for (Writable obj : mapArray) {
                ArrayWritable mapObj = (ArrayWritable)obj;
                Writable[] arr = mapObj.get();
                map.put(arr[0], arr[1]);
            }
            return map;
        }
        if (data instanceof Map) {
            return (Map)data;
        }
        throw new UnsupportedOperationException("Cannot inspect " + data.getClass().getCanonicalName());
    }

    public int getMapSize(Object data) {
        if (data == null) {
            return -1;
        }
        if (data instanceof ArrayWritable) {
            Writable[] mapContainer = ((ArrayWritable)data).get();
            if (mapContainer == null || mapContainer.length == 0) {
                return -1;
            }
            return ((ArrayWritable)mapContainer[0]).get().length;
        }
        if (data instanceof Map) {
            return ((Map)data).size();
        }
        throw new UnsupportedOperationException("Cannot inspect " + data.getClass().getCanonicalName());
    }

    public Object create() {
        HashMap m = new HashMap();
        return m;
    }

    public Object put(Object map, Object key, Object value) {
        HashMap m = (HashMap)map;
        m.put(key, value);
        return m;
    }

    public Object remove(Object map, Object key) {
        HashMap m = (HashMap)map;
        m.remove(key);
        return m;
    }

    public Object clear(Object map) {
        HashMap m = (HashMap)map;
        m.clear();
        return m;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.keyInspector == null ? 0 : this.keyInspector.hashCode());
        result = 31 * result + (this.valueInspector == null ? 0 : this.valueInspector.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractParquetMapInspector other = (AbstractParquetMapInspector)obj;
        if (this.keyInspector == null ? other.keyInspector != null : !this.keyInspector.equals(other.keyInspector)) {
            return false;
        }
        return !(this.valueInspector == null ? other.valueInspector != null : !this.valueInspector.equals(other.valueInspector));
    }
}

