/*
 * Decompiled with CFR 0.152.
 */
package parquet.hadoop;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import parquet.Preconditions;
import parquet.filter.UnboundRecordFilter;
import parquet.filter2.compat.FilterCompat;
import parquet.filter2.compat.RowGroupFilter;
import parquet.hadoop.Footer;
import parquet.hadoop.InternalParquetRecordReader;
import parquet.hadoop.ParquetFileReader;
import parquet.hadoop.ParquetFileWriter;
import parquet.hadoop.api.InitContext;
import parquet.hadoop.api.ReadSupport;
import parquet.hadoop.metadata.BlockMetaData;
import parquet.hadoop.metadata.GlobalMetaData;
import parquet.schema.MessageType;

public class ParquetReader<T>
implements Closeable {
    private final ReadSupport<T> readSupport;
    private final Configuration conf;
    private final ReadSupport.ReadContext readContext;
    private final Iterator<Footer> footersIterator;
    private final GlobalMetaData globalMetaData;
    private final FilterCompat.Filter filter;
    private InternalParquetRecordReader<T> reader;

    @Deprecated
    public ParquetReader(Path file, ReadSupport<T> readSupport) throws IOException {
        this(new Configuration(), file, readSupport, FilterCompat.NOOP);
    }

    @Deprecated
    public ParquetReader(Configuration conf, Path file, ReadSupport<T> readSupport) throws IOException {
        this(conf, file, readSupport, FilterCompat.NOOP);
    }

    @Deprecated
    public ParquetReader(Path file, ReadSupport<T> readSupport, UnboundRecordFilter unboundRecordFilter) throws IOException {
        this(new Configuration(), file, readSupport, FilterCompat.get((UnboundRecordFilter)unboundRecordFilter));
    }

    @Deprecated
    public ParquetReader(Configuration conf, Path file, ReadSupport<T> readSupport, UnboundRecordFilter unboundRecordFilter) throws IOException {
        this(conf, file, readSupport, FilterCompat.get((UnboundRecordFilter)unboundRecordFilter));
    }

    private ParquetReader(Configuration conf, Path file, ReadSupport<T> readSupport, FilterCompat.Filter filter) throws IOException {
        this.readSupport = readSupport;
        this.filter = (FilterCompat.Filter)Preconditions.checkNotNull((Object)filter, (String)"filter");
        this.conf = conf;
        FileSystem fs = file.getFileSystem(conf);
        List<FileStatus> statuses = Arrays.asList(fs.listStatus(file));
        List<Footer> footers = ParquetFileReader.readAllFootersInParallelUsingSummaryFiles(conf, statuses, false);
        this.footersIterator = footers.iterator();
        this.globalMetaData = ParquetFileWriter.getGlobalMetaData(footers);
        MessageType schema = this.globalMetaData.getSchema();
        Map<String, Set<String>> extraMetadata = this.globalMetaData.getKeyValueMetaData();
        this.readContext = readSupport.init(new InitContext(conf, extraMetadata, schema));
    }

    public T read() throws IOException {
        try {
            if (this.reader != null && this.reader.nextKeyValue()) {
                return this.reader.getCurrentValue();
            }
            this.initReader();
            return this.reader == null ? null : (T)this.read();
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    private void initReader() throws IOException {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
        if (this.footersIterator.hasNext()) {
            Footer footer = this.footersIterator.next();
            List<BlockMetaData> blocks = footer.getParquetMetadata().getBlocks();
            List<BlockMetaData> filteredBlocks = RowGroupFilter.filterRowGroups(this.filter, blocks, footer.getParquetMetadata().getFileMetaData().getSchema());
            this.reader = new InternalParquetRecordReader<T>(this.readSupport, this.filter);
            this.reader.initialize(this.readContext.getRequestedSchema(), this.globalMetaData.getSchema(), footer.getParquetMetadata().getFileMetaData().getKeyValueMetaData(), this.readContext.getReadSupportMetadata(), footer.getFile(), filteredBlocks, this.conf);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
    }

    public static <T> Builder<T> builder(ReadSupport<T> readSupport, Path path) {
        return new Builder(readSupport, path);
    }

    public static class Builder<T> {
        private final ReadSupport<T> readSupport;
        private final Path file;
        private Configuration conf;
        private FilterCompat.Filter filter;

        private Builder(ReadSupport<T> readSupport, Path path) {
            this.readSupport = (ReadSupport)Preconditions.checkNotNull(readSupport, (String)"readSupport");
            this.file = (Path)Preconditions.checkNotNull((Object)path, (String)"path");
            this.conf = new Configuration();
            this.filter = FilterCompat.NOOP;
        }

        public Builder<T> withConf(Configuration conf) {
            this.conf = (Configuration)Preconditions.checkNotNull((Object)conf, (String)"conf");
            return this;
        }

        public Builder<T> withFilter(FilterCompat.Filter filter) {
            this.filter = (FilterCompat.Filter)Preconditions.checkNotNull((Object)filter, (String)"filter");
            return this;
        }

        public ParquetReader<T> build() throws IOException {
            return new ParquetReader(this.conf, this.file, this.readSupport, this.filter);
        }
    }
}

