package parquet.filter2.recordlevel;

import parquet.common.schema.ColumnPath;
import parquet.filter2.predicate.Operators.Eq;
import parquet.filter2.predicate.Operators.Gt;
import parquet.filter2.predicate.Operators.GtEq;
import parquet.filter2.predicate.Operators.LogicalNotUserDefined;
import parquet.filter2.predicate.Operators.Lt;
import parquet.filter2.predicate.Operators.LtEq;
import parquet.filter2.predicate.Operators.NotEq;
import parquet.filter2.predicate.Operators.UserDefined;
import parquet.filter2.predicate.UserDefinedPredicate;
import parquet.filter2.recordlevel.IncrementallyUpdatedFilterPredicate.ValueInspector;
import parquet.io.api.Binary;

/**
 * This class is auto-generated by {@link parquet.filter2.IncrementallyUpdatedFilterPredicateGenerator}
 * Do not manually edit!
 * See {@link IncrementallyUpdatedFilterPredicateBuilderBase}
 */
public class IncrementallyUpdatedFilterPredicateBuilder extends IncrementallyUpdatedFilterPredicateBuilderBase {

  @Override
  public <T extends Comparable<T>> IncrementallyUpdatedFilterPredicate visit(Eq<T> pred) {
    ColumnPath columnPath = pred.getColumn().getColumnPath();
    Class<T> clazz = pred.getColumn().getColumnType();

    ValueInspector valueInspector = null;

    if (clazz.equals(Integer.class)) {
      if (pred.getValue() == null) {
        valueInspector = new ValueInspector() {
          @Override
          public void updateNull() {
            setResult(true);
          }

          @Override
          public void update(int value) {
            setResult(false);
          }
        };
      } else {
        final int target = (Integer) (Object) pred.getValue();

        valueInspector = new ValueInspector() {
          @Override
          public void updateNull() {
            setResult(false);
          }

          @Override
          public void update(int value) {
            setResult(value == target);
          }
        };
      }
    }

    if (clazz.equals(Long.class)) {
      if (pred.getValue() == null) {
        valueInspector = new ValueInspector() {
          @Override
          public void updateNull() {
            setResult(true);
          }

          @Override
          public void update(long value) {
            setResult(false);
          }
        };
      } else {
        final long target = (Long) (Object) pred.getValue();

        valueInspector = new ValueInspector() {
          @Override
          public void updateNull() {
            setResult(false);
          }

          @Override
          public void update(long value) {
            setResult(value == target);
          }
        };
      }
    }

    if (clazz.equals(Boolean.class)) {
      if (pred.getValue() == null) {
        valueInspector = new ValueInspector() {
          @Override
          public void updateNull() {
            setResult(true);
          }

          @Override
          public void update(boolean value) {
            setResult(false);
          }
        };
      } else {
        final boolean target = (Boolean) (Object) pred.getValue();

        valueInspector = new ValueInspector() {
          @Override
          public void updateNull() {
            setResult(false);
          }

          @Override
          public void update(boolean value) {
            setResult(value == target);
          }
        };
      }
    }

    if (clazz.equals(Float.class)) {
      if (pred.getValue() == null) {
        valueInspector = new ValueInspector() {
          @Override
          public void updateNull() {
            setResult(true);
          }

          @Override
          public void update(float value) {
            setResult(false);
          }
        };
      } else {
        final float target = (Float) (Object) pred.getValue();

        valueInspector = new ValueInspector() {
          @Override
          public void updateNull() {
            setResult(false);
          }

          @Override
          public void update(float value) {
            setResult(value == target);
          }
        };
      }
    }

    if (clazz.equals(Double.class)) {
      if (pred.getValue() == null) {
        valueInspector = new ValueInspector() {
          @Override
          public void updateNull() {
            setResult(true);
          }

          @Override
          public void update(double value) {
            setResult(false);
          }
        };
      } else {
        final double target = (Double) (Object) pred.getValue();

        valueInspector = new ValueInspector() {
          @Override
          public void updateNull() {
            setResult(false);
          }

          @Override
          public void update(double value) {
            setResult(value == target);
          }
        };
      }
    }

    if (clazz.equals(Binary.class)) {
      if (pred.getValue() == null) {
        valueInspector = new ValueInspector() {
          @Override
          public void updateNull() {
            setResult(true);
          }

          @Override
          public void update(Binary value) {
            setResult(false);
          }
        };
      } else {
        final Binary target = (Binary) (Object) pred.getValue();

        valueInspector = new ValueInspector() {
          @Override
          public void updateNull() {
            setResult(false);
          }

          @Override
          public void update(Binary value) {
            setResult(value.compareTo(target) == 0 );
          }
        };
      }
    }

    if (valueInspector == null) {
      throw new IllegalArgumentException("Encountered unknown type " + clazz);
    }

    addValueInspector(columnPath, valueInspector);
    return valueInspector;
  }

  @Override
  public <T extends Comparable<T>> IncrementallyUpdatedFilterPredicate visit(NotEq<T> pred) {
    ColumnPath columnPath = pred.getColumn().getColumnPath();
    Class<T> clazz = pred.getColumn().getColumnType();

    ValueInspector valueInspector = null;

    if (clazz.equals(Integer.class)) {
      if (pred.getValue() == null) {
        valueInspector = new ValueInspector() {
          @Override
          public void updateNull() {
            setResult(false);
          }

          @Override
          public void update(int value) {
            setResult(true);
          }
        };
      } else {
        final int target = (Integer) (Object) pred.getValue();

        valueInspector = new ValueInspector() {
          @Override
          public void updateNull() {
            setResult(true);
          }

          @Override
          public void update(int value) {
            setResult(value != target);
          }
        };
      }
    }

    if (clazz.equals(Long.class)) {
      if (pred.getValue() == null) {
        valueInspector = new ValueInspector() {
          @Override
          public void updateNull() {
            setResult(false);
          }

          @Override
          public void update(long value) {
            setResult(true);
          }
        };
      } else {
        final long target = (Long) (Object) pred.getValue();

        valueInspector = new ValueInspector() {
          @Override
          public void updateNull() {
            setResult(true);
          }

          @Override
          public void update(long value) {
            setResult(value != target);
          }
        };
      }
    }

    if (clazz.equals(Boolean.class)) {
      if (pred.getValue() == null) {
        valueInspector = new ValueInspector() {
          @Override
          public void updateNull() {
            setResult(false);
          }

          @Override
          public void update(boolean value) {
            setResult(true);
          }
        };
      } else {
        final boolean target = (Boolean) (Object) pred.getValue();

        valueInspector = new ValueInspector() {
          @Override
          public void updateNull() {
            setResult(true);
          }

          @Override
          public void update(boolean value) {
            setResult(value != target);
          }
        };
      }
    }

    if (clazz.equals(Float.class)) {
      if (pred.getValue() == null) {
        valueInspector = new ValueInspector() {
          @Override
          public void updateNull() {
            setResult(false);
          }

          @Override
          public void update(float value) {
            setResult(true);
          }
        };
      } else {
        final float target = (Float) (Object) pred.getValue();

        valueInspector = new ValueInspector() {
          @Override
          public void updateNull() {
            setResult(true);
          }

          @Override
          public void update(float value) {
            setResult(value != target);
          }
        };
      }
    }

    if (clazz.equals(Double.class)) {
      if (pred.getValue() == null) {
        valueInspector = new ValueInspector() {
          @Override
          public void updateNull() {
            setResult(false);
          }

          @Override
          public void update(double value) {
            setResult(true);
          }
        };
      } else {
        final double target = (Double) (Object) pred.getValue();

        valueInspector = new ValueInspector() {
          @Override
          public void updateNull() {
            setResult(true);
          }

          @Override
          public void update(double value) {
            setResult(value != target);
          }
        };
      }
    }

    if (clazz.equals(Binary.class)) {
      if (pred.getValue() == null) {
        valueInspector = new ValueInspector() {
          @Override
          public void updateNull() {
            setResult(false);
          }

          @Override
          public void update(Binary value) {
            setResult(true);
          }
        };
      } else {
        final Binary target = (Binary) (Object) pred.getValue();

        valueInspector = new ValueInspector() {
          @Override
          public void updateNull() {
            setResult(true);
          }

          @Override
          public void update(Binary value) {
            setResult(value.compareTo(target) != 0);
          }
        };
      }
    }

    if (valueInspector == null) {
      throw new IllegalArgumentException("Encountered unknown type " + clazz);
    }

    addValueInspector(columnPath, valueInspector);
    return valueInspector;
  }

  @Override
  public <T extends Comparable<T>> IncrementallyUpdatedFilterPredicate visit(Lt<T> pred) {
    ColumnPath columnPath = pred.getColumn().getColumnPath();
    Class<T> clazz = pred.getColumn().getColumnType();

    ValueInspector valueInspector = null;

    if (clazz.equals(Integer.class)) {
      final int target = (Integer) (Object) pred.getValue();

      valueInspector = new ValueInspector() {
        @Override
        public void updateNull() {
          setResult(false);
        }

        @Override
        public void update(int value) {
          setResult(value < target);
        }
      };
    }

    if (clazz.equals(Long.class)) {
      final long target = (Long) (Object) pred.getValue();

      valueInspector = new ValueInspector() {
        @Override
        public void updateNull() {
          setResult(false);
        }

        @Override
        public void update(long value) {
          setResult(value < target);
        }
      };
    }

    if (clazz.equals(Boolean.class)) {
      throw new IllegalArgumentException("Operator < not supported for Boolean");
    }

    if (clazz.equals(Float.class)) {
      final float target = (Float) (Object) pred.getValue();

      valueInspector = new ValueInspector() {
        @Override
        public void updateNull() {
          setResult(false);
        }

        @Override
        public void update(float value) {
          setResult(value < target);
        }
      };
    }

    if (clazz.equals(Double.class)) {
      final double target = (Double) (Object) pred.getValue();

      valueInspector = new ValueInspector() {
        @Override
        public void updateNull() {
          setResult(false);
        }

        @Override
        public void update(double value) {
          setResult(value < target);
        }
      };
    }

    if (clazz.equals(Binary.class)) {
      final Binary target = (Binary) (Object) pred.getValue();

      valueInspector = new ValueInspector() {
        @Override
        public void updateNull() {
          setResult(false);
        }

        @Override
        public void update(Binary value) {
          setResult(value.compareTo(target) < 0);
        }
      };
    }

    if (valueInspector == null) {
      throw new IllegalArgumentException("Encountered unknown type " + clazz);
    }

    addValueInspector(columnPath, valueInspector);
    return valueInspector;
  }

  @Override
  public <T extends Comparable<T>> IncrementallyUpdatedFilterPredicate visit(LtEq<T> pred) {
    ColumnPath columnPath = pred.getColumn().getColumnPath();
    Class<T> clazz = pred.getColumn().getColumnType();

    ValueInspector valueInspector = null;

    if (clazz.equals(Integer.class)) {
      final int target = (Integer) (Object) pred.getValue();

      valueInspector = new ValueInspector() {
        @Override
        public void updateNull() {
          setResult(false);
        }

        @Override
        public void update(int value) {
          setResult(value <= target);
        }
      };
    }

    if (clazz.equals(Long.class)) {
      final long target = (Long) (Object) pred.getValue();

      valueInspector = new ValueInspector() {
        @Override
        public void updateNull() {
          setResult(false);
        }

        @Override
        public void update(long value) {
          setResult(value <= target);
        }
      };
    }

    if (clazz.equals(Boolean.class)) {
      throw new IllegalArgumentException("Operator <= not supported for Boolean");
    }

    if (clazz.equals(Float.class)) {
      final float target = (Float) (Object) pred.getValue();

      valueInspector = new ValueInspector() {
        @Override
        public void updateNull() {
          setResult(false);
        }

        @Override
        public void update(float value) {
          setResult(value <= target);
        }
      };
    }

    if (clazz.equals(Double.class)) {
      final double target = (Double) (Object) pred.getValue();

      valueInspector = new ValueInspector() {
        @Override
        public void updateNull() {
          setResult(false);
        }

        @Override
        public void update(double value) {
          setResult(value <= target);
        }
      };
    }

    if (clazz.equals(Binary.class)) {
      final Binary target = (Binary) (Object) pred.getValue();

      valueInspector = new ValueInspector() {
        @Override
        public void updateNull() {
          setResult(false);
        }

        @Override
        public void update(Binary value) {
          setResult(value.compareTo(target) <= 0);
        }
      };
    }

    if (valueInspector == null) {
      throw new IllegalArgumentException("Encountered unknown type " + clazz);
    }

    addValueInspector(columnPath, valueInspector);
    return valueInspector;
  }

  @Override
  public <T extends Comparable<T>> IncrementallyUpdatedFilterPredicate visit(Gt<T> pred) {
    ColumnPath columnPath = pred.getColumn().getColumnPath();
    Class<T> clazz = pred.getColumn().getColumnType();

    ValueInspector valueInspector = null;

    if (clazz.equals(Integer.class)) {
      final int target = (Integer) (Object) pred.getValue();

      valueInspector = new ValueInspector() {
        @Override
        public void updateNull() {
          setResult(false);
        }

        @Override
        public void update(int value) {
          setResult(value > target);
        }
      };
    }

    if (clazz.equals(Long.class)) {
      final long target = (Long) (Object) pred.getValue();

      valueInspector = new ValueInspector() {
        @Override
        public void updateNull() {
          setResult(false);
        }

        @Override
        public void update(long value) {
          setResult(value > target);
        }
      };
    }

    if (clazz.equals(Boolean.class)) {
      throw new IllegalArgumentException("Operator > not supported for Boolean");
    }

    if (clazz.equals(Float.class)) {
      final float target = (Float) (Object) pred.getValue();

      valueInspector = new ValueInspector() {
        @Override
        public void updateNull() {
          setResult(false);
        }

        @Override
        public void update(float value) {
          setResult(value > target);
        }
      };
    }

    if (clazz.equals(Double.class)) {
      final double target = (Double) (Object) pred.getValue();

      valueInspector = new ValueInspector() {
        @Override
        public void updateNull() {
          setResult(false);
        }

        @Override
        public void update(double value) {
          setResult(value > target);
        }
      };
    }

    if (clazz.equals(Binary.class)) {
      final Binary target = (Binary) (Object) pred.getValue();

      valueInspector = new ValueInspector() {
        @Override
        public void updateNull() {
          setResult(false);
        }

        @Override
        public void update(Binary value) {
          setResult(value.compareTo(target) > 0);
        }
      };
    }

    if (valueInspector == null) {
      throw new IllegalArgumentException("Encountered unknown type " + clazz);
    }

    addValueInspector(columnPath, valueInspector);
    return valueInspector;
  }

  @Override
  public <T extends Comparable<T>> IncrementallyUpdatedFilterPredicate visit(GtEq<T> pred) {
    ColumnPath columnPath = pred.getColumn().getColumnPath();
    Class<T> clazz = pred.getColumn().getColumnType();

    ValueInspector valueInspector = null;

    if (clazz.equals(Integer.class)) {
      final int target = (Integer) (Object) pred.getValue();

      valueInspector = new ValueInspector() {
        @Override
        public void updateNull() {
          setResult(false);
        }

        @Override
        public void update(int value) {
          setResult(value >= target);
        }
      };
    }

    if (clazz.equals(Long.class)) {
      final long target = (Long) (Object) pred.getValue();

      valueInspector = new ValueInspector() {
        @Override
        public void updateNull() {
          setResult(false);
        }

        @Override
        public void update(long value) {
          setResult(value >= target);
        }
      };
    }

    if (clazz.equals(Boolean.class)) {
      throw new IllegalArgumentException("Operator >= not supported for Boolean");
    }

    if (clazz.equals(Float.class)) {
      final float target = (Float) (Object) pred.getValue();

      valueInspector = new ValueInspector() {
        @Override
        public void updateNull() {
          setResult(false);
        }

        @Override
        public void update(float value) {
          setResult(value >= target);
        }
      };
    }

    if (clazz.equals(Double.class)) {
      final double target = (Double) (Object) pred.getValue();

      valueInspector = new ValueInspector() {
        @Override
        public void updateNull() {
          setResult(false);
        }

        @Override
        public void update(double value) {
          setResult(value >= target);
        }
      };
    }

    if (clazz.equals(Binary.class)) {
      final Binary target = (Binary) (Object) pred.getValue();

      valueInspector = new ValueInspector() {
        @Override
        public void updateNull() {
          setResult(false);
        }

        @Override
        public void update(Binary value) {
          setResult(value.compareTo(target) >= 0);
        }
      };
    }

    if (valueInspector == null) {
      throw new IllegalArgumentException("Encountered unknown type " + clazz);
    }

    addValueInspector(columnPath, valueInspector);
    return valueInspector;
  }

  @Override
  public <T extends Comparable<T>, U extends UserDefinedPredicate<T>> IncrementallyUpdatedFilterPredicate visit(UserDefined<T, U> pred) {
    ColumnPath columnPath = pred.getColumn().getColumnPath();
    Class<T> clazz = pred.getColumn().getColumnType();

    ValueInspector valueInspector = null;

    final U udp = pred.getUserDefinedPredicate();

    if (clazz.equals(Integer.class)) {
      valueInspector = new ValueInspector() {
        @Override
        public void updateNull() {
          setResult(udp.keep(null));
        }

        @SuppressWarnings("unchecked")
        @Override
        public void update(int value) {
          setResult(udp.keep((T) (Object) value));
        }
      };
    }

    if (clazz.equals(Long.class)) {
      valueInspector = new ValueInspector() {
        @Override
        public void updateNull() {
          setResult(udp.keep(null));
        }

        @SuppressWarnings("unchecked")
        @Override
        public void update(long value) {
          setResult(udp.keep((T) (Object) value));
        }
      };
    }

    if (clazz.equals(Boolean.class)) {
      valueInspector = new ValueInspector() {
        @Override
        public void updateNull() {
          setResult(udp.keep(null));
        }

        @SuppressWarnings("unchecked")
        @Override
        public void update(boolean value) {
          setResult(udp.keep((T) (Object) value));
        }
      };
    }

    if (clazz.equals(Float.class)) {
      valueInspector = new ValueInspector() {
        @Override
        public void updateNull() {
          setResult(udp.keep(null));
        }

        @SuppressWarnings("unchecked")
        @Override
        public void update(float value) {
          setResult(udp.keep((T) (Object) value));
        }
      };
    }

    if (clazz.equals(Double.class)) {
      valueInspector = new ValueInspector() {
        @Override
        public void updateNull() {
          setResult(udp.keep(null));
        }

        @SuppressWarnings("unchecked")
        @Override
        public void update(double value) {
          setResult(udp.keep((T) (Object) value));
        }
      };
    }

    if (clazz.equals(Binary.class)) {
      valueInspector = new ValueInspector() {
        @Override
        public void updateNull() {
          setResult(udp.keep(null));
        }

        @SuppressWarnings("unchecked")
        @Override
        public void update(Binary value) {
          setResult(udp.keep((T) (Object) value));
        }
      };
    }

    if (valueInspector == null) {
      throw new IllegalArgumentException("Encountered unknown type " + clazz);
    }

    addValueInspector(columnPath, valueInspector);
    return valueInspector;
  }

  @Override
  public <T extends Comparable<T>, U extends UserDefinedPredicate<T>> IncrementallyUpdatedFilterPredicate visit(LogicalNotUserDefined<T, U> notPred) {
    UserDefined<T, U> pred = notPred.getUserDefined();
    ColumnPath columnPath = pred.getColumn().getColumnPath();
    Class<T> clazz = pred.getColumn().getColumnType();

    ValueInspector valueInspector = null;

    final U udp = pred.getUserDefinedPredicate();

    if (clazz.equals(Integer.class)) {
      valueInspector = new ValueInspector() {
        @Override
        public void updateNull() {
          setResult(!udp.keep(null));
        }

        @SuppressWarnings("unchecked")
        @Override
        public void update(int value) {
          setResult(!udp.keep((T) (Object) value));
        }
      };
    }

    if (clazz.equals(Long.class)) {
      valueInspector = new ValueInspector() {
        @Override
        public void updateNull() {
          setResult(!udp.keep(null));
        }

        @SuppressWarnings("unchecked")
        @Override
        public void update(long value) {
          setResult(!udp.keep((T) (Object) value));
        }
      };
    }

    if (clazz.equals(Boolean.class)) {
      valueInspector = new ValueInspector() {
        @Override
        public void updateNull() {
          setResult(!udp.keep(null));
        }

        @SuppressWarnings("unchecked")
        @Override
        public void update(boolean value) {
          setResult(!udp.keep((T) (Object) value));
        }
      };
    }

    if (clazz.equals(Float.class)) {
      valueInspector = new ValueInspector() {
        @Override
        public void updateNull() {
          setResult(!udp.keep(null));
        }

        @SuppressWarnings("unchecked")
        @Override
        public void update(float value) {
          setResult(!udp.keep((T) (Object) value));
        }
      };
    }

    if (clazz.equals(Double.class)) {
      valueInspector = new ValueInspector() {
        @Override
        public void updateNull() {
          setResult(!udp.keep(null));
        }

        @SuppressWarnings("unchecked")
        @Override
        public void update(double value) {
          setResult(!udp.keep((T) (Object) value));
        }
      };
    }

    if (clazz.equals(Binary.class)) {
      valueInspector = new ValueInspector() {
        @Override
        public void updateNull() {
          setResult(!udp.keep(null));
        }

        @SuppressWarnings("unchecked")
        @Override
        public void update(Binary value) {
          setResult(!udp.keep((T) (Object) value));
        }
      };
    }

    if (valueInspector == null) {
      throw new IllegalArgumentException("Encountered unknown type " + clazz);
    }

    addValueInspector(columnPath, valueInspector);
    return valueInspector;
  }

}
