/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.joauth;

import com.twitter.joauth.MalformedRequest;
import com.twitter.joauth.Normalizer;
import com.twitter.joauth.OAuthParams;
import com.twitter.joauth.Request;
import com.twitter.joauth.UrlCodec;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

public interface UnpackedRequest {
    public static final OAuth1RequestHelper O_AUTH_1_REQUEST_HELPER = new OAuth1RequestHelper();

    public Request.ParsedRequest parsedRequest();

    public static class OAuth1RequestHelper {
        private static final String NO_VALUE_FOR = "no value for ";
        private static final String SCHEME = "scheme";
        private static final String HOST = "host";
        private static final String PORT = "port";
        private static final String VERB = "verb";
        private static final String PATH = "path";
        private static final String UNSUPPORTED_METHOD = "unsupported signature method: ";
        private static final String UNSUPPORTED_VERSION = "unsupported oauth version: ";
        private static final String MALFORMED_TOKEN = "malformed oauth token: ";
        private static final int MaxTokenLength = 50;

        private void throwMalformedException(String name) throws MalformedRequest {
            throw new MalformedRequest(NO_VALUE_FOR + name);
        }

        public void verify(Request.ParsedRequest parsedRequest, OAuthParams.OAuth1Params oAuth1Params) throws MalformedRequest {
            if (parsedRequest.scheme() == null) {
                this.throwMalformedException(SCHEME);
            } else if (parsedRequest.host() == null) {
                this.throwMalformedException(HOST);
            } else if (parsedRequest.port() < 0) {
                this.throwMalformedException(PORT);
            } else if (parsedRequest.verb() == null) {
                this.throwMalformedException(VERB);
            } else if (parsedRequest.path() == null) {
                this.throwMalformedException(PATH);
            } else {
                if (oAuth1Params.signatureMethod() == null || !oAuth1Params.signatureMethod().equals("HMAC-SHA1") && !oAuth1Params.signatureMethod().equals("HMAC-SHA256")) {
                    throw new MalformedRequest(UNSUPPORTED_METHOD + oAuth1Params.signatureMethod());
                }
                if (oAuth1Params.version() != null && !oAuth1Params.version().equals("1.0") && !oAuth1Params.version().toLowerCase().equals("1.0a")) {
                    throw new MalformedRequest(UNSUPPORTED_VERSION + oAuth1Params.version());
                }
                if (oAuth1Params.token() != null && (oAuth1Params.token().indexOf(32) > 0 || oAuth1Params.token().length() > 50)) {
                    throw new MalformedRequest(MALFORMED_TOKEN + oAuth1Params.token());
                }
            }
        }

        public OAuth1Request buildOAuth1Request(Request.ParsedRequest parsedRequest, OAuthParams.OAuth1Params oAuth1Params, Normalizer normalize) throws MalformedRequest, UnsupportedEncodingException {
            this.verify(parsedRequest, oAuth1Params);
            return new OAuth1Request(UrlCodec.decode(oAuth1Params.token()), UrlCodec.decode(oAuth1Params.consumerKey()), UrlCodec.decode(oAuth1Params.nonce()), oAuth1Params.timestampSecs(), oAuth1Params.signature(), oAuth1Params.signatureMethod(), oAuth1Params.version(), parsedRequest, normalize.normalize(parsedRequest, oAuth1Params));
        }

        public OAuth1TwoLeggedRequest buildOAuth1TwoLeggedRequest(Request.ParsedRequest parsedRequest, OAuthParams.OAuth1Params oAuth1Params, Normalizer normalize) throws MalformedRequest, UnsupportedEncodingException {
            this.verify(parsedRequest, oAuth1Params);
            return new OAuth1TwoLeggedRequest(UrlCodec.decode(oAuth1Params.consumerKey()), UrlCodec.decode(oAuth1Params.nonce()), oAuth1Params.timestampSecs(), oAuth1Params.signature(), oAuth1Params.signatureMethod(), oAuth1Params.version(), parsedRequest, normalize.normalize(parsedRequest, oAuth1Params));
        }
    }

    public static class OAuth2Request
    implements OAuthRequest {
        public final String token;
        private final Request.ParsedRequest parsedRequest;
        private final String clientId;

        public OAuth2Request(String token, Request.ParsedRequest parsedRequest, String clientId) {
            this.token = token;
            this.parsedRequest = parsedRequest;
            this.clientId = clientId;
        }

        public String clientId() {
            return this.clientId;
        }

        public String token() {
            return this.token;
        }

        @Override
        public Request.ParsedRequest parsedRequest() {
            return this.parsedRequest;
        }

        @Override
        public String oAuthVersionString() {
            return "oauth2";
        }

        public HashMap<String, String> oAuthParamMap() {
            HashMap<String, String> map = new HashMap<String, String>(4);
            map.put("Bearer", this.token);
            map.put("client_id", this.clientId);
            return map;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OAuth2Request that = (OAuth2Request)o;
            if (this.clientId != null ? !this.clientId.equals(that.clientId) : that.clientId != null) {
                return false;
            }
            if (this.parsedRequest != null ? !this.parsedRequest.equals(that.parsedRequest) : that.parsedRequest != null) {
                return false;
            }
            return !(this.token != null ? !this.token.equals(that.token) : that.token != null);
        }

        public int hashCode() {
            int result = this.token != null ? this.token.hashCode() : 0;
            result = 31 * result + (this.parsedRequest != null ? this.parsedRequest.hashCode() : 0);
            result = 31 * result + (this.clientId != null ? this.clientId.hashCode() : 0);
            return result;
        }
    }

    public static class OAuth1Request
    extends OAuth1RequestBase {
        private final String token;

        public OAuth1Request(String token, String consumerKey, String nonce, Long timestampSecs, String signature, String signatureMethod, String version, Request.ParsedRequest parsedRequest, String normalizedRequest) {
            super(consumerKey, nonce, timestampSecs, signature, signatureMethod, version, parsedRequest, normalizedRequest);
            this.token = token;
        }

        public String token() {
            return this.token;
        }

        @Override
        public Map<String, String> oAuthParamMap() {
            Map<String, String> map = super.oAuthParamMap();
            map.put("oauth_token", this.token);
            return map;
        }

        @Override
        public String toString() {
            return String.format("{token -> %s, consumerKey -> %s, nonce -> %s, timestamp -> %s, signature -> %s, method -> %s}", this.token, this.consumerKey(), this.nonce(), this.timestampSecs(), this.signature(), this.signatureMethod());
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            OAuth1Request that = (OAuth1Request)o;
            return !(this.token != null ? !this.token.equals(that.token) : that.token != null);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + (this.token != null ? this.token.hashCode() : 0);
            return result;
        }
    }

    public static class OAuth1RequestBase
    implements OAuthRequest {
        private final String consumerKey;
        private final String nonce;
        private final Long timestampSecs;
        private final String signature;
        private final String signatureMethod;
        private final String version;
        private final Request.ParsedRequest parsedRequest;
        private final String normalizedRequest;

        public String consumerKey() {
            return this.consumerKey;
        }

        public String nonce() {
            return this.nonce;
        }

        public Long timestampSecs() {
            return this.timestampSecs;
        }

        public String signature() {
            return this.signature;
        }

        public String signatureMethod() {
            return this.signatureMethod;
        }

        public String version() {
            return this.version;
        }

        public String normalizedRequest() {
            return this.normalizedRequest;
        }

        public OAuth1RequestBase(String consumerKey, String nonce, Long timestampSecs, String signature, String signatureMethod, String version, Request.ParsedRequest parsedRequest, String normalizedRequest) {
            this.consumerKey = consumerKey;
            this.nonce = nonce;
            this.timestampSecs = timestampSecs;
            this.signature = signature;
            this.signatureMethod = signatureMethod;
            this.version = version;
            this.parsedRequest = parsedRequest;
            this.normalizedRequest = normalizedRequest;
        }

        @Override
        public Request.ParsedRequest parsedRequest() {
            return this.parsedRequest;
        }

        @Override
        public String oAuthVersionString() {
            return "oauth1";
        }

        @Override
        public Map<String, String> oAuthParamMap() {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("oauth_consumer_key", this.consumerKey);
            map.put("oauth_nonce", this.nonce);
            map.put("oauth_timestamp", this.timestampSecs.toString());
            map.put("oauth_signature_method", this.signatureMethod);
            map.put("oauth_signature", this.signature);
            map.put("oauth_version", this.version == null ? "1.0" : this.version);
            map.put("normalized_request", this.normalizedRequest);
            return map;
        }

        public String toString() {
            return String.format("{consumerKey -> %s, nonce -> %s, timestamp -> %s, signature -> %s, method -> %s}", this.consumerKey, this.nonce, this.timestampSecs, this.signature, this.signatureMethod);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OAuth1RequestBase that = (OAuth1RequestBase)o;
            if (this.consumerKey != null ? !this.consumerKey.equals(that.consumerKey) : that.consumerKey != null) {
                return false;
            }
            if (this.nonce != null ? !this.nonce.equals(that.nonce) : that.nonce != null) {
                return false;
            }
            if (this.normalizedRequest != null ? !this.normalizedRequest.equals(that.normalizedRequest) : that.normalizedRequest != null) {
                return false;
            }
            if (this.parsedRequest != null ? !this.parsedRequest.equals(that.parsedRequest) : that.parsedRequest != null) {
                return false;
            }
            if (this.signature != null ? !this.signature.equals(that.signature) : that.signature != null) {
                return false;
            }
            if (this.signatureMethod != null ? !this.signatureMethod.equals(that.signatureMethod) : that.signatureMethod != null) {
                return false;
            }
            if (this.timestampSecs != null ? !this.timestampSecs.equals(that.timestampSecs) : that.timestampSecs != null) {
                return false;
            }
            return !(this.version != null ? !this.version.equals(that.version) : that.version != null);
        }

        public int hashCode() {
            int result = this.consumerKey != null ? this.consumerKey.hashCode() : 0;
            result = 31 * result + (this.nonce != null ? this.nonce.hashCode() : 0);
            result = 31 * result + (this.timestampSecs != null ? this.timestampSecs.hashCode() : 0);
            result = 31 * result + (this.signature != null ? this.signature.hashCode() : 0);
            result = 31 * result + (this.signatureMethod != null ? this.signatureMethod.hashCode() : 0);
            result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
            result = 31 * result + (this.parsedRequest != null ? this.parsedRequest.hashCode() : 0);
            result = 31 * result + (this.normalizedRequest != null ? this.normalizedRequest.hashCode() : 0);
            return result;
        }
    }

    public static class OAuth1TwoLeggedRequest
    extends OAuth1RequestBase {
        public OAuth1TwoLeggedRequest(String consumerKey, String nonce, Long timestampSecs, String signature, String signatureMethod, String version, Request.ParsedRequest parsedRequest, String normalizedRequest) {
            super(consumerKey, nonce, timestampSecs, signature, signatureMethod, version, parsedRequest, normalizedRequest);
        }
    }

    public static interface OAuthRequest
    extends UnpackedRequest {
        public String oAuthVersionString();

        public Map<String, String> oAuthParamMap();
    }

    public static class UnknownRequest
    implements UnpackedRequest {
        private final Request.ParsedRequest parsedRequest;

        public UnknownRequest(Request.ParsedRequest parsedRequest) {
            this.parsedRequest = parsedRequest;
        }

        @Override
        public Request.ParsedRequest parsedRequest() {
            return this.parsedRequest;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UnknownRequest that = (UnknownRequest)o;
            return !(this.parsedRequest != null ? !this.parsedRequest.equals(that.parsedRequest) : that.parsedRequest != null);
        }

        public int hashCode() {
            return this.parsedRequest != null ? this.parsedRequest.hashCode() : 0;
        }
    }
}

