/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.util;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.twitter.elephantbird.util.ColumnarMetadata;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.RCFile;
import org.apache.hadoop.hive.serde2.ColumnProjectionUtils;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.pig.LoadPushDown;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RCFileUtil {
    private static final Logger LOG = LoggerFactory.getLogger(RCFileUtil.class);
    public static String REQUIRED_FIELD_INDICES_CONF = "elephantbird.rcfile.input.required.field.indices";
    public static String COLUMN_METADATA_PROTOBUF_KEY = "elephantbird.rcfile.column.info.protobuf";

    public static ColumnarMetadata readMetadata(Configuration conf, Path rcfile) throws IOException {
        SequenceFile.Metadata metadata = null;
        Configuration confCopy = new Configuration(conf);
        ColumnProjectionUtils.setFullyReadColumns((Configuration)confCopy);
        RCFile.Reader reader = new RCFile.Reader(rcfile.getFileSystem(confCopy), rcfile, confCopy);
        try {
            Field f = RCFile.Reader.class.getDeclaredField("metadata");
            f.setAccessible(true);
            metadata = (SequenceFile.Metadata)f.get(reader);
        }
        catch (Throwable t) {
            throw new IOException("Could not access metadata field in RCFile reader", t);
        }
        reader.close();
        Text metadataKey = new Text(COLUMN_METADATA_PROTOBUF_KEY);
        if (metadata == null || metadata.get(metadataKey) == null) {
            throw new IOException("could not find ColumnarMetadata in " + rcfile);
        }
        return ColumnarMetadata.parseFrom(metadata.get(metadataKey).getBytes());
    }

    public static ArrayList<Integer> findColumnsToRead(Configuration conf, List<Integer> currFieldIds, ColumnarMetadata storedInfo) throws IOException {
        ArrayList columnsToRead = Lists.newArrayList();
        ArrayList requiredFieldIds = Lists.newArrayList();
        String reqFieldStr = conf.get(REQUIRED_FIELD_INDICES_CONF, "");
        int numKnownFields = currFieldIds.size();
        if (reqFieldStr == null || reqFieldStr.equals("")) {
            for (int i = 0; i < numKnownFields; ++i) {
                requiredFieldIds.add(currFieldIds.get(i));
            }
        } else {
            for (String str : reqFieldStr.split(",")) {
                int idx = Integer.valueOf(str);
                if (idx < 0 || idx >= numKnownFields) {
                    throw new IOException("idx " + idx + " is out of range for known fields");
                }
                requiredFieldIds.add(currFieldIds.get(idx));
            }
        }
        List<Integer> storedFieldIds = storedInfo.getFieldIdList();
        for (int i = 0; i < storedFieldIds.size(); ++i) {
            int sid = storedFieldIds.get(i);
            if (sid <= 0 || !requiredFieldIds.contains(sid)) continue;
            columnsToRead.add(i);
        }
        String unknownFields = "";
        Iterator i$ = requiredFieldIds.iterator();
        while (i$.hasNext()) {
            int rid = (Integer)i$.next();
            if (storedFieldIds.contains(rid)) continue;
            unknownFields = unknownFields + " " + rid;
        }
        if (unknownFields.length() > 0) {
            int last = storedFieldIds.size() - 1;
            LOG.info("unknown fields among required fileds :" + unknownFields);
            if (storedFieldIds.get(last) != -1) {
                throw new IOException("No unknowns column in in input");
            }
            columnsToRead.add(last);
        }
        LOG.info(String.format("reading %d%s out of %d stored columns for %d required columns", columnsToRead.size(), unknownFields.length() > 0 ? " (including unknowns column)" : "", storedInfo.getFieldIdList().size(), requiredFieldIds.size()));
        return columnsToRead;
    }

    public static void setRequiredFieldConf(Configuration conf, LoadPushDown.RequiredFieldList requiredFieldList) {
        String value = "";
        if (requiredFieldList != null) {
            ArrayList indices = Lists.newArrayList();
            for (LoadPushDown.RequiredField f : requiredFieldList.getFields()) {
                indices.add(f.getIndex());
            }
            value = Joiner.on((String)",").join((Iterable)indices);
        }
        conf.set(REQUIRED_FIELD_INDICES_CONF, value);
    }
}

