/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.pig.store;

import com.twitter.elephantbird.mapreduce.io.ThriftWritable;
import com.twitter.elephantbird.mapreduce.output.RCFileThriftOutputFormat;
import com.twitter.elephantbird.pig.store.BaseStoreFunc;
import com.twitter.elephantbird.pig.util.PigToThrift;
import com.twitter.elephantbird.util.ThriftUtils;
import com.twitter.elephantbird.util.TypeRef;
import java.io.IOException;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.pig.data.Tuple;
import org.apache.thrift.TBase;

public class RCFileThriftPigStorage
extends BaseStoreFunc {
    private final TypeRef<? extends TBase<?, ?>> typeRef;
    private final ThriftWritable<TBase<?, ?>> writable;
    private final PigToThrift<TBase<?, ?>> pigToThrift;

    public RCFileThriftPigStorage(String thriftClassName) {
        this.typeRef = ThriftUtils.getTypeRef((String)thriftClassName);
        this.pigToThrift = PigToThrift.newInstance(this.typeRef);
        this.writable = new ThriftWritable(this.typeRef);
    }

    public OutputFormat getOutputFormat() throws IOException {
        return new RCFileThriftOutputFormat(this.typeRef);
    }

    public void putNext(Tuple t) throws IOException {
        TBase tObj = this.pigToThrift.getThriftObject(t);
        this.writable.set((Object)tObj);
        this.writeRecord(null, this.writable);
    }
}

