/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.pig.store;

import com.twitter.elephantbird.mapreduce.input.MapReduceInputFormatWrapper;
import com.twitter.elephantbird.mapreduce.output.RCFileOutputFormat;
import com.twitter.elephantbird.util.HadoopCompat;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.io.RCFileInputFormat;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.ColumnProjectionUtils;
import org.apache.hadoop.hive.serde2.columnar.BytesRefArrayWritable;
import org.apache.hadoop.hive.serde2.columnar.BytesRefWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.pig.LoadPushDown;
import org.apache.pig.ResourceSchema;
import org.apache.pig.builtin.PigStorage;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.util.ObjectSerializer;
import org.apache.pig.impl.util.StorageUtil;
import org.apache.pig.impl.util.UDFContext;

public class RCFilePigStorage
extends PigStorage {
    private TupleFactory tupleFactory = TupleFactory.getInstance();
    private int[] requiredColumns = null;
    private int numColumns = -1;
    private ByteStream.Output byteStream;
    private BytesRefArrayWritable rowWritable;
    private BytesRefWritable[] colValRefs;

    private Properties getUDFProperties() {
        return UDFContext.getUDFContext().getUDFProperties(((Object)((Object)this)).getClass(), new String[]{this.signature});
    }

    public InputFormat<LongWritable, BytesRefArrayWritable> getInputFormat() {
        return new MapReduceInputFormatWrapper((org.apache.hadoop.mapred.InputFormat)new RCFileInputFormat());
    }

    public OutputFormat<NullWritable, Writable> getOutputFormat() {
        return new RCFileOutputFormat();
    }

    public LoadPushDown.RequiredFieldResponse pushProjection(LoadPushDown.RequiredFieldList requiredFieldList) throws FrontendException {
        try {
            this.getUDFProperties().setProperty("requiredFieldList", ObjectSerializer.serialize((Serializable)requiredFieldList));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new LoadPushDown.RequiredFieldResponse(true);
    }

    public void setLocation(String location, Job job) throws IOException {
        super.setLocation(location, job);
        String obj = this.getUDFProperties().getProperty("requiredFieldList");
        if (obj == null) {
            ColumnProjectionUtils.setFullyReadColumns((Configuration)HadoopCompat.getConfiguration((JobContext)job));
            return;
        }
        LoadPushDown.RequiredFieldList fieldList = (LoadPushDown.RequiredFieldList)ObjectSerializer.deserialize((String)obj);
        ArrayList<Integer> ids = new ArrayList<Integer>();
        this.requiredColumns = new int[fieldList.getFields().size()];
        int i = 0;
        for (LoadPushDown.RequiredField rf : fieldList.getFields()) {
            this.requiredColumns[i++] = rf.getIndex();
            ids.add(rf.getIndex());
        }
        ColumnProjectionUtils.setReadColumnIDs((Configuration)HadoopCompat.getConfiguration((JobContext)job), ids);
    }

    public void checkSchema(ResourceSchema s) throws IOException {
        super.checkSchema(s);
        this.getUDFProperties().setProperty("numColumns", Integer.toString(s.getFields().length));
    }

    public void setStoreLocation(String location, Job job) throws IOException {
        super.setStoreLocation(location, job);
        Properties p = this.getUDFProperties();
        if (p != null) {
            this.numColumns = Integer.parseInt(p.getProperty("numColumns", "-1"));
        }
        if (this.numColumns > 0) {
            RCFileOutputFormat.setColumnNumber(HadoopCompat.getConfiguration((JobContext)job), this.numColumns);
        }
    }

    public Tuple getNext() throws IOException {
        try {
            if (!this.in.nextKeyValue()) {
                return null;
            }
            BytesRefArrayWritable byteRefs = (BytesRefArrayWritable)this.in.getCurrentValue();
            boolean isProjected = this.requiredColumns != null;
            int inputSize = byteRefs.size();
            int tupleSize = isProjected ? this.requiredColumns.length : inputSize;
            Tuple tuple = this.tupleFactory.newTuple(tupleSize);
            int tupleIdx = 0;
            for (int i = 0; i < inputSize && tupleIdx < tupleSize; ++i) {
                if (isProjected && i != this.requiredColumns[tupleIdx]) continue;
                BytesRefWritable ref = byteRefs.get(i);
                if (ref != null && ref.getLength() > 0) {
                    tuple.set(tupleIdx, (Object)new DataByteArray(ref.getBytesCopy()));
                }
                ++tupleIdx;
            }
            return tuple;
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    public void putNext(Tuple t) throws IOException {
        if (this.rowWritable == null) {
            if (this.numColumns < 1) {
                throw new IOException("number of columns is not set");
            }
            this.byteStream = new ByteStream.Output();
            this.rowWritable = new BytesRefArrayWritable();
            this.colValRefs = new BytesRefWritable[this.numColumns];
            for (int i = 0; i < this.numColumns; ++i) {
                this.colValRefs[i] = new BytesRefWritable();
                this.rowWritable.set(i, this.colValRefs[i]);
            }
        }
        this.byteStream.reset();
        int sz = t.size();
        int startPos = 0;
        for (int i = 0; i < sz && i < this.numColumns; ++i) {
            StorageUtil.putField((OutputStream)this.byteStream, (Object)t.get(i));
            this.colValRefs[i].set(this.byteStream.getData(), startPos, this.byteStream.getCount() - startPos);
            startPos = this.byteStream.getCount();
        }
        try {
            this.writer.write(null, (Object)this.rowWritable);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }
}

