/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.pig.load;

import com.twitter.elephantbird.mapreduce.input.RCFileThriftTupleInputFormat;
import com.twitter.elephantbird.pig.load.ThriftPigLoader;
import com.twitter.elephantbird.util.HadoopCompat;
import com.twitter.elephantbird.util.RCFileUtil;
import com.twitter.elephantbird.util.TypeRef;
import java.io.IOException;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigSplit;
import org.apache.pig.data.Tuple;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;

public class RCFileThriftPigLoader
extends ThriftPigLoader<TBase<?, ?>> {
    private RCFileThriftTupleInputFormat.TupleReader thriftReader;

    public RCFileThriftPigLoader(String thriftClassName) {
        super(thriftClassName);
    }

    public InputFormat getInputFormat() throws IOException {
        return new RCFileThriftTupleInputFormat((TypeRef<TBase<?, ?>>)this.typeRef);
    }

    public Tuple getNext() throws IOException {
        if (this.thriftReader.isReadingUnknonwsColumn()) {
            return super.getNext();
        }
        try {
            if (this.thriftReader.nextKeyValue()) {
                return this.thriftReader.getCurrentTupleValue();
            }
        }
        catch (TException e) {
            throw new IOException(e);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        return null;
    }

    public void prepareToRead(RecordReader reader, PigSplit split) {
        super.prepareToRead(reader, split);
        this.thriftReader = (RCFileThriftTupleInputFormat.TupleReader)reader;
    }

    public void setLocation(String location, Job job) throws IOException {
        super.setLocation(location, job);
        RCFileUtil.setRequiredFieldConf(HadoopCompat.getConfiguration((JobContext)job), this.requiredFieldList);
    }
}

