/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.pig.load;

import com.google.protobuf.Message;
import com.twitter.elephantbird.mapreduce.input.RCFileProtobufTupleInputFormat;
import com.twitter.elephantbird.pig.load.ProtobufPigLoader;
import com.twitter.elephantbird.util.HadoopCompat;
import com.twitter.elephantbird.util.RCFileUtil;
import com.twitter.elephantbird.util.TypeRef;
import java.io.IOException;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigSplit;
import org.apache.pig.data.Tuple;

public class RCFileProtobufPigLoader
extends ProtobufPigLoader<Message> {
    private RCFileProtobufTupleInputFormat.TupleReader protoReader;

    public RCFileProtobufPigLoader(String protoClassName) {
        super(protoClassName);
    }

    public InputFormat getInputFormat() throws IOException {
        return new RCFileProtobufTupleInputFormat((TypeRef<Message>)this.typeRef);
    }

    public Tuple getNext() throws IOException {
        if (this.protoReader.isReadingUnknonwsColumn()) {
            return super.getNext();
        }
        try {
            if (this.protoReader.nextKeyValue()) {
                return this.protoReader.getCurrentTupleValue();
            }
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        return null;
    }

    public void prepareToRead(RecordReader reader, PigSplit split) {
        super.prepareToRead(reader, split);
        this.protoReader = (RCFileProtobufTupleInputFormat.TupleReader)reader;
    }

    public void setLocation(String location, Job job) throws IOException {
        super.setLocation(location, job);
        RCFileUtil.setRequiredFieldConf(HadoopCompat.getConfiguration((JobContext)job), this.requiredFieldList);
    }
}

