/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.mapreduce.output;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.protobuf.Message;
import com.twitter.elephantbird.mapreduce.io.ThriftWritable;
import com.twitter.elephantbird.mapreduce.output.RCFileOutputFormat;
import com.twitter.elephantbird.thrift.TStructDescriptor;
import com.twitter.elephantbird.util.ColumnarMetadata;
import com.twitter.elephantbird.util.HadoopCompat;
import com.twitter.elephantbird.util.Protobufs;
import com.twitter.elephantbird.util.ThriftUtils;
import com.twitter.elephantbird.util.TypeRef;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.columnar.BytesRefArrayWritable;
import org.apache.hadoop.hive.serde2.columnar.BytesRefWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TMemoryInputTransport;
import org.apache.thrift.transport.TTransport;

public class RCFileThriftOutputFormat
extends RCFileOutputFormat {
    private TypeRef<? extends TBase<?, ?>> typeRef;
    private TStructDescriptor tDesc;
    private List<TStructDescriptor.Field> tFields;
    private int numColumns;
    private BytesRefArrayWritable rowWritable = new BytesRefArrayWritable();
    private BytesRefWritable[] colValRefs;

    public RCFileThriftOutputFormat() {
    }

    public RCFileThriftOutputFormat(TypeRef<? extends TBase<?, ?>> typeRef) {
        this.typeRef = typeRef;
        this.init();
    }

    private void init() {
        this.tDesc = TStructDescriptor.getInstance((Class)this.typeRef.getRawClass());
        this.tFields = this.tDesc.getFields();
        this.numColumns = this.tFields.size() + 1;
        this.colValRefs = new BytesRefWritable[this.numColumns];
        for (int i = 0; i < this.numColumns; ++i) {
            this.colValRefs[i] = new BytesRefWritable();
            this.rowWritable.set(i, this.colValRefs[i]);
        }
    }

    protected ColumnarMetadata makeColumnarMetadata() {
        ArrayList fieldIds = Lists.newArrayList();
        for (TStructDescriptor.Field fd : this.tDesc.getFields()) {
            fieldIds.add(Integer.valueOf(fd.getFieldId()));
        }
        fieldIds.add(-1);
        return ColumnarMetadata.newInstance(this.typeRef.getRawClass().getName(), fieldIds);
    }

    public static void setClassConf(Class<? extends TBase<?, ?>> thriftClass, Configuration conf) {
        ThriftUtils.setClassConf((Configuration)conf, RCFileThriftOutputFormat.class, thriftClass);
    }

    @Override
    public RecordWriter<NullWritable, Writable> getRecordWriter(TaskAttemptContext job) throws IOException, InterruptedException {
        if (this.typeRef == null) {
            this.typeRef = ThriftUtils.getTypeRef((Configuration)HadoopCompat.getConfiguration((JobContext)job), RCFileThriftOutputFormat.class);
            this.init();
        }
        RCFileOutputFormat.setColumnNumber(HadoopCompat.getConfiguration((JobContext)job), this.numColumns);
        return new ThriftWriter(job);
    }

    private class ThriftWriter
    extends RCFileOutputFormat.Writer {
        private ByteStream.Output byteStream;
        private TBinaryProtocol tProto;
        private Map<Short, Integer> idMap;
        private TMemoryInputTransport mTransport;
        private TBinaryProtocol skipProto;

        ThriftWriter(TaskAttemptContext job) throws IOException {
            super(RCFileThriftOutputFormat.this, job, Protobufs.toText((Message)RCFileThriftOutputFormat.this.makeColumnarMetadata().getMessage()));
            this.byteStream = new ByteStream.Output();
            this.tProto = new TBinaryProtocol((TTransport)new TIOStreamTransport((OutputStream)this.byteStream));
        }

        @Override
        public void write(NullWritable key, Writable value) throws IOException, InterruptedException {
            try {
                if (value instanceof BytesWritable) {
                    this.fromBytes((BytesWritable)value);
                } else {
                    this.fromObject((TBase)((ThriftWritable)value).get());
                }
            }
            catch (TException e) {
                throw new IOException(e);
            }
            super.write(null, (Writable)RCFileThriftOutputFormat.this.rowWritable);
        }

        private void fromObject(TBase tObj) throws IOException, InterruptedException, TException {
            this.byteStream.reset();
            int startPos = 0;
            for (int i = 0; i < RCFileThriftOutputFormat.this.numColumns; ++i) {
                if (i < RCFileThriftOutputFormat.this.numColumns - 1) {
                    TStructDescriptor.Field fd = (TStructDescriptor.Field)RCFileThriftOutputFormat.this.tFields.get(i);
                    ThriftUtils.writeFieldNoTag((TProtocol)this.tProto, (TStructDescriptor.Field)fd, (Object)RCFileThriftOutputFormat.this.tDesc.getFieldValue(i, tObj));
                }
                RCFileThriftOutputFormat.this.colValRefs[i].set(this.byteStream.getData(), startPos, this.byteStream.getCount() - startPos);
                startPos = this.byteStream.getCount();
            }
        }

        private void fromBytes(BytesWritable bytesWritable) throws IOException, InterruptedException, TException {
            if (this.mTransport == null) {
                this.initIdMap();
                this.mTransport = new TMemoryInputTransport();
                this.skipProto = new TBinaryProtocol((TTransport)this.mTransport);
            }
            byte[] bytes = bytesWritable.getBytes();
            this.mTransport.reset(bytes, 0, bytesWritable.getLength());
            this.byteStream.reset();
            for (BytesRefWritable ref : RCFileThriftOutputFormat.this.colValRefs) {
                ref.set(bytes, 0, 0);
            }
            this.skipProto.readStructBegin();
            while (true) {
                int start = this.mTransport.getBufferPosition();
                TField field = this.skipProto.readFieldBegin();
                if (field.type == 0) break;
                int fieldStart = this.mTransport.getBufferPosition();
                TProtocolUtil.skip((TProtocol)this.skipProto, (byte)field.type);
                int end = this.mTransport.getBufferPosition();
                Integer idx = this.idMap.get(field.id);
                if (idx != null && field.type == ((TStructDescriptor.Field)RCFileThriftOutputFormat.this.tFields.get(idx)).getType()) {
                    RCFileThriftOutputFormat.this.colValRefs[idx].set(bytes, fieldStart, end - fieldStart);
                    continue;
                }
                this.byteStream.write(bytes, start, end - start);
            }
            if (this.byteStream.getCount() > 0) {
                this.byteStream.write(0);
                RCFileThriftOutputFormat.this.colValRefs[RCFileThriftOutputFormat.this.colValRefs.length - 1].set(this.byteStream.getData(), 0, this.byteStream.getCount());
            }
        }

        private void initIdMap() {
            this.idMap = Maps.newHashMap();
            for (int i = 0; i < RCFileThriftOutputFormat.this.tFields.size(); ++i) {
                this.idMap.put(((TStructDescriptor.Field)RCFileThriftOutputFormat.this.tFields.get(i)).getFieldId(), i);
            }
            this.idMap = ImmutableMap.copyOf(this.idMap);
        }
    }
}

