/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.mapreduce.input;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.twitter.elephantbird.mapreduce.input.FilterRecordReader;
import com.twitter.elephantbird.mapreduce.input.RCFileBaseInputFormat;
import com.twitter.elephantbird.mapreduce.io.ThriftWritable;
import com.twitter.elephantbird.thrift.TStructDescriptor;
import com.twitter.elephantbird.util.ColumnarMetadata;
import com.twitter.elephantbird.util.HadoopCompat;
import com.twitter.elephantbird.util.RCFileUtil;
import com.twitter.elephantbird.util.ThriftUtils;
import com.twitter.elephantbird.util.TypeRef;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.serde2.ColumnProjectionUtils;
import org.apache.hadoop.hive.serde2.columnar.BytesRefArrayWritable;
import org.apache.hadoop.hive.serde2.columnar.BytesRefWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TMemoryInputTransport;
import org.apache.thrift.transport.TTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RCFileThriftInputFormat
extends RCFileBaseInputFormat {
    private static final Logger LOG = LoggerFactory.getLogger(RCFileThriftInputFormat.class);
    private TypeRef<? extends TBase<?, ?>> typeRef;

    public RCFileThriftInputFormat() {
    }

    public RCFileThriftInputFormat(TypeRef<? extends TBase<?, ?>> typeRef) {
        this.typeRef = typeRef;
    }

    public static void setClassConf(Class<? extends TBase<?, ?>> thriftClass, Configuration conf) {
        ThriftUtils.setClassConf((Configuration)conf, RCFileThriftInputFormat.class, thriftClass);
    }

    public RecordReader<LongWritable, Writable> createRecordReader(InputSplit split, TaskAttemptContext taskAttempt) throws IOException, InterruptedException {
        if (this.typeRef == null) {
            this.typeRef = ThriftUtils.getTypeRef((Configuration)HadoopCompat.getConfiguration((JobContext)taskAttempt), RCFileThriftInputFormat.class);
        }
        return new ThriftReader(this.createUnwrappedRecordReader(split, taskAttempt));
    }

    public class ThriftReader
    extends FilterRecordReader<LongWritable, Writable> {
        protected TStructDescriptor tDesc;
        protected boolean readUnknownsColumn;
        protected List<TStructDescriptor.Field> knownRequiredFields;
        protected ArrayList<Integer> columnsBeingRead;
        protected TMemoryInputTransport memTransport;
        protected TBinaryProtocol tProto;
        protected ThriftWritable<TBase<?, ?>> thriftWritable;

        public ThriftReader(RecordReader reader) {
            super(reader);
            this.readUnknownsColumn = false;
            this.knownRequiredFields = Lists.newArrayList();
            this.columnsBeingRead = Lists.newArrayList();
            this.memTransport = new TMemoryInputTransport();
            this.tProto = new TBinaryProtocol((TTransport)this.memTransport);
        }

        public boolean isReadingUnknonwsColumn() {
            return this.readUnknownsColumn;
        }

        public void initialize(InputSplit split, TaskAttemptContext ctx) throws IOException, InterruptedException {
            this.tDesc = TStructDescriptor.getInstance((Class)RCFileThriftInputFormat.this.typeRef.getRawClass());
            this.thriftWritable = ThriftWritable.newInstance((Class)RCFileThriftInputFormat.this.typeRef.getRawClass());
            List tFields = this.tDesc.getFields();
            FileSplit fsplit = (FileSplit)split;
            Path file = fsplit.getPath();
            LOG.info(String.format("reading %s from %s:%d:%d", RCFileThriftInputFormat.this.typeRef.getRawClass().getName(), file.toString(), fsplit.getStart(), fsplit.getStart() + fsplit.getLength()));
            Configuration conf = HadoopCompat.getConfiguration((JobContext)ctx);
            ColumnarMetadata storedInfo = RCFileUtil.readMetadata(conf, file);
            List tFieldIds = Lists.transform((List)tFields, (Function)new Function<TStructDescriptor.Field, Integer>(){

                public Integer apply(TStructDescriptor.Field fd) {
                    return fd.getFieldId();
                }
            });
            this.columnsBeingRead = RCFileUtil.findColumnsToRead(conf, tFieldIds, storedInfo);
            for (int idx : this.columnsBeingRead) {
                int fid = storedInfo.getFieldId(idx);
                if (fid >= 0) {
                    this.knownRequiredFields.add((TStructDescriptor.Field)tFields.get(tFieldIds.indexOf(fid)));
                    continue;
                }
                this.readUnknownsColumn = true;
            }
            ColumnProjectionUtils.setReadColumnIDs((Configuration)conf, this.columnsBeingRead);
            super.initialize(split, ctx);
        }

        public Writable getCurrentValue() throws IOException, InterruptedException {
            try {
                this.thriftWritable.set(this.getCurrentThriftValue());
                return this.thriftWritable;
            }
            catch (TException e) {
                throw new IOException(e);
            }
        }

        public BytesRefArrayWritable getCurrentBytesRefArrayWritable() throws IOException, InterruptedException {
            return (BytesRefArrayWritable)super.getCurrentValue();
        }

        public TBase<?, ?> getCurrentThriftValue() throws IOException, InterruptedException, TException {
            int last;
            BytesRefWritable buf;
            BytesRefArrayWritable byteRefs = this.getCurrentBytesRefArrayWritable();
            if (byteRefs == null) {
                return null;
            }
            TBase tObj = this.tDesc.newThriftObject();
            for (int i = 0; i < this.knownRequiredFields.size(); ++i) {
                buf = byteRefs.get(this.columnsBeingRead.get(i).intValue());
                if (buf.getLength() <= 0) continue;
                this.memTransport.reset(buf.getData(), buf.getStart(), buf.getLength());
                TStructDescriptor.Field field = this.knownRequiredFields.get(i);
                tObj.setFieldValue(field.getFieldIdEnum(), ThriftUtils.readFieldNoTag((TProtocol)this.tProto, (TStructDescriptor.Field)field));
            }
            if (this.readUnknownsColumn && (buf = byteRefs.get(last = this.columnsBeingRead.get(this.columnsBeingRead.size() - 1).intValue())).getLength() > 0) {
                this.memTransport.reset(buf.getData(), buf.getStart(), buf.getLength());
                tObj.read((TProtocol)this.tProto);
            }
            return tObj;
        }
    }
}

