/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.mapreduce.input;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.twitter.elephantbird.mapreduce.input.FilterRecordReader;
import com.twitter.elephantbird.mapreduce.input.RCFileBaseInputFormat;
import com.twitter.elephantbird.mapreduce.io.ProtobufWritable;
import com.twitter.elephantbird.util.ColumnarMetadata;
import com.twitter.elephantbird.util.HadoopCompat;
import com.twitter.elephantbird.util.Protobufs;
import com.twitter.elephantbird.util.RCFileUtil;
import com.twitter.elephantbird.util.TypeRef;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.serde2.ColumnProjectionUtils;
import org.apache.hadoop.hive.serde2.columnar.BytesRefArrayWritable;
import org.apache.hadoop.hive.serde2.columnar.BytesRefWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RCFileProtobufInputFormat
extends RCFileBaseInputFormat {
    private static final Logger LOG = LoggerFactory.getLogger(RCFileProtobufInputFormat.class);
    private TypeRef<Message> typeRef;

    public RCFileProtobufInputFormat() {
    }

    public RCFileProtobufInputFormat(TypeRef<Message> typeRef) {
        this.typeRef = typeRef;
    }

    public static void setClassConf(Class<? extends Message> protoClass, Configuration conf) {
        Protobufs.setClassConf((Configuration)conf, RCFileProtobufInputFormat.class, protoClass);
    }

    public RecordReader<LongWritable, Writable> createRecordReader(InputSplit split, TaskAttemptContext taskAttempt) throws IOException, InterruptedException {
        if (this.typeRef == null) {
            this.typeRef = Protobufs.getTypeRef((Configuration)HadoopCompat.getConfiguration((JobContext)taskAttempt), RCFileProtobufInputFormat.class);
        }
        return new ProtobufReader(this.createUnwrappedRecordReader(split, taskAttempt));
    }

    public class ProtobufReader
    extends FilterRecordReader<LongWritable, Writable> {
        protected Message msgInstance;
        protected Message.Builder msgBuilder;
        protected boolean readUnknownsColumn;
        protected List<Descriptors.FieldDescriptor> knownRequiredFields;
        protected ArrayList<Integer> columnsBeingRead;
        protected ProtobufWritable<Message> protoWritable;

        public ProtobufReader(RecordReader reader) {
            super(reader);
            this.readUnknownsColumn = false;
            this.knownRequiredFields = Lists.newArrayList();
            this.columnsBeingRead = Lists.newArrayList();
        }

        public boolean isReadingUnknonwsColumn() {
            return this.readUnknownsColumn;
        }

        public void initialize(InputSplit split, TaskAttemptContext ctx) throws IOException, InterruptedException {
            this.msgBuilder = Protobufs.getMessageBuilder((Class)RCFileProtobufInputFormat.this.typeRef.getRawClass());
            this.msgInstance = this.msgBuilder.getDefaultInstanceForType();
            this.protoWritable = ProtobufWritable.newInstance((Class)RCFileProtobufInputFormat.this.typeRef.getRawClass());
            Descriptors.Descriptor msgDesc = this.msgBuilder.getDescriptorForType();
            List msgFields = msgDesc.getFields();
            Configuration conf = new Configuration(HadoopCompat.getConfiguration((JobContext)ctx));
            ColumnProjectionUtils.setFullyReadColumns((Configuration)conf);
            FileSplit fsplit = (FileSplit)split;
            Path file = fsplit.getPath();
            LOG.info(String.format("reading %s from %s:%d:%d", RCFileProtobufInputFormat.this.typeRef.getRawClass().getName(), file.toString(), fsplit.getStart(), fsplit.getStart() + fsplit.getLength()));
            ColumnarMetadata storedInfo = RCFileUtil.readMetadata(conf, file);
            List msgFieldIds = Lists.transform((List)msgFields, (Function)new Function<Descriptors.FieldDescriptor, Integer>(){

                public Integer apply(Descriptors.FieldDescriptor fd) {
                    return fd.getNumber();
                }
            });
            this.columnsBeingRead = RCFileUtil.findColumnsToRead(conf, msgFieldIds, storedInfo);
            for (int idx : this.columnsBeingRead) {
                int fid = storedInfo.getFieldId(idx);
                if (fid >= 0) {
                    this.knownRequiredFields.add((Descriptors.FieldDescriptor)msgFields.get(msgFieldIds.indexOf(fid)));
                    continue;
                }
                this.readUnknownsColumn = true;
            }
            ColumnProjectionUtils.setReadColumnIDs((Configuration)conf, this.columnsBeingRead);
            super.initialize(split, ctx);
        }

        public Writable getCurrentValue() throws IOException, InterruptedException {
            this.protoWritable.set((Object)this.getCurrentProtobufValue());
            return this.protoWritable;
        }

        public BytesRefArrayWritable getCurrentBytesRefArrayWritable() throws IOException, InterruptedException {
            return (BytesRefArrayWritable)super.getCurrentValue();
        }

        public Message getCurrentProtobufValue() throws IOException, InterruptedException {
            int last;
            BytesRefWritable buf;
            BytesRefArrayWritable byteRefs = this.getCurrentBytesRefArrayWritable();
            if (byteRefs == null) {
                return null;
            }
            Message.Builder builder = this.msgInstance.newBuilderForType();
            for (int i = 0; i < this.knownRequiredFields.size(); ++i) {
                buf = byteRefs.get(this.columnsBeingRead.get(i).intValue());
                if (buf.getLength() <= 0) continue;
                Protobufs.setFieldValue((CodedInputStream)CodedInputStream.newInstance((byte[])buf.getData(), (int)buf.getStart(), (int)buf.getLength()), (Descriptors.FieldDescriptor)this.knownRequiredFields.get(i), (Message.Builder)builder);
            }
            if (this.readUnknownsColumn && (buf = byteRefs.get(last = this.columnsBeingRead.get(this.columnsBeingRead.size() - 1).intValue())).getLength() > 0) {
                builder.mergeFrom(buf.getData(), buf.getStart(), buf.getLength());
            }
            return builder.build();
        }
    }
}

