/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.pig.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;

public abstract class AbstractLazyTuple
implements Tuple {
    private static TupleFactory tf = TupleFactory.getInstance();
    protected Tuple realTuple;
    protected boolean isRef;
    protected BitSet idxBits;

    protected void initRealTuple(int tupleSize) {
        this.realTuple = tf.newTuple(tupleSize);
        this.idxBits = new BitSet(tupleSize);
        this.isRef = false;
    }

    protected abstract Object getObjectAt(int var1);

    public void append(Object obj) {
        this.realTuple.append(obj);
    }

    public Object get(int idx) throws ExecException {
        if (!this.isRef && !this.idxBits.get(idx)) {
            this.realTuple.set(idx, this.getObjectAt(idx));
            this.idxBits.set(idx);
        }
        return this.realTuple.get(idx);
    }

    public List<Object> getAll() {
        this.convertAll();
        return this.realTuple.getAll();
    }

    public long getMemorySize() {
        return this.realTuple.getMemorySize();
    }

    public byte getType(int idx) throws ExecException {
        this.get(idx);
        return this.realTuple.getType(idx);
    }

    public boolean isNull(int idx) throws ExecException {
        this.get(idx);
        return this.realTuple.isNull(idx);
    }

    public void reference(Tuple t) {
        if (t != this) {
            this.realTuple = t;
            this.isRef = true;
        }
    }

    public void set(int idx, Object val) throws ExecException {
        this.realTuple.set(idx, val);
        this.idxBits.set(idx);
    }

    public int size() {
        return this.realTuple.size();
    }

    public String toDelimitedString(String delim) throws ExecException {
        this.convertAll();
        return this.realTuple.toDelimitedString(delim);
    }

    public void readFields(DataInput in) throws IOException {
        Tuple t = tf.newTuple(this.realTuple.size());
        t.readFields(in);
        this.reference(t);
    }

    public void write(DataOutput out) throws IOException {
        this.convertAll();
        this.realTuple.write(out);
    }

    public String toString() {
        this.convertAll();
        return this.realTuple.toString();
    }

    public int compareTo(Object arg0) {
        this.convertAll();
        return this.realTuple.compareTo(arg0);
    }

    public Iterator<Object> iterator() {
        this.convertAll();
        return this.realTuple.iterator();
    }

    protected void convertAll() {
        if (this.isRef) {
            return;
        }
        int size = this.realTuple.size();
        for (int i = 0; i < size; ++i) {
            try {
                this.get(i);
                continue;
            }
            catch (ExecException e) {
                throw new RuntimeException("Unable to process field " + i, e);
            }
        }
    }
}

